/*
 * Decompiled with CFR 0.152.
 */
package ffx.potential.terms;

import ffx.potential.bonded.BondedTerm;
import ffx.potential.bonded.PiOrbitalTorsion;
import ffx.potential.terms.EnergyTerm;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;

public class PiOrbitalTorsionPotentialEnergy
extends EnergyTerm {
    private static final Logger logger = Logger.getLogger(PiOrbitalTorsionPotentialEnergy.class.getName());
    private final List<PiOrbitalTorsion> piOrbitalTorsions = new ArrayList<PiOrbitalTorsion>();

    public PiOrbitalTorsionPotentialEnergy(String name) {
        super(name);
    }

    public PiOrbitalTorsionPotentialEnergy(String name, int forceGroup) {
        super(name, forceGroup);
    }

    public PiOrbitalTorsionPotentialEnergy(String name, int forceGroup, List<PiOrbitalTorsion> piOrbitalTorsions) {
        super(name, forceGroup);
        if (piOrbitalTorsions != null) {
            Collections.sort(piOrbitalTorsions);
            this.piOrbitalTorsions.addAll(piOrbitalTorsions);
            logger.info(String.format("  Pi-Orbital Torsions:               %10d", this.getNumberOfPiOrbitalTorsions()));
        }
    }

    @Override
    public int getNumberOfTerms() {
        return this.getNumberOfPiOrbitalTorsions();
    }

    @Override
    public BondedTerm[] getBondedTermsArray() {
        return this.getPiOrbitalTorsionArray();
    }

    public PiOrbitalTorsionPotentialEnergy(String name, Collection<PiOrbitalTorsion> piOrbitalTorsions) {
        super(name);
        if (piOrbitalTorsions != null) {
            this.piOrbitalTorsions.addAll(piOrbitalTorsions);
        }
    }

    public boolean addPiOrbitalTorsion(PiOrbitalTorsion piOrbitalTorsion) {
        if (piOrbitalTorsion == null) {
            return false;
        }
        return this.piOrbitalTorsions.add(piOrbitalTorsion);
    }

    public boolean addPiOrbitalTorsions(PiOrbitalTorsion[] piOrbitalTorsions) {
        if (piOrbitalTorsions == null) {
            return false;
        }
        Collections.addAll(this.piOrbitalTorsions, piOrbitalTorsions);
        return true;
    }

    public boolean addPiOrbitalTorsions(List<PiOrbitalTorsion> piOrbitalTorsions) {
        if (piOrbitalTorsions == null) {
            return false;
        }
        this.piOrbitalTorsions.addAll(piOrbitalTorsions);
        return true;
    }

    public boolean removePiOrbitalTorsion(PiOrbitalTorsion piOrbitalTorsion) {
        if (piOrbitalTorsion == null) {
            return false;
        }
        return this.piOrbitalTorsions.remove(piOrbitalTorsion);
    }

    public PiOrbitalTorsion getPiOrbitalTorsion(int index) {
        return this.piOrbitalTorsions.get(index);
    }

    public List<PiOrbitalTorsion> getPiOrbitalTorsions() {
        return Collections.unmodifiableList(this.piOrbitalTorsions);
    }

    public PiOrbitalTorsion[] getPiOrbitalTorsionArray() {
        return this.piOrbitalTorsions.toArray(new PiOrbitalTorsion[0]);
    }

    public int getNumberOfPiOrbitalTorsions() {
        return this.piOrbitalTorsions.size();
    }

    public void setLambda(double lambda) {
        for (PiOrbitalTorsion piOrbitalTorsion : this.piOrbitalTorsions) {
            piOrbitalTorsion.setLambda(lambda);
        }
    }

    public double getdEdL() {
        double dEdL = 0.0;
        for (PiOrbitalTorsion piOrbitalTorsion : this.piOrbitalTorsions) {
            dEdL += piOrbitalTorsion.getdEdL();
        }
        return dEdL;
    }

    public double getd2EdL2() {
        double d2EdLambda2 = 0.0;
        for (PiOrbitalTorsion piOrbitalTorsion : this.piOrbitalTorsions) {
            d2EdLambda2 += piOrbitalTorsion.getd2EdL2();
        }
        return d2EdLambda2;
    }

    public static String getPiOrbitalTorsionEnergyString() {
        String energy = "2*k*sin(phi)^2;\nphi = pointdihedral(x3+c1x, y3+c1y, z3+c1z, x3, y3, z3, x4, y4, z4, x4+c2x, y4+c2y, z4+c2z);\nc1x = (d14y*d24z-d14z*d24y);\nc1y = (d14z*d24x-d14x*d24z);\nc1z = (d14x*d24y-d14y*d24x);\nc2x = (d53y*d63z-d53z*d63y);\nc2y = (d53z*d63x-d53x*d63z);\nc2z = (d53x*d63y-d53y*d63x);\nd14x = x1-x4;\nd14y = y1-y4;\nd14z = z1-z4;\nd24x = x2-x4;\nd24y = y2-y4;\nd24z = z2-z4;\nd53x = x5-x3;\nd53y = y5-y3;\nd53z = z5-z3;\nd63x = x6-x3;\nd63y = y6-y3;\nd63z = z6-z3;\n";
        return energy;
    }

    @Override
    public void log() {
        if (this.getNumberOfPiOrbitalTorsions() <= 0) {
            return;
        }
        logger.info("\n Pi-Orbital Torsion Interactions:");
        for (PiOrbitalTorsion piOrbitalTorsion : this.getPiOrbitalTorsions()) {
            logger.info(" Pi-Torsion \t" + piOrbitalTorsion.toString());
        }
    }

    @Override
    public String toPDBString() {
        if (this.getNumberOfPiOrbitalTorsions() <= 0) {
            return "";
        }
        return String.format("REMARK   3   %s %g (%d)\n", "PI-ORBITAL TORSION         : ", this.getEnergy(), this.getNumberOfPiOrbitalTorsions());
    }

    @Override
    public String toString() {
        return String.format("  %s %20.8f %12d %12.3f\n", "Pi-Orbital Torsion", this.getEnergy(), this.getNumberOfPiOrbitalTorsions(), this.getTime());
    }
}

