/*
 * Decompiled with CFR 0.152.
 */
package ffx.potential.terms;

import edu.rit.pj.reduction.SharedDouble;
import ffx.potential.bonded.BondedTerm;
import java.util.logging.Logger;
import org.apache.commons.math3.util.FastMath;

public abstract class EnergyTerm {
    private static final Logger logger = Logger.getLogger(EnergyTerm.class.getName());
    protected String name;
    protected int forceGroup = 0;
    protected SharedDouble energy = new SharedDouble();
    private final SharedDouble sharedRMSD = new SharedDouble();
    private long computeTime = 0L;

    protected EnergyTerm() {
    }

    protected EnergyTerm(String name) {
        this.name = name;
    }

    protected EnergyTerm(String name, int forceGroup) {
        this.name = name;
        this.forceGroup = forceGroup;
    }

    public abstract int getNumberOfTerms();

    public abstract BondedTerm[] getBondedTermsArray();

    public abstract void log();

    public abstract String toString();

    public abstract String toPDBString();

    public int getForceGroup() {
        return this.forceGroup;
    }

    public void setForceGroup(int forceGroup) {
        this.forceGroup = forceGroup;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public double getEnergy() {
        return this.energy.get();
    }

    protected void setEnergy(double e) {
        this.energy.set(e);
    }

    protected double addAndGetEnergy(double e) {
        return this.energy.addAndGet(e);
    }

    protected void setRMSD(double rmsd) {
        this.sharedRMSD.set(rmsd);
    }

    public double getRMSD() {
        return FastMath.sqrt((double)(this.sharedRMSD.get() / (double)this.getNumberOfTerms()));
    }

    protected double addAndGetRMSD(double rmsd) {
        return this.sharedRMSD.addAndGet(rmsd);
    }

    protected void startTime() {
        this.computeTime = -System.nanoTime();
    }

    public void stopTime() {
        this.computeTime += System.nanoTime();
    }

    public double getTime() {
        return (double)this.computeTime * 1.0E-9;
    }
}

