/*
 * Decompiled with CFR 0.152.
 */
package ffx.potential.terms;

import ffx.potential.bonded.Bond;
import ffx.potential.bonded.BondedTerm;
import ffx.potential.parameters.BondType;
import ffx.potential.terms.EnergyTerm;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;

public class BondPotentialEnergy
extends EnergyTerm {
    private static final Logger logger = Logger.getLogger(BondPotentialEnergy.class.getName());
    private final List<Bond> bonds = new ArrayList<Bond>();

    public BondPotentialEnergy(String name) {
        super(name);
    }

    public BondPotentialEnergy(String name, int forceGroup) {
        super(name, forceGroup);
    }

    public BondPotentialEnergy(String name, int forceGroup, List<Bond> bonds) {
        super(name, forceGroup);
        if (bonds != null) {
            Collections.sort(bonds);
            this.bonds.addAll(bonds);
            logger.info(String.format("  Bonds:                             %10d", this.getNumberOfBonds()));
        }
    }

    @Override
    public int getNumberOfTerms() {
        return this.getNumberOfBonds();
    }

    @Override
    public BondedTerm[] getBondedTermsArray() {
        return this.getBondArray();
    }

    public BondPotentialEnergy(String name, Collection<Bond> bonds) {
        super(name);
        if (bonds != null) {
            this.bonds.addAll(bonds);
        }
    }

    public boolean addBond(Bond bond) {
        if (bond == null) {
            return false;
        }
        return this.bonds.add(bond);
    }

    public boolean addBonds(Bond[] bonds) {
        if (bonds == null) {
            return false;
        }
        Collections.addAll(this.bonds, bonds);
        return true;
    }

    public boolean addBonds(List<Bond> bonds) {
        if (bonds == null) {
            return false;
        }
        this.bonds.addAll(bonds);
        return true;
    }

    public boolean removeBond(Bond bond) {
        if (bond == null) {
            return false;
        }
        return this.bonds.remove(bond);
    }

    public Bond getBond(int index) {
        return this.bonds.get(index);
    }

    public List<Bond> getBonds() {
        return Collections.unmodifiableList(this.bonds);
    }

    public Bond[] getBondArray() {
        return this.bonds.toArray(new Bond[0]);
    }

    public int getNumberOfBonds() {
        return this.bonds.size();
    }

    public String getBondEnergyString() {
        BondType bondType = this.bonds.getFirst().getBondType();
        String energy = bondType.bondFunction == BondType.BondFunction.QUARTIC ? String.format("k*(d^2 + %.15g*d^3 + %.15g*d^4);\nd=r-r0;\n", bondType.cubic / 0.1, bondType.quartic / 0.010000000000000002) : "k*(d^2);\nd=r-r0;\n";
        return energy;
    }

    @Override
    public void log() {
        if (this.getNumberOfBonds() <= 0) {
            return;
        }
        logger.info("\n Bond Stretching Interactions:");
        for (Bond bond : this.getBonds()) {
            logger.info(" Bond \t" + bond.toString());
        }
    }

    @Override
    public String toPDBString() {
        if (this.getNumberOfBonds() <= 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        sb.append(String.format("REMARK   3   %s %g (%d)\n", "BOND STRETCHING            : ", this.getEnergy(), this.getNumberOfBonds()));
        sb.append(String.format("REMARK   3   %s %g\n", "BOND RMSD                  : ", this.getRMSD()));
        return sb.toString();
    }

    @Override
    public String toString() {
        return String.format("  %s %20.8f %12d %12.3f (%8.5f)\n", "Bond Stretching   ", this.getEnergy(), this.getNumberOfBonds(), this.getTime(), this.getRMSD());
    }
}

