/*
 * Decompiled with CFR 0.152.
 */
package ffx.potential.parsers;

import ffx.potential.MolecularAssembly;
import ffx.potential.Utilities;
import ffx.potential.bonded.Atom;
import ffx.potential.bonded.Bond;
import ffx.potential.parameters.ForceField;
import ffx.utilities.StringUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.OptionalDouble;
import java.util.Set;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.apache.commons.configuration2.CompositeConfiguration;

public abstract class SystemFilter {
    protected static final Pattern lambdaPattern = Pattern.compile("Lambda: +([01]\\.\\d+)");
    private static final Logger logger = Logger.getLogger(SystemFilter.class.getName());
    private static Versioning vers = Versioning.TINKER;
    private static int absoluteCounter = 0;
    protected final boolean dieOnMissingAtom;
    protected boolean standardizeAtomNames;
    protected final boolean vdwH;
    protected List<Atom> atomList = null;
    protected List<Bond> bondList = null;
    protected List<MolecularAssembly> systems = new Vector<MolecularAssembly>();
    protected List<File> files;
    protected Utilities.FileType fileType = Utilities.FileType.UNK;
    protected CompositeConfiguration properties;
    protected ForceField forceField;
    protected boolean fileRead = false;
    MolecularAssembly activeMolecularAssembly;
    File currentFile = null;

    private SystemFilter(ForceField forceField, CompositeConfiguration properties) {
        this.forceField = forceField;
        this.properties = properties;
        if (properties == null && forceField != null) {
            this.properties = forceField.getProperties();
        }
        if (this.properties != null) {
            this.vdwH = this.properties.getBoolean("vdwHydrogens", false);
            this.dieOnMissingAtom = this.properties.getBoolean("trajectory-dieOnMissing", false);
            this.standardizeAtomNames = this.properties.getBoolean("standardizeAtomNames", true);
        } else {
            logger.info(" SystemFilter: Using default values due to no properties.");
            this.vdwH = false;
            this.dieOnMissingAtom = false;
            this.standardizeAtomNames = true;
        }
    }

    public SystemFilter(List<File> files, MolecularAssembly molecularAssembly, ForceField forceField, CompositeConfiguration properties) {
        this(forceField, properties);
        this.files = files;
        if (files != null) {
            this.currentFile = files.get(0);
        }
        this.activeMolecularAssembly = molecularAssembly;
    }

    public SystemFilter(File file, MolecularAssembly molecularAssembly, ForceField forceField, CompositeConfiguration properties) {
        this(forceField, properties);
        this.files = new ArrayList<File>();
        if (file != null) {
            this.files.add(file);
        }
        this.currentFile = file;
        this.activeMolecularAssembly = molecularAssembly;
    }

    public SystemFilter(File file, List<MolecularAssembly> molecularAssemblies, ForceField forceField, CompositeConfiguration properties) {
        this(forceField, properties);
        this.files = new ArrayList<File>();
        if (file != null) {
            this.files.add(file);
        }
        this.currentFile = file;
        this.systems = new ArrayList<MolecularAssembly>(molecularAssemblies);
        this.activeMolecularAssembly = this.systems.get(0);
    }

    public static File previousVersion(File file) {
        if (file == null) {
            return null;
        }
        String fileName = file.getAbsolutePath();
        int dot = file.getAbsolutePath().lastIndexOf(".");
        int under = file.getAbsolutePath().lastIndexOf("_");
        File newFile = file;
        if (under > dot) {
            String name = fileName.substring(0, under);
            newFile = new File(name);
        }
        File baseFile = newFile;
        File previousFile = null;
        int i = 1;
        while (newFile.exists()) {
            previousFile = newFile;
            newFile = baseFile;
            int thousand = ++i / 1000;
            int hundred = (i - 1000 * thousand) / 100;
            int tens = (i - 1000 * thousand - 100 * hundred) / 10;
            int ones = i - 1000 * thousand - 100 * hundred - 10 * tens;
            StringBuilder newFileString = new StringBuilder(baseFile.getAbsolutePath());
            if (thousand != 0) {
                newFileString.append('_').append(thousand).append(hundred).append(tens).append(ones);
            } else if (hundred != 0) {
                newFileString.append('_').append(hundred).append(tens).append(ones);
            } else if (tens != 0) {
                newFileString.append('_').append(tens).append(ones);
            } else {
                newFileString.append('_').append(ones);
            }
            newFile = new File(newFileString.toString());
        }
        return previousFile;
    }

    public static void setVersioning(Versioning vers) {
        SystemFilter.vers = vers;
    }

    public static File version(File file) {
        if (vers == Versioning.TINKER) {
            return SystemFilter.versionTinker(file);
        }
        if (vers == Versioning.PREFIX_ABSOLUTE || vers == Versioning.POSTFIX_ABSOLUTE) {
            return SystemFilter.versionAbsolute(file, vers == Versioning.PREFIX_ABSOLUTE);
        }
        return SystemFilter.version(file, vers == Versioning.PREFIX);
    }

    private static File version(File file, boolean prefix) {
        String newFn;
        if (file == null || !file.exists()) {
            return file;
        }
        Object fn = file.getAbsolutePath();
        int dot = ((String)fn).lastIndexOf(".");
        int under = ((String)fn).lastIndexOf("_");
        if (dot < 0) {
            fn = (String)fn + ".unk";
            dot = ((String)fn).lastIndexOf(".");
        }
        if (under < 0) {
            under = dot;
        }
        String name = prefix ? ((String)fn).substring(0, under) : ((String)fn).substring(0, dot);
        String extension = prefix ? ((String)fn).substring(dot + 1) : ((String)fn).substring(dot + 1, under);
        int number = 0;
        String string = newFn = prefix ? String.format("%s_%d.%s", name, number, extension) : String.format("%s.%s_%d", name, extension, number);
        if (prefix && under < dot) {
            try {
                number = Integer.parseInt(((String)fn).substring(under + 1, dot));
            }
            catch (NumberFormatException ex) {
                name = ((String)fn).substring(0, dot);
                newFn = String.format("%s_%d.%s", name, ++number, extension);
            }
        } else if (!prefix && under > dot) {
            try {
                number = Integer.parseInt(((String)fn).substring(under + 1));
                ++number;
            }
            catch (NumberFormatException ex) {
                // empty catch block
            }
        }
        File newFile = new File(newFn);
        while (newFile.exists()) {
            newFn = prefix ? String.format("%s_%d.%s", name, number, extension) : String.format("%s.%s_%d", name, extension, ++number);
            newFile = new File(newFn);
        }
        return newFile;
    }

    private static synchronized File versionAbsolute(File file, boolean prefix) {
        if (file == null || !file.exists()) {
            return file;
        }
        Object fn = file.getAbsolutePath();
        int dot = ((String)fn).lastIndexOf(".");
        int under = ((String)fn).lastIndexOf("_");
        if (dot < 0) {
            fn = (String)fn + ".unk";
            dot = ((String)fn).lastIndexOf(".");
        }
        if (under < 0) {
            under = dot;
        }
        String name = prefix ? ((String)fn).substring(0, under) : ((String)fn).substring(0, dot);
        String extension = prefix ? ((String)fn).substring(dot + 1) : ((String)fn).substring(dot + 1, under);
        String newFn = prefix ? String.format("%s_%d.%s", name, absoluteCounter, extension) : String.format("%s.%s_%d", name, extension, absoluteCounter);
        File newFile = new File(newFn);
        while (newFile.exists()) {
            newFn = prefix ? String.format("%s_%d.%s", name, absoluteCounter, extension) : String.format("%s.%s_%d", name, extension, ++absoluteCounter);
            newFile = new File(newFn);
        }
        return newFile;
    }

    private static File versionTinker(File file) {
        if (file == null) {
            return null;
        }
        if (!file.exists()) {
            return file;
        }
        String fileName = file.getAbsolutePath();
        int dot = file.getAbsolutePath().lastIndexOf(".");
        int under = file.getAbsolutePath().lastIndexOf("_");
        File newFile = file;
        if (under > dot) {
            String name = fileName.substring(0, under);
            newFile = new File(name);
        }
        File oldFile = newFile;
        int i = 1;
        while (newFile.exists()) {
            String newFileString = String.format("%s_%d", oldFile.getAbsolutePath(), ++i);
            newFile = new File(newFileString);
        }
        return newFile;
    }

    public static Set<Atom> atomListToSet(List<Integer> atomList, Atom[] atoms) {
        HashSet<Atom> atomSet = new HashSet<Atom>();
        for (int i = 0; i < atomList.size(); ++i) {
            atomSet.add(atoms[atomList.get(i)]);
        }
        return atomSet;
    }

    /*
     * WARNING - void declaration
     */
    public void applyAtomProperties() {
        void var7_20;
        String[] noElStrings;
        int n;
        Atom[] atomArray = this.activeMolecularAssembly.getAtomArray();
        int nAtoms = atomArray.length;
        String[] nouseKeys = this.properties.getStringArray("nouse");
        for (String string : nouseKeys) {
            String[] stringArray;
            for (String tok : stringArray = string.split("\\s+")) {
                try {
                    List nouseRange = StringUtils.parseAtomRange((String)"nouse", (String)tok, (int)nAtoms);
                    Iterator iterator = nouseRange.iterator();
                    while (iterator.hasNext()) {
                        int j = (Integer)iterator.next();
                        atomArray[j].setUse(false);
                    }
                }
                catch (IllegalArgumentException ex) {
                    boolean atomFound = false;
                    for (Atom atom : atomArray) {
                        if (!atom.getName().equalsIgnoreCase(tok)) continue;
                        atomFound = true;
                        atom.setUse(false);
                    }
                    if (atomFound) {
                        logger.info(String.format(" Setting atoms with name %s to not be used", tok));
                        continue;
                    }
                    logger.log(Level.INFO, ex.getLocalizedMessage());
                }
            }
        }
        if (this.properties.containsKey("active")) {
            void var7_14;
            Object[] activeKeys;
            for (Atom atom : atomArray) {
                atom.setActive(false);
            }
            Object[] objectArray = activeKeys = this.properties.getStringArray("active");
            n = objectArray.length;
            boolean bl = false;
            while (var7_14 < n) {
                Object object = objectArray[var7_14];
                try {
                    inactiveRange = StringUtils.parseAtomRange((String)"inactive", (String)object, (int)nAtoms);
                    Iterator iterator = inactiveRange.iterator();
                    while (iterator.hasNext()) {
                        i = (Integer)iterator.next();
                        atomArray[i].setActive(false);
                    }
                }
                catch (IllegalArgumentException ex) {
                    logger.log(Level.INFO, ex.getLocalizedMessage());
                }
                ++var7_14;
            }
        } else if (this.properties.containsKey("inactive")) {
            void var7_18;
            String[] inactiveKeys;
            for (Atom atom : atomArray) {
                atom.setActive(true);
            }
            String[] stringArray = inactiveKeys = this.properties.getStringArray("inactive");
            n = stringArray.length;
            boolean bl = false;
            while (var7_18 < n) {
                String string = stringArray[var7_18];
                try {
                    inactiveRange = StringUtils.parseAtomRange((String)"inactive", (String)string, (int)nAtoms);
                    Iterator iterator = inactiveRange.iterator();
                    while (iterator.hasNext()) {
                        i = (Integer)iterator.next();
                        atomArray[i].setActive(false);
                    }
                }
                catch (IllegalArgumentException ex) {
                    logger.log(Level.INFO, ex.getLocalizedMessage());
                }
                ++var7_18;
            }
        }
        String[] stringArray = noElStrings = this.properties.getStringArray("noElectro");
        n = stringArray.length;
        boolean bl = false;
        while (var7_20 < n) {
            String[] toks;
            String string = stringArray[var7_20];
            for (String tok : toks = string.split("\\s+")) {
                try {
                    List noERange = StringUtils.parseAtomRange((String)"noElectro", (String)tok, (int)nAtoms);
                    Iterator j = noERange.iterator();
                    while (j.hasNext()) {
                        int i = (Integer)j.next();
                        atomArray[i].setElectrostatics(false);
                    }
                }
                catch (IllegalArgumentException ex) {
                    boolean atomFound = false;
                    for (Atom atom : atomArray) {
                        if (!atom.getName().equalsIgnoreCase(tok)) continue;
                        atomFound = true;
                        atom.setElectrostatics(false);
                    }
                    if (atomFound) {
                        logger.info(String.format(" Disabled electrostatics for atoms with name %s", tok));
                        continue;
                    }
                    logger.log(Level.INFO, String.format(" No electrostatics input %s could not be parsed as a numerical range or atom type present in assembly", tok));
                }
            }
            ++var7_20;
        }
    }

    public abstract void closeReader();

    public int countNumModels() {
        return -1;
    }

    public boolean fileRead() {
        return this.fileRead;
    }

    public MolecularAssembly getActiveMolecularSystem() {
        return this.activeMolecularAssembly;
    }

    public List<Atom> getAtomList() {
        return this.atomList;
    }

    public File getFile() {
        return this.currentFile;
    }

    public void setFile(File file) {
        this.currentFile = file;
        this.files = new ArrayList<File>();
        if (file != null) {
            this.files.add(file);
        }
    }

    public List<File> getFiles() {
        return this.files;
    }

    public void setFiles(List<File> files) {
        this.files = files;
        this.currentFile = files != null && !files.isEmpty() ? files.get(0) : null;
    }

    public OptionalDouble getLastReadLambda() {
        return OptionalDouble.empty();
    }

    public MolecularAssembly[] getMolecularAssemblyArray() {
        if (!this.systems.isEmpty()) {
            return this.systems.toArray(new MolecularAssembly[0]);
        }
        return new MolecularAssembly[]{this.activeMolecularAssembly};
    }

    public String[] getRemarkLines() {
        return new String[0];
    }

    public int getSnapshot() {
        return -1;
    }

    public Utilities.FileType getType() {
        return this.fileType;
    }

    public void setType(Utilities.FileType fileType) {
        this.fileType = fileType;
    }

    public abstract boolean readFile();

    public abstract boolean readNext();

    public abstract boolean readNext(boolean var1);

    public abstract boolean readNext(boolean var1, boolean var2);

    public abstract boolean readNext(boolean var1, boolean var2, boolean var3);

    public void setForceField(ForceField forceField) {
        this.forceField = forceField;
    }

    public void setProperties(CompositeConfiguration properties) {
        this.properties = properties;
    }

    public boolean writeFile(File saveFile, boolean append) {
        return this.writeFile(saveFile, append, null);
    }

    public abstract boolean writeFile(File var1, boolean var2, String[] var3);

    protected void setFileRead(boolean fileRead) {
        this.fileRead = fileRead;
    }

    void setMolecularSystem(MolecularAssembly molecularAssembly) {
        this.activeMolecularAssembly = molecularAssembly;
    }

    public static enum Versioning {
        TINKER,
        PREFIX,
        POSTFIX,
        PREFIX_ABSOLUTE,
        POSTFIX_ABSOLUTE,
        NONE;

    }
}

