/*
 * Decompiled with CFR 0.152.
 */
package ffx.potential.parsers;

import ffx.potential.MolecularAssembly;
import ffx.potential.bonded.Atom;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.List;
import java.util.logging.Logger;

public class InducedFilter {
    private static final Logger logger = Logger.getLogger(InducedFilter.class.getName());
    File file;
    private final MolecularAssembly molecularAssembly;

    public InducedFilter(MolecularAssembly s, File f) {
        this.molecularAssembly = s;
        this.file = f;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean read() {
        if (!this.file.exists()) return false;
        if (!this.file.canRead()) {
            return false;
        }
        try (BufferedReader br = new BufferedReader(new FileReader(this.file));){
            String data = br.readLine();
            String[] tokens = data.trim().split(" +");
            if (tokens.length == 0) {
                boolean bl = false;
                return bl;
            }
            int numAtoms = Integer.parseInt(tokens[0]);
            if (numAtoms != this.molecularAssembly.getAtomList().size()) {
                boolean bl = false;
                return bl;
            }
            double[][] x = new double[numAtoms][3];
            for (int i = 0; i < numAtoms; ++i) {
                data = br.readLine().trim();
                tokens = data.split(" +");
                if (tokens.length != 5) {
                    boolean bl = false;
                    return bl;
                }
                x[i][0] = Double.parseDouble(tokens[2]);
                x[i][1] = Double.parseDouble(tokens[3]);
                x[i][2] = Double.parseDouble(tokens[4]);
            }
            List<Atom> atoms = this.molecularAssembly.getAtomList();
            double max = 0.0;
            for (Atom a : atoms) {
                int n = a.getIndex() - 1;
            }
            logger.warning("Max Induced: " + max);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }
}

