/*
 * Decompiled with CFR 0.152.
 */
package ffx.potential.parsers;

import ffx.potential.MolecularAssembly;
import ffx.potential.Utilities;
import ffx.potential.bonded.Atom;
import ffx.potential.bonded.Bond;
import ffx.potential.bonded.BondedUtils;
import ffx.potential.parameters.AtomType;
import ffx.potential.parameters.BondType;
import ffx.potential.parameters.ForceField;
import ffx.potential.parsers.SystemFilter;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import java.util.logging.Logger;
import org.apache.commons.configuration2.CompositeConfiguration;

public class INTFilter
extends SystemFilter {
    private static final Logger logger = Logger.getLogger(INTFilter.class.getName());

    public INTFilter(List<File> files, MolecularAssembly molecularAssembly, ForceField forceField, CompositeConfiguration properties) {
        super(files, molecularAssembly, forceField, properties);
        this.fileType = Utilities.FileType.INT;
    }

    public INTFilter(File file, MolecularAssembly molecularAssembly, ForceField forceField, CompositeConfiguration properties) {
        super(file, molecularAssembly, forceField, properties);
        this.fileType = Utilities.FileType.INT;
    }

    @Override
    public void closeReader() {
        logger.fine(" Reading trajectories not yet supported for INTFilter");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean readFile() {
        File intFile = this.activeMolecularAssembly.getFile();
        if (this.forceField == null) {
            logger.warning("No force field is associated with " + intFile.toString());
            return false;
        }
        logger.info(" Opening " + intFile.toString());
        try {
            int i;
            Vector<int[]> zdel;
            Vector<int[]> zadd;
            double[][] zv;
            int[][] zi;
            int numberOfAtoms;
            block53: {
                BufferedReader br = new BufferedReader(new FileReader(intFile));
                String data = br.readLine().trim();
                while (data.isEmpty()) {
                    data = br.readLine().trim();
                }
                String[] tokens = data.trim().split(" +");
                try {
                    numberOfAtoms = Integer.parseInt(tokens[0]);
                    if (numberOfAtoms < 1) {
                        logger.warning("Invalid number of atoms: " + numberOfAtoms);
                        boolean bl = false;
                        return bl;
                    }
                }
                catch (Exception e) {
                    logger.severe("Error parsing the number of atoms.\n" + String.valueOf(e));
                    boolean bl = false;
                    return bl;
                }
                if (tokens.length >= 2) {
                    tokens = data.trim().split(" +", 2);
                    this.activeMolecularAssembly.setName(tokens[1]);
                }
                logger.info("  Opening " + intFile.getName() + " with " + numberOfAtoms + " atoms");
                double[] d = new double[]{0.0, 0.0, 0.0};
                zi = new int[numberOfAtoms][4];
                zv = new double[numberOfAtoms][3];
                zadd = new Vector<int[]>();
                zdel = new Vector<int[]>();
                this.atomList = new ArrayList();
                for (i = 0; i < numberOfAtoms; ++i) {
                    if (!br.ready()) {
                        boolean bl = false;
                        return bl;
                    }
                    data = br.readLine();
                    if (data == null) {
                        logger.severe("  Check atom " + (i + 1) + " in " + this.activeMolecularAssembly.getFile().getName());
                        boolean bl = false;
                        return bl;
                    }
                    tokens = data.trim().split(" +");
                    if (tokens.length < 3) {
                        logger.severe("  Check atom " + (i + 1) + " in " + this.activeMolecularAssembly.getFile().getName());
                        boolean bl = false;
                        return bl;
                    }
                    String name = tokens[1];
                    int type = Integer.parseInt(tokens[2]);
                    AtomType atomType = this.forceField.getAtomType(Integer.toString(type));
                    if (atomType == null) {
                        StringBuilder message = new StringBuilder("Check atom type ");
                        message.append(type).append(" for Atom ").append(i + 1);
                        message.append(" in ").append(this.activeMolecularAssembly.getFile().getName());
                        logger.warning(message.toString());
                        boolean bl = false;
                        return bl;
                    }
                    Atom atom = new Atom(i + 1, name, atomType, d);
                    this.atomList.add(atom);
                    if (tokens.length >= 5) {
                        zi[i][0] = Integer.parseInt(tokens[3]);
                        zv[i][0] = Double.parseDouble(tokens[4]);
                    } else {
                        zi[i][0] = 0;
                        zv[i][0] = 0.0;
                    }
                    if (tokens.length >= 7) {
                        zi[i][1] = Integer.parseInt(tokens[5]);
                        zv[i][1] = Double.parseDouble(tokens[6]);
                    } else {
                        zi[i][1] = 0;
                        zv[i][1] = 0.0;
                    }
                    if (tokens.length >= 10) {
                        zi[i][2] = Integer.parseInt(tokens[7]);
                        zv[i][2] = Double.parseDouble(tokens[8]);
                        zi[i][3] = Integer.parseInt(tokens[9]);
                        continue;
                    }
                    zi[i][2] = 0;
                    zv[i][2] = 0.0;
                    zi[i][3] = 0;
                }
                if (br.ready() && (data = br.readLine()).trim().equalsIgnoreCase("")) {
                    int[] pair;
                    boolean blank = false;
                    while (br.ready() && !blank) {
                        data = br.readLine();
                        if (data.trim().equalsIgnoreCase("")) {
                            blank = true;
                            continue;
                        }
                        tokens = data.trim().split(" +");
                        if (tokens.length != 2) {
                            logger.severe("  Check Additional Bond Pair: " + (zadd.size() + 1) + " in " + this.activeMolecularAssembly.getFile().getName());
                            boolean name = false;
                            return name;
                        }
                        pair = new int[]{Integer.parseInt(tokens[0]), Integer.parseInt(tokens[1])};
                        zadd.add(pair);
                    }
                    while (br.ready()) {
                        data = br.readLine();
                        tokens = data.trim().split(" +");
                        if (tokens.length != 2) {
                            logger.severe("  Check Bond Pair to Remove: " + (zadd.size() + 1) + " in " + this.activeMolecularAssembly.getFile().getName());
                            boolean pair2 = false;
                            return pair2;
                        }
                        pair = new int[]{Integer.parseInt(tokens[0]), Integer.parseInt(tokens[1])};
                        zdel.add(pair);
                    }
                }
                if (this.atomList.size() == numberOfAtoms) {
                    this.bondList = new ArrayList();
                    break block53;
                } else {
                    logger.warning("\n Reported number of Atoms: " + numberOfAtoms + "\n Number of Atoms Found: " + this.atomList.size());
                    return false;
                }
                finally {
                    br.close();
                }
            }
            for (i = 1; i < numberOfAtoms; ++i) {
                int partner = zi[i][0];
                boolean del = false;
                for (int[] pair : zdel) {
                    if (pair[0] == i + 1 && pair[1] == partner) {
                        del = true;
                    }
                    if (pair[1] != i + 1 || pair[0] != partner) continue;
                    del = true;
                }
                if (del) continue;
                Atom atom1 = (Atom)this.atomList.get(i);
                Atom atom2 = (Atom)this.atomList.get(partner - 1);
                Bond bond = new Bond(atom1, atom2);
                BondType bondType = this.forceField.getBondType(atom1.getAtomType(), atom2.getAtomType());
                if (bondType == null) {
                    Bond.logNoBondType(atom1, atom2, this.forceField);
                } else {
                    bond.setBondType(bondType);
                }
                this.bondList.add(bond);
            }
            for (int[] pair : zadd) {
                Atom atom1 = (Atom)this.atomList.get(pair[0] - 1);
                Atom atom2 = (Atom)this.atomList.get(pair[1] - 1);
                Bond bond = new Bond(atom1, atom2);
                BondType bondType = this.forceField.getBondType(atom1.getAtomType(), atom2.getAtomType());
                if (bondType == null) {
                    Bond.logNoBondType(atom1, atom2, this.forceField);
                } else {
                    bond.setBondType(bondType);
                }
                this.bondList.add(bond);
            }
            int i2 = 0;
            while (true) {
                if (i2 >= numberOfAtoms) {
                    boolean bl = true;
                    return bl;
                }
                Atom atom = (Atom)this.atomList.get(i2);
                Atom ia = null;
                Atom ib = null;
                Atom ic = null;
                int[] atoms = zi[i2];
                if (atoms[0] > 0) {
                    ia = (Atom)this.atomList.get(atoms[0] - 1);
                }
                if (atoms[1] > 0) {
                    ib = (Atom)this.atomList.get(atoms[1] - 1);
                }
                if (atoms[2] > 0) {
                    ic = (Atom)this.atomList.get(atoms[2] - 1);
                }
                double bond = zv[i2][0];
                double angle1 = zv[i2][1];
                double angle2 = zv[i2][2];
                int chiral = atoms[3];
                BondedUtils.intxyz(atom, ia, bond, ib, angle1, ic, angle2, chiral);
                ++i2;
            }
        }
        catch (IOException e) {
            logger.severe(e.toString());
        }
        return false;
    }

    @Override
    public boolean readNext(boolean resetPosition) {
        return false;
    }

    @Override
    public boolean readNext(boolean resetPosition, boolean print) {
        return false;
    }

    @Override
    public boolean readNext(boolean resetPosition, boolean print, boolean parse) {
        return false;
    }

    @Override
    public boolean readNext() {
        return this.readNext(false);
    }

    @Override
    public boolean writeFile(File saveFile, boolean append, String[] extraLines) {
        return false;
    }
}

