/*
 * Decompiled with CFR 0.152.
 */
package ffx.potential.parameters;

import ffx.potential.parameters.AtomType;
import ffx.potential.parameters.BaseType;
import ffx.potential.parameters.ForceField;
import ffx.utilities.FFXProperty;
import ffx.utilities.PropertyGroup;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

@FFXProperty(name="ureybrad", clazz=String.class, propertyGroup=PropertyGroup.PotentialFunctionParameter, description="[3 integers and 2 reals]\nProvides the values for a single Urey-Bradley cross term potential parameter.\nThe integer modifiers give the atom class numbers for the three kinds of atoms\ninvolved in the angle for which a Urey-Bradley term is to be defined.\nThe real number modifiers give the force constant value for the term and the target value for the 1-3 distance in Angstroms.\nThe default units for the force constant are kcal/mole/Ang^2, but this can be controlled via the ureyunit keyword\n")
public final class UreyBradleyType
extends BaseType
implements Comparator<String> {
    public static final double DEFAULT_UREY_UNIT = 1.0;
    public static final double DEFAULT_UREY_CUBIC = 0.0;
    public static final double DEFAULT_UREY_QUARTIC = 0.0;
    @FFXProperty(name="ureyunit", propertyGroup=PropertyGroup.EnergyUnitConversion, defaultValue="1.0", description="Sets the scale factor needed to convert the energy value computed by the Urey-Bradley potential into units of kcal/mole.\nThe correct value is force field dependent and typically provided in the header of the master force field parameter file.\n")
    public double ureyUnit = 1.0;
    @FFXProperty(name="urey-cubic", propertyGroup=PropertyGroup.LocalGeometryFunctionalForm, defaultValue="0.0", description="Sets the value of the cubic term in the Taylor series expansion form of the Urey-Bradley potential energy.\nThe real number modifier gives the value of the coefficient as a multiple of the quadratic coefficient.\nThe default value in the absence of the urey-cubic keyword is zero; i.e., the cubic Urey-Bradley term is omitted.\n")
    public double cubic = 0.0;
    @FFXProperty(name="urey-quartic", propertyGroup=PropertyGroup.LocalGeometryFunctionalForm, defaultValue="0.0", description="Sets the value of the quartic term in the Taylor series expansion form of the Urey-Bradley potential energy.\nThe real number modifier gives the value of the coefficient as a multiple of the quadratic coefficient.\nThe default value in the absence of the urey-quartic keyword is zero; i.e., the quartic Urey-Bradley term is omitted.\n")
    public double quartic = 0.0;
    private static final Logger logger = Logger.getLogger(UreyBradleyType.class.getName());
    public final int[] atomClasses;
    public final double forceConstant;
    public final double distance;

    public UreyBradleyType(int[] atomClasses, double forceConstant, double distance) {
        super(ForceField.ForceFieldType.UREYBRAD, UreyBradleyType.sortKey(atomClasses));
        this.atomClasses = atomClasses;
        this.forceConstant = forceConstant;
        this.distance = distance;
    }

    public static UreyBradleyType average(@Nullable UreyBradleyType ureyBradleyType1, @Nullable UreyBradleyType ureyBradleyType2, @Nullable int[] atomClasses) {
        if (ureyBradleyType1 == null || ureyBradleyType2 == null || atomClasses == null) {
            return null;
        }
        double forceConstant = (ureyBradleyType1.forceConstant + ureyBradleyType2.forceConstant) / 2.0;
        double distance = (ureyBradleyType1.distance + ureyBradleyType2.distance) / 2.0;
        return new UreyBradleyType(atomClasses, forceConstant, distance);
    }

    public static UreyBradleyType parse(String input, String[] tokens) {
        if (tokens.length < 5) {
            logger.log(Level.WARNING, "Invalid UREYBRAD type:\n{0}", input);
        } else {
            try {
                int[] atomClasses = new int[]{Integer.parseInt(tokens[1]), Integer.parseInt(tokens[2]), Integer.parseInt(tokens[3])};
                double forceConstant = Double.parseDouble(tokens[4]);
                double distance = Double.parseDouble(tokens[5]);
                return new UreyBradleyType(atomClasses, forceConstant, distance);
            }
            catch (NumberFormatException e) {
                String message = "Exception parsing UREYBRAD type:\n" + input + "\n";
                logger.log(Level.SEVERE, message, e);
            }
        }
        return null;
    }

    public static String sortKey(int[] c) {
        if (c == null || c.length != 3) {
            return null;
        }
        if (c[0] > c[2]) {
            int temp = c[0];
            c[0] = c[2];
            c[2] = temp;
        }
        return c[0] + " " + c[1] + " " + c[2];
    }

    @Override
    public int compare(String key1, String key2) {
        String[] keys1 = key1.split(" ");
        String[] keys2 = key2.split(" ");
        int[] c1 = new int[3];
        int[] c2 = new int[3];
        for (int i = 0; i < 3; ++i) {
            c1[i] = Integer.parseInt(keys1[i]);
            c2[i] = Integer.parseInt(keys2[i]);
        }
        if (c1[1] < c2[1]) {
            return -1;
        }
        if (c1[1] > c2[1]) {
            return 1;
        }
        if (c1[0] < c2[0]) {
            return -1;
        }
        if (c1[0] > c2[0]) {
            return 1;
        }
        if (c1[2] < c2[2]) {
            return -1;
        }
        if (c1[2] > c2[2]) {
            return 1;
        }
        return 0;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UreyBradleyType ureyBradleyType = (UreyBradleyType)o;
        return Arrays.equals(this.atomClasses, ureyBradleyType.atomClasses);
    }

    public int hashCode() {
        return Arrays.hashCode(this.atomClasses);
    }

    public void incrementClasses(int increment) {
        int i = 0;
        while (i < this.atomClasses.length) {
            int n = i++;
            this.atomClasses[n] = this.atomClasses[n] + increment;
        }
        this.setKey(UreyBradleyType.sortKey(this.atomClasses));
    }

    public void patchClasses(HashMap<AtomType, AtomType> typeMap) {
        int count = 0;
        for (AtomType newType : typeMap.keySet()) {
            for (int atomClass : this.atomClasses) {
                if (atomClass != newType.atomClass) continue;
                ++count;
            }
        }
        if (count > 0 && count < this.atomClasses.length) {
            for (AtomType newType : typeMap.keySet()) {
                for (int i = 0; i < this.atomClasses.length; ++i) {
                    if (this.atomClasses[i] != newType.atomClass) continue;
                    AtomType knownType = typeMap.get(newType);
                    this.atomClasses[i] = knownType.atomClass;
                }
            }
            this.setKey(UreyBradleyType.sortKey(this.atomClasses));
        }
    }

    @Override
    public String toString() {
        return String.format("ureybrad  %5d  %5d  %5d  %6.2f  %7.4f", this.atomClasses[0], this.atomClasses[1], this.atomClasses[2], this.forceConstant, this.distance);
    }

    public static Element getXMLForce(Document doc, ForceField forceField) {
        Map<String, UreyBradleyType> types = forceField.getUreyBradleyTypes();
        if (!types.values().isEmpty()) {
            Element node = doc.createElement("AmoebaUreyBradleyForce");
            node.setAttribute("cubic", String.valueOf(forceField.getDouble("urey-cubic", 0.0)));
            node.setAttribute("quartic", String.valueOf(forceField.getDouble("urey-quartic", 0.0)));
            for (UreyBradleyType ureyBradleyType : types.values()) {
                node.appendChild(ureyBradleyType.toXML(doc));
            }
            return node;
        }
        return null;
    }

    public Element toXML(Document doc) {
        Element node = doc.createElement("UreyBradley");
        node.setAttribute("class1", String.format("%d", this.atomClasses[0]));
        node.setAttribute("class2", String.format("%d", this.atomClasses[1]));
        node.setAttribute("class3", String.format("%d", this.atomClasses[2]));
        node.setAttribute("k", String.format("%.17f", this.forceConstant * 4.184 / 0.010000000000000002));
        node.setAttribute("d", String.format("%.17f", this.distance * 0.1));
        return node;
    }
}

