/*
 * Decompiled with CFR 0.152.
 */
package ffx.potential.parameters;

import ffx.numerics.OptimizationInterface;
import ffx.numerics.Potential;
import ffx.numerics.optimization.LBFGS;
import ffx.numerics.optimization.LineSearch;
import ffx.numerics.optimization.OptimizationListener;
import ffx.potential.bonded.AminoAcidUtils;
import ffx.potential.bonded.Angle;
import ffx.potential.bonded.AngleTorsion;
import ffx.potential.bonded.Atom;
import ffx.potential.bonded.Bond;
import ffx.potential.bonded.BondedUtils;
import ffx.potential.bonded.ImproperTorsion;
import ffx.potential.bonded.OutOfPlaneBend;
import ffx.potential.bonded.PiOrbitalTorsion;
import ffx.potential.bonded.Residue;
import ffx.potential.bonded.Rotamer;
import ffx.potential.bonded.StretchBend;
import ffx.potential.bonded.StretchTorsion;
import ffx.potential.bonded.Torsion;
import ffx.potential.bonded.TorsionTorsion;
import ffx.potential.bonded.UreyBradley;
import ffx.potential.parameters.AngleType;
import ffx.potential.parameters.AtomType;
import ffx.potential.parameters.BondType;
import ffx.potential.parameters.ForceField;
import ffx.potential.parameters.MultipoleType;
import ffx.potential.parameters.OutOfPlaneBendType;
import ffx.potential.parameters.PiOrbitalTorsionType;
import ffx.potential.parameters.PolarizeType;
import ffx.potential.parameters.SoluteType;
import ffx.potential.parameters.StretchBendType;
import ffx.potential.parameters.TorsionType;
import ffx.potential.parameters.VDWType;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.math3.util.FastMath;

public class TitrationUtils {
    private static final Logger logger = Logger.getLogger(TitrationUtils.class.getName());
    private static final double LOG10 = FastMath.log((double)10.0);
    private static final MultipoleType aspZeroMultipoleType = new MultipoleType(MultipoleType.zeroM, new int[]{0, 140, 139}, MultipoleType.MultipoleFrameDefinition.ZTHENX, false);
    private static final MultipoleType ashZeroMultipoleType = new MultipoleType(MultipoleType.zeroM, new int[]{0, 144, 143}, MultipoleType.MultipoleFrameDefinition.ZTHENX, false);
    private static final MultipoleType gluZeroMultipoleType = new MultipoleType(MultipoleType.zeroM, new int[]{0, 158, 157}, MultipoleType.MultipoleFrameDefinition.ZTHENX, false);
    private static final MultipoleType glhZeroMultipoleType = new MultipoleType(MultipoleType.zeroM, new int[]{0, 164, 163}, MultipoleType.MultipoleFrameDefinition.ZTHENX, false);
    private static final MultipoleType hieZeroMultipoleType = new MultipoleType(MultipoleType.zeroM, new int[]{0, 130, 129}, MultipoleType.MultipoleFrameDefinition.ZTHENX, false);
    private static final MultipoleType hidZeroMultipoleType = new MultipoleType(MultipoleType.zeroM, new int[]{0, 126, 124}, MultipoleType.MultipoleFrameDefinition.ZTHENX, false);
    private static final MultipoleType lydZeroMultipoleType = new MultipoleType(MultipoleType.zeroM, new int[]{0, 200, 198}, MultipoleType.MultipoleFrameDefinition.ZTHENX, false);
    private static final MultipoleType cydZeroMultipoleType = new MultipoleType(MultipoleType.zeroM, new int[]{0, 49, 43}, MultipoleType.MultipoleFrameDefinition.ZTHENX, false);
    private static final PolarizeType zeroPolarizeType = new PolarizeType(0, 0.0, 0.39, 0.0, new int[]{0});
    private static final SoluteType zeroSoluteType = new SoluteType(0, 1.0);
    private static final AtomType dummyHydrogenAtomType = new AtomType(0, 0, "H", "\"Dummy Hydrogen\"", 1, 1.008, 1);
    private static final BondType zeroBondType = new BondType(new int[]{0, 0}, 0.0, 1.0);
    private static final AngleType zeroAngleType = new AngleType(new int[]{0, 0, 0}, 0.0, new double[]{0.0});
    private static final StretchBendType zeroStretchBendType = new StretchBendType(new int[]{0, 0, 0}, new double[]{0.0, 0.0});
    private static final OutOfPlaneBendType zeroOutOfPlaneBendType = new OutOfPlaneBendType(new int[]{0, 0, 0, 0}, 0.0);
    private static final TorsionType zeroTorsionType = new TorsionType(new int[]{0, 0, 0, 0}, new double[]{0.0}, new double[]{0.0}, new int[]{0});
    private static final PiOrbitalTorsionType zeroPiOrbitalTorsionType = new PiOrbitalTorsionType(new int[]{0, 0}, 0.0);
    private double proteinDielectric;
    private boolean tanhCorrection;
    private final int nLysAtomNames = LysineAtomNames.values().length;
    private final int nLysStates = LysStates.values().length;
    private final AtomType[][] lysAtomTypes = new AtomType[this.nLysAtomNames][this.nLysStates];
    private final MultipoleType[][] lysMultipoleTypes = new MultipoleType[this.nLysAtomNames][this.nLysStates];
    private final PolarizeType[][] lysPolarizeTypes = new PolarizeType[this.nLysAtomNames][this.nLysStates];
    private final VDWType[][] lysVDWTypes = new VDWType[this.nLysAtomNames][this.nLysStates];
    private final SoluteType[][] lysSoluteTypes = new SoluteType[this.nLysAtomNames][this.nLysStates];
    private final int nHisAtomNames = HistidineAtomNames.values().length;
    private final int nHisStates = HisStates.values().length;
    private final AtomType[][] hisAtomTypes = new AtomType[this.nHisAtomNames][this.nHisStates];
    private final MultipoleType[][] hisMultipoleTypes = new MultipoleType[this.nHisAtomNames][this.nHisStates];
    private final PolarizeType[][] hisPolarizeTypes = new PolarizeType[this.nHisAtomNames][this.nHisStates];
    private final VDWType[][] hisVDWTypes = new VDWType[this.nHisAtomNames][this.nHisStates];
    private final SoluteType[][] hisSoluteTypes = new SoluteType[this.nHisAtomNames][this.nHisStates];
    private final int nAspAtomNames = AspartateAtomNames.values().length;
    private final int nAspStates = AspStates.values().length;
    private final AtomType[][] aspAtomTypes = new AtomType[this.nAspAtomNames][this.nAspStates];
    private final MultipoleType[][] aspMultipoleTypes = new MultipoleType[this.nAspAtomNames][this.nAspStates];
    private final PolarizeType[][] aspPolarizeTypes = new PolarizeType[this.nAspAtomNames][this.nAspStates];
    private final VDWType[][] aspVDWTypes = new VDWType[this.nAspAtomNames][this.nAspStates];
    private final SoluteType[][] aspSoluteTypes = new SoluteType[this.nAspAtomNames][this.nAspStates];
    private final int nGluAtomNames = GlutamateAtomNames.values().length;
    private final int nGluStates = GluStates.values().length;
    private final AtomType[][] gluAtomTypes = new AtomType[this.nGluAtomNames][this.nGluStates];
    private final MultipoleType[][] gluMultipoleTypes = new MultipoleType[this.nGluAtomNames][this.nGluStates];
    private final PolarizeType[][] gluPolarizeTypes = new PolarizeType[this.nGluAtomNames][this.nGluStates];
    private final VDWType[][] gluVDWTypes = new VDWType[this.nGluAtomNames][this.nGluStates];
    private final SoluteType[][] gluSoluteTypes = new SoluteType[this.nGluAtomNames][this.nGluStates];
    private final int nCysAtomNames = CysteineAtomNames.values().length;
    private final int nCysStates = CysStates.values().length;
    private final AtomType[][] cysAtomTypes = new AtomType[this.nCysAtomNames][this.nCysStates];
    private final MultipoleType[][] cysMultipoleTypes = new MultipoleType[this.nCysAtomNames][this.nCysStates];
    private final PolarizeType[][] cysPolarizeTypes = new PolarizeType[this.nCysAtomNames][this.nCysStates];
    private final VDWType[][] cysVDWTypes = new VDWType[this.nCysAtomNames][this.nCysStates];
    private final SoluteType[][] cysSoluteTypes = new SoluteType[this.nCysAtomNames][this.nCysStates];
    private final ForceField forceField;
    private final SoluteType.SOLUTE_RADII_TYPE soluteRadiiType;
    private final boolean updateBondedTerms;
    private final HashMap<AminoAcidUtils.AminoAcid3, Double> rotamerPhBiasMap = new HashMap();

    public TitrationUtils(ForceField forceField) {
        SoluteType.SOLUTE_RADII_TYPE tempType;
        this.forceField = forceField;
        String gkRadius = forceField.getString("GK_RADIUS", "SOLUTE");
        try {
            tempType = SoluteType.SOLUTE_RADII_TYPE.valueOf(gkRadius.trim().toUpperCase());
        }
        catch (Exception e) {
            tempType = SoluteType.SOLUTE_RADII_TYPE.SOLUTE;
        }
        this.soluteRadiiType = tempType;
        this.updateBondedTerms = forceField.getBoolean("TITRATION_UPDATE_BONDED_TERMS", true);
        this.constructLYSState(AminoAcidUtils.AA_CB[AminoAcidUtils.AminoAcid3.LYS.ordinal()], LysStates.LYS);
        this.constructLYSState(AminoAcidUtils.AA_CB[AminoAcidUtils.AminoAcid3.LYD.ordinal()], LysStates.LYD);
        this.checkParameterTypes("LYS", this.lysAtomTypes, this.lysPolarizeTypes, this.lysMultipoleTypes, this.lysVDWTypes);
        this.constructHISState(AminoAcidUtils.AA_CB[AminoAcidUtils.AminoAcid3.HIS.ordinal()], HisStates.HIS);
        this.constructHISState(AminoAcidUtils.AA_CB[AminoAcidUtils.AminoAcid3.HID.ordinal()], HisStates.HID);
        this.constructHISState(AminoAcidUtils.AA_CB[AminoAcidUtils.AminoAcid3.HIE.ordinal()], HisStates.HIE);
        this.checkParameterTypes("HIS", this.hisAtomTypes, this.hisPolarizeTypes, this.hisMultipoleTypes, this.hisVDWTypes);
        this.constructASPState(AminoAcidUtils.AA_CB[AminoAcidUtils.AminoAcid3.ASP.ordinal()], AspStates.ASP);
        this.constructASPState(AminoAcidUtils.AA_CB[AminoAcidUtils.AminoAcid3.ASH.ordinal()], AspStates.ASH1);
        this.constructASPState(AminoAcidUtils.AA_CB[AminoAcidUtils.AminoAcid3.ASH.ordinal()], AspStates.ASH2);
        this.checkParameterTypes("ASP", this.aspAtomTypes, this.aspPolarizeTypes, this.aspMultipoleTypes, this.aspVDWTypes);
        this.constructGLUState(AminoAcidUtils.AA_CB[AminoAcidUtils.AminoAcid3.GLU.ordinal()], GluStates.GLU);
        this.constructGLUState(AminoAcidUtils.AA_CB[AminoAcidUtils.AminoAcid3.GLH.ordinal()], GluStates.GLH1);
        this.constructGLUState(AminoAcidUtils.AA_CB[AminoAcidUtils.AminoAcid3.GLH.ordinal()], GluStates.GLH2);
        this.checkParameterTypes("GLU", this.gluAtomTypes, this.gluPolarizeTypes, this.gluMultipoleTypes, this.gluVDWTypes);
        this.constructCYSState(AminoAcidUtils.AA_CB[AminoAcidUtils.AminoAcid3.CYS.ordinal()], CysStates.CYS);
        this.constructCYSState(AminoAcidUtils.AA_CB[AminoAcidUtils.AminoAcid3.CYD.ordinal()], CysStates.CYD);
        this.checkParameterTypes("CYS", this.cysAtomTypes, this.cysPolarizeTypes, this.cysMultipoleTypes, this.cysVDWTypes);
    }

    public TitrationUtils(ForceField forceField, double proteinDielectric, boolean tanhCorrection) {
        this(forceField);
        this.proteinDielectric = proteinDielectric;
        this.tanhCorrection = tanhCorrection;
    }

    public boolean testResidueTypes(Residue residue) {
        int i;
        boolean testPassed = true;
        int nStates = 1;
        AminoAcidUtils.AminoAcid3 aminoAcid3 = residue.getAminoAcid3();
        switch (aminoAcid3) {
            case ASP: 
            case ASH: 
            case ASD: 
            case GLU: 
            case GLH: 
            case GLD: 
            case HIS: 
            case HID: 
            case HIE: {
                nStates = 3;
                break;
            }
            case CYS: 
            case CYD: 
            case LYS: 
            case LYD: {
                nStates = 2;
                break;
            }
            default: {
                logger.info(String.format(" Only one state for atom %s.", new Object[]{aminoAcid3}));
            }
        }
        List<Atom> atomList = residue.getSideChainAtoms();
        int nAtoms = atomList.size();
        int[][][] axisAtomIndices = new int[nAtoms][nStates][];
        AtomType[][] atomTypes = new AtomType[nAtoms][nStates];
        MultipoleType[][] multipoleTypes = new MultipoleType[nAtoms][nStates];
        AtomType[] initialAtomTypes = new AtomType[nAtoms];
        MultipoleType[] initialMultipoleTypes = new MultipoleType[nAtoms];
        for (i = 0; i < nAtoms; ++i) {
            Atom atom = atomList.get(i);
            initialAtomTypes[i] = atom.getAtomType();
            initialMultipoleTypes[i] = atom.getMultipoleType();
        }
        for (int state = 0; state < nStates; ++state) {
            Atom atom;
            int i2;
            for (i2 = 0; i2 < nAtoms; ++i2) {
                atom = atomList.get(i2);
                String atomName = atom.getName();
                switch (aminoAcid3) {
                    case ASP: 
                    case ASH: 
                    case ASD: {
                        int index = AspartateAtomNames.valueOf(atomName).ordinal();
                        atom.setAtomType(this.aspAtomTypes[index][state]);
                        atom.setMultipoleType(this.aspMultipoleTypes[index][state]);
                        break;
                    }
                    case CYS: 
                    case CYD: {
                        int index = CysteineAtomNames.valueOf(atomName).ordinal();
                        atom.setAtomType(this.cysAtomTypes[index][state]);
                        atom.setMultipoleType(this.cysMultipoleTypes[index][state]);
                        break;
                    }
                    case GLU: 
                    case GLH: 
                    case GLD: {
                        int index = GlutamateAtomNames.valueOf(atomName).ordinal();
                        atom.setAtomType(this.gluAtomTypes[index][state]);
                        atom.setMultipoleType(this.gluMultipoleTypes[index][state]);
                        break;
                    }
                    case HIS: 
                    case HID: 
                    case HIE: {
                        int index = HistidineAtomNames.valueOf(atomName).ordinal();
                        atom.setAtomType(this.hisAtomTypes[index][state]);
                        atom.setMultipoleType(this.hisMultipoleTypes[index][state]);
                        break;
                    }
                    case LYS: 
                    case LYD: {
                        int index = LysineAtomNames.valueOf(atomName).ordinal();
                        atom.setAtomType(this.lysAtomTypes[index][state]);
                        atom.setMultipoleType(this.lysMultipoleTypes[index][state]);
                        break;
                    }
                    default: {
                        logger.info(String.format(" Only one state for atom %s.", atom));
                    }
                }
                atomTypes[i2][state] = atom.getAtomType();
                multipoleTypes[i2][state] = atom.getMultipoleType();
            }
            for (i2 = 0; i2 < nAtoms; ++i2) {
                atom = atomList.get(i2);
                MultipoleType.assignAxisAtoms(atom);
                axisAtomIndices[i2][state] = atom.getAxisAtomIndices();
            }
        }
        for (i = 0; i < nAtoms; ++i) {
            Atom atom = atomList.get(i);
            int[] referenceIndices = axisAtomIndices[i][0];
            AtomType referenceAtomType = atomTypes[i][0];
            MultipoleType referenceMultipoleType = multipoleTypes[i][0];
            for (int state = 1; state < nStates; ++state) {
                int[] stateIndices = axisAtomIndices[i][state];
                AtomType stateAtomType = atomTypes[i][state];
                MultipoleType stateMultipoleType = multipoleTypes[i][state];
                if (referenceMultipoleType.frameDefinition != stateMultipoleType.frameDefinition) {
                    logger.warning(String.format(" Local frame definition is inconsistent for atom %s", atom));
                    logger.warning(String.format("  %s\n  %s", referenceAtomType, referenceMultipoleType));
                    logger.warning(String.format("  %s\n  %s", stateAtomType, stateMultipoleType));
                    testPassed = false;
                    continue;
                }
                if (Arrays.compare(referenceIndices, stateIndices) == 0 || referenceMultipoleType.frameDefinition == MultipoleType.MultipoleFrameDefinition.BISECTOR && referenceIndices[0] == stateIndices[1] && referenceIndices[1] == stateIndices[0]) continue;
                logger.warning(String.format(" Local frame atom indices are inconsistent for atom %s", atom));
                logger.warning(String.format("  %s %s\n  %s", referenceAtomType, Arrays.toString(referenceIndices), referenceMultipoleType));
                logger.warning(String.format("  %s %s\n  %s", stateAtomType, Arrays.toString(stateIndices), stateMultipoleType));
                testPassed = false;
            }
        }
        for (i = 0; i < nAtoms; ++i) {
            Atom atom = atomList.get(i);
            atom.setAtomType(initialAtomTypes[i]);
            atom.setMultipoleType(initialMultipoleTypes[i]);
        }
        return testPassed;
    }

    /*
     * WARNING - void declaration
     */
    public void updateResidueParameters(Residue residue, Rotamer rotamer) {
        List<UreyBradley> list;
        List<TorsionTorsion> torsionTorsions;
        List<AngleTorsion> angleTorsions;
        List<StretchTorsion> stretchTorsions;
        if (!rotamer.isTitrating) {
            return;
        }
        AminoAcidUtils.AminoAcid3 aminoAcid3 = residue.getAminoAcid3();
        switch (aminoAcid3) {
            case ASP: 
            case ASH: {
                Atom atom;
                int atomIndex;
                int aspIndex = AspStates.ASP.ordinal();
                if (rotamer.aminoAcid3 == AminoAcidUtils.AminoAcid3.ASH) {
                    aspIndex = AspStates.ASH2.ordinal();
                }
                for (Enum enum_ : AspartateAtomNames.values()) {
                    if (enum_.name().equals("HD1")) continue;
                    atomIndex = enum_.ordinal();
                    atom = (Atom)residue.getAtomNode(enum_.name());
                    if (atom == null) {
                        logger.severe(" Atom is null for " + String.valueOf(enum_));
                        return;
                    }
                    atom.setAtomType(this.aspAtomTypes[atomIndex][aspIndex]);
                    atom.setMultipoleType(this.aspMultipoleTypes[atomIndex][aspIndex]);
                    atom.setPolarizeType(this.aspPolarizeTypes[atomIndex][aspIndex]);
                    atom.setVDWType(this.aspVDWTypes[atomIndex][aspIndex]);
                    atom.setSoluteType(this.aspSoluteTypes[atomIndex][aspIndex]);
                }
                break;
            }
            case GLU: 
            case GLH: {
                Atom atom;
                int atomIndex;
                int gluIndex = GluStates.GLU.ordinal();
                if (rotamer.aminoAcid3 == AminoAcidUtils.AminoAcid3.GLH) {
                    gluIndex = GluStates.GLH2.ordinal();
                }
                for (Enum enum_ : GlutamateAtomNames.values()) {
                    if (enum_.name().equals("HE1")) continue;
                    atomIndex = enum_.ordinal();
                    atom = (Atom)residue.getAtomNode(enum_.name());
                    if (atom == null) {
                        logger.severe(" Atom is null for " + String.valueOf(enum_));
                        return;
                    }
                    atom.setAtomType(this.gluAtomTypes[atomIndex][gluIndex]);
                    atom.setMultipoleType(this.gluMultipoleTypes[atomIndex][gluIndex]);
                    atom.setPolarizeType(this.gluPolarizeTypes[atomIndex][gluIndex]);
                    atom.setVDWType(this.gluVDWTypes[atomIndex][gluIndex]);
                    atom.setSoluteType(this.gluSoluteTypes[atomIndex][gluIndex]);
                }
                break;
            }
            case LYS: 
            case LYD: {
                Atom atom;
                int atomIndex;
                int lysIndex = LysStates.LYS.ordinal();
                if (rotamer.aminoAcid3 == AminoAcidUtils.AminoAcid3.LYD) {
                    lysIndex = LysStates.LYD.ordinal();
                }
                for (Enum enum_ : LysineAtomNames.values()) {
                    atomIndex = enum_.ordinal();
                    atom = (Atom)residue.getAtomNode(enum_.name());
                    if (atom == null) {
                        logger.severe(" Atom is null for " + String.valueOf(enum_));
                        return;
                    }
                    atom.setAtomType(this.lysAtomTypes[atomIndex][lysIndex]);
                    atom.setMultipoleType(this.lysMultipoleTypes[atomIndex][lysIndex]);
                    atom.setPolarizeType(this.lysPolarizeTypes[atomIndex][lysIndex]);
                    atom.setVDWType(this.lysVDWTypes[atomIndex][lysIndex]);
                    atom.setSoluteType(this.lysSoluteTypes[atomIndex][lysIndex]);
                }
                break;
            }
            case CYS: 
            case CYD: {
                Atom atom;
                int atomIndex;
                int cysIndex = CysStates.CYS.ordinal();
                if (rotamer.aminoAcid3 == AminoAcidUtils.AminoAcid3.CYD) {
                    cysIndex = CysStates.CYD.ordinal();
                }
                for (Enum enum_ : CysteineAtomNames.values()) {
                    atomIndex = enum_.ordinal();
                    atom = (Atom)residue.getAtomNode(enum_.name());
                    if (atom == null) {
                        logger.severe(" Atom is null for " + String.valueOf(enum_));
                        return;
                    }
                    atom.setAtomType(this.cysAtomTypes[atomIndex][cysIndex]);
                    atom.setMultipoleType(this.cysMultipoleTypes[atomIndex][cysIndex]);
                    atom.setPolarizeType(this.cysPolarizeTypes[atomIndex][cysIndex]);
                    atom.setVDWType(this.cysVDWTypes[atomIndex][cysIndex]);
                    atom.setSoluteType(this.cysSoluteTypes[atomIndex][cysIndex]);
                }
                break;
            }
            case HIS: 
            case HID: 
            case HIE: {
                Atom atom;
                int atomIndex;
                int hisIndex = switch (rotamer.aminoAcid3) {
                    case AminoAcidUtils.AminoAcid3.HIE -> HisStates.HIE.ordinal();
                    case AminoAcidUtils.AminoAcid3.HID -> HisStates.HID.ordinal();
                    default -> HisStates.HIS.ordinal();
                };
                for (Enum enum_ : HistidineAtomNames.values()) {
                    atomIndex = enum_.ordinal();
                    atom = (Atom)residue.getAtomNode(enum_.name());
                    if (atom == null) {
                        logger.severe(" Atom is null for " + String.valueOf(enum_));
                        return;
                    }
                    atom.setAtomType(this.hisAtomTypes[atomIndex][hisIndex]);
                    atom.setMultipoleType(this.hisMultipoleTypes[atomIndex][hisIndex]);
                    atom.setPolarizeType(this.hisPolarizeTypes[atomIndex][hisIndex]);
                    atom.setVDWType(this.hisVDWTypes[atomIndex][hisIndex]);
                    atom.setSoluteType(this.hisSoluteTypes[atomIndex][hisIndex]);
                }
                break;
            }
            default: {
                logger.severe(String.format(" No support for titrating residue %s with rotamer %s.", residue, rotamer));
            }
        }
        for (Atom atom : residue.getSideChainAtoms()) {
            MultipoleType.assignAxisAtoms(atom);
        }
        if (!this.updateBondedTerms) {
            return;
        }
        for (Bond bond : residue.getBondList()) {
            void var8_32;
            AtomType a2;
            AtomType a1 = bond.getAtom(0).getAtomType();
            BondType bondType = this.forceField.getBondType(a1, a2 = bond.getAtom(1).getAtomType());
            if (bondType == null) {
                BondType bondType2 = zeroBondType;
            }
            bond.setBondType((BondType)var8_32);
        }
        for (Angle angle : residue.getAngleList()) {
            AtomType atomType;
            AtomType a2;
            AtomType a1 = angle.getAtom(0).getAtomType();
            AngleType angleType = this.forceField.getAngleType(a1, a2 = angle.getAtom(1).getAtomType(), atomType = angle.getAtom(2).getAtomType());
            if (angleType == null) {
                angleType = zeroAngleType;
            }
            angle.setAngleType(angleType);
        }
        for (StretchBend stretchBend : residue.getStretchBendList()) {
            AtomType atomType;
            AtomType a2;
            AtomType a1 = stretchBend.getAtom(0).getAtomType();
            StretchBendType stretchBendType = this.forceField.getStretchBendType(a1, a2 = stretchBend.getAtom(1).getAtomType(), atomType = stretchBend.getAtom(2).getAtomType());
            if (stretchBendType == null) {
                stretchBendType = zeroStretchBendType;
            }
            stretchBend.setStretchBendType(stretchBendType);
        }
        for (OutOfPlaneBend outOfPlaneBend : residue.getOutOfPlaneBendList()) {
            AtomType a2;
            AtomType atomType;
            AtomType a0;
            AtomType a4 = outOfPlaneBend.getFourthAtom().getAtomType();
            OutOfPlaneBendType outOfPlaneBendType = this.forceField.getOutOfPlaneBendType(a4, a0 = outOfPlaneBend.getFirstAngleAtom().getAtomType(), atomType = outOfPlaneBend.getTrigonalAtom().getAtomType(), a2 = outOfPlaneBend.getLastAngleAtom().getAtomType());
            if (outOfPlaneBendType == null) {
                outOfPlaneBendType = zeroOutOfPlaneBendType;
            }
            outOfPlaneBend.setOutOfPlaneBendType(outOfPlaneBendType);
        }
        for (Torsion torsion : residue.getTorsionList()) {
            AtomType a4;
            AtomType atomType;
            AtomType a2;
            AtomType a1 = torsion.getAtom(0).getAtomType();
            TorsionType torsionType = this.forceField.getTorsionType(a1, a2 = torsion.getAtom(1).getAtomType(), atomType = torsion.getAtom(2).getAtomType(), a4 = torsion.getAtom(3).getAtomType());
            if (torsionType == null) {
                torsionType = zeroTorsionType;
            }
            torsion.setTorsionType(torsionType);
        }
        for (PiOrbitalTorsion piOrbitalTorsion : residue.getPiOrbitalTorsionList()) {
            AtomType atomType;
            Bond middleBond = piOrbitalTorsion.getMiddleBond();
            AtomType a1 = middleBond.getAtom(0).getAtomType();
            PiOrbitalTorsionType piOrbitalTorsionType = this.forceField.getPiOrbitalTorsionType(a1, atomType = middleBond.getAtom(1).getAtomType());
            if (piOrbitalTorsionType == null) {
                piOrbitalTorsionType = zeroPiOrbitalTorsionType;
            }
            piOrbitalTorsion.setPiOrbitalTorsionType(piOrbitalTorsionType);
        }
        List<ImproperTorsion> improperTorsions = residue.getImproperTorsionList();
        if (improperTorsions != null && !improperTorsions.isEmpty()) {
            logger.severe(" Improper torsions are not supported yet for pH-dependent rotamer optimization.");
        }
        if ((stretchTorsions = residue.getStretchTorsionList()) != null && !stretchTorsions.isEmpty()) {
            logger.severe(" Stretch-torsions are not supported yet for pH-dependent rotamer optimization.");
        }
        if ((angleTorsions = residue.getAngleTorsionList()) != null && !angleTorsions.isEmpty()) {
            logger.severe(" Angle-torsions are not supported yet for pH-dependent rotamer optimization.");
        }
        if ((torsionTorsions = residue.getTorsionTorsionList()) != null && !torsionTorsions.isEmpty()) {
            logger.severe(" Torsion-torsions are not supported yet for pH-dependent rotamer optimization.");
        }
        if ((list = residue.getUreyBradleyList()) != null && !list.isEmpty()) {
            logger.severe(" Urey-Bradleys are not supported yet for pH-dependent rotamer optimization.");
        }
    }

    public double[] getMultipole(Atom atom, double titrationLambda, double tautomerLambda, double[] multipole) {
        AminoAcidUtils.AminoAcid3 aminoAcid3;
        try {
            aminoAcid3 = atom.getMSNode(Residue.class).getAminoAcid3();
        }
        catch (Exception exception) {
            return multipole;
        }
        String atomName = atom.getName();
        switch (aminoAcid3) {
            case LYS: {
                int atomIndex = LysineAtomNames.valueOf(atomName).ordinal();
                MultipoleType lysM = this.lysMultipoleTypes[atomIndex][LysStates.LYS.ordinal()];
                MultipoleType lydM = this.lysMultipoleTypes[atomIndex][LysStates.LYD.ordinal()];
                double[] lys = lysM.getMultipole();
                double[] lyd = lydM.getMultipole();
                for (int i = 0; i < multipole.length; ++i) {
                    multipole[i] = titrationLambda * lys[i] + (1.0 - titrationLambda) * lyd[i];
                }
                break;
            }
            case CYS: {
                int atomIndex = CysteineAtomNames.valueOf(atomName).ordinal();
                MultipoleType cysM = this.cysMultipoleTypes[atomIndex][CysStates.CYS.ordinal()];
                MultipoleType cydM = this.cysMultipoleTypes[atomIndex][CysStates.CYD.ordinal()];
                double[] cys = cysM.getMultipole();
                double[] cyd = cydM.getMultipole();
                for (int i = 0; i < multipole.length; ++i) {
                    multipole[i] = titrationLambda * cys[i] + (1.0 - titrationLambda) * cyd[i];
                }
                break;
            }
            case HIS: {
                int atomIndex = HistidineAtomNames.valueOf(atomName).ordinal();
                MultipoleType hisM = this.hisMultipoleTypes[atomIndex][HisStates.HIS.ordinal()];
                MultipoleType hidM = this.hisMultipoleTypes[atomIndex][HisStates.HID.ordinal()];
                MultipoleType hieM = this.hisMultipoleTypes[atomIndex][HisStates.HIE.ordinal()];
                double[] his = hisM.getMultipole();
                double[] hid = hidM.getMultipole();
                double[] hie = hieM.getMultipole();
                for (int i = 0; i < multipole.length; ++i) {
                    multipole[i] = titrationLambda * his[i] + (1.0 - titrationLambda) * (tautomerLambda * hie[i] + (1.0 - tautomerLambda) * hid[i]);
                }
                break;
            }
            case ASD: {
                int atomIndex = AspartateAtomNames.valueOf(atomName).ordinal();
                MultipoleType aspM = this.aspMultipoleTypes[atomIndex][AspStates.ASP.ordinal()];
                MultipoleType ash1M = this.aspMultipoleTypes[atomIndex][AspStates.ASH1.ordinal()];
                MultipoleType ash2M = this.aspMultipoleTypes[atomIndex][AspStates.ASH2.ordinal()];
                double[] asp = aspM.getMultipole();
                double[] ash1 = ash1M.getMultipole();
                double[] ash2 = ash2M.getMultipole();
                for (int i = 0; i < multipole.length; ++i) {
                    multipole[i] = titrationLambda * (tautomerLambda * ash1[i] + (1.0 - tautomerLambda) * ash2[i]) + (1.0 - titrationLambda) * asp[i];
                }
                break;
            }
            case GLD: {
                int atomIndex = GlutamateAtomNames.valueOf(atomName).ordinal();
                MultipoleType gluM = this.gluMultipoleTypes[atomIndex][GluStates.GLU.ordinal()];
                MultipoleType glh1M = this.gluMultipoleTypes[atomIndex][GluStates.GLH1.ordinal()];
                MultipoleType glh2M = this.gluMultipoleTypes[atomIndex][GluStates.GLH2.ordinal()];
                double[] glu = gluM.getMultipole();
                double[] glh1 = glh1M.getMultipole();
                double[] glh2 = glh2M.getMultipole();
                for (int i = 0; i < multipole.length; ++i) {
                    multipole[i] = titrationLambda * (tautomerLambda * glh1[i] + (1.0 - tautomerLambda) * glh2[i]) + (1.0 - titrationLambda) * glu[i];
                }
                break;
            }
            default: {
                return multipole;
            }
        }
        return multipole;
    }

    public double[] getMultipoleTitrationDeriv(Atom atom, double titrationLambda, double tautomerLambda, double[] multipole) {
        AminoAcidUtils.AminoAcid3 aminoAcid3;
        try {
            aminoAcid3 = atom.getMSNode(Residue.class).getAminoAcid3();
        }
        catch (Exception exception) {
            return multipole;
        }
        String atomName = atom.getName();
        switch (aminoAcid3) {
            case LYS: {
                int atomIndex = LysineAtomNames.valueOf(atomName).ordinal();
                double[] lys = this.lysMultipoleTypes[atomIndex][LysStates.LYS.ordinal()].getMultipole();
                double[] lyd = this.lysMultipoleTypes[atomIndex][LysStates.LYD.ordinal()].getMultipole();
                for (int i = 0; i < multipole.length; ++i) {
                    multipole[i] = lys[i] - lyd[i];
                }
                break;
            }
            case CYS: {
                int atomIndex = CysteineAtomNames.valueOf(atomName).ordinal();
                double[] cys = this.cysMultipoleTypes[atomIndex][CysStates.CYS.ordinal()].getMultipole();
                double[] cyd = this.cysMultipoleTypes[atomIndex][CysStates.CYD.ordinal()].getMultipole();
                for (int i = 0; i < multipole.length; ++i) {
                    multipole[i] = cys[i] - cyd[i];
                }
                break;
            }
            case HIS: {
                int atomIndex = HistidineAtomNames.valueOf(atomName).ordinal();
                double[] his = this.hisMultipoleTypes[atomIndex][HisStates.HIS.ordinal()].getMultipole();
                double[] hid = this.hisMultipoleTypes[atomIndex][HisStates.HID.ordinal()].getMultipole();
                double[] hie = this.hisMultipoleTypes[atomIndex][HisStates.HIE.ordinal()].getMultipole();
                for (int i = 0; i < multipole.length; ++i) {
                    multipole[i] = his[i] - (tautomerLambda * hie[i] + (1.0 - tautomerLambda) * hid[i]);
                }
                break;
            }
            case ASD: {
                int atomIndex = AspartateAtomNames.valueOf(atomName).ordinal();
                double[] asp = this.aspMultipoleTypes[atomIndex][AspStates.ASP.ordinal()].getMultipole();
                double[] ash1 = this.aspMultipoleTypes[atomIndex][AspStates.ASH1.ordinal()].getMultipole();
                double[] ash2 = this.aspMultipoleTypes[atomIndex][AspStates.ASH2.ordinal()].getMultipole();
                for (int i = 0; i < multipole.length; ++i) {
                    multipole[i] = tautomerLambda * ash1[i] + (1.0 - tautomerLambda) * ash2[i] - asp[i];
                }
                break;
            }
            case GLD: {
                int atomIndex = GlutamateAtomNames.valueOf(atomName).ordinal();
                double[] glu = this.gluMultipoleTypes[atomIndex][GluStates.GLU.ordinal()].getMultipole();
                double[] glh1 = this.gluMultipoleTypes[atomIndex][GluStates.GLH1.ordinal()].getMultipole();
                double[] glh2 = this.gluMultipoleTypes[atomIndex][GluStates.GLH2.ordinal()].getMultipole();
                for (int i = 0; i < multipole.length; ++i) {
                    multipole[i] = tautomerLambda * glh1[i] + (1.0 - tautomerLambda) * glh2[i] - glu[i];
                }
                break;
            }
            default: {
                return multipole;
            }
        }
        return multipole;
    }

    public double[] getMultipoleTautomerDeriv(Atom atom, double titrationLambda, double tautomerLambda, double[] multipole) {
        AminoAcidUtils.AminoAcid3 aminoAcid3;
        try {
            aminoAcid3 = atom.getMSNode(Residue.class).getAminoAcid3();
        }
        catch (Exception exception) {
            return multipole;
        }
        String atomName = atom.getName();
        switch (aminoAcid3) {
            case HIS: {
                int atomIndex = HistidineAtomNames.valueOf(atomName).ordinal();
                double[] his = this.hisMultipoleTypes[atomIndex][HisStates.HIS.ordinal()].getMultipole();
                double[] hid = this.hisMultipoleTypes[atomIndex][HisStates.HID.ordinal()].getMultipole();
                double[] hie = this.hisMultipoleTypes[atomIndex][HisStates.HIE.ordinal()].getMultipole();
                for (int i = 0; i < multipole.length; ++i) {
                    multipole[i] = (1.0 - titrationLambda) * (hie[i] - hid[i]);
                }
                break;
            }
            case ASD: {
                int atomIndex = AspartateAtomNames.valueOf(atomName).ordinal();
                double[] asp = this.aspMultipoleTypes[atomIndex][AspStates.ASP.ordinal()].getMultipole();
                double[] ash1 = this.aspMultipoleTypes[atomIndex][AspStates.ASH1.ordinal()].getMultipole();
                double[] ash2 = this.aspMultipoleTypes[atomIndex][AspStates.ASH2.ordinal()].getMultipole();
                for (int i = 0; i < multipole.length; ++i) {
                    multipole[i] = titrationLambda * (ash1[i] - ash2[i]);
                }
                break;
            }
            case GLD: {
                int atomIndex = GlutamateAtomNames.valueOf(atomName).ordinal();
                double[] glu = this.gluMultipoleTypes[atomIndex][GluStates.GLU.ordinal()].getMultipole();
                double[] glh1 = this.gluMultipoleTypes[atomIndex][GluStates.GLH1.ordinal()].getMultipole();
                double[] glh2 = this.gluMultipoleTypes[atomIndex][GluStates.GLH2.ordinal()].getMultipole();
                for (int i = 0; i < multipole.length; ++i) {
                    multipole[i] = titrationLambda * (glh1[i] - glh2[i]);
                }
                break;
            }
            default: {
                return multipole;
            }
        }
        return multipole;
    }

    public double getPolarizability(Atom atom, double titrationLambda, double tautomerLambda, double defaultPolarizability) {
        AminoAcidUtils.AminoAcid3 aminoAcid3;
        try {
            aminoAcid3 = atom.getMSNode(Residue.class).getAminoAcid3();
        }
        catch (Exception exception) {
            return defaultPolarizability;
        }
        String atomName = atom.getName();
        switch (aminoAcid3) {
            case LYS: {
                int atomIndex = LysineAtomNames.valueOf(atomName).ordinal();
                double lys = this.lysPolarizeTypes[atomIndex][LysStates.LYS.ordinal()].polarizability;
                double lyd = this.lysPolarizeTypes[atomIndex][LysStates.LYD.ordinal()].polarizability;
                return titrationLambda * lys + (1.0 - titrationLambda) * lyd;
            }
            case CYS: {
                int atomIndex = CysteineAtomNames.valueOf(atomName).ordinal();
                double cys = this.cysPolarizeTypes[atomIndex][CysStates.CYS.ordinal()].polarizability;
                double cyd = this.cysPolarizeTypes[atomIndex][CysStates.CYD.ordinal()].polarizability;
                return titrationLambda * cys + (1.0 - titrationLambda) * cyd;
            }
            case HIS: {
                int atomIndex = HistidineAtomNames.valueOf(atomName).ordinal();
                double his = this.hisPolarizeTypes[atomIndex][HisStates.HIS.ordinal()].polarizability;
                double hid = this.hisPolarizeTypes[atomIndex][HisStates.HID.ordinal()].polarizability;
                double hie = this.hisPolarizeTypes[atomIndex][HisStates.HIE.ordinal()].polarizability;
                return titrationLambda * his + (1.0 - titrationLambda) * (tautomerLambda * hie + (1.0 - tautomerLambda) * hid);
            }
            case ASD: {
                int atomIndex = AspartateAtomNames.valueOf(atomName).ordinal();
                double asp = this.aspPolarizeTypes[atomIndex][AspStates.ASP.ordinal()].polarizability;
                double ash1 = this.aspPolarizeTypes[atomIndex][AspStates.ASH1.ordinal()].polarizability;
                double ash2 = this.aspPolarizeTypes[atomIndex][AspStates.ASH2.ordinal()].polarizability;
                return titrationLambda * (tautomerLambda * ash1 + (1.0 - tautomerLambda) * ash2) + (1.0 - titrationLambda) * asp;
            }
            case GLD: {
                int atomIndex = GlutamateAtomNames.valueOf(atomName).ordinal();
                double glu = this.gluPolarizeTypes[atomIndex][GluStates.GLU.ordinal()].polarizability;
                double glh1 = this.gluPolarizeTypes[atomIndex][GluStates.GLH1.ordinal()].polarizability;
                double glh2 = this.gluPolarizeTypes[atomIndex][GluStates.GLH2.ordinal()].polarizability;
                return titrationLambda * (tautomerLambda * glh1 + (1.0 - tautomerLambda) * glh2) + (1.0 - titrationLambda) * glu;
            }
        }
        return defaultPolarizability;
    }

    public double getPolarizabilityTitrationDeriv(Atom atom, double titrationLambda, double tautomerLambda) {
        AminoAcidUtils.AminoAcid3 aminoAcid3;
        try {
            aminoAcid3 = atom.getMSNode(Residue.class).getAminoAcid3();
        }
        catch (Exception exception) {
            return 0.0;
        }
        String atomName = atom.getName();
        switch (aminoAcid3) {
            case LYS: {
                int atomIndex = LysineAtomNames.valueOf(atomName).ordinal();
                double lys = this.lysPolarizeTypes[atomIndex][LysStates.LYS.ordinal()].polarizability;
                double lyd = this.lysPolarizeTypes[atomIndex][LysStates.LYD.ordinal()].polarizability;
                return lys - lyd;
            }
            case CYS: {
                int atomIndex = CysteineAtomNames.valueOf(atomName).ordinal();
                double cys = this.cysPolarizeTypes[atomIndex][CysStates.CYS.ordinal()].polarizability;
                double cyd = this.cysPolarizeTypes[atomIndex][CysStates.CYD.ordinal()].polarizability;
                return cys - cyd;
            }
            case HIS: {
                int atomIndex = HistidineAtomNames.valueOf(atomName).ordinal();
                double his = this.hisPolarizeTypes[atomIndex][HisStates.HIS.ordinal()].polarizability;
                double hid = this.hisPolarizeTypes[atomIndex][HisStates.HID.ordinal()].polarizability;
                double hie = this.hisPolarizeTypes[atomIndex][HisStates.HIE.ordinal()].polarizability;
                return his - (tautomerLambda * hie + (1.0 - tautomerLambda) * hid);
            }
            case ASD: {
                int atomIndex = AspartateAtomNames.valueOf(atomName).ordinal();
                double asp = this.aspPolarizeTypes[atomIndex][AspStates.ASP.ordinal()].polarizability;
                double ash1 = this.aspPolarizeTypes[atomIndex][AspStates.ASH1.ordinal()].polarizability;
                double ash2 = this.aspPolarizeTypes[atomIndex][AspStates.ASH2.ordinal()].polarizability;
                return tautomerLambda * ash1 + (1.0 - tautomerLambda) * ash2 - asp;
            }
            case GLD: {
                int atomIndex = GlutamateAtomNames.valueOf(atomName).ordinal();
                double glu = this.gluPolarizeTypes[atomIndex][GluStates.GLU.ordinal()].polarizability;
                double glh1 = this.gluPolarizeTypes[atomIndex][GluStates.GLH1.ordinal()].polarizability;
                double glh2 = this.gluPolarizeTypes[atomIndex][GluStates.GLH2.ordinal()].polarizability;
                return tautomerLambda * glh1 + (1.0 - tautomerLambda) * glh2 - glu;
            }
        }
        return 0.0;
    }

    public double getPolarizabilityTautomerDeriv(Atom atom, double titrationLambda, double tautomerLambda) {
        AminoAcidUtils.AminoAcid3 aminoAcid3;
        try {
            aminoAcid3 = atom.getMSNode(Residue.class).getAminoAcid3();
        }
        catch (Exception exception) {
            return 0.0;
        }
        String atomName = atom.getName();
        switch (aminoAcid3) {
            case HIS: {
                int atomIndex = HistidineAtomNames.valueOf(atomName).ordinal();
                double his = this.hisPolarizeTypes[atomIndex][HisStates.HIS.ordinal()].polarizability;
                double hid = this.hisPolarizeTypes[atomIndex][HisStates.HID.ordinal()].polarizability;
                double hie = this.hisPolarizeTypes[atomIndex][HisStates.HIE.ordinal()].polarizability;
                return (1.0 - titrationLambda) * (hie - hid);
            }
            case ASD: {
                int atomIndex = AspartateAtomNames.valueOf(atomName).ordinal();
                double asp = this.aspPolarizeTypes[atomIndex][AspStates.ASP.ordinal()].polarizability;
                double ash1 = this.aspPolarizeTypes[atomIndex][AspStates.ASH1.ordinal()].polarizability;
                double ash2 = this.aspPolarizeTypes[atomIndex][AspStates.ASH2.ordinal()].polarizability;
                return titrationLambda * (ash1 - ash2);
            }
            case GLD: {
                int atomIndex = GlutamateAtomNames.valueOf(atomName).ordinal();
                double glu = this.gluPolarizeTypes[atomIndex][GluStates.GLU.ordinal()].polarizability;
                double glh1 = this.gluPolarizeTypes[atomIndex][GluStates.GLH1.ordinal()].polarizability;
                double glh2 = this.gluPolarizeTypes[atomIndex][GluStates.GLH2.ordinal()].polarizability;
                return titrationLambda * (glh1 - glh2);
            }
        }
        return 0.0;
    }

    public static boolean isTitratingHydrogen(AminoAcidUtils.AminoAcid3 aminoAcid3, Atom atom) {
        boolean isTitratingHydrogen = false;
        String atomName = atom.getName();
        switch (aminoAcid3) {
            case ASD: {
                if (!atomName.equals(AspartateAtomNames.HD1.name()) && !atomName.equals(AspartateAtomNames.HD2.name())) break;
                isTitratingHydrogen = true;
                break;
            }
            case GLD: {
                if (!atomName.equals(GlutamateAtomNames.HE1.name()) && !atomName.equals(GlutamateAtomNames.HE2.name())) break;
                isTitratingHydrogen = true;
                break;
            }
            case HIS: {
                if (!atomName.equals(HistidineAtomNames.HD1.name()) && !atomName.equals(HistidineAtomNames.HE2.name())) break;
                isTitratingHydrogen = true;
                break;
            }
            case LYS: {
                if (!atomName.equals(LysineAtomNames.HZ3.name())) break;
                isTitratingHydrogen = true;
                break;
            }
            case CYS: {
                if (!atomName.equals(CysteineAtomNames.HG.name())) break;
                isTitratingHydrogen = true;
            }
        }
        return isTitratingHydrogen;
    }

    public static boolean isTitratingHeavy(AminoAcidUtils.AminoAcid3 aminoAcid3, Atom atom) {
        boolean isTitratingHeavy = false;
        String atomName = atom.getName();
        switch (aminoAcid3) {
            case ASD: {
                if (!atomName.equals(AspartateAtomNames.OD1.name()) && !atomName.equals(AspartateAtomNames.OD2.name())) break;
                isTitratingHeavy = true;
                break;
            }
            case GLD: {
                if (!atomName.equals(GlutamateAtomNames.OE1.name()) && !atomName.equals(GlutamateAtomNames.OE2.name())) break;
                isTitratingHeavy = true;
                break;
            }
            case CYS: {
                if (!atomName.equals(CysteineAtomNames.SG.name())) break;
                isTitratingHeavy = true;
            }
        }
        return isTitratingHeavy;
    }

    public static int getTitratingHydrogenDirection(AminoAcidUtils.AminoAcid3 aminoAcid3, Atom atom) {
        int tautomerDirection = 0;
        String atomName = atom.getName();
        switch (aminoAcid3) {
            case ASD: {
                if (atomName.equals(AspartateAtomNames.HD1.name())) {
                    tautomerDirection = AspartateAtomNames.HD1.tautomerDirection;
                    break;
                }
                if (!atomName.equals(AspartateAtomNames.HD2.name())) break;
                tautomerDirection = AspartateAtomNames.HD2.tautomerDirection;
                break;
            }
            case GLD: {
                if (atomName.equals(GlutamateAtomNames.HE1.name())) {
                    tautomerDirection = GlutamateAtomNames.HE1.tautomerDirection;
                    break;
                }
                if (!atomName.equals(GlutamateAtomNames.HE2.name())) break;
                tautomerDirection = GlutamateAtomNames.HE2.tautomerDirection;
                break;
            }
            case HIS: {
                if (atomName.equals(HistidineAtomNames.HD1.name())) {
                    tautomerDirection = HistidineAtomNames.HD1.tautomerDirection;
                    break;
                }
                if (!atomName.equals(HistidineAtomNames.HE2.name())) break;
                tautomerDirection = HistidineAtomNames.HE2.tautomerDirection;
            }
        }
        return tautomerDirection;
    }

    private void constructHISState(int biotypeCB, HisStates hisState) {
        int state = hisState.ordinal();
        for (HistidineAtomNames atomName : HistidineAtomNames.values()) {
            int index = atomName.ordinal();
            int offset = atomName.getOffsetHIS(hisState);
            if (offset < 0) {
                this.hisAtomTypes[index][state] = dummyHydrogenAtomType;
                if (hisState == HisStates.HID) {
                    this.hisMultipoleTypes[index][state] = hidZeroMultipoleType;
                } else if (hisState == HisStates.HIE) {
                    this.hisMultipoleTypes[index][state] = hieZeroMultipoleType;
                } else {
                    logger.severe(" Error constructing HIS states.");
                }
                this.hisPolarizeTypes[index][state] = zeroPolarizeType;
                this.hisVDWTypes[index][state] = this.forceField.getVDWType(Integer.toString(0));
                this.hisSoluteTypes[index][state] = zeroSoluteType;
                continue;
            }
            int biotype = biotypeCB + offset;
            this.hisAtomTypes[index][state] = BondedUtils.findAtomType(biotype, this.forceField);
            String key = this.hisAtomTypes[index][state].getKey();
            this.hisMultipoleTypes[index][state] = this.forceField.getMultipoleTypeBeginsWith(key);
            this.hisPolarizeTypes[index][state] = this.forceField.getPolarizeType(key);
            int atomClass = this.hisAtomTypes[index][state].atomClass;
            this.hisVDWTypes[index][state] = this.forceField.getVDWType("" + atomClass);
            this.hisSoluteTypes[index][state] = this.getSoluteType(this.forceField, this.hisAtomTypes[index][state], this.hisVDWTypes[index][state]);
            if (this.hisMultipoleTypes[index][state] != null && this.hisPolarizeTypes[index][state] != null && this.hisSoluteTypes[index][state] != null) continue;
            logger.severe(String.format(" Titration parameters could not be assigned for His atom %s.\n %s\n", new Object[]{atomName, this.hisAtomTypes[index][state]}));
        }
    }

    private void constructLYSState(int biotypeCB, LysStates lysState) {
        int state = lysState.ordinal();
        for (LysineAtomNames atomName : LysineAtomNames.values()) {
            int index = atomName.ordinal();
            int offset = atomName.getOffsetLYS(lysState);
            if (offset < 0) {
                this.lysAtomTypes[index][state] = dummyHydrogenAtomType;
                this.lysMultipoleTypes[index][state] = lydZeroMultipoleType;
                this.lysPolarizeTypes[index][state] = zeroPolarizeType;
                this.lysVDWTypes[index][state] = this.forceField.getVDWType(Integer.toString(0));
                this.lysSoluteTypes[index][state] = zeroSoluteType;
                continue;
            }
            int biotype = biotypeCB + offset;
            this.lysAtomTypes[index][state] = BondedUtils.findAtomType(biotype, this.forceField);
            String key = this.lysAtomTypes[index][state].getKey();
            this.lysMultipoleTypes[index][state] = this.forceField.getMultipoleTypeBeginsWith(key);
            this.lysPolarizeTypes[index][state] = this.forceField.getPolarizeType(key);
            int atomClass = this.lysAtomTypes[index][state].atomClass;
            this.lysVDWTypes[index][state] = this.forceField.getVDWType("" + atomClass);
            this.lysSoluteTypes[index][state] = this.getSoluteType(this.forceField, this.lysAtomTypes[index][state], this.lysVDWTypes[index][state]);
            if (this.lysMultipoleTypes[index][state] != null && this.lysPolarizeTypes[index][state] != null && this.lysSoluteTypes[index][state] != null) continue;
            logger.severe(String.format(" Titration parameters could not be assigned for Lys atom %s.\n %s\n", new Object[]{atomName, this.lysAtomTypes[index][state]}));
        }
    }

    private void constructASPState(int biotypeCB, AspStates aspState) {
        int state = aspState.ordinal();
        for (AspartateAtomNames atomName : AspartateAtomNames.values()) {
            int index = atomName.ordinal();
            int offset = atomName.getOffset(aspState);
            if (offset < 0) {
                this.aspAtomTypes[index][state] = dummyHydrogenAtomType;
                this.aspMultipoleTypes[index][state] = aspState == AspStates.ASP ? aspZeroMultipoleType : ashZeroMultipoleType;
                this.aspPolarizeTypes[index][state] = zeroPolarizeType;
                this.aspVDWTypes[index][state] = this.forceField.getVDWType(Integer.toString(0));
                this.aspSoluteTypes[index][state] = zeroSoluteType;
                continue;
            }
            int biotype = biotypeCB + offset;
            this.aspAtomTypes[index][state] = BondedUtils.findAtomType(biotype, this.forceField);
            String key = this.aspAtomTypes[index][state].getKey();
            this.aspMultipoleTypes[index][state] = this.forceField.getMultipoleTypeBeginsWith(key);
            this.aspPolarizeTypes[index][state] = this.forceField.getPolarizeType(key);
            int atomClass = this.aspAtomTypes[index][state].atomClass;
            this.aspVDWTypes[index][state] = this.forceField.getVDWType("" + atomClass);
            this.aspSoluteTypes[index][state] = this.getSoluteType(this.forceField, this.aspAtomTypes[index][state], this.aspVDWTypes[index][state]);
            if (this.aspMultipoleTypes[index][state] != null && this.aspPolarizeTypes[index][state] != null && this.aspSoluteTypes[index][state] != null) continue;
            logger.severe(String.format(" Titration parameters could not be assigned for Asp atom %s.\n %s\n", new Object[]{atomName, this.aspAtomTypes[index][state]}));
        }
    }

    private void constructGLUState(int biotypeCB, GluStates gluState) {
        int state = gluState.ordinal();
        for (GlutamateAtomNames atomName : GlutamateAtomNames.values()) {
            int index = atomName.ordinal();
            int offset = atomName.getOffset(gluState);
            if (offset < 0) {
                this.gluAtomTypes[index][state] = dummyHydrogenAtomType;
                this.gluMultipoleTypes[index][state] = gluState == GluStates.GLU ? gluZeroMultipoleType : glhZeroMultipoleType;
                this.gluPolarizeTypes[index][state] = zeroPolarizeType;
                this.gluVDWTypes[index][state] = this.forceField.getVDWType(Integer.toString(0));
                this.gluSoluteTypes[index][state] = zeroSoluteType;
                continue;
            }
            int biotype = biotypeCB + offset;
            this.gluAtomTypes[index][state] = BondedUtils.findAtomType(biotype, this.forceField);
            String key = this.gluAtomTypes[index][state].getKey();
            this.gluMultipoleTypes[index][state] = this.forceField.getMultipoleTypeBeginsWith(key);
            this.gluPolarizeTypes[index][state] = this.forceField.getPolarizeType(key);
            int atomClass = this.gluAtomTypes[index][state].atomClass;
            this.gluVDWTypes[index][state] = this.forceField.getVDWType("" + atomClass);
            this.gluSoluteTypes[index][state] = this.getSoluteType(this.forceField, this.gluAtomTypes[index][state], this.gluVDWTypes[index][state]);
            if (this.gluMultipoleTypes[index][state] != null && this.gluPolarizeTypes[index][state] != null && this.gluSoluteTypes[index][state] != null) continue;
            logger.severe(String.format(" Titration parameters could not be assigned for Glu atom %s.\n %s\n", new Object[]{atomName, this.gluAtomTypes[index][state]}));
        }
    }

    private void constructCYSState(int biotypeCB, CysStates cysState) {
        int state = cysState.ordinal();
        for (CysteineAtomNames atomName : CysteineAtomNames.values()) {
            int index = atomName.ordinal();
            int offset = atomName.getOffsetCYS(cysState);
            if (offset < 0) {
                this.cysAtomTypes[index][state] = dummyHydrogenAtomType;
                this.cysMultipoleTypes[index][state] = cydZeroMultipoleType;
                this.cysPolarizeTypes[index][state] = zeroPolarizeType;
                this.cysVDWTypes[index][state] = this.forceField.getVDWType(Integer.toString(0));
                this.cysSoluteTypes[index][state] = zeroSoluteType;
                continue;
            }
            int biotype = biotypeCB + offset;
            this.cysAtomTypes[index][state] = BondedUtils.findAtomType(biotype, this.forceField);
            String key = this.cysAtomTypes[index][state].getKey();
            this.cysMultipoleTypes[index][state] = this.forceField.getMultipoleTypeBeginsWith(key);
            if (this.cysMultipoleTypes[index][state] == null) {
                this.cysMultipoleTypes[index][state] = cysState == CysStates.CYS ? (atomName == CysteineAtomNames.CB ? this.forceField.getMultipoleType(key + " 8 45") : this.forceField.getMultipoleType(key + " 43 8")) : (atomName == CysteineAtomNames.CB ? this.forceField.getMultipoleType(key + " 8 49") : this.forceField.getMultipoleType(key + " 43 8"));
            }
            this.cysPolarizeTypes[index][state] = this.forceField.getPolarizeType(key);
            int atomClass = this.cysAtomTypes[index][state].atomClass;
            this.cysVDWTypes[index][state] = this.forceField.getVDWType("" + atomClass);
            this.cysSoluteTypes[index][state] = this.getSoluteType(this.forceField, this.cysAtomTypes[index][state], this.cysVDWTypes[index][state]);
            if (this.cysMultipoleTypes[index][state] != null && this.cysPolarizeTypes[index][state] != null && this.cysSoluteTypes[index][state] != null) continue;
            logger.severe(String.format(" Titration parameters could not be assigned for Cys atom %s.\n %s\n", new Object[]{atomName, this.cysAtomTypes[index][state]}));
        }
    }

    private void checkParameterTypes(String label, AtomType[][] atomTypes, PolarizeType[][] polarizeTypes, MultipoleType[][] multipoleTypes, VDWType[][] vdwTypes) {
        int states = multipoleTypes.length;
        int types = multipoleTypes[0].length;
        StringBuilder sb = new StringBuilder();
        for (int t = 0; t < types; ++t) {
            MultipoleType.MultipoleFrameDefinition frame0 = multipoleTypes[0][t].frameDefinition;
            double eps0 = vdwTypes[0][t].wellDepth;
            double rad0 = vdwTypes[0][t].radius;
            sb.append(String.format("\n %s Type %d\n", label, t));
            sb.append(String.format(" %s\n  %s\n  %s\n  %s\n", atomTypes[0][t], polarizeTypes[0][t], multipoleTypes[0][t], vdwTypes[0][t]));
            for (int s = 1; s < states; ++s) {
                sb.append(String.format(" %s\n  %s\n  %s\n  %s\n", atomTypes[s][t], polarizeTypes[s][t], multipoleTypes[s][t], vdwTypes[s][t]));
                MultipoleType.MultipoleFrameDefinition frame = multipoleTypes[s][t].frameDefinition;
                if (!frame0.equals((Object)frame)) {
                    sb.append("\n Incompatible multipole frames:\n");
                    sb.append(String.format(" %s\n  %s\n  %s\n", atomTypes[0][t], polarizeTypes[0][t], multipoleTypes[0][t]));
                    sb.append(String.format(" %s\n  %s\n  %s\n", atomTypes[s][t], polarizeTypes[s][t], multipoleTypes[s][t]));
                }
                if (atomTypes[0][t].atomicNumber == 1) continue;
                double epsS = vdwTypes[s][t].wellDepth;
                double radS = vdwTypes[s][t].radius;
                if (epsS == eps0 && radS == rad0) continue;
                sb.append("\n Incompatible vdW types:\n");
                sb.append(String.format(" %s\n  %s\n", atomTypes[0][t], vdwTypes[0][t]));
                sb.append(String.format(" %s\n  %s\n", atomTypes[s][t], vdwTypes[s][t]));
            }
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine(sb.toString());
        }
    }

    private SoluteType getSoluteType(ForceField forceField, AtomType atomType, VDWType vdwType) {
        SoluteType soluteType = SoluteType.getCensusSoluteType(atomType.atomicNumber);
        switch (this.soluteRadiiType) {
            case SOLUTE: {
                SoluteType type = SoluteType.getFitSoluteType(forceField, atomType.type);
                if (type == null) break;
                soluteType = type;
                break;
            }
            case VDW: {
                SoluteType type = SoluteType.getVDWSoluteType(vdwType);
                if (type == null) break;
                soluteType = type;
            }
        }
        if (soluteType == null) {
            logger.severe(String.format(" No solute type (%s) for %d:\n  \"%s\"\n  %s", new Object[]{this.soluteRadiiType, atomType.type, atomType, vdwType}));
        }
        return soluteType;
    }

    public void setRotamerPhBias(double temperature, double pH) {
        this.rotamerPhBiasMap.put(AminoAcidUtils.AminoAcid3.ASH, 0.0);
        double acidostat = LOG10 * 0.0019872042586408316 * temperature * (Titration.ASHtoASP.pKa - pH);
        double fMod = Titration.ASHtoASP.freeEnergyDiff;
        if (this.tanhCorrection) {
            fMod = Titration.ASHtoASP.freeEnergyDiffGK;
            if (this.proteinDielectric == 2.0) {
                fMod = Titration.ASHtoASP.freeEnergyDiffGK2;
            }
        } else if (this.proteinDielectric == 2.0) {
            fMod = Titration.ASHtoASP.freeEnergyDiff2;
        }
        this.rotamerPhBiasMap.put(AminoAcidUtils.AminoAcid3.ASP, acidostat - fMod);
        this.rotamerPhBiasMap.put(AminoAcidUtils.AminoAcid3.GLH, 0.0);
        acidostat = LOG10 * 0.0019872042586408316 * temperature * (Titration.GLHtoGLU.pKa - pH);
        fMod = Titration.GLHtoGLU.freeEnergyDiff;
        if (this.tanhCorrection) {
            fMod = Titration.GLHtoGLU.freeEnergyDiffGK;
            if (this.proteinDielectric == 2.0) {
                fMod = Titration.GLHtoGLU.freeEnergyDiffGK2;
            }
        } else if (this.proteinDielectric == 2.0) {
            fMod = Titration.GLHtoGLU.freeEnergyDiff2;
        }
        this.rotamerPhBiasMap.put(AminoAcidUtils.AminoAcid3.GLU, acidostat - fMod);
        this.rotamerPhBiasMap.put(AminoAcidUtils.AminoAcid3.LYS, 0.0);
        acidostat = LOG10 * 0.0019872042586408316 * temperature * (Titration.LYStoLYD.pKa - pH);
        fMod = Titration.LYStoLYD.freeEnergyDiff;
        if (this.tanhCorrection) {
            fMod = Titration.LYStoLYD.freeEnergyDiffGK;
            if (this.proteinDielectric == 2.0) {
                fMod = Titration.LYStoLYD.freeEnergyDiffGK2;
            }
        } else if (this.proteinDielectric == 2.0) {
            fMod = Titration.LYStoLYD.freeEnergyDiff2;
        }
        this.rotamerPhBiasMap.put(AminoAcidUtils.AminoAcid3.LYD, acidostat - fMod);
        this.rotamerPhBiasMap.put(AminoAcidUtils.AminoAcid3.CYS, 0.0);
        acidostat = LOG10 * 0.0019872042586408316 * temperature * (Titration.CYStoCYD.pKa - pH);
        fMod = Titration.CYStoCYD.freeEnergyDiff;
        if (this.tanhCorrection) {
            fMod = Titration.CYStoCYD.freeEnergyDiffGK;
            if (this.proteinDielectric == 2.0) {
                fMod = Titration.CYStoCYD.freeEnergyDiffGK2;
            }
        } else if (this.proteinDielectric == 2.0) {
            fMod = Titration.CYStoCYD.freeEnergyDiff2;
        }
        this.rotamerPhBiasMap.put(AminoAcidUtils.AminoAcid3.CYD, acidostat - fMod);
        this.rotamerPhBiasMap.put(AminoAcidUtils.AminoAcid3.HIS, 0.0);
        acidostat = LOG10 * 0.0019872042586408316 * temperature * (Titration.HIStoHID.pKa - pH);
        fMod = Titration.HIStoHID.freeEnergyDiff;
        if (this.tanhCorrection) {
            fMod = Titration.HIStoHID.freeEnergyDiffGK;
            if (this.proteinDielectric == 2.0) {
                fMod = Titration.HIStoHID.freeEnergyDiffGK2;
            }
        } else if (this.proteinDielectric == 2.0) {
            fMod = Titration.HIStoHID.freeEnergyDiff2;
        }
        this.rotamerPhBiasMap.put(AminoAcidUtils.AminoAcid3.HID, acidostat - fMod);
        acidostat = LOG10 * 0.0019872042586408316 * temperature * (Titration.HIStoHIE.pKa - pH);
        fMod = Titration.HIStoHIE.freeEnergyDiff;
        if (this.tanhCorrection) {
            fMod = Titration.HIStoHIE.freeEnergyDiffGK;
            if (this.proteinDielectric == 2.0) {
                fMod = Titration.HIStoHIE.freeEnergyDiffGK2;
            }
        } else if (this.proteinDielectric == 2.0) {
            fMod = Titration.HIStoHIE.freeEnergyDiff2;
        }
        this.rotamerPhBiasMap.put(AminoAcidUtils.AminoAcid3.HIE, acidostat - fMod);
    }

    public double getRotamerPhBias(AminoAcidUtils.AminoAcid3 AA3) {
        return this.rotamerPhBiasMap.getOrDefault((Object)AA3, 0.0);
    }

    public double getTotalRotamerPhBias(Rotamer[] rotamers) {
        double total = 0.0;
        for (Rotamer r : rotamers) {
            if (!r.isTitrating) continue;
            total += this.getRotamerPhBias(r.aminoAcid3);
        }
        return total;
    }

    public static double[] predictHillCoeffandPka(final double[] pHScale, final double[] residueFractions) {
        Potential hendersonHasselbach = new Potential(){
            static final double logb10 = Math.log(10.0);

            public double energy(double[] x) {
                return this.leastSquaresLoss(residueFractions, this.getValues(x));
            }

            public double leastSquaresLoss(double[] residueFractions2, double[] guessedFractions) {
                double loss = 0.0;
                for (int i = 0; i < residueFractions2.length; ++i) {
                    loss += Math.pow(residueFractions2[i] - guessedFractions[i], 2.0);
                }
                return loss;
            }

            public double[] getValues(double[] x) {
                double[] values = new double[pHScale.length];
                for (int i = 0; i < pHScale.length; ++i) {
                    values[i] = 1.0 / (1.0 + Math.pow(10.0, x[0] * (x[1] - pHScale[i])));
                }
                return values;
            }

            public void gradient(double[] x, double[] gradient) {
                Arrays.fill(gradient, 0.0);
                double[] values = this.getValues(x);
                for (int i = 0; i < pHScale.length; ++i) {
                    double term = Math.pow(10.0, x[0] * (x[1] - pHScale[i]));
                    double d = (1.0 + term) * (1.0 + term);
                    gradient[0] = gradient[0] + 2.0 * (residueFractions[i] - values[i]) * logb10 * (x[1] - pHScale[i]) * term / d;
                    gradient[1] = gradient[1] + 2.0 * (residueFractions[i] - values[i]) * x[0] * logb10 * term / d;
                }
            }

            public double energyAndGradient(double[] x, double[] g) {
                this.gradient(x, g);
                return this.energy(x);
            }

            public double[] getAcceleration(double[] acceleration) {
                return new double[0];
            }

            public double[] getCoordinates(double[] parameters) {
                return new double[0];
            }

            public void setCoordinates(double[] parameters) {
            }

            public Potential.STATE getEnergyTermState() {
                return null;
            }

            public void setEnergyTermState(Potential.STATE state) {
            }

            public double[] getMass() {
                return new double[0];
            }

            public int getNumberOfVariables() {
                return 0;
            }

            public double[] getPreviousAcceleration(double[] previousAcceleration) {
                return new double[0];
            }

            public double[] getScaling() {
                return null;
            }

            public void setScaling(double[] scaling) {
            }

            public double getTotalEnergy() {
                return 0.0;
            }

            public Potential.VARIABLE_TYPE[] getVariableTypes() {
                return new Potential.VARIABLE_TYPE[0];
            }

            public double[] getVelocity(double[] velocity) {
                return new double[0];
            }

            public void setAcceleration(double[] acceleration) {
            }

            public void setPreviousAcceleration(double[] previousAcceleration) {
            }

            public void setVelocity(double[] velocity) {
            }
        };
        int n = 2;
        double[] x = new double[]{1.0, 7.0};
        int m = 3;
        double energy = hendersonHasselbach.energy(x);
        double[] grad = new double[n];
        hendersonHasselbach.energyAndGradient(x, grad);
        hendersonHasselbach.setScaling(new double[]{1.0, 1.0});
        double eps = 1.0E-5;
        int maxIterations = 100;
        OptimizationListener listener = new OptimizationListener(){

            public boolean optimizationUpdate(int iter, int nBFGS, int nFunctionEvals, double gradientRMS, double coordinateRMS, double f, double df, double angle, LineSearch.LineSearchResult info) {
                return true;
            }
        };
        int statuspKa = LBFGS.minimize((int)n, (int)m, (double[])x, (double)energy, (double[])grad, (double)eps, (int)maxIterations, (OptimizationInterface)hendersonHasselbach, (OptimizationListener)listener);
        return new double[]{x[0], x[1]};
    }

    public static enum LysineAtomNames {
        CB(0, 0),
        HB2(1, 1),
        HB3(1, 1),
        CG(2, 2),
        HG2(3, 3),
        HG3(3, 3),
        CD(4, 4),
        HD2(5, 5),
        HD3(5, 5),
        CE(6, 6),
        HE2(7, 7),
        HE3(7, 7),
        NZ(8, 8),
        HZ1(9, 9),
        HZ2(9, 9),
        HZ3(9, -1);

        private final int offsetLYS;
        private final int offsetLYD;

        public int getOffsetLYS(LysStates state) {
            if (state == LysStates.LYS) {
                return this.offsetLYS;
            }
            return this.offsetLYD;
        }

        private LysineAtomNames(int offsetLYS, int offsetLYD) {
            this.offsetLYS = offsetLYS;
            this.offsetLYD = offsetLYD;
        }
    }

    public static enum LysStates {
        LYD,
        LYS;

    }

    public static enum HistidineAtomNames {
        CB(0, 0, 0, 0),
        HB2(1, 1, 1, 0),
        HB3(1, 1, 1, 0),
        CG(2, 2, 2, 0),
        ND1(3, 3, 3, 0),
        HD1(4, 4, -1, -1),
        CD2(5, 5, 4, 0),
        HD2(6, 6, 5, 0),
        CE1(7, 7, 6, 0),
        HE1(8, 8, 7, 0),
        NE2(9, 9, 8, 0),
        HE2(10, -1, 9, 1);

        private final int offsetHIS;
        private final int offsetHID;
        private final int offsetHIE;
        private final int tautomerDirection;

        public int getOffsetHIS(HisStates state) {
            if (state == HisStates.HIS) {
                return this.offsetHIS;
            }
            if (state == HisStates.HID) {
                return this.offsetHID;
            }
            return this.offsetHIE;
        }

        private HistidineAtomNames(int offsetHIS, int offsetHID, int offsetHIE, int tautomerDirection) {
            this.offsetHIS = offsetHIS;
            this.offsetHID = offsetHID;
            this.offsetHIE = offsetHIE;
            this.tautomerDirection = tautomerDirection;
        }
    }

    public static enum HisStates {
        HIS,
        HID,
        HIE;

    }

    private static enum AspartateAtomNames {
        CB(0, 0, 0, 0),
        HB2(1, 1, 1, 0),
        HB3(1, 1, 1, 0),
        CG(2, 2, 2, 0),
        OD1(3, 4, 3, 0),
        OD2(3, 3, 4, 0),
        HD1(-1, 5, -1, 1),
        HD2(-1, -1, 5, -1);

        private final int offsetASP;
        private final int offsetASH1;
        private final int offsetASH2;
        private final int tautomerDirection;

        public int getOffset(AspStates state) {
            if (state == AspStates.ASP) {
                return this.offsetASP;
            }
            if (state == AspStates.ASH1) {
                return this.offsetASH1;
            }
            return this.offsetASH2;
        }

        private AspartateAtomNames(int offsetASP, int offsetASH1, int offsetASH2, int tautomerDirection) {
            this.offsetASP = offsetASP;
            this.offsetASH1 = offsetASH1;
            this.offsetASH2 = offsetASH2;
            this.tautomerDirection = tautomerDirection;
        }
    }

    static enum AspStates {
        ASP,
        ASH1,
        ASH2;

    }

    private static enum GlutamateAtomNames {
        CB(0, 0, 0, 0),
        HB2(1, 1, 1, 0),
        HB3(1, 1, 1, 0),
        CG(2, 2, 2, 0),
        HG2(3, 3, 3, 0),
        HG3(3, 3, 3, 0),
        CD(4, 4, 4, 0),
        OE1(5, 6, 5, 0),
        OE2(5, 5, 6, 0),
        HE1(-1, 7, -1, 1),
        HE2(-1, -1, 7, -1);

        private final int offsetGLU;
        private final int offsetGLH1;
        private final int offsetGLH2;
        private final int tautomerDirection;

        public int getOffset(GluStates state) {
            if (state == GluStates.GLU) {
                return this.offsetGLU;
            }
            if (state == GluStates.GLH1) {
                return this.offsetGLH1;
            }
            return this.offsetGLH2;
        }

        private GlutamateAtomNames(int offsetGLU, int offsetGLH1, int offsetGLH2, int tautomerDirection) {
            this.offsetGLU = offsetGLU;
            this.offsetGLH1 = offsetGLH1;
            this.offsetGLH2 = offsetGLH2;
            this.tautomerDirection = tautomerDirection;
        }
    }

    static enum GluStates {
        GLU,
        GLH1,
        GLH2;

    }

    public static enum CysteineAtomNames {
        CB(0, 0),
        HB2(1, 1),
        HB3(1, 1),
        SG(2, 2),
        HG(3, -1);

        private final int offsetCYS;
        private final int offsetCYD;

        public int getOffsetCYS(CysStates state) {
            if (state == CysStates.CYS) {
                return this.offsetCYS;
            }
            return this.offsetCYD;
        }

        private CysteineAtomNames(int offsetCYS, int offsetCYD) {
            this.offsetCYS = offsetCYS;
            this.offsetCYD = offsetCYD;
        }
    }

    public static enum CysStates {
        CYS,
        CYD;

    }

    public static enum Titration {
        ASHtoASP(3.94, -70.35, -35.45, -52.1, -33.87, 12.73, -107.43, 166.369, 0.0, AminoAcidUtils.AminoAcid3.ASH, AminoAcidUtils.AminoAcid3.ASP),
        ASH1toASH2(Double.NaN, 0.0, 0.0, 0.0, 0.0, 0.0, -35.305, 35.305, 0.0, AminoAcidUtils.AminoAcid3.ASH, AminoAcidUtils.AminoAcid3.ASH),
        GLHtoGLU(4.25, -81.9, -39.21, -64.85, -39.35, 28.024, -131.27, 189.98, 0.0, AminoAcidUtils.AminoAcid3.GLH, AminoAcidUtils.AminoAcid3.GLU),
        GLH1toGLH2(Double.NaN, 0.0, 0.0, 0.0, 0.0, 0.0, -29.395, 29.395, 0.0, AminoAcidUtils.AminoAcid3.GLH, AminoAcidUtils.AminoAcid3.GLH),
        LYStoLYD(10.4, 41.35, 19.25, 41.31, 19.8, 6.752, -78.804, 26.894, 0.0, AminoAcidUtils.AminoAcid3.LYS, AminoAcidUtils.AminoAcid3.LYD),
        CYStoCYD(8.55, -53.1, 0.0, -33.12, -6.75, 44.247, -183.99, 226.71, 0.0, AminoAcidUtils.AminoAcid3.CYS, AminoAcidUtils.AminoAcid3.CYD),
        HIStoHID(7.0, 40.2, 16.55, 26.3, 25.0, 0.0, -64.317, 30.35, 0.0, AminoAcidUtils.AminoAcid3.HIS, AminoAcidUtils.AminoAcid3.HID),
        HIStoHIE(6.6, 37.44, 17.41, 40.43, 22.9, 0.0, -62.931, 32.0, 0.0, AminoAcidUtils.AminoAcid3.HIS, AminoAcidUtils.AminoAcid3.HIE),
        HIDtoHIE(Double.NaN, 0.0, 0.0, 0.0, 0.0, 0.0, -36.83, 34.325, 0.0, AminoAcidUtils.AminoAcid3.HID, AminoAcidUtils.AminoAcid3.HIE);

        public final double pKa;
        public final double freeEnergyDiff;
        public final double freeEnergyDiff2;
        public final double freeEnergyDiffGK;
        public final double freeEnergyDiffGK2;
        public final double cubic;
        public final double quadratic;
        public final double linear;
        public final double offset;
        public final AminoAcidUtils.AminoAcid3 protForm;
        public final AminoAcidUtils.AminoAcid3 deprotForm;

        private Titration(double pKa, double freeEnergyDiff, double freeEnergyDiff2, double freeEnergyDiffGK, double freeEnergyDiffGK2, double cubic, double quadratic, double linear, double offset, AminoAcidUtils.AminoAcid3 protForm, AminoAcidUtils.AminoAcid3 deprotForm) {
            this.pKa = pKa;
            this.freeEnergyDiff = freeEnergyDiff;
            this.freeEnergyDiff2 = freeEnergyDiff2;
            this.freeEnergyDiffGK = freeEnergyDiffGK;
            this.freeEnergyDiffGK2 = freeEnergyDiffGK2;
            this.cubic = cubic;
            this.quadratic = quadratic;
            this.linear = linear;
            this.offset = offset;
            this.protForm = protForm;
            this.deprotForm = deprotForm;
        }
    }
}

