/*
 * Decompiled with CFR 0.152.
 */
package ffx.potential.parameters;

import ffx.potential.bonded.Atom;
import ffx.potential.parameters.BaseType;
import ffx.potential.parameters.ForceField;
import ffx.potential.parameters.VDWType;
import ffx.utilities.FFXProperty;
import ffx.utilities.PropertyGroup;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang3.math.NumberUtils;

@FFXProperty(name="solute", clazz=String.class, propertyGroup=PropertyGroup.PotentialFunctionParameter, description="[integers and 4 reals]\nProvides values for a single implicit solvation parameter.\nThe integer modifier gives the atom type number for which solvation atom size parameters are to be defined.\nThe first three real number modifiers give the values of the atomic diameter in Angstroms,\nfor use in Poisson-Boltzmann (APBS), ddCOSMO and Generalized Kirkwood (GK) calculations, respectively.\nThe final real number is the Sneck scaling factor for implicit solvent interstitial space corrections.\n")
public final class SoluteType
extends BaseType
implements Comparator<String> {
    private static final Logger logger = Logger.getLogger(SoluteType.class.getName());
    static final Map<Integer, SoluteType> CONSENSUS_RADII = new HashMap<Integer, SoluteType>();
    public double pbDiameter;
    public double cosDiameter;
    public double gkDiameter;
    public double sneck;
    public double DEFAULT_SNECK = 0.6784;
    public String description;
    private int atomType;

    public SoluteType(int atomType, double diameter) {
        super(ForceField.ForceFieldType.SOLUTE, Integer.toString(atomType));
        this.atomType = atomType;
        this.pbDiameter = diameter;
        this.cosDiameter = diameter;
        this.gkDiameter = diameter;
        this.description = null;
        this.sneck = this.DEFAULT_SNECK;
    }

    public SoluteType(int atomType, double pbDiameter, double cosDiameter, double gkDiameter) {
        super(ForceField.ForceFieldType.SOLUTE, Integer.toString(atomType));
        this.atomType = atomType;
        this.pbDiameter = pbDiameter;
        this.cosDiameter = cosDiameter;
        this.gkDiameter = gkDiameter;
        this.description = null;
        this.sneck = this.DEFAULT_SNECK;
    }

    public SoluteType(int atomType, double pbDiameter, double cosDiameter, double gkDiameter, double sneck) {
        super(ForceField.ForceFieldType.SOLUTE, Integer.toString(atomType));
        this.atomType = atomType;
        this.pbDiameter = pbDiameter;
        this.cosDiameter = cosDiameter;
        this.gkDiameter = gkDiameter;
        this.description = null;
        this.sneck = sneck;
    }

    public SoluteType(int atomType, String description, double pbDiameter, double cosDiameter, double gkDiameter) {
        this(atomType, pbDiameter, cosDiameter, gkDiameter);
        this.description = description;
        this.sneck = this.DEFAULT_SNECK;
    }

    public static SoluteType parse(String input, String[] tokens) {
        if (tokens.length < 4) {
            logger.log(Level.WARNING, "Invalid SOLUTE type:\n{0}", input);
        } else {
            try {
                if (tokens.length == 5) {
                    int atomType = Integer.parseInt(tokens[1].trim());
                    double pbDiameter = Double.parseDouble(tokens[2].trim());
                    double cosDiameter = Double.parseDouble(tokens[3].trim());
                    double gkDiameter = Double.parseDouble(tokens[4].trim());
                    return new SoluteType(atomType, pbDiameter, cosDiameter, gkDiameter);
                }
                if (NumberUtils.isParsable((String)tokens[2].trim())) {
                    int atomType = Integer.parseInt(tokens[1].trim());
                    double pbDiameter = Double.parseDouble(tokens[2].trim());
                    double cosDiameter = Double.parseDouble(tokens[3].trim());
                    double gkDiameter = Double.parseDouble(tokens[4].trim());
                    double sneck = Double.parseDouble(tokens[5].trim());
                    return new SoluteType(atomType, pbDiameter, cosDiameter, gkDiameter, sneck);
                }
                int atomType = Integer.parseInt(tokens[1].trim());
                String description = tokens[2].trim();
                double pbDiameter = Double.parseDouble(tokens[3].trim());
                double cosDiameter = Double.parseDouble(tokens[4].trim());
                double gkDiameter = Double.parseDouble(tokens[5].trim());
                return new SoluteType(atomType, description, pbDiameter, cosDiameter, gkDiameter);
            }
            catch (NumberFormatException e) {
                String message = "Exception parsing SOLUTE type:\n" + input + "\n";
                logger.log(Level.SEVERE, message, e);
            }
        }
        return null;
    }

    @Override
    public int compare(String key1, String key2) {
        int type1 = Integer.parseInt(key1);
        int type2 = Integer.parseInt(key2);
        return Integer.compare(type1, type2);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SoluteType soluteType = (SoluteType)o;
        return soluteType.atomType == this.atomType;
    }

    public int hashCode() {
        return Objects.hash(this.atomType);
    }

    @Override
    public String toString() {
        if (this.description == null) {
            return String.format("solute  %4d  %7.4f  %7.4f %7.4f", this.atomType, this.pbDiameter, this.cosDiameter, this.gkDiameter);
        }
        return String.format("solute  %4d  %30s  %7.4f  %7.4f %7.4f", this.atomType, this.description, this.pbDiameter, this.cosDiameter, this.gkDiameter);
    }

    void incrementType(int increment) {
        this.atomType += increment;
        this.setKey(Integer.toString(this.atomType));
    }

    public static SoluteType getCensusSoluteType(int atomicNumber) {
        return CONSENSUS_RADII.get(atomicNumber);
    }

    public static SoluteType getVDWSoluteType(VDWType vdwType) {
        return new SoluteType(vdwType.atomClass, vdwType.radius);
    }

    public static SoluteType getFitSoluteType(ForceField forceField, int type) {
        SoluteType soluteType = forceField.getSoluteType(Integer.toString(type));
        if (soluteType != null && soluteType.gkDiameter <= 0.0) {
            logger.severe(String.format(" Invalid solute type: %s", soluteType));
        }
        return soluteType;
    }

    public static SoluteType getSoluteType(Atom atom, ForceField forceField, SOLUTE_RADII_TYPE soluteRadiiType) {
        SoluteType type;
        SoluteType soluteType = SoluteType.getCensusSoluteType(atom.getAtomicNumber());
        if (soluteRadiiType == SOLUTE_RADII_TYPE.VDW) {
            SoluteType type2 = SoluteType.getVDWSoluteType(atom.getVDWType());
            if (type2 != null) {
                soluteType = type2;
            }
        } else if (soluteRadiiType == SOLUTE_RADII_TYPE.SOLUTE && (type = SoluteType.getFitSoluteType(forceField, atom.getAtomType().type)) != null) {
            soluteType = type;
        }
        return soluteType;
    }

    public static void setSoluteRadii(ForceField forceField, Atom[] atoms, SOLUTE_RADII_TYPE soluteRadiiType) {
        for (Atom atom : atoms) {
            atom.setSoluteType(SoluteType.getSoluteType(atom, forceField, soluteRadiiType));
        }
    }

    static {
        CONSENSUS_RADII.put(0, new SoluteType(0, 0.0));
        CONSENSUS_RADII.put(1, new SoluteType(1, 2.4));
        CONSENSUS_RADII.put(2, new SoluteType(2, 2.8));
        CONSENSUS_RADII.put(5, new SoluteType(5, 3.6));
        CONSENSUS_RADII.put(6, new SoluteType(6, 3.4));
        CONSENSUS_RADII.put(7, new SoluteType(7, 3.1));
        CONSENSUS_RADII.put(8, new SoluteType(8, 3.04));
        CONSENSUS_RADII.put(9, new SoluteType(9, 2.94));
        CONSENSUS_RADII.put(10, new SoluteType(10, 3.08));
        CONSENSUS_RADII.put(14, new SoluteType(14, 4.2));
        CONSENSUS_RADII.put(15, new SoluteType(15, 3.6));
        CONSENSUS_RADII.put(16, new SoluteType(16, 3.6));
        CONSENSUS_RADII.put(17, new SoluteType(17, 3.5));
        CONSENSUS_RADII.put(18, new SoluteType(18, 3.76));
        CONSENSUS_RADII.put(34, new SoluteType(34, 3.8));
        CONSENSUS_RADII.put(35, new SoluteType(35, 3.7));
        CONSENSUS_RADII.put(36, new SoluteType(36, 4.04));
        CONSENSUS_RADII.put(53, new SoluteType(53, 3.96));
        CONSENSUS_RADII.put(54, new SoluteType(54, 4.32));
        for (int i = 0; i <= 118; ++i) {
            if (CONSENSUS_RADII.containsKey(i)) continue;
            CONSENSUS_RADII.put(i, new SoluteType(i, 4.0));
        }
    }

    public static enum SOLUTE_RADII_TYPE {
        VDW,
        CONSENSUS,
        SOLUTE;

    }
}

