/*
 * Decompiled with CFR 0.152.
 */
package ffx.potential.parameters;

import ffx.potential.parameters.AtomType;
import ffx.potential.parameters.BaseType;
import ffx.potential.parameters.ForceField;
import ffx.utilities.FFXProperty;
import ffx.utilities.PropertyGroup;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;
import org.apache.commons.math3.util.FastMath;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

@FFXProperty(name="opbend", clazz=String.class, propertyGroup=PropertyGroup.PotentialFunctionParameter, description="[4 integers and 1 real]\nProvides the values for a single out-of-plane bending potential parameter.\nThe first integer modifier is the atom class of the out-of-plane atom and the second integer is the atom class of the central trigonal atom.\nThe third and fourth integers give the atom classes of the two remaining atoms attached to the trigonal atom.\nValues of zero for the third and fourth integers are treated as wildcards, and can represent any atom type.\nThe real number modifier gives the force constant value for the out-of-plane angle.\nThe default units for the force constant are kcal/mole/radian^2, but this can be controlled via the opbendunit keyword.\n")
public final class OutOfPlaneBendType
extends BaseType
implements Comparator<String> {
    public static final double DEFAULT_OPBEND_CUBIC = 0.0;
    public static final double DEFAULT_OPBEND_QUARTIC = 0.0;
    public static final double DEFAULT_OPBEND_PENTIC = 0.0;
    public static final double DEFAULT_OPBEND_SEXTIC = 0.0;
    @FFXProperty(name="opbend-cubic", propertyGroup=PropertyGroup.LocalGeometryFunctionalForm, defaultValue="0.0", description="Sets the value of the cubic term in the Taylor series expansion form of the out-of-plane bending potential energy.\nThe real number modifier gives the value of the coefficient as a multiple of the quadratic coefficient.\nThis term multiplied by the out-of-plane bending energy unit conversion factor, the force constant,\nand the cube of the deviation of the out-of-plane angle from zero gives the cubic contribution to the out-of-plane bending energy.\nThe default value in the absence of the opbend-cubic keyword is zero; i.e., the cubic out-of-plane bending term is omitted.\n")
    public double cubic = 0.0;
    @FFXProperty(name="opbend-quartic", propertyGroup=PropertyGroup.LocalGeometryFunctionalForm, defaultValue="0.0", description="Sets the value of the quartic term in the Taylor series expansion form of the out-of-plane bending potential energy.\nThe real number modifier gives the value of the coefficient as a multiple of the quadratic coefficient.\nThis term multiplied by the out-of-plane bending energy unit conversion factor, the force constant,\nand the forth power of the deviation of the out-of-plane angle from zero gives the quartic contribution to the out-of-plane bending energy.\nThe default value in the absence of the opbend-quartic keyword is zero; i.e., the quartic out-of-plane bending term is omitted.\n")
    public double quartic = 0.0;
    @FFXProperty(name="opbend-pentic", propertyGroup=PropertyGroup.LocalGeometryFunctionalForm, defaultValue="0.0", description="Sets the value of the fifth power term in the Taylor series expansion form of the out-of-plane bending potential energy.\nThe real number modifier gives the value of the coefficient as a multiple of the quadratic coefficient.\nThis term multiplied by the out-of-plane bending energy unit conversion factor, the force constant,\nand the fifth power of the deviation of the out-of-plane angle from zero gives the pentic contribution to the out-of-plane bending energy.\nThe default value in the absence of the opbend-pentic keyword is zero; i.e., the pentic out-of-plane bending term is omitted.\n")
    public double pentic = 0.0;
    @FFXProperty(name="opbend-sextic", propertyGroup=PropertyGroup.LocalGeometryFunctionalForm, defaultValue="0.0", description="Sets the value of the sixth power term in the Taylor series expansion form of the out-of-plane bending potential energy.\nThe real number modifier gives the value of the coefficient as a multiple of the quadratic coefficient.\nThis term multiplied by the out-of-plane bending energy unit conversion factor, the force constant,\nand the sixth power of the deviation of the out-of-plane angle from zero gives the sextic contribution to the out-of-plane bending energy.\nThe default value in the absence of the opbend-sextic keyword is zero; i.e., the sextic out-of-plane bending term is omitted.\n")
    public double sextic = 0.0;
    @FFXProperty(name="opbendunit", propertyGroup=PropertyGroup.EnergyUnitConversion, defaultValue="(Pi/180)^2", description="Sets the scale factor needed to convert the energy value computed by the out-of-plane bending potential into units of kcal/mole. \"\nThe correct value is force field dependent and typically provided in the header of the master force field parameter file.\n")
    public double opBendUnit = DEFAULT_OPBEND_UNIT;
    public static final double DEFAULT_OPBEND_UNIT = FastMath.pow((double)(Math.PI / 180), (int)2);
    private static final Logger logger = Logger.getLogger(OutOfPlaneBendType.class.getName());
    public final int[] atomClasses;
    public final double forceConstant;

    public OutOfPlaneBendType(int[] atomClasses, double forceConstant) {
        super(ForceField.ForceFieldType.OPBEND, OutOfPlaneBendType.sortKey(atomClasses));
        this.atomClasses = atomClasses;
        this.forceConstant = forceConstant;
    }

    public static OutOfPlaneBendType average(@Nullable OutOfPlaneBendType outOfPlaneBendType1, @Nullable OutOfPlaneBendType outOfPlaneBendType2, @Nullable int[] atomClasses) {
        if (outOfPlaneBendType1 == null || outOfPlaneBendType2 == null || atomClasses == null) {
            return null;
        }
        double forceConstant = (outOfPlaneBendType1.forceConstant + outOfPlaneBendType2.forceConstant) / 2.0;
        return new OutOfPlaneBendType(atomClasses, forceConstant);
    }

    public static OutOfPlaneBendType parse(String input, String[] tokens) {
        if (tokens.length < 6) {
            logger.log(Level.WARNING, "Invalid OPBEND type:\n{0}", input);
        } else {
            try {
                int[] atomClasses = new int[]{Integer.parseInt(tokens[1]), Integer.parseInt(tokens[2]), Integer.parseInt(tokens[3]), Integer.parseInt(tokens[4])};
                double forceConstant = Double.parseDouble(tokens[5]);
                return new OutOfPlaneBendType(atomClasses, forceConstant);
            }
            catch (NumberFormatException e) {
                String message = "Exception parsing OPBEND type:\n" + input + "\n";
                logger.log(Level.SEVERE, message, e);
            }
        }
        return null;
    }

    public static String sortKey(int[] c) {
        if (c == null || c.length != 4) {
            return null;
        }
        return c[0] + " " + c[1] + " " + c[2] + " " + c[3];
    }

    @Override
    public int compare(String s1, String s2) {
        String[] keys1 = s1.split(" ");
        String[] keys2 = s2.split(" ");
        for (int i = 0; i < 4; ++i) {
            int c2;
            int c1 = Integer.parseInt(keys1[i]);
            if (c1 < (c2 = Integer.parseInt(keys2[i]))) {
                return -1;
            }
            if (c1 <= c2) continue;
            return 1;
        }
        return 0;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OutOfPlaneBendType outOfPlaneBendType = (OutOfPlaneBendType)o;
        return Arrays.equals(this.atomClasses, outOfPlaneBendType.atomClasses);
    }

    public int hashCode() {
        return Arrays.hashCode(this.atomClasses);
    }

    public void incrementClasses(int increment) {
        for (int i = 0; i < this.atomClasses.length; ++i) {
            if (this.atomClasses[i] <= 0) continue;
            int n = i;
            this.atomClasses[n] = this.atomClasses[n] + increment;
        }
        this.setKey(OutOfPlaneBendType.sortKey(this.atomClasses));
    }

    public OutOfPlaneBendType patchClasses(HashMap<AtomType, AtomType> typeMap) {
        int count = 0;
        int len = this.atomClasses.length;
        for (AtomType newType : typeMap.keySet()) {
            for (int atomClass : this.atomClasses) {
                if (atomClass != newType.atomClass) continue;
                ++count;
            }
        }
        if (count == 1) {
            int[] newClasses = Arrays.copyOf(this.atomClasses, len);
            for (AtomType newType : typeMap.keySet()) {
                for (int i = 0; i < len; ++i) {
                    if (this.atomClasses[i] != newType.atomClass) continue;
                    AtomType knownType = typeMap.get(newType);
                    newClasses[i] = knownType.atomClass;
                }
            }
            return new OutOfPlaneBendType(newClasses, this.forceConstant);
        }
        return null;
    }

    @Override
    public String toString() {
        return String.format("opbend  %5d  %5d  %5d  %5d  %6.2f", this.atomClasses[0], this.atomClasses[1], this.atomClasses[2], this.atomClasses[3], this.forceConstant);
    }

    public static Element getXMLForce(Document doc, ForceField forceField) {
        Map<String, OutOfPlaneBendType> types = forceField.getOutOfPlaneBendTypes();
        if (!types.values().isEmpty()) {
            Element node = doc.createElement("AmoebaOutOfPlaneBendForce");
            node.setAttribute("type", forceField.getString("opbendtype", "ALLINGER"));
            node.setAttribute("opbend-cubic", String.valueOf(forceField.getDouble("opbend-cubic", 0.0)));
            node.setAttribute("opbend-quartic", String.valueOf(forceField.getDouble("opbend-quartic", 0.0)));
            node.setAttribute("opbend-pentic", String.valueOf(forceField.getDouble("opbend-pentic", 0.0)));
            node.setAttribute("opbend-sextic", String.valueOf(forceField.getDouble("opbend-sextic", 0.0)));
            for (OutOfPlaneBendType outOfPlaneBendType : types.values()) {
                node.appendChild(outOfPlaneBendType.toXML(doc));
            }
            return node;
        }
        return null;
    }

    public Element toXML(Document doc) {
        Element node = doc.createElement("Angle");
        int i = 1;
        for (int ac : this.atomClasses) {
            if (ac == 0) {
                node.setAttribute(String.format("class%d", i), "");
            } else {
                node.setAttribute(String.format("class%d", i), String.format("%d", ac));
            }
            ++i;
        }
        node.setAttribute("k", String.format("%.17f", this.forceConstant * 4.184 / 3282.806350011744));
        return node;
    }
}

