/*
 * Decompiled with CFR 0.152.
 */
package ffx.potential.parameters;

import ffx.potential.parameters.ForceField;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class BaseType {
    private static final Logger logger = Logger.getLogger(BaseType.class.getName());
    protected String key;
    ForceField.ForceFieldType forceFieldType;

    public BaseType(ForceField.ForceFieldType forceFieldType, int[] keys) {
        this.forceFieldType = forceFieldType;
        this.setKey(keys);
    }

    public BaseType(ForceField.ForceFieldType forceFieldType, String key) {
        this.forceFieldType = forceFieldType;
        this.key = key;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(int[] keys) {
        if (keys == null) {
            this.key = null;
            return;
        }
        StringBuilder keyBuffer = new StringBuilder();
        for (int k : keys) {
            keyBuffer.append(k);
            keyBuffer.append(" ");
        }
        this.key = keyBuffer.toString().trim();
    }

    public void setKey(String key) {
        this.key = key;
    }

    public void log() {
        if (logger.isLoggable(Level.INFO)) {
            logger.info(this.toString());
        }
    }

    public void print() {
        System.out.println(this);
    }

    public String toString() {
        return String.valueOf((Object)this.forceFieldType) + " " + this.key;
    }
}

