/*
 * Decompiled with CFR 0.152.
 */
package ffx.potential.parameters;

import ffx.potential.parameters.AtomType;
import ffx.potential.parameters.BaseType;
import ffx.potential.parameters.ForceField;
import ffx.utilities.FFXProperty;
import ffx.utilities.PropertyGroup;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

@FFXProperty(name="angtors", clazz=String.class, propertyGroup=PropertyGroup.PotentialFunctionParameter, description="[4 integers and 6 reals]\nProvides the values for a single bond angle bending-torsional angle parameter.\nThe integer modifiers give the atom class numbers for the four kinds of atoms involved in the torsion and its contained angles.\nThe real number modifiers give the force constant values for both angles coupled with 1-, 2- and 3-fold torsional terms.\nThe default units for the force constants are kcal/mole/radian, but this can be controlled via the angtorunit keyword.\n")
public final class AngleTorsionType
extends BaseType
implements Comparator<String> {
    public static final double DEFAULT_ANGTOR_UNIT = Math.PI / 180;
    @FFXProperty(name="angtorunit", propertyGroup=PropertyGroup.EnergyUnitConversion, defaultValue="Pi/180", description="Sets the scale factor needed to convert the energy value computed by the angle bending-torsional angle\ncross term into units of kcal/mole. The correct value is force field dependent and typically provided in the\nheader of the master force field parameter file.\n")
    public double angtorunit = Math.PI / 180;
    private static final Logger logger = Logger.getLogger(AngleTorsionType.class.getName());
    public final int[] atomClasses;
    public final double[] forceConstants;

    public AngleTorsionType(int[] atomClasses, double[] forceConstants) {
        super(ForceField.ForceFieldType.ANGTORS, AngleTorsionType.sortKey(atomClasses));
        this.atomClasses = atomClasses;
        this.forceConstants = forceConstants;
    }

    public static AngleTorsionType average(@Nullable AngleTorsionType angleTorsionType1, @Nullable AngleTorsionType angleTorsionType2, @Nullable int[] atomClasses) {
        if (angleTorsionType1 == null || angleTorsionType2 == null || atomClasses == null) {
            return null;
        }
        int len = angleTorsionType1.forceConstants.length;
        if (len != angleTorsionType2.forceConstants.length) {
            return null;
        }
        double[] forceConstants = new double[len];
        for (int i = 0; i < len; ++i) {
            forceConstants[i] = (angleTorsionType1.forceConstants[i] + angleTorsionType2.forceConstants[i]) / 2.0;
        }
        return new AngleTorsionType(atomClasses, forceConstants);
    }

    public static AngleTorsionType parse(String input, String[] tokens) {
        if (tokens.length < 10) {
            logger.log(Level.WARNING, "Invalid ANGTORS type:\n{0}", input);
        } else {
            try {
                int[] atomClasses = new int[]{Integer.parseInt(tokens[1]), Integer.parseInt(tokens[2]), Integer.parseInt(tokens[3]), Integer.parseInt(tokens[4])};
                double[] constants = new double[]{Double.parseDouble(tokens[5]), Double.parseDouble(tokens[6]), Double.parseDouble(tokens[7]), Double.parseDouble(tokens[8]), Double.parseDouble(tokens[9]), Double.parseDouble(tokens[10])};
                return new AngleTorsionType(atomClasses, constants);
            }
            catch (NumberFormatException e) {
                String message = "Exception parsing ANGTORS type:\n" + input + "\n";
                logger.log(Level.SEVERE, message, e);
            }
        }
        return null;
    }

    public static String sortKey(int[] c) {
        return c[0] + " " + c[1] + " " + c[2] + " " + c[3];
    }

    @Override
    public int compare(String s1, String s2) {
        String[] keys1 = s1.split(" ");
        String[] keys2 = s2.split(" ");
        int[] c1 = new int[4];
        int[] c2 = new int[4];
        for (int i = 0; i < 4; ++i) {
            c1[i] = Integer.parseInt(keys1[i]);
            c2[i] = Integer.parseInt(keys2[i]);
        }
        if (c1[1] < c2[1]) {
            return -1;
        }
        if (c1[1] > c2[1]) {
            return 1;
        }
        if (c1[2] < c2[2]) {
            return -1;
        }
        if (c1[2] > c2[2]) {
            return 1;
        }
        if (c1[0] < c2[0]) {
            return -1;
        }
        if (c1[0] > c2[0]) {
            return 1;
        }
        if (c1[3] < c2[3]) {
            return -1;
        }
        if (c1[3] > c2[3]) {
            return 1;
        }
        return 0;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AngleTorsionType angleTorsionType = (AngleTorsionType)o;
        return Arrays.equals(this.atomClasses, angleTorsionType.atomClasses);
    }

    public int hashCode() {
        return Arrays.hashCode(this.atomClasses);
    }

    public void incrementClasses(int increment) {
        int i = 0;
        while (i < this.atomClasses.length) {
            int n = i++;
            this.atomClasses[n] = this.atomClasses[n] + increment;
        }
        this.setKey(AngleTorsionType.sortKey(this.atomClasses));
    }

    public AngleTorsionType patchClasses(HashMap<AtomType, AtomType> typeMap) {
        int count = 0;
        int len = this.atomClasses.length;
        for (AtomType newType : typeMap.keySet()) {
            for (int atomClass : this.atomClasses) {
                if (atomClass != newType.atomClass) continue;
                ++count;
            }
        }
        if (count == 1 || count == 2) {
            int[] newClasses = Arrays.copyOf(this.atomClasses, len);
            for (AtomType newType : typeMap.keySet()) {
                for (int i = 0; i < len; ++i) {
                    if (this.atomClasses[i] != newType.atomClass) continue;
                    AtomType knownType = typeMap.get(newType);
                    newClasses[i] = knownType.atomClass;
                }
            }
            return new AngleTorsionType(newClasses, this.forceConstants);
        }
        return null;
    }

    @Override
    public String toString() {
        return String.format("angtors  %5d  %5d  %5d  %5d  %6.3f  %6.3f  %6.3f  %6.3f  %6.3f  %6.3f", this.atomClasses[0], this.atomClasses[1], this.atomClasses[2], this.atomClasses[3], this.forceConstants[0], this.forceConstants[1], this.forceConstants[2], this.forceConstants[3], this.forceConstants[4], this.forceConstants[5]);
    }

    public static Element getXMLForce(Document doc, ForceField forceField) {
        Map<String, AngleTorsionType> types = forceField.getAngleTorsionTypes();
        if (!types.values().isEmpty()) {
            Element node = doc.createElement("AmoebaAngleTorsionForce");
            for (AngleTorsionType angleTorsionType : types.values()) {
                node.appendChild(angleTorsionType.toXML(doc));
            }
            return node;
        }
        return null;
    }

    public Element toXML(Document doc) {
        Element node = doc.createElement("Torsion");
        node.setAttribute("class1", String.format("%d", this.atomClasses[0]));
        node.setAttribute("class2", String.format("%d", this.atomClasses[1]));
        node.setAttribute("class3", String.format("%d", this.atomClasses[2]));
        node.setAttribute("class4", String.format("%d", this.atomClasses[3]));
        node.setAttribute("v11", String.format("%.17f", this.forceConstants[0] * 4.184));
        node.setAttribute("v12", String.format("%.17f", this.forceConstants[1] * 4.184));
        node.setAttribute("v13", String.format("%.17f", this.forceConstants[2] * 4.184));
        node.setAttribute("v21", String.format("%.17f", this.forceConstants[3] * 4.184));
        node.setAttribute("v22", String.format("%.17f", this.forceConstants[4] * 4.184));
        node.setAttribute("v23", String.format("%.17f", this.forceConstants[5] * 4.184));
        return node;
    }
}

