/*
 * Decompiled with CFR 0.152.
 */
package ffx.potential.openmm;

import ffx.openmm.CustomCentroidBondForce;
import ffx.openmm.DoubleArray;
import ffx.openmm.Force;
import ffx.openmm.IntArray;
import ffx.potential.bonded.Atom;
import ffx.potential.nonbonded.RestrainGroups;
import ffx.potential.openmm.OpenMMEnergy;
import java.util.logging.Level;
import java.util.logging.Logger;

public class RestrainGroupsForce
extends CustomCentroidBondForce {
    private static final Logger logger = Logger.getLogger(RestrainGroupsForce.class.getName());
    private static final String energy = "step(distance(g1,g2)-u)*k*(distance(g1,g2)-u)^2+step(l-distance(g1,g2))*k*(distance(g1,g2)-l)^2";

    public RestrainGroupsForce(OpenMMEnergy openMMEnergy) {
        super(2, energy);
        RestrainGroups restrainGroups = openMMEnergy.getRestrainGroups();
        if (restrainGroups == null) {
            this.destroy();
            return;
        }
        this.addPerBondParameter("k");
        this.addPerBondParameter("l");
        this.addPerBondParameter("u");
        Atom[] atoms = openMMEnergy.getMolecularAssembly().getAtomArray();
        int nGroups = restrainGroups.getNumberOfGroups();
        IntArray group = new IntArray(0);
        DoubleArray weight = new DoubleArray(0);
        for (int j = 0; j < nGroups; ++j) {
            int[] groupMembers;
            for (int i : groupMembers = restrainGroups.getGroupMembers(j)) {
                group.append(i);
                weight.append(atoms[i].getMass());
            }
            this.addGroup(group, weight);
            group.resize(0);
            weight.resize(0);
        }
        group.destroy();
        weight.destroy();
        double convert = 418.3999999999999;
        int nRestraints = restrainGroups.getNumberOfRestraints();
        int[] group1 = restrainGroups.getGroup1();
        int[] group2 = restrainGroups.getGroup2();
        double[] forceConstants = restrainGroups.getForceConstants();
        double[] smallerDistance = restrainGroups.getSmallerDistance();
        double[] largerDistance = restrainGroups.getLargerDistance();
        group = new IntArray(0);
        DoubleArray parameters = new DoubleArray(0);
        for (int i = 0; i < nRestraints; ++i) {
            group.append(group1[i]);
            group.append(group2[i]);
            parameters.append(forceConstants[i] * convert);
            parameters.append(smallerDistance[i] * 0.1);
            parameters.append(largerDistance[i] * 0.1);
            this.addBond(group, parameters);
            group.resize(0);
            parameters.resize(0);
        }
        group.destroy();
        parameters.destroy();
        int forceGroup = openMMEnergy.getMolecularAssembly().getForceField().getInteger("RESTRAIN_GROUPS_FORCE_GROUP", 0);
        this.setForceGroup(forceGroup);
        if (openMMEnergy.getCrystal().aperiodic()) {
            this.setUsesPeriodicBoundaryConditions(0);
        } else {
            this.setUsesPeriodicBoundaryConditions(1);
        }
        logger.log(Level.INFO, String.format("  Restrain Groups \t%6d\t\t%1d", nRestraints, forceGroup));
    }

    public static Force constructForce(OpenMMEnergy openMMEnergy) {
        RestrainGroups restrainGroups = openMMEnergy.getRestrainGroups();
        if (restrainGroups == null) {
            return null;
        }
        return new RestrainGroupsForce(openMMEnergy);
    }
}

