/*
 * Decompiled with CFR 0.152.
 */
package ffx.potential.openmm;

import edu.uiowa.jopenmm.OpenMM_Vec3;
import ffx.crystal.Crystal;
import ffx.numerics.Potential;
import ffx.openmm.AndersenThermostat;
import ffx.openmm.CMMotionRemover;
import ffx.openmm.Force;
import ffx.openmm.MonteCarloBarostat;
import ffx.openmm.System;
import ffx.potential.ForceFieldEnergy;
import ffx.potential.MolecularAssembly;
import ffx.potential.bonded.Angle;
import ffx.potential.bonded.Atom;
import ffx.potential.bonded.Bond;
import ffx.potential.nonbonded.GeneralizedKirkwood;
import ffx.potential.nonbonded.ParticleMeshEwald;
import ffx.potential.nonbonded.VanDerWaals;
import ffx.potential.nonbonded.VanDerWaalsForm;
import ffx.potential.nonbonded.implicit.ChandlerCavitation;
import ffx.potential.nonbonded.implicit.DispersionRegion;
import ffx.potential.openmm.AmoebaGKCavitationForce;
import ffx.potential.openmm.AmoebaGeneralizedKirkwoodForce;
import ffx.potential.openmm.AmoebaMultipoleForce;
import ffx.potential.openmm.AmoebaTorsionTorsionForce;
import ffx.potential.openmm.AmoebaVdwForce;
import ffx.potential.openmm.AmoebaWcaDispersionForce;
import ffx.potential.openmm.AngleForce;
import ffx.potential.openmm.AngleTorsionForce;
import ffx.potential.openmm.BondForce;
import ffx.potential.openmm.FixedChargeAlchemicalForces;
import ffx.potential.openmm.FixedChargeGBForce;
import ffx.potential.openmm.FixedChargeNonbondedForce;
import ffx.potential.openmm.ImproperTorsionForce;
import ffx.potential.openmm.InPlaneAngleForce;
import ffx.potential.openmm.OpenMMEnergy;
import ffx.potential.openmm.OutOfPlaneBendForce;
import ffx.potential.openmm.PiOrbitalTorsionForce;
import ffx.potential.openmm.RestrainDistanceForce;
import ffx.potential.openmm.RestrainGroupsForce;
import ffx.potential.openmm.RestrainPositionsForce;
import ffx.potential.openmm.RestrainTorsionsForce;
import ffx.potential.openmm.StretchBendForce;
import ffx.potential.openmm.StretchTorsionForce;
import ffx.potential.openmm.TorsionForce;
import ffx.potential.openmm.UreyBradleyForce;
import ffx.potential.parameters.BondType;
import ffx.potential.parameters.ForceField;
import ffx.potential.parameters.VDWType;
import ffx.potential.terms.AnglePotentialEnergy;
import ffx.potential.terms.BondPotentialEnergy;
import java.util.logging.Logger;
import javax.annotation.Nullable;
import org.apache.commons.configuration2.CompositeConfiguration;
import org.apache.commons.math3.util.FastMath;

public class OpenMMSystem
extends System {
    private static final Logger logger = Logger.getLogger(OpenMMSystem.class.getName());
    private final OpenMMEnergy openMMEnergy;
    protected ForceField forceField;
    protected Atom[] atoms;
    protected boolean updateBondedTerms = false;
    protected boolean softcoreCreated = false;
    protected BondForce bondForce = null;
    protected AngleForce angleForce = null;
    protected InPlaneAngleForce inPlaneAngleForce = null;
    protected StretchBendForce stretchBendForce = null;
    protected UreyBradleyForce ureyBradleyForce = null;
    protected OutOfPlaneBendForce outOfPlaneBendForce = null;
    protected PiOrbitalTorsionForce piOrbitalTorsionForce = null;
    protected TorsionForce torsionForce = null;
    protected ImproperTorsionForce improperTorsionForce = null;
    protected AmoebaTorsionTorsionForce amoebaTorsionTorsionForce = null;
    protected StretchTorsionForce stretchTorsionForce = null;
    protected AngleTorsionForce angleTorsionForce = null;
    protected RestrainTorsionsForce restrainTorsionsForce = null;
    protected RestrainPositionsForce restrainPositionsForce = null;
    protected RestrainGroupsForce restrainGroupsForce = null;
    protected AmoebaVdwForce amoebaVDWForce = null;
    protected AmoebaMultipoleForce amoebaMultipoleForce = null;
    protected AmoebaGeneralizedKirkwoodForce amoebaGeneralizedKirkwoodForce = null;
    protected AmoebaWcaDispersionForce amoebaWcaDispersionForce = null;
    protected AmoebaGKCavitationForce amoebaGKCavitationForce = null;
    protected FixedChargeGBForce fixedChargeGBForce = null;
    protected FixedChargeNonbondedForce fixedChargeNonBondedForce = null;
    protected FixedChargeAlchemicalForces fixedChargeAlchemicalForces = null;
    protected AndersenThermostat andersenThermostat = null;
    protected MonteCarloBarostat monteCarloBarostat = null;
    protected CMMotionRemover cmMotionRemover = null;

    public OpenMMSystem() {
        this.openMMEnergy = null;
        this.forceField = null;
        this.atoms = null;
    }

    public OpenMMSystem(OpenMMEnergy openMMEnergy) {
        this.openMMEnergy = openMMEnergy;
        MolecularAssembly molecularAssembly = openMMEnergy.getMolecularAssembly();
        this.forceField = molecularAssembly.getForceField();
        this.atoms = molecularAssembly.getAtomArray();
        try {
            this.addAtoms();
        }
        catch (Exception e) {
            logger.severe(" Atom without mass encountered.");
        }
        logger.info(String.format("\n OpenMM system created with %d atoms.", this.atoms.length));
    }

    public Potential getPotential() {
        return this.openMMEnergy;
    }

    public Atom[] getAtoms() {
        return this.atoms;
    }

    public void addForces() {
        boolean rigidHydrogen = this.forceField.getBoolean("RIGID_HYDROGEN", false);
        boolean rigidBonds = this.forceField.getBoolean("RIGID_BONDS", false);
        boolean rigidHydrogenAngles = this.forceField.getBoolean("RIGID_HYDROGEN_ANGLES", false);
        if (rigidHydrogen) {
            this.addHydrogenConstraints();
        }
        if (rigidBonds) {
            this.addUpBondConstraints();
        }
        if (rigidHydrogenAngles) {
            this.setUpHydrogenAngleConstraints();
        }
        logger.info("\n Bonded Terms\n");
        if (rigidBonds) {
            logger.info(" Not creating AmoebaBondForce because bonds are constrained.");
        } else {
            this.bondForce = (BondForce)BondForce.constructForce(this.openMMEnergy);
            this.addForce((Force)this.bondForce);
        }
        this.angleForce = (AngleForce)AngleForce.constructForce(this.openMMEnergy);
        this.addForce((Force)this.angleForce);
        this.inPlaneAngleForce = (InPlaneAngleForce)InPlaneAngleForce.constructForce(this.openMMEnergy);
        this.addForce((Force)this.inPlaneAngleForce);
        this.stretchBendForce = (StretchBendForce)StretchBendForce.constructForce(this.openMMEnergy);
        this.addForce((Force)this.stretchBendForce);
        this.ureyBradleyForce = (UreyBradleyForce)UreyBradleyForce.constructForce(this.openMMEnergy);
        this.addForce((Force)this.ureyBradleyForce);
        this.outOfPlaneBendForce = (OutOfPlaneBendForce)OutOfPlaneBendForce.constructForce(this.openMMEnergy);
        this.addForce((Force)this.outOfPlaneBendForce);
        this.piOrbitalTorsionForce = (PiOrbitalTorsionForce)PiOrbitalTorsionForce.constructForce(this.openMMEnergy);
        this.addForce((Force)this.piOrbitalTorsionForce);
        this.torsionForce = (TorsionForce)TorsionForce.constructForce(this.openMMEnergy);
        this.addForce((Force)this.torsionForce);
        this.improperTorsionForce = (ImproperTorsionForce)ImproperTorsionForce.constructForce(this.openMMEnergy);
        this.addForce((Force)this.improperTorsionForce);
        this.stretchTorsionForce = (StretchTorsionForce)StretchTorsionForce.constructForce(this.openMMEnergy);
        this.addForce((Force)this.stretchTorsionForce);
        this.angleTorsionForce = (AngleTorsionForce)AngleTorsionForce.constructForce(this.openMMEnergy);
        this.addForce((Force)this.angleTorsionForce);
        this.amoebaTorsionTorsionForce = (AmoebaTorsionTorsionForce)AmoebaTorsionTorsionForce.constructForce(this.openMMEnergy);
        this.addForce((Force)this.amoebaTorsionTorsionForce);
        if (this.openMMEnergy.getRestrainMode() == ForceFieldEnergy.RestrainMode.ENERGY) {
            this.restrainPositionsForce = (RestrainPositionsForce)RestrainPositionsForce.constructForce(this.openMMEnergy);
            this.addForce((Force)this.restrainPositionsForce);
            for (BondType.BondFunction function : BondType.BondFunction.values()) {
                RestrainDistanceForce restrainDistanceForce = (RestrainDistanceForce)RestrainDistanceForce.constructForce(function, this.openMMEnergy);
                this.addForce((Force)restrainDistanceForce);
            }
            this.restrainTorsionsForce = (RestrainTorsionsForce)RestrainTorsionsForce.constructForce(this.openMMEnergy);
            this.addForce((Force)this.restrainTorsionsForce);
        }
        this.restrainGroupsForce = (RestrainGroupsForce)RestrainGroupsForce.constructForce(this.openMMEnergy);
        this.addForce((Force)this.restrainGroupsForce);
        this.setDefaultPeriodicBoxVectors();
        VanDerWaals vdW = this.openMMEnergy.getVdwNode();
        if (vdW != null) {
            logger.info("\n Non-Bonded Terms");
            VanDerWaalsForm vdwForm = vdW.getVDWForm();
            if (vdwForm.vdwType == VDWType.VDW_TYPE.LENNARD_JONES) {
                GeneralizedKirkwood gk;
                this.fixedChargeNonBondedForce = (FixedChargeNonbondedForce)FixedChargeNonbondedForce.constructForce(this.openMMEnergy);
                this.addForce((Force)this.fixedChargeNonBondedForce);
                if (this.fixedChargeNonBondedForce != null && (gk = this.openMMEnergy.getGK()) != null) {
                    this.fixedChargeGBForce = (FixedChargeGBForce)FixedChargeGBForce.constructForce(this.openMMEnergy);
                    this.addForce((Force)this.fixedChargeGBForce);
                }
            } else {
                this.amoebaVDWForce = (AmoebaVdwForce)AmoebaVdwForce.constructForce(this.openMMEnergy);
                this.addForce((Force)this.amoebaVDWForce);
                this.amoebaMultipoleForce = (AmoebaMultipoleForce)AmoebaMultipoleForce.constructForce(this.openMMEnergy);
                this.addForce((Force)this.amoebaMultipoleForce);
                GeneralizedKirkwood gk = this.openMMEnergy.getGK();
                if (gk != null) {
                    ChandlerCavitation chandlerCavitation;
                    this.amoebaGeneralizedKirkwoodForce = (AmoebaGeneralizedKirkwoodForce)AmoebaGeneralizedKirkwoodForce.constructForce(this.openMMEnergy);
                    this.addForce((Force)this.amoebaGeneralizedKirkwoodForce);
                    DispersionRegion dispersionRegion = gk.getDispersionRegion();
                    if (dispersionRegion != null) {
                        this.amoebaWcaDispersionForce = (AmoebaWcaDispersionForce)AmoebaWcaDispersionForce.constructForce(this.openMMEnergy);
                        this.addForce((Force)this.amoebaWcaDispersionForce);
                    }
                    if ((chandlerCavitation = gk.getChandlerCavitation()) != null && chandlerCavitation.getGaussVol() != null) {
                        this.amoebaGKCavitationForce = (AmoebaGKCavitationForce)AmoebaGKCavitationForce.constructForce(this.openMMEnergy);
                        this.addForce((Force)this.amoebaGKCavitationForce);
                    }
                }
            }
        }
    }

    public void removeForce(Force force) {
        if (force != null) {
            this.removeForce(force.getForceIndex());
        }
    }

    public void addAndersenThermostatForce(double targetTemp) {
        double collisionFreq = this.forceField.getDouble("COLLISION_FREQ", 1.0);
        this.addAndersenThermostatForce(targetTemp, collisionFreq);
    }

    public void addAndersenThermostatForce(double targetTemp, double collisionFreq) {
        if (this.andersenThermostat != null) {
            this.removeForce((Force)this.andersenThermostat);
            this.andersenThermostat = null;
        }
        this.andersenThermostat = new AndersenThermostat(targetTemp, collisionFreq);
        this.addForce((Force)this.andersenThermostat);
        logger.info("\n Adding an Andersen thermostat");
        logger.info(String.format("  Target Temperature:   %6.2f (K)", targetTemp));
        logger.info(String.format("  Collision Frequency:  %6.2f (1/psec)", collisionFreq));
    }

    public void addCOMMRemoverForce() {
        if (this.cmMotionRemover != null) {
            this.removeForce((Force)this.cmMotionRemover);
            this.cmMotionRemover = null;
        }
        int frequency = this.forceField.getInteger("REMOVE-COM-FREQUENCY", 100);
        this.cmMotionRemover = new CMMotionRemover(frequency);
        int forceGroup = this.forceField.getInteger("COMM_FORCE_GROUP", 1);
        this.cmMotionRemover.setForceGroup(forceGroup);
        this.addForce((Force)this.cmMotionRemover);
        logger.info("\n Added a Center of Mass Motion Remover");
        logger.info(String.format("  Frequency:            %6d", frequency));
        logger.info(String.format("  Force Group:          %6d", forceGroup));
    }

    public void addMonteCarloBarostatForce(double targetPressure, double targetTemp, int frequency) {
        if (this.monteCarloBarostat != null) {
            this.removeForce((Force)this.monteCarloBarostat);
            this.monteCarloBarostat = null;
        }
        double pressureInBar = targetPressure * 1.01325;
        this.monteCarloBarostat = new MonteCarloBarostat(pressureInBar, targetTemp, frequency);
        CompositeConfiguration properties = this.openMMEnergy.getMolecularAssembly().getProperties();
        if (properties.containsKey("barostat-seed")) {
            int randomSeed = properties.getInt("barostat-seed", 0);
            logger.info(String.format(" Setting random seed %d for Monte Carlo Barostat", randomSeed));
            this.monteCarloBarostat.setRandomNumberSeed(randomSeed);
        }
        this.addForce((Force)this.monteCarloBarostat);
        logger.info("\n Added a Monte Carlo Barostat");
        logger.info(String.format("  Target Pressure:      %6.2f (atm)", targetPressure));
        logger.info(String.format("  Target Temperature:   %6.2f (K)", targetTemp));
        logger.info(String.format("  MC Move Frequency:    %6d", frequency));
    }

    public int calculateDegreesOfFreedom() {
        int dof = this.openMMEnergy.getNumberOfVariables();
        dof -= this.getNumConstraints();
        if (this.cmMotionRemover != null) {
            dof -= 3;
        }
        return dof;
    }

    public double getTemperature(double kineticEnergy) {
        double dof = this.calculateDegreesOfFreedom();
        return 2.0 * kineticEnergy * 418.4 / (0.831446261815324 * dof);
    }

    public ForceField getForceField() {
        return this.forceField;
    }

    public Crystal getCrystal() {
        return this.openMMEnergy.getCrystal();
    }

    public int getNumberOfVariables() {
        return this.openMMEnergy.getNumberOfVariables();
    }

    public void free() {
        if (this.getPointer() != null) {
            logger.fine(" Free OpenMM system.");
            this.destroy();
            logger.fine(" Free OpenMM system completed.");
        }
    }

    public void setUpdateBondedTerms(boolean updateBondedTerms) {
        this.updateBondedTerms = updateBondedTerms;
    }

    protected void setDefaultPeriodicBoxVectors() {
        Crystal crystal = this.openMMEnergy.getCrystal();
        if (!crystal.aperiodic()) {
            OpenMM_Vec3 a = new OpenMM_Vec3();
            OpenMM_Vec3 b = new OpenMM_Vec3();
            OpenMM_Vec3 c = new OpenMM_Vec3();
            double[][] Ai = crystal.Ai;
            a.x = Ai[0][0] * 0.1;
            a.y = Ai[0][1] * 0.1;
            a.z = Ai[0][2] * 0.1;
            b.x = Ai[1][0] * 0.1;
            b.y = Ai[1][1] * 0.1;
            b.z = Ai[1][2] * 0.1;
            c.x = Ai[2][0] * 0.1;
            c.y = Ai[2][1] * 0.1;
            c.z = Ai[2][2] * 0.1;
            this.setDefaultPeriodicBoxVectors(a, b, c);
        }
    }

    public void updateParameters(@Nullable Atom[] atoms) {
        boolean vdwLambdaTerm;
        VanDerWaals vanDerWaals = this.openMMEnergy.getVdwNode();
        if (vanDerWaals != null && (vdwLambdaTerm = vanDerWaals.getLambdaTerm())) {
            double lambdaVDW = vanDerWaals.getLambda();
            if (this.fixedChargeNonBondedForce != null) {
                if (!this.softcoreCreated) {
                    this.fixedChargeAlchemicalForces = new FixedChargeAlchemicalForces(this.openMMEnergy, this.fixedChargeNonBondedForce);
                    this.addForce((Force)this.fixedChargeAlchemicalForces.getFixedChargeSoftcoreForce());
                    this.addForce((Force)this.fixedChargeAlchemicalForces.getAlchemicalAlchemicalStericsForce());
                    this.addForce((Force)this.fixedChargeAlchemicalForces.getNonAlchemicalAlchemicalStericsForce());
                    this.openMMEnergy.getContext().reinitialize(1);
                    this.softcoreCreated = true;
                }
                this.openMMEnergy.getContext().setParameter("vdw_lambda", lambdaVDW);
            } else if (this.amoebaVDWForce != null) {
                this.openMMEnergy.getContext().setParameter("AmoebaVdwLambda", lambdaVDW);
                if (this.softcoreCreated) {
                    ParticleMeshEwald pme = this.openMMEnergy.getPmeNode();
                    if (pme == null || !pme.getLambdaTerm()) {
                        return;
                    }
                } else {
                    this.softcoreCreated = true;
                }
            }
        }
        if (this.updateBondedTerms) {
            if (this.bondForce != null) {
                this.bondForce.updateForce(this.openMMEnergy);
            }
            if (this.angleForce != null) {
                this.angleForce.updateForce(this.openMMEnergy);
            }
            if (this.inPlaneAngleForce != null) {
                this.inPlaneAngleForce.updateForce(this.openMMEnergy);
            }
            if (this.stretchBendForce != null) {
                this.stretchBendForce.updateForce(this.openMMEnergy);
            }
            if (this.ureyBradleyForce != null) {
                this.ureyBradleyForce.updateForce(this.openMMEnergy);
            }
            if (this.outOfPlaneBendForce != null) {
                this.outOfPlaneBendForce.updateForce(this.openMMEnergy);
            }
            if (this.piOrbitalTorsionForce != null) {
                this.piOrbitalTorsionForce.updateForce(this.openMMEnergy);
            }
            if (this.torsionForce != null) {
                this.torsionForce.updateForce(this.openMMEnergy);
            }
            if (this.improperTorsionForce != null) {
                this.improperTorsionForce.updateForce(this.openMMEnergy);
            }
        }
        if (this.restrainTorsionsForce != null) {
            this.restrainTorsionsForce.updateForce(this.openMMEnergy);
        }
        if (atoms == null || atoms.length == 0) {
            return;
        }
        if (this.fixedChargeNonBondedForce != null) {
            this.fixedChargeNonBondedForce.updateForce(this.atoms, this.openMMEnergy);
        }
        if (this.fixedChargeGBForce != null) {
            this.fixedChargeGBForce.updateForce(atoms, this.openMMEnergy);
        }
        if (this.amoebaVDWForce != null) {
            this.amoebaVDWForce.updateForce(atoms, this.openMMEnergy);
        }
        if (this.amoebaMultipoleForce != null) {
            this.amoebaMultipoleForce.updateForce(atoms, this.openMMEnergy);
        }
        if (this.amoebaGeneralizedKirkwoodForce != null) {
            this.amoebaGeneralizedKirkwoodForce.updateForce(atoms, this.openMMEnergy);
        }
        if (this.amoebaWcaDispersionForce != null) {
            this.amoebaWcaDispersionForce.updateForce(atoms, this.openMMEnergy);
        }
        if (this.amoebaGKCavitationForce != null) {
            this.amoebaGKCavitationForce.updateForce(atoms, this.openMMEnergy);
        }
    }

    protected void addAtoms() throws Exception {
        for (Atom atom : this.atoms) {
            double mass = atom.getMass();
            if (mass < 0.0) {
                throw new Exception(" Atom with mass less than 0.");
            }
            if (mass == 0.0) {
                logger.info(String.format(" Atom %s has zero mass.", atom));
            }
            this.addParticle(mass);
        }
    }

    public boolean updateAtomMass() {
        int index = 0;
        int inactiveCount = 0;
        for (Atom atom : this.atoms) {
            double mass = 0.0;
            if (atom.isActive()) {
                mass = atom.getMass();
            } else {
                ++inactiveCount;
            }
            this.setParticleMass(index++, mass);
        }
        if (inactiveCount > 0) {
            logger.fine(String.format(" Inactive atoms (%d) set to zero mass.", inactiveCount));
            return true;
        }
        return false;
    }

    public boolean hasAmoebaCavitationForce() {
        return this.amoebaGKCavitationForce != null;
    }

    protected void addUpBondConstraints() {
        BondPotentialEnergy bondPotentialEnergy = this.openMMEnergy.getBondPotentialEnergy();
        if (bondPotentialEnergy == null) {
            return;
        }
        Bond[] bonds = bondPotentialEnergy.getBondArray();
        logger.info(" Adding constraints for all bonds.");
        for (Bond bond : bonds) {
            Atom atom1 = bond.getAtom(0);
            Atom atom2 = bond.getAtom(1);
            int iAtom1 = atom1.getXyzIndex() - 1;
            int iAtom2 = atom2.getXyzIndex() - 1;
            this.addConstraint(iAtom1, iAtom2, bond.bondType.distance * 0.1);
        }
    }

    protected void addHydrogenConstraints() {
        BondPotentialEnergy bondPotentialEnergy = this.openMMEnergy.getBondPotentialEnergy();
        if (bondPotentialEnergy == null) {
            return;
        }
        Bond[] bonds = bondPotentialEnergy.getBondArray();
        logger.info(" Adding constraints for hydrogen bonds.");
        for (Bond bond : bonds) {
            Atom atom1 = bond.getAtom(0);
            Atom atom2 = bond.getAtom(1);
            if (!atom1.isHydrogen() && !atom2.isHydrogen()) continue;
            BondType bondType = bond.bondType;
            int iAtom1 = atom1.getXyzIndex() - 1;
            int iAtom2 = atom2.getXyzIndex() - 1;
            this.addConstraint(iAtom1, iAtom2, bondType.distance * 0.1);
        }
    }

    protected void setUpHydrogenAngleConstraints() {
        AnglePotentialEnergy anglePotentialEnergy = this.openMMEnergy.getAnglePotentialEnergy();
        if (anglePotentialEnergy == null) {
            return;
        }
        Angle[] angles = anglePotentialEnergy.getAngleArray();
        logger.info(" Adding hydrogen angle constraints.");
        for (Angle angle : angles) {
            if (!this.isHydrogenAngle(angle)) continue;
            Atom atom1 = angle.getAtom(0);
            Atom atom3 = angle.getAtom(2);
            Bond bond1 = angle.getBond(0);
            double distance1 = bond1.bondType.distance;
            Bond bond2 = angle.getBond(1);
            double distance2 = bond2.bondType.distance;
            double angleVal = angle.angleType.angle[angle.nh];
            double falseBondLength = FastMath.sqrt((double)(distance1 * distance1 + distance2 * distance2 - 2.0 * distance1 * distance2 * FastMath.cos((double)FastMath.toRadians((double)angleVal))));
            int iAtom1 = atom1.getXyzIndex() - 1;
            int iAtom3 = atom3.getXyzIndex() - 1;
            this.addConstraint(iAtom1, iAtom3, falseBondLength * 0.1);
        }
    }

    protected boolean isHydrogenAngle(Angle angle) {
        double angleVal;
        if (angle.containsHydrogen() && (angleVal = angle.angleType.angle[angle.nh]) < 160.0) {
            Atom atom1 = angle.getAtom(0);
            Atom atom2 = angle.getAtom(1);
            Atom atom3 = angle.getAtom(2);
            return atom1.isHydrogen() && atom3.isHydrogen() && !atom2.isHydrogen();
        }
        return false;
    }
}

