/*
 * Decompiled with CFR 0.152.
 */
package ffx.potential.openmm;

import ffx.crystal.Crystal;
import ffx.numerics.switching.UnivariateSwitchingFunction;
import ffx.potential.DualTopologyEnergy;
import ffx.potential.ForceFieldEnergy;
import ffx.potential.MolecularAssembly;
import ffx.potential.Platform;
import ffx.potential.bonded.Atom;
import ffx.potential.openmm.OpenMMContext;
import ffx.potential.openmm.OpenMMDualTopologySystem;
import ffx.potential.openmm.OpenMMPotential;
import ffx.potential.openmm.OpenMMState;
import ffx.potential.openmm.OpenMMSystem;
import ffx.potential.parameters.ForceField;
import ffx.potential.utils.EnergyException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;

public class OpenMMDualTopologyEnergy
extends DualTopologyEnergy
implements OpenMMPotential {
    private static final Logger logger = Logger.getLogger(OpenMMDualTopologyEnergy.class.getName());
    private final OpenMMContext openMMContext;
    private final OpenMMDualTopologySystem openMMDualTopologySystem;
    private final Atom[] atoms;
    private final MolecularAssembly molecularAssembly1;
    private final MolecularAssembly molecularAssembly2;

    public OpenMMDualTopologyEnergy(MolecularAssembly topology1, MolecularAssembly topology2, UnivariateSwitchingFunction switchFunction, Platform requestedPlatform) {
        super(topology1, topology2, switchFunction);
        logger.info("\n Initializing an OpenMM Dual Topology System.");
        this.molecularAssembly1 = topology1;
        this.molecularAssembly2 = topology2;
        Crystal crystal1 = this.molecularAssembly1.getCrystal();
        int symOps1 = crystal1.spaceGroup.getNumberOfSymOps();
        Crystal crystal2 = this.molecularAssembly2.getCrystal();
        int symOps2 = crystal2.spaceGroup.getNumberOfSymOps();
        if (symOps1 > 1 || symOps2 > 1) {
            logger.severe(" OpenMM does not support symmetry operators.");
        }
        ForceField forceField = topology1.getForceField();
        ffx.openmm.Platform openMMPlatform = OpenMMContext.loadPlatform(requestedPlatform, forceField);
        this.openMMDualTopologySystem = new OpenMMDualTopologySystem(this);
        this.openMMDualTopologySystem.addForces();
        this.atoms = this.getDualTopologyAtoms(0);
        this.openMMContext = new OpenMMContext(openMMPlatform, this.openMMDualTopologySystem, this.atoms);
    }

    @Override
    public double energy(double[] x) {
        return this.energy(x, false);
    }

    @Override
    public double energy(double[] x, boolean verbose) {
        this.openMMContext.update();
        this.updateParameters(this.atoms);
        this.unscaleCoordinates(x);
        this.setCoordinates(x);
        OpenMMState openMMState = this.openMMContext.getOpenMMState(8);
        double e = openMMState.potentialEnergy;
        openMMState.destroy();
        if (!Double.isFinite(e)) {
            String message = String.format(" OpenMMDualTopologyEnergy was a non-finite %8g", e);
            logger.warning(message);
            throw new EnergyException(message);
        }
        if (verbose) {
            logger.log(Level.INFO, String.format("\n OpenMM Energy: %14.10g", e));
        }
        return e;
    }

    public double energyFFX(double[] x) {
        return super.energy(x, false);
    }

    public double energyFFX(double[] x, boolean verbose) {
        return super.energy(x, verbose);
    }

    @Override
    public void setCoordinates(double[] x) {
        super.setCoordinates(x);
        int n = this.atoms.length * 3;
        double[] xall = new double[n];
        int i = 0;
        for (Atom atom : this.atoms) {
            xall[i] = atom.getX();
            xall[i + 1] = atom.getY();
            xall[i + 2] = atom.getZ();
            i += 3;
        }
        this.openMMContext.setPositions(xall);
    }

    @Override
    public void setVelocity(double[] v) {
        super.setVelocity(v);
        int n = this.atoms.length * 3;
        double[] vall = new double[n];
        double[] v3 = new double[3];
        int i = 0;
        for (Atom atom : this.atoms) {
            atom.getVelocity(v3);
            if (!atom.isActive()) {
                v3[0] = 0.0;
                v3[1] = 0.0;
                v3[2] = 0.0;
                atom.setVelocity(v3);
            }
            vall[i] = v3[0];
            vall[i + 1] = v3[1];
            vall[i + 2] = v3[2];
            i += 3;
        }
        this.openMMContext.setVelocities(vall);
    }

    public MolecularAssembly getMolecularAssembly(int topology) {
        if (topology == 0) {
            return this.molecularAssembly1;
        }
        if (topology == 1) {
            return this.molecularAssembly2;
        }
        throw new IllegalArgumentException(" Invalid topology index: " + topology);
    }

    public ForceFieldEnergy getForceFieldEnergy(int topology) {
        if (topology == 0) {
            return this.getForceFieldEnergy1();
        }
        if (topology == 1) {
            return this.getForceFieldEnergy2();
        }
        throw new IllegalArgumentException(" Invalid topology index: " + topology);
    }

    @Override
    public void updateParameters(@Nullable Atom[] atoms) {
        if (atoms == null) {
            atoms = this.atoms;
        }
        if (this.openMMDualTopologySystem != null) {
            this.openMMDualTopologySystem.updateParameters(atoms);
        }
    }

    @Override
    public OpenMMContext getContext() {
        return this.openMMContext;
    }

    @Override
    public void updateContext(String integratorName, double timeStep, double temperature, boolean forceCreation) {
        this.openMMContext.update(integratorName, timeStep, temperature, forceCreation);
    }

    @Override
    public OpenMMState getOpenMMState(int mask) {
        return this.openMMContext.getOpenMMState(mask);
    }

    @Override
    public OpenMMSystem getSystem() {
        return this.openMMDualTopologySystem;
    }

    @Override
    public boolean setActiveAtoms() {
        return this.openMMDualTopologySystem.updateAtomMass();
    }
}

