/*
 * Decompiled with CFR 0.152.
 */
package ffx.potential.openmm;

import ffx.openmm.CustomCompoundBondForce;
import ffx.openmm.DoubleArray;
import ffx.openmm.Force;
import ffx.openmm.IntArray;
import ffx.potential.ForceFieldEnergy;
import ffx.potential.bonded.Angle;
import ffx.potential.bonded.Atom;
import ffx.potential.openmm.OpenMMDualTopologyEnergy;
import ffx.potential.openmm.OpenMMEnergy;
import ffx.potential.parameters.AngleType;
import ffx.potential.parameters.ForceField;
import ffx.potential.terms.AnglePotentialEnergy;
import java.util.logging.Logger;

public class InPlaneAngleForce
extends CustomCompoundBondForce {
    private static final Logger logger = Logger.getLogger(InPlaneAngleForce.class.getName());
    private int nAngles = 0;
    private final boolean manyBodyTitration;

    public InPlaneAngleForce(AnglePotentialEnergy anglePotentialEnergy, OpenMMEnergy openMMEnergy) {
        super(4, anglePotentialEnergy.getInPlaneAngleEnergyString());
        Angle[] angles = anglePotentialEnergy.getAngleArray();
        this.addPerBondParameter("theta0");
        this.addPerBondParameter("k");
        this.setName("InPlaneAngle");
        ForceField forceField = openMMEnergy.getMolecularAssembly().getForceField();
        this.manyBodyTitration = forceField.getBoolean("MANYBODY_TITRATION", false);
        IntArray particles = new IntArray(0);
        DoubleArray parameters = new DoubleArray(0);
        for (Angle angle : angles) {
            int i4;
            AngleType.AngleMode angleMode = angle.angleType.angleMode;
            if (!this.manyBodyTitration && angleMode == AngleType.AngleMode.NORMAL) continue;
            double theta0 = angle.angleType.angle[angle.nh];
            double k = 4.184 * angle.angleType.angleUnit * angle.angleType.forceConstant;
            int i1 = angle.getAtom(0).getArrayIndex();
            int i2 = angle.getAtom(1).getArrayIndex();
            int i3 = angle.getAtom(2).getArrayIndex();
            if (angleMode == AngleType.AngleMode.NORMAL) {
                k = 0.0;
                Atom fourthAtom = angle.getFourthAtomOfTrigonalCenter();
                if (fourthAtom != null) {
                    i4 = fourthAtom.getArrayIndex();
                } else {
                    for (i4 = 0; i1 == i4 || i2 == i4 || i3 == i4; ++i4) {
                    }
                }
            } else {
                i4 = angle.getAtom4().getArrayIndex();
            }
            particles.append(i1);
            particles.append(i2);
            particles.append(i3);
            particles.append(i4);
            parameters.append(theta0);
            parameters.append(k);
            this.addBond(particles, parameters);
            ++this.nAngles;
            particles.resize(0);
            parameters.resize(0);
        }
        particles.destroy();
        parameters.destroy();
        if (this.nAngles > 0) {
            int forceGroup = anglePotentialEnergy.getForceGroup();
            this.setForceGroup(forceGroup);
            logger.info(String.format("  In-Plane Angles:                   %10d", this.nAngles));
            logger.fine(String.format("   Force Group:                      %10d", forceGroup));
        }
    }

    public InPlaneAngleForce(AnglePotentialEnergy anglePotentialEnergy, int topology, OpenMMDualTopologyEnergy openMMDualTopologyEnergy) {
        super(4, anglePotentialEnergy.getInPlaneAngleEnergyString());
        ForceFieldEnergy forceFieldEnergy = openMMDualTopologyEnergy.getForceFieldEnergy(topology);
        ForceField forceField = forceFieldEnergy.getMolecularAssembly().getForceField();
        this.manyBodyTitration = forceField.getBoolean("MANYBODY_TITRATION", false);
        if (this.manyBodyTitration) {
            logger.severe("Dual Topology does not support many body titration.");
        }
        Angle[] angles = anglePotentialEnergy.getAngleArray();
        this.addPerBondParameter("theta0");
        this.addPerBondParameter("k");
        this.setName("InPlaneAngle");
        double scale = openMMDualTopologyEnergy.getTopologyScale(topology);
        IntArray particles = new IntArray(0);
        DoubleArray parameters = new DoubleArray(0);
        for (Angle angle : angles) {
            AngleType.AngleMode angleMode = angle.angleType.angleMode;
            if (angleMode == AngleType.AngleMode.NORMAL) continue;
            double theta0 = angle.angleType.angle[angle.nh];
            double k = 4.184 * angle.angleType.angleUnit * angle.angleType.forceConstant;
            if (!angle.applyLambda()) {
                k *= scale;
            }
            int i1 = angle.getAtom(0).getArrayIndex();
            int i2 = angle.getAtom(1).getArrayIndex();
            int i3 = angle.getAtom(2).getArrayIndex();
            int i4 = angle.getAtom4().getArrayIndex();
            i1 = openMMDualTopologyEnergy.mapToDualTopologyIndex(topology, i1);
            i2 = openMMDualTopologyEnergy.mapToDualTopologyIndex(topology, i2);
            i3 = openMMDualTopologyEnergy.mapToDualTopologyIndex(topology, i3);
            i4 = openMMDualTopologyEnergy.mapToDualTopologyIndex(topology, i4);
            particles.append(i1);
            particles.append(i2);
            particles.append(i3);
            particles.append(i4);
            parameters.append(theta0);
            parameters.append(k);
            this.addBond(particles, parameters);
            ++this.nAngles;
            particles.resize(0);
            parameters.resize(0);
        }
        particles.destroy();
        parameters.destroy();
        if (this.nAngles > 0) {
            int forceGroup = anglePotentialEnergy.getForceGroup();
            this.setForceGroup(forceGroup);
            logger.info(String.format("  In-Plane Angles:                   %10d", this.nAngles));
            logger.fine(String.format("   Force Group:                      %10d", forceGroup));
        }
    }

    public static Force constructForce(OpenMMEnergy openMMEnergy) {
        AnglePotentialEnergy anglePotentialEnergy = openMMEnergy.getAnglePotentialEnergy();
        if (anglePotentialEnergy == null) {
            return null;
        }
        InPlaneAngleForce angleForce = new InPlaneAngleForce(anglePotentialEnergy, openMMEnergy);
        if (angleForce.nAngles > 0) {
            return angleForce;
        }
        return null;
    }

    public static Force constructForce(int topology, OpenMMDualTopologyEnergy openMMDualTopologyEnergy) {
        ForceFieldEnergy forceFieldEnergy = openMMDualTopologyEnergy.getForceFieldEnergy(topology);
        AnglePotentialEnergy anglePotentialEnergy = forceFieldEnergy.getAnglePotentialEnergy();
        if (anglePotentialEnergy == null) {
            return null;
        }
        InPlaneAngleForce angleForce = new InPlaneAngleForce(anglePotentialEnergy, topology, openMMDualTopologyEnergy);
        if (angleForce.nAngles > 0) {
            return angleForce;
        }
        return null;
    }

    public void updateForce(OpenMMEnergy openMMEnergy) {
        AnglePotentialEnergy anglePotentialEnergy = openMMEnergy.getAnglePotentialEnergy();
        if (anglePotentialEnergy == null) {
            return;
        }
        Angle[] angles = anglePotentialEnergy.getAngleArray();
        IntArray particles = new IntArray(0);
        DoubleArray parameters = new DoubleArray(0);
        int index = 0;
        for (Angle angle : angles) {
            int i4;
            AngleType.AngleMode angleMode = angle.angleType.angleMode;
            if (!this.manyBodyTitration && angleMode == AngleType.AngleMode.NORMAL) continue;
            double theta0 = angle.angleType.angle[angle.nh];
            double k = 4.184 * angle.angleType.angleUnit * angle.angleType.forceConstant;
            int i1 = angle.getAtom(0).getArrayIndex();
            int i2 = angle.getAtom(1).getArrayIndex();
            int i3 = angle.getAtom(2).getArrayIndex();
            if (angleMode == AngleType.AngleMode.NORMAL) {
                k = 0.0;
                Atom fourthAtom = angle.getFourthAtomOfTrigonalCenter();
                if (fourthAtom != null) {
                    i4 = fourthAtom.getArrayIndex();
                } else {
                    for (i4 = 0; i1 == i4 || i2 == i4 || i3 == i4; ++i4) {
                    }
                }
            } else {
                i4 = angle.getAtom4().getArrayIndex();
            }
            particles.append(i1);
            particles.append(i2);
            particles.append(i3);
            particles.append(i4);
            parameters.append(theta0);
            parameters.append(k);
            this.setBondParameters(index++, particles, parameters);
            particles.resize(0);
            parameters.resize(0);
        }
        particles.destroy();
        parameters.destroy();
        this.updateParametersInContext(openMMEnergy.getContext());
    }

    public void updateForce(int topology, OpenMMDualTopologyEnergy openMMDualTopologyEnergy) {
        ForceFieldEnergy forceFieldEnergy = openMMDualTopologyEnergy.getForceFieldEnergy(topology);
        AnglePotentialEnergy anglePotentialEnergy = forceFieldEnergy.getAnglePotentialEnergy();
        if (anglePotentialEnergy == null) {
            return;
        }
        Angle[] angles = anglePotentialEnergy.getAngleArray();
        double scale = openMMDualTopologyEnergy.getTopologyScale(topology);
        IntArray particles = new IntArray(0);
        DoubleArray parameters = new DoubleArray(0);
        int index = 0;
        for (Angle angle : angles) {
            AngleType.AngleMode angleMode = angle.angleType.angleMode;
            if (angleMode == AngleType.AngleMode.NORMAL) continue;
            double theta0 = angle.angleType.angle[angle.nh];
            double k = 4.184 * angle.angleType.angleUnit * angle.angleType.forceConstant;
            if (!angle.applyLambda()) {
                k *= scale;
            }
            int i1 = angle.getAtom(0).getArrayIndex();
            int i2 = angle.getAtom(1).getArrayIndex();
            int i3 = angle.getAtom(2).getArrayIndex();
            int i4 = angle.getAtom4().getArrayIndex();
            i1 = openMMDualTopologyEnergy.mapToDualTopologyIndex(topology, i1);
            i2 = openMMDualTopologyEnergy.mapToDualTopologyIndex(topology, i2);
            i3 = openMMDualTopologyEnergy.mapToDualTopologyIndex(topology, i3);
            i4 = openMMDualTopologyEnergy.mapToDualTopologyIndex(topology, i4);
            particles.append(i1);
            particles.append(i2);
            particles.append(i3);
            particles.append(i4);
            parameters.append(theta0);
            parameters.append(k);
            this.setBondParameters(index++, particles, parameters);
            particles.resize(0);
            parameters.resize(0);
        }
        particles.destroy();
        parameters.destroy();
        this.updateParametersInContext(openMMDualTopologyEnergy.getContext());
    }
}

