/*
 * Decompiled with CFR 0.152.
 */
package ffx.potential.openmm;

import com.sun.jna.ptr.DoubleByReference;
import com.sun.jna.ptr.IntByReference;
import ffx.crystal.Crystal;
import ffx.openmm.BondArray;
import ffx.openmm.Force;
import ffx.openmm.NonbondedForce;
import ffx.potential.bonded.Atom;
import ffx.potential.bonded.Bond;
import ffx.potential.nonbonded.NonbondedCutoff;
import ffx.potential.nonbonded.ParticleMeshEwald;
import ffx.potential.nonbonded.VanDerWaals;
import ffx.potential.nonbonded.VanDerWaalsForm;
import ffx.potential.openmm.OpenMMEnergy;
import ffx.potential.parameters.ForceField;
import ffx.potential.parameters.MultipoleType;
import ffx.potential.parameters.VDWType;
import ffx.potential.terms.BondPotentialEnergy;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.math3.util.FastMath;

public class FixedChargeNonbondedForce
extends NonbondedForce {
    private static final Logger logger = Logger.getLogger(FixedChargeNonbondedForce.class.getName());
    private boolean[] chargeExclusion;
    private boolean[] vdWExclusion;
    private double[] exceptionChargeProd;
    private double[] exceptionEps;

    public FixedChargeNonbondedForce(OpenMMEnergy openMMEnergy) {
        Crystal crystal;
        BondPotentialEnergy bondPotentialEnergy;
        Atom[] atoms;
        VanDerWaals vdW = openMMEnergy.getVdwNode();
        if (vdW == null) {
            this.destroy();
            return;
        }
        VanDerWaalsForm vdwForm = vdW.getVDWForm();
        if (vdwForm.vdwType != VDWType.VDW_TYPE.LENNARD_JONES || vdwForm.radiusRule != VDWType.RADIUS_RULE.ARITHMETIC || vdwForm.epsilonRule != VDWType.EPSILON_RULE.GEOMETRIC) {
            logger.info(String.format(" VDW Type:         %s", new Object[]{vdwForm.vdwType}));
            logger.info(String.format(" VDW Radius Rule:  %s", new Object[]{vdwForm.radiusRule}));
            logger.info(String.format(" VDW Epsilon Rule: %s", new Object[]{vdwForm.epsilonRule}));
            logger.log(Level.SEVERE, " Unsupported van der Waals functional form.");
            return;
        }
        double radScale = 1.0;
        if (vdwForm.radiusSize == VDWType.RADIUS_SIZE.RADIUS) {
            radScale = 2.0;
        }
        if (vdwForm.radiusType == VDWType.RADIUS_TYPE.R_MIN) {
            radScale /= 1.122462048309373;
        }
        for (Atom atom : atoms = openMMEnergy.getMolecularAssembly().getAtomArray()) {
            VDWType vdwType = atom.getVDWType();
            double sigma = 0.1 * vdwType.radius * radScale;
            double eps = 4.184 * vdwType.wellDepth;
            double charge = 0.0;
            MultipoleType multipoleType = atom.getMultipoleType();
            if (multipoleType != null && atom.getElectrostatics()) {
                charge = multipoleType.charge;
            }
            this.addParticle(charge, sigma, eps);
        }
        double lj14Scale = vdwForm.getScale14();
        double coulomb14Scale = 0.8333333333333334;
        ParticleMeshEwald pme = openMMEnergy.getPmeNode();
        if (pme != null) {
            coulomb14Scale = pme.getScale14();
        }
        if ((bondPotentialEnergy = openMMEnergy.getBondPotentialEnergy()) != null) {
            Bond[] bonds = bondPotentialEnergy.getBondArray();
            BondArray bondArray = new BondArray(0);
            for (Bond bond : bonds) {
                int i1 = bond.getAtom(0).getXyzIndex() - 1;
                int i2 = bond.getAtom(1).getXyzIndex() - 1;
                bondArray.append(i1, i2);
            }
            this.createExceptionsFromBonds(bondArray, coulomb14Scale, lj14Scale);
            bondArray.destroy();
            int num = this.getNumExceptions();
            this.chargeExclusion = new boolean[num];
            this.vdWExclusion = new boolean[num];
            this.exceptionChargeProd = new double[num];
            this.exceptionEps = new double[num];
            IntByReference particle1 = new IntByReference();
            IntByReference particle2 = new IntByReference();
            DoubleByReference chargeProd = new DoubleByReference();
            DoubleByReference sigma = new DoubleByReference();
            DoubleByReference eps = new DoubleByReference();
            for (int i = 0; i < num; ++i) {
                this.getExceptionParameters(i, particle1, particle2, chargeProd, sigma, eps);
                if (FastMath.abs((double)chargeProd.getValue()) > 0.0) {
                    this.chargeExclusion[i] = false;
                    this.exceptionChargeProd[i] = chargeProd.getValue();
                } else {
                    this.exceptionChargeProd[i] = 0.0;
                    this.chargeExclusion[i] = true;
                }
                if (FastMath.abs((double)eps.getValue()) > 0.0) {
                    this.vdWExclusion[i] = false;
                    this.exceptionEps[i] = eps.getValue();
                    continue;
                }
                this.vdWExclusion[i] = true;
                this.exceptionEps[i] = 0.0;
            }
        }
        if ((crystal = openMMEnergy.getCrystal()).aperiodic()) {
            this.setNonbondedMethod(0);
        } else {
            this.setNonbondedMethod(4);
            if (pme != null) {
                double aEwald = 10.0 * pme.getEwaldCoefficient();
                int nx = pme.getReciprocalSpace().getXDim();
                int ny = pme.getReciprocalSpace().getYDim();
                int nz = pme.getReciprocalSpace().getZDim();
                this.setPMEParameters(aEwald, nx, ny, nz);
            }
            NonbondedCutoff nonbondedCutoff = vdW.getNonbondedCutoff();
            double off = nonbondedCutoff.off;
            double cut = nonbondedCutoff.cut;
            this.setCutoffDistance(0.1 * off);
            this.setUseSwitchingFunction(1);
            if (cut == off) {
                logger.warning(" OpenMM does not properly handle cutoffs where cut == off!");
                if (cut == Double.MAX_VALUE || cut == Double.POSITIVE_INFINITY) {
                    logger.info(" Detected infinite or max-value cutoff; setting cut to 1E+40 for OpenMM.");
                    cut = 1.0E40;
                } else {
                    logger.info(String.format(" Detected cut %8.4g == off %8.4g; scaling cut to 0.99 of off for OpenMM.", cut, off));
                    cut *= 0.99;
                }
            }
            this.setSwitchingDistance(0.1 * cut);
        }
        this.setUseDispersionCorrection(0);
        ForceField forceField = openMMEnergy.getMolecularAssembly().getForceField();
        int forceGroup = forceField.getInteger("VDW_FORCE_GROUP", 1);
        int pmeGroup = forceField.getInteger("PME_FORCE_GROUP", 1);
        if (forceGroup != pmeGroup) {
            logger.severe(String.format(" ERROR: VDW-FORCE-GROUP is %d while PME-FORCE-GROUP is %d. This is invalid for fixed-charge force fields with combined non-bonded forces.", forceGroup, pmeGroup));
        }
        this.setForceGroup(forceGroup);
        logger.log(Level.INFO, String.format("  Fixed charge non-bonded force \t%1d", forceGroup));
    }

    public static Force constructForce(OpenMMEnergy openMMEnergy) {
        VanDerWaals vdW = openMMEnergy.getVdwNode();
        if (vdW == null) {
            return null;
        }
        VanDerWaalsForm vdwForm = vdW.getVDWForm();
        if (vdwForm.vdwType != VDWType.VDW_TYPE.LENNARD_JONES || vdwForm.radiusRule != VDWType.RADIUS_RULE.ARITHMETIC || vdwForm.epsilonRule != VDWType.EPSILON_RULE.GEOMETRIC) {
            logger.info(String.format(" VDW Type:         %s", new Object[]{vdwForm.vdwType}));
            logger.info(String.format(" VDW Radius Rule:  %s", new Object[]{vdwForm.radiusRule}));
            logger.info(String.format(" VDW Epsilon Rule: %s", new Object[]{vdwForm.epsilonRule}));
            logger.log(Level.SEVERE, " Unsupported van der Waals functional form.");
            return null;
        }
        return new FixedChargeNonbondedForce(openMMEnergy);
    }

    public void updateForce(Atom[] atoms, OpenMMEnergy openMMEnergy) {
        VanDerWaals vdW = openMMEnergy.getVdwNode();
        VanDerWaalsForm vdwForm = vdW.getVDWForm();
        if (vdwForm.vdwType != VDWType.VDW_TYPE.LENNARD_JONES || vdwForm.radiusRule != VDWType.RADIUS_RULE.ARITHMETIC || vdwForm.epsilonRule != VDWType.EPSILON_RULE.GEOMETRIC) {
            logger.log(Level.SEVERE, " Unsupported van der Waals functional form.");
            return;
        }
        double radScale = 1.0;
        if (vdwForm.radiusSize == VDWType.RADIUS_SIZE.RADIUS) {
            radScale = 2.0;
        }
        if (vdwForm.radiusType == VDWType.RADIUS_TYPE.R_MIN) {
            radScale /= 1.122462048309373;
        }
        for (Atom atom : atoms) {
            int index = atom.getXyzIndex() - 1;
            boolean applyLambda = atom.applyLambda();
            double charge = Double.MIN_VALUE;
            MultipoleType multipoleType = atom.getMultipoleType();
            if (multipoleType != null && atom.getElectrostatics()) {
                charge = multipoleType.charge;
            }
            VDWType vdwType = atom.getVDWType();
            double sigma = 0.1 * vdwType.radius * radScale;
            double eps = 4.184 * vdwType.wellDepth;
            if (applyLambda) {
                boolean vdwLambdaTerm = vdW.getLambdaTerm();
                if (vdwLambdaTerm) {
                    eps = 0.0;
                }
                double permLambda = openMMEnergy.getPmeNode().getAlchemicalParameters().permLambda;
                charge *= permLambda;
            }
            if (!atom.getUse()) {
                eps = 0.0;
                charge = 0.0;
            }
            this.setParticleParameters(index, charge, sigma, eps);
        }
        IntByReference particle1 = new IntByReference();
        IntByReference particle2 = new IntByReference();
        DoubleByReference chargeProd = new DoubleByReference();
        DoubleByReference sigma = new DoubleByReference();
        DoubleByReference eps = new DoubleByReference();
        int numExceptions = this.getNumExceptions();
        for (int i = 0; i < numExceptions; ++i) {
            if (this.chargeExclusion[i] && this.vdWExclusion[i]) continue;
            this.getExceptionParameters(i, particle1, particle2, chargeProd, sigma, eps);
            int i1 = particle1.getValue();
            int i2 = particle2.getValue();
            double qq = this.exceptionChargeProd[i];
            double epsilon = this.exceptionEps[i];
            Atom atom1 = atoms[i1];
            Atom atom2 = atoms[i2];
            double minEpsilon = 1.0E-12;
            double lambdaElec = 1.0;
            ParticleMeshEwald pme = openMMEnergy.getPmeNode();
            if (pme != null) {
                lambdaElec = pme.getAlchemicalParameters().permLambda;
            }
            boolean vdwLambdaTerm = vdW.getLambdaTerm();
            if (lambdaElec < minEpsilon) {
                lambdaElec = minEpsilon;
            }
            if (atom1.applyLambda()) {
                qq *= lambdaElec;
                if (vdwLambdaTerm) {
                    epsilon = minEpsilon;
                }
            }
            if (atom2.applyLambda()) {
                qq *= lambdaElec;
                if (vdwLambdaTerm) {
                    epsilon = minEpsilon;
                }
            }
            if (!atom1.getUse() || !atom2.getUse()) {
                qq = minEpsilon;
                epsilon = minEpsilon;
            }
            this.setExceptionParameters(i, i1, i2, qq, sigma.getValue(), epsilon);
        }
        this.updateParametersInContext(openMMEnergy.getContext());
    }
}

