/*
 * Decompiled with CFR 0.152.
 */
package ffx.potential.openmm;

import ffx.openmm.CustomIntegrator;
import java.util.Arrays;
import java.util.logging.Logger;

public class CustomMTSIntegrator
extends CustomIntegrator {
    private static final Logger logger = Logger.getLogger(CustomMTSIntegrator.class.getName());

    public CustomMTSIntegrator(double dt, double constraintTolerance, boolean hasAmoebaCavitationForce) {
        super(dt);
        this.setConstraintTolerance(constraintTolerance);
        int n = 4;
        int[] forceGroups = new int[]{1, 0};
        int[] subSteps = new int[]{1, 4};
        if (hasAmoebaCavitationForce) {
            n = 8;
            forceGroups = new int[]{2, 1, 0};
            subSteps = new int[]{1, 2, 8};
        }
        this.addPerDofVariable("x1", 0.0);
        this.addUpdateContextState();
        this.createMTSSubStep(1, forceGroups, subSteps);
        this.addConstrainVelocities();
        logger.info("  Custom MTS Integrator");
        logger.info(String.format("  Time step:            %6.2f (fsec)", dt * 1000.0));
        logger.info(String.format("  Inner Time step:      %6.2f (fsec)", dt / (double)n * 1000.0));
    }

    public void createMTSSubStep(int parentSubsteps, int[] forceGroups, int[] subSteps) {
        int forceGroup = forceGroups[0];
        int steps = subSteps[0];
        int stepsPerParentStep = steps / parentSubsteps;
        if (stepsPerParentStep < 1 || steps % parentSubsteps != 0) {
            throw new IllegalArgumentException("The number for substeps for each group must be a multiple of the number for the previous group");
        }
        if (forceGroup < 0 || forceGroup > 31) {
            throw new IllegalArgumentException("Force group must be between 0 and 31");
        }
        for (int i = 0; i < stepsPerParentStep; ++i) {
            this.addComputePerDof("v", "v+0.5*(dt/" + steps + ")*f" + forceGroup + "/m");
            if (forceGroups.length == 1) {
                this.addComputePerDof("x", "x+(dt/" + steps + ")*v");
                this.addComputePerDof("x1", "x");
                this.addConstrainPositions();
                this.addComputePerDof("v", "v+(x-x1)/(dt/" + steps + ")");
                this.addConstrainVelocities();
            } else {
                this.createMTSSubStep(steps, Arrays.copyOfRange(forceGroups, 1, forceGroups.length), Arrays.copyOfRange(subSteps, 1, subSteps.length));
            }
            this.addComputePerDof("v", "v+0.5*(dt/" + steps + ")*f" + forceGroup + "/m");
        }
    }
}

