/*
 * Decompiled with CFR 0.152.
 */
package ffx.potential.openmm;

import ffx.openmm.Force;
import ffx.openmm.amoeba.WcaDispersionForce;
import ffx.potential.bonded.Atom;
import ffx.potential.nonbonded.GeneralizedKirkwood;
import ffx.potential.nonbonded.VanDerWaals;
import ffx.potential.nonbonded.VanDerWaalsForm;
import ffx.potential.nonbonded.implicit.DispersionRegion;
import ffx.potential.openmm.AmoebaGeneralizedKirkwoodForce;
import ffx.potential.openmm.OpenMMEnergy;
import ffx.potential.parameters.VDWType;
import java.util.logging.Level;
import java.util.logging.Logger;

public class AmoebaWcaDispersionForce
extends WcaDispersionForce {
    private static final Logger logger = Logger.getLogger(AmoebaGeneralizedKirkwoodForce.class.getName());

    public AmoebaWcaDispersionForce(OpenMMEnergy openMMEnergy) {
        Atom[] atoms;
        GeneralizedKirkwood gk = openMMEnergy.getGK();
        if (gk == null) {
            this.destroy();
            return;
        }
        DispersionRegion dispersionRegion = gk.getDispersionRegion();
        if (dispersionRegion == null) {
            return;
        }
        double epso = 0.11;
        double epsh = 0.0135;
        double rmino = 1.7025;
        double rminh = 1.3275;
        double awater = 0.033428;
        double slevy = 1.0;
        double dispoff = dispersionRegion.getDispersionOffset();
        double shctd = dispersionRegion.getDispersionOverlapFactor();
        VanDerWaals vdW = openMMEnergy.getVdwNode();
        VanDerWaalsForm vdwForm = vdW.getVDWForm();
        double radScale = 1.0;
        if (vdwForm.radiusSize == VDWType.RADIUS_SIZE.DIAMETER) {
            radScale = 0.5;
        }
        for (Atom atom : atoms = openMMEnergy.getMolecularAssembly().getAtomArray()) {
            VDWType vdwType = atom.getVDWType();
            double radius = vdwType.radius;
            double eps = vdwType.wellDepth;
            this.addParticle(0.1 * radius * radScale, 4.184 * eps);
        }
        this.setEpso(epso * 4.184);
        this.setEpsh(epsh * 4.184);
        this.setRmino(rmino * 0.1);
        this.setRminh(rminh * 0.1);
        this.setDispoff(dispoff * 0.1);
        this.setAwater(awater / 0.0010000000000000002);
        this.setSlevy(slevy);
        this.setShctd(shctd);
        int forceGroup = openMMEnergy.getMolecularAssembly().getForceField().getInteger("GK_FORCE_GROUP", 1);
        this.setForceGroup(forceGroup);
        logger.log(Level.INFO, String.format("  WCA dispersion force \t\t\t%d", forceGroup));
    }

    public static Force constructForce(OpenMMEnergy openMMEnergy) {
        GeneralizedKirkwood gk = openMMEnergy.getGK();
        if (gk == null) {
            return null;
        }
        DispersionRegion dispersionRegion = gk.getDispersionRegion();
        if (dispersionRegion == null) {
            return null;
        }
        return new AmoebaWcaDispersionForce(openMMEnergy);
    }

    public void updateForce(Atom[] atoms, OpenMMEnergy openMMEnergy) {
        VanDerWaals vdW = openMMEnergy.getVdwNode();
        VanDerWaalsForm vdwForm = vdW.getVDWForm();
        double radScale = 1.0;
        if (vdwForm.radiusSize == VDWType.RADIUS_SIZE.DIAMETER) {
            radScale = 0.5;
        }
        double lambdaElec = openMMEnergy.getPmeNode().getAlchemicalParameters().permLambda;
        for (Atom atom : atoms) {
            int index = atom.getXyzIndex() - 1;
            double useFactor = 1.0;
            if (!atom.getUse()) {
                useFactor = 0.0;
            }
            double lambdaScale = lambdaElec * lambdaElec;
            if (!atom.applyLambda()) {
                lambdaScale = 1.0;
            }
            VDWType vdwType = atom.getVDWType();
            double radius = vdwType.radius;
            double eps = vdwType.wellDepth;
            this.setParticleParameters(index, 0.1 * radius * radScale, 4.184 * eps * (useFactor *= lambdaScale));
        }
        this.updateParametersInContext(openMMEnergy.getContext());
    }
}

