/*
 * Decompiled with CFR 0.152.
 */
package ffx.potential.openmm;

import ffx.crystal.Crystal;
import ffx.openmm.Force;
import ffx.openmm.IntArray;
import ffx.openmm.amoeba.VdwForce;
import ffx.potential.ForceFieldEnergy;
import ffx.potential.bonded.Atom;
import ffx.potential.extended.ExtendedSystem;
import ffx.potential.nonbonded.NonbondedCutoff;
import ffx.potential.nonbonded.VanDerWaals;
import ffx.potential.nonbonded.VanDerWaalsForm;
import ffx.potential.openmm.OpenMMDualTopologyEnergy;
import ffx.potential.openmm.OpenMMEnergy;
import ffx.potential.parameters.ForceField;
import ffx.potential.parameters.VDWPairType;
import ffx.potential.parameters.VDWType;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class AmoebaVdwForce
extends VdwForce {
    private static final Logger logger = Logger.getLogger(AmoebaVdwForce.class.getName());
    private int vdWClassForNoInteraction = 0;
    private final Map<Integer, Integer> vdwClassToOpenMMType = new HashMap<Integer, Integer>();

    public AmoebaVdwForce(OpenMMEnergy openMMEnergy) {
        VanDerWaals vdW = openMMEnergy.getVdwNode();
        if (vdW == null) {
            this.destroy();
            return;
        }
        this.configureForce(openMMEnergy);
        ExtendedSystem extendedSystem = vdW.getExtendedSystem();
        double[] vdwPrefactorAndDerivs = new double[3];
        int[] ired = vdW.getReductionIndex();
        Atom[] atoms = openMMEnergy.getMolecularAssembly().getAtomArray();
        int nAtoms = atoms.length;
        for (int i = 0; i < nAtoms; ++i) {
            Atom atom = atoms[i];
            VDWType vdwType = atom.getVDWType();
            int atomClass = vdwType.atomClass;
            int type = this.vdwClassToOpenMMType.get(atomClass);
            int isAlchemical = atom.applyLambda() ? 1 : 0;
            double scaleFactor = 1.0;
            if (extendedSystem != null) {
                extendedSystem.getVdwPrefactor(i, vdwPrefactorAndDerivs);
                scaleFactor = vdwPrefactorAndDerivs[0];
            }
            this.addParticle(ired[i], type, vdwType.reductionFactor, isAlchemical, scaleFactor);
        }
        int[][] bondMask = vdW.getMask12();
        int[][] angleMask = vdW.getMask13();
        IntArray exclusions = new IntArray(0);
        for (int i = 0; i < nAtoms; ++i) {
            int[] angleMaski;
            int[] bondMaski;
            exclusions.append(i);
            for (int value : bondMaski = bondMask[i]) {
                exclusions.append(value);
            }
            for (int value : angleMaski = angleMask[i]) {
                exclusions.append(value);
            }
            this.setParticleExclusions(i, exclusions);
            exclusions.resize(0);
        }
        exclusions.destroy();
    }

    public AmoebaVdwForce(int topology, OpenMMDualTopologyEnergy openMMDualTopologyEnergy) {
        int index;
        ForceFieldEnergy forceFieldEnergy = openMMDualTopologyEnergy.getForceFieldEnergy(topology);
        VanDerWaals vdW = forceFieldEnergy.getVdwNode();
        if (vdW == null) {
            this.destroy();
            return;
        }
        double scale = Math.sqrt(openMMDualTopologyEnergy.getTopologyScale(topology));
        this.configureForce(forceFieldEnergy);
        ExtendedSystem extendedSystem = vdW.getExtendedSystem();
        if (extendedSystem != null) {
            logger.severe(" Extended system is not supported for dual-topology simulations.");
        }
        int nAtoms = openMMDualTopologyEnergy.getNumberOfAtoms();
        int[] ired = vdW.getReductionIndex();
        for (int i = 0; i < nAtoms; ++i) {
            Atom atom = openMMDualTopologyEnergy.getDualTopologyAtom(topology, i);
            int top = atom.getTopologyIndex();
            if (top == topology) {
                index = atom.getArrayIndex();
                int ir = openMMDualTopologyEnergy.mapToDualTopologyIndex(topology, ired[index]);
                VDWType vdwType = atom.getVDWType();
                int atomClass = vdwType.atomClass;
                int type = this.vdwClassToOpenMMType.get(atomClass);
                int isAlchemical = atom.applyLambda() ? 1 : 0;
                this.addParticle(ir, type, vdwType.reductionFactor, isAlchemical, scale);
                continue;
            }
            index = atom.getTopologyAtomIndex();
            int type = this.vdwClassToOpenMMType.get(this.vdWClassForNoInteraction);
            int isAlchemical = 1;
            double scaleFactor = 0.0;
            this.addParticle(index, type, 1.0, isAlchemical, scaleFactor);
        }
        int[][] bondMask = vdW.getMask12();
        int[][] angleMask = vdW.getMask13();
        IntArray exclusions = new IntArray(0);
        for (index = 0; index < nAtoms; ++index) {
            int[] angleMaski;
            int[] bondMaski;
            Atom atom = openMMDualTopologyEnergy.getDualTopologyAtom(topology, index);
            if (atom.getTopologyIndex() != topology) continue;
            exclusions.append(index);
            for (int value : bondMaski = bondMask[atom.getArrayIndex()]) {
                value = openMMDualTopologyEnergy.mapToDualTopologyIndex(topology, value);
                exclusions.append(value);
            }
            for (int value : angleMaski = angleMask[atom.getArrayIndex()]) {
                value = openMMDualTopologyEnergy.mapToDualTopologyIndex(topology, value);
                exclusions.append(value);
            }
            this.setParticleExclusions(index, exclusions);
            exclusions.resize(0);
        }
        exclusions.destroy();
    }

    private void configureForce(ForceFieldEnergy forceFieldEnergy) {
        VanDerWaals vdW = forceFieldEnergy.getVdwNode();
        VanDerWaalsForm vdwForm = vdW.getVDWForm();
        double radScale = 1.0;
        if (vdwForm.radiusSize == VDWType.RADIUS_SIZE.DIAMETER) {
            radScale = 0.5;
        }
        ForceField forceField = forceFieldEnergy.getMolecularAssembly().getForceField();
        Map<String, VDWType> vdwTypes = forceField.getVDWTypes();
        for (VDWType vdwType : vdwTypes.values()) {
            int atomClass = vdwType.atomClass;
            if (this.vdwClassToOpenMMType.containsKey(atomClass)) continue;
            double eps = 4.184 * vdwType.wellDepth;
            double rad = 0.1 * vdwType.radius * radScale;
            if (rad == 0.0) {
                rad = 0.1 * radScale;
            }
            int type = this.addParticleType(rad, eps);
            this.vdwClassToOpenMMType.put(atomClass, type);
            if (atomClass > this.vdWClassForNoInteraction) continue;
            this.vdWClassForNoInteraction = atomClass - 1;
        }
        int type = this.addParticleType(0.1, 0.0);
        this.vdwClassToOpenMMType.put(this.vdWClassForNoInteraction, type);
        Map<String, VDWPairType> vdwPairTypeMap = forceField.getVDWPairTypes();
        for (VDWPairType vdwPairType : vdwPairTypeMap.values()) {
            int c1 = vdwPairType.atomClasses[0];
            int c2 = vdwPairType.atomClasses[1];
            int type1 = this.vdwClassToOpenMMType.get(c1);
            int type2 = this.vdwClassToOpenMMType.get(c2);
            double rMin = vdwPairType.radius * 0.1;
            double eps = vdwPairType.wellDepth * 4.184;
            this.addTypePair(type1, type2, rMin, eps);
            this.addTypePair(type2, type1, rMin, eps);
        }
        NonbondedCutoff nonbondedCutoff = vdW.getNonbondedCutoff();
        this.setCutoffDistance(nonbondedCutoff.off * 0.1);
        if (vdW.getDoLongRangeCorrection()) {
            this.setUseDispersionCorrection(true);
        } else {
            this.setUseDispersionCorrection(false);
        }
        Crystal crystal = forceFieldEnergy.getCrystal();
        if (crystal.aperiodic()) {
            this.setNonbondedMethod(0);
        } else {
            this.setNonbondedMethod(1);
        }
        if (vdW.getLambdaTerm()) {
            boolean annihilate = vdW.getIntramolecularSoftcore();
            if (annihilate) {
                this.setAlchemicalMethod(2);
            } else {
                this.setAlchemicalMethod(1);
            }
            this.setSoftcoreAlpha(vdW.getAlpha());
            this.setSoftcorePower((int)vdW.getBeta());
        }
        int forceGroup = forceField.getInteger("VDW_FORCE_GROUP", 1);
        this.setForceGroup(forceGroup);
        logger.log(Level.INFO, vdW.toString());
        logger.log(Level.FINE, String.format("   Force group:\t\t%d\n", forceGroup));
    }

    public static Force constructForce(OpenMMEnergy openMMEnergy) {
        VanDerWaals vdW = openMMEnergy.getVdwNode();
        if (vdW == null) {
            return null;
        }
        return new AmoebaVdwForce(openMMEnergy);
    }

    public static Force constructForce(int topology, OpenMMDualTopologyEnergy openMMDualTopologyEnergy) {
        ForceFieldEnergy forceFieldEnergy = openMMDualTopologyEnergy.getForceFieldEnergy(topology);
        VanDerWaals vdW = forceFieldEnergy.getVdwNode();
        if (vdW == null) {
            return null;
        }
        return new AmoebaVdwForce(topology, openMMDualTopologyEnergy);
    }

    public void updateForce(Atom[] atoms, OpenMMEnergy openMMEnergy) {
        VanDerWaals vdW = openMMEnergy.getVdwNode();
        VanDerWaalsForm vdwForm = vdW.getVDWForm();
        double radScale = 1.0;
        if (vdwForm.radiusSize == VDWType.RADIUS_SIZE.DIAMETER) {
            radScale = 0.5;
        }
        ExtendedSystem extendedSystem = vdW.getExtendedSystem();
        double[] vdwPrefactorAndDerivs = new double[3];
        int[] ired = vdW.getReductionIndex();
        for (Atom atom : atoms) {
            int index = atom.getArrayIndex();
            VDWType vdwType = atom.getVDWType();
            int type = this.vdwClassToOpenMMType.get(vdwType.atomClass);
            if (!atom.getUse()) {
                type = this.vdwClassToOpenMMType.get(this.vdWClassForNoInteraction);
            }
            int isAlchemical = atom.applyLambda() ? 1 : 0;
            double eps = 4.184 * vdwType.wellDepth;
            double rad = 0.1 * vdwType.radius * radScale;
            double scaleFactor = 1.0;
            if (extendedSystem != null) {
                extendedSystem.getVdwPrefactor(index, vdwPrefactorAndDerivs);
                scaleFactor = vdwPrefactorAndDerivs[0];
            }
            this.setParticleParameters(index, ired[index], rad, eps, vdwType.reductionFactor, isAlchemical, type, scaleFactor);
        }
        this.updateParametersInContext(openMMEnergy.getContext());
    }

    public void updateForce(Atom[] atoms, int topology, OpenMMDualTopologyEnergy openMMDualTopologyEnergy) {
        ForceFieldEnergy forceFieldEnergy = openMMDualTopologyEnergy.getForceFieldEnergy(topology);
        double scale = Math.sqrt(openMMDualTopologyEnergy.getTopologyScale(topology));
        VanDerWaals vdW = forceFieldEnergy.getVdwNode();
        VanDerWaalsForm vdwForm = vdW.getVDWForm();
        double radScale = 1.0;
        if (vdwForm.radiusSize == VDWType.RADIUS_SIZE.DIAMETER) {
            radScale = 0.5;
        }
        int[] ired = vdW.getReductionIndex();
        for (Atom atom : atoms) {
            if (atom.getTopologyIndex() != topology) continue;
            int indexDT = atom.getTopologyAtomIndex();
            int ir = ired[atom.getArrayIndex()];
            ir = openMMDualTopologyEnergy.mapToDualTopologyIndex(topology, ir);
            VDWType vdwType = atom.getVDWType();
            int type = this.vdwClassToOpenMMType.get(vdwType.atomClass);
            if (!atom.getUse()) {
                type = this.vdwClassToOpenMMType.get(this.vdWClassForNoInteraction);
            }
            int isAlchemical = atom.applyLambda() ? 1 : 0;
            double eps = 4.184 * vdwType.wellDepth;
            double rad = 0.1 * vdwType.radius * radScale;
            this.setParticleParameters(indexDT, ir, rad, eps, vdwType.reductionFactor, isAlchemical, type, scale);
        }
        this.updateParametersInContext(openMMDualTopologyEnergy.getContext());
    }
}

