/*
 * Decompiled with CFR 0.152.
 */
package ffx.potential.openmm;

import ffx.openmm.Force;
import ffx.openmm.amoeba.GeneralizedKirkwoodForce;
import ffx.potential.bonded.Atom;
import ffx.potential.nonbonded.GeneralizedKirkwood;
import ffx.potential.openmm.OpenMMEnergy;
import ffx.potential.parameters.ForceField;
import ffx.potential.parameters.MultipoleType;
import java.util.logging.Level;
import java.util.logging.Logger;

public class AmoebaGeneralizedKirkwoodForce
extends GeneralizedKirkwoodForce {
    private static final Logger logger = Logger.getLogger(AmoebaGeneralizedKirkwoodForce.class.getName());

    public AmoebaGeneralizedKirkwoodForce(OpenMMEnergy openMMEnergy) {
        GeneralizedKirkwood gk = openMMEnergy.getGK();
        if (gk == null) {
            this.destroy();
            return;
        }
        this.setSolventDielectric(gk.getSolventPermittivity());
        double soluteDielectric = gk.getSolutePermittivity();
        if (soluteDielectric != 1.0) {
            logger.severe(" Solute dielectric is not 1.0, which is not supported by OpenMM.");
        }
        this.setSoluteDielectric(1.0);
        this.setDielectricOffset(gk.getDescreenOffset() * 0.1);
        boolean usePerfectRadii = gk.getUsePerfectRadii();
        double perfectRadiiScale = 1.0;
        if (usePerfectRadii) {
            perfectRadiiScale = 0.0;
        }
        int tanhRescale = 0;
        if (gk.getTanhCorrection() && !usePerfectRadii) {
            tanhRescale = 1;
        }
        double[] betas = gk.getTanhBetas();
        this.setTanhRescaling(tanhRescale);
        this.setTanhParameters(betas[0], betas[1], betas[2]);
        double[] baseRadius = gk.getBaseRadii();
        if (usePerfectRadii) {
            baseRadius = gk.getPerfectRadii();
        }
        double[] overlapScale = gk.getOverlapScale();
        double[] descreenRadius = gk.getDescreenRadii();
        double[] neckFactor = gk.getNeckScale();
        if (!usePerfectRadii && logger.isLoggable(Level.FINE)) {
            logger.fine("   GK Base Radii  Descreen Radius  Overlap Scale  Overlap");
        }
        Atom[] atoms = openMMEnergy.getMolecularAssembly().getAtomArray();
        int nAtoms = atoms.length;
        for (int i = 0; i < nAtoms; ++i) {
            MultipoleType multipoleType = atoms[i].getMultipoleType();
            double base = baseRadius[i] * 0.1;
            double descreen = descreenRadius[i] * 0.1 * perfectRadiiScale;
            double overlap = overlapScale[i] * perfectRadiiScale;
            double neck = neckFactor[i] * perfectRadiiScale;
            this.addParticle(multipoleType.charge, base, overlap, descreen, neck);
            if (usePerfectRadii || !logger.isLoggable(Level.FINE)) continue;
            logger.fine(String.format("   %s %8.6f %8.6f %5.3f", atoms[i].toString(), baseRadius[i], descreenRadius[i], overlapScale[i]));
        }
        this.setProbeRadius(gk.getProbeRadius() * 0.1);
        GeneralizedKirkwood.NonPolarModel nonpolar = gk.getNonPolarModel();
        switch (nonpolar) {
            case BORN_CAV_DISP: 
            case BORN_SOLV: {
                double surfaceTension = gk.getSurfaceTension() * 4.184 * 10.0 * 10.0;
                this.setIncludeCavityTerm(1);
                this.setSurfaceAreaFactor(-surfaceTension);
                break;
            }
            default: {
                this.setIncludeCavityTerm(0);
            }
        }
        ForceField forceField = openMMEnergy.getMolecularAssembly().getForceField();
        int forceGroup = forceField.getInteger("GK_FORCE_GROUP", 1);
        this.setForceGroup(forceGroup);
        logger.log(Level.INFO, String.format("  Generalized Kirkwood force \t\t%d", forceGroup));
    }

    public static Force constructForce(OpenMMEnergy openMMEnergy) {
        GeneralizedKirkwood gk = openMMEnergy.getGK();
        if (gk == null) {
            return null;
        }
        return new AmoebaGeneralizedKirkwoodForce(openMMEnergy);
    }

    public void updateForce(Atom[] atoms, OpenMMEnergy openMMEnergy) {
        GeneralizedKirkwood gk = openMMEnergy.getGK();
        if (gk == null || this.pointer == null) {
            return;
        }
        int nAtoms = openMMEnergy.getMolecularAssembly().getAtomArray().length;
        for (int i = 0; i < nAtoms; ++i) {
            gk.udpateSoluteParameters(i);
        }
        boolean usePerfectRadii = gk.getUsePerfectRadii();
        double perfectRadiiScale = 1.0;
        if (usePerfectRadii) {
            perfectRadiiScale = 0.0;
        }
        double[] baseRadii = gk.getBaseRadii();
        if (usePerfectRadii) {
            baseRadii = gk.getPerfectRadii();
        }
        double[] overlapScale = gk.getOverlapScale();
        double[] descreenRadius = gk.getDescreenRadii();
        double[] neckFactors = gk.getNeckScale();
        boolean nea = gk.getNativeEnvironmentApproximation();
        double lambdaElec = openMMEnergy.getPmeNode().getAlchemicalParameters().permLambda;
        for (Atom atom : atoms) {
            int index = atom.getXyzIndex() - 1;
            double chargeUseFactor = 1.0;
            if (!atom.getUse() || !atom.getElectrostatics()) {
                chargeUseFactor = 0.0;
            }
            double lambdaScale = lambdaElec;
            if (!atom.applyLambda()) {
                lambdaScale = 1.0;
            }
            double baseSize = baseRadii[index] * 0.1;
            double descreenSize = descreenRadius[index] * 0.1 * perfectRadiiScale;
            double overlapScaleUseFactor = nea ? 1.0 : (chargeUseFactor *= lambdaScale);
            double overlap = overlapScale[index] * (overlapScaleUseFactor *= perfectRadiiScale);
            double neckFactor = neckFactors[index] * overlapScaleUseFactor;
            MultipoleType multipoleType = atom.getMultipoleType();
            this.setParticleParameters(index, multipoleType.charge * chargeUseFactor, baseSize, overlap, descreenSize, neckFactor);
        }
        GeneralizedKirkwood.NonPolarModel nonpolar = gk.getNonPolarModel();
        switch (nonpolar) {
            case BORN_CAV_DISP: 
            case BORN_SOLV: {
                double surfaceTension = gk.getSurfaceTension() * 4.184 * 10.0 * 10.0;
                this.setSurfaceAreaFactor(-surfaceTension);
            }
        }
        this.updateParametersInContext(openMMEnergy.getContext());
    }
}

