/*
 * Decompiled with CFR 0.152.
 */
package ffx.potential.nonbonded.pme;

import ffx.numerics.math.ScalarMath;
import ffx.potential.nonbonded.pme.LambdaMode;
import ffx.potential.nonbonded.pme.SCFPredictor;
import ffx.potential.parameters.ForceField;
import java.util.Arrays;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.math3.analysis.DifferentiableMultivariateVectorFunction;
import org.apache.commons.math3.analysis.MultivariateMatrixFunction;
import org.apache.commons.math3.optimization.ConvergenceChecker;
import org.apache.commons.math3.optimization.PointVectorValuePair;
import org.apache.commons.math3.optimization.SimpleVectorValueChecker;
import org.apache.commons.math3.optimization.general.LevenbergMarquardtOptimizer;

public class SCFPredictorParameters {
    private static final Logger logger = Logger.getLogger(SCFPredictorParameters.class.getName());
    public int predictorOrder;
    public int predictorStartIndex;
    public int predictorCount;
    public double[][][][] predictorInducedDipole;
    public double[][][][] predictorInducedDipoleCR;
    private LeastSquaresPredictor leastSquaresPredictor;
    public LevenbergMarquardtOptimizer leastSquaresOptimizer;
    public final SCFPredictor scfPredictor;
    private final int nAtoms;

    public SCFPredictorParameters(SCFPredictor scfPredictor, int nAtoms) {
        this.nAtoms = nAtoms;
        this.scfPredictor = scfPredictor;
    }

    public void aspcPredictor(LambdaMode lambdaMode, double[][][] inducedDipole, double[][][] inducedDipoleCR) {
        if (this.predictorCount < 6) {
            return;
        }
        int mode = switch (lambdaMode) {
            case LambdaMode.CONDENSED_NO_LIGAND -> 1;
            case LambdaMode.VAPOR -> 2;
            default -> 0;
        };
        double[] aspc = new double[]{3.142857142857143, -3.9285714285714284, 2.619047619047619, -1.0476190476190477, 0.23809523809523808, -0.023809523809523808};
        int index = this.predictorStartIndex;
        for (int k = 0; k < 6; ++k) {
            double c = aspc[k];
            for (int i = 0; i < this.nAtoms; ++i) {
                for (int j = 0; j < 3; ++j) {
                    double[] dArray = inducedDipole[0][i];
                    int n = j;
                    dArray[n] = dArray[n] + c * this.predictorInducedDipole[mode][index][i][j];
                    double[] dArray2 = inducedDipoleCR[0][i];
                    int n2 = j;
                    dArray2[n2] = dArray2[n2] + c * this.predictorInducedDipoleCR[mode][index][i][j];
                }
            }
            if (++index < this.predictorOrder) continue;
            index = 0;
        }
    }

    public void init(ForceField forceField) {
        this.predictorCount = 0;
        int defaultOrder = 6;
        this.predictorOrder = forceField.getInteger("SCF_PREDICTOR_ORDER", defaultOrder);
        if (this.scfPredictor == SCFPredictor.LS) {
            this.leastSquaresPredictor = new LeastSquaresPredictor(this);
            double eps = 1.0E-4;
            this.leastSquaresOptimizer = new LevenbergMarquardtOptimizer((ConvergenceChecker)new SimpleVectorValueChecker(eps, eps));
        } else if (this.scfPredictor == SCFPredictor.ASPC) {
            this.predictorOrder = 6;
        }
        this.predictorStartIndex = 0;
    }

    public void leastSquaresPredictor(LambdaMode lambdaMode, double[][][] inducedDipole, double[][][] inducedDipoleCR) {
        if (this.predictorCount < 2) {
            return;
        }
        try {
            this.leastSquaresPredictor.lambdaMode = lambdaMode;
            this.leastSquaresPredictor.updateJacobianAndTarget();
            int maxEvals = 100;
            Arrays.fill(this.leastSquaresPredictor.initialSolution, 0.0);
            this.leastSquaresPredictor.initialSolution[0] = 1.0;
            PointVectorValuePair optimum = this.leastSquaresOptimizer.optimize(maxEvals, (DifferentiableMultivariateVectorFunction)this.leastSquaresPredictor, this.leastSquaresPredictor.calculateTarget(), this.leastSquaresPredictor.weights, this.leastSquaresPredictor.initialSolution);
            double[] optimalValues = optimum.getPoint();
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest(String.format("\n LS RMS:            %10.6f", this.leastSquaresOptimizer.getRMS()));
                logger.finest(String.format(" LS Iterations:     %10d", this.leastSquaresOptimizer.getEvaluations()));
                logger.finest(String.format(" Jacobian Evals:    %10d", this.leastSquaresOptimizer.getJacobianEvaluations()));
                logger.finest(String.format(" Chi Square:        %10.6f", this.leastSquaresOptimizer.getChiSquare()));
                logger.finest(" LS Coefficients");
                for (int i = 0; i < this.predictorOrder - 1; ++i) {
                    logger.finest(String.format(" %2d  %10.6f", i + 1, optimalValues[i]));
                }
            }
            int mode = switch (lambdaMode) {
                case LambdaMode.CONDENSED_NO_LIGAND -> 1;
                case LambdaMode.VAPOR -> 2;
                default -> 0;
            };
            int index = this.predictorStartIndex;
            for (int k = 0; k < this.predictorOrder - 1; ++k) {
                double c = optimalValues[k];
                for (int i = 0; i < this.nAtoms; ++i) {
                    for (int j = 0; j < 3; ++j) {
                        double[] dArray = inducedDipole[0][i];
                        int n = j;
                        dArray[n] = dArray[n] + c * this.predictorInducedDipole[mode][index][i][j];
                        double[] dArray2 = inducedDipoleCR[0][i];
                        int n2 = j;
                        dArray2[n2] = dArray2[n2] + c * this.predictorInducedDipoleCR[mode][index][i][j];
                    }
                }
                if (++index < this.predictorOrder) continue;
                index = 0;
            }
        }
        catch (Exception e) {
            logger.log(Level.WARNING, " Exception computing predictor coefficients", e);
        }
    }

    public void polynomialPredictor(LambdaMode lambdaMode, double[][][] inducedDipole, double[][][] inducedDipoleCR) {
        if (this.predictorCount == 0) {
            return;
        }
        int mode = switch (lambdaMode) {
            case LambdaMode.CONDENSED_NO_LIGAND -> 1;
            case LambdaMode.VAPOR -> 2;
            default -> 0;
        };
        int n = this.predictorOrder;
        if (this.predictorCount < this.predictorOrder) {
            n = this.predictorCount;
        }
        int index = this.predictorStartIndex;
        double sign = -1.0;
        for (int k = 0; k < n; ++k) {
            double c = (sign *= -1.0) * (double)ScalarMath.binomial((long)n, (long)k);
            for (int i = 0; i < this.nAtoms; ++i) {
                for (int j = 0; j < 3; ++j) {
                    double[] dArray = inducedDipole[0][i];
                    int n2 = j;
                    dArray[n2] = dArray[n2] + c * this.predictorInducedDipole[mode][index][i][j];
                    double[] dArray2 = inducedDipoleCR[0][i];
                    int n3 = j;
                    dArray2[n3] = dArray2[n3] + c * this.predictorInducedDipoleCR[mode][index][i][j];
                }
            }
            if (++index < this.predictorOrder) continue;
            index = 0;
        }
    }

    public void saveMutualInducedDipoles(LambdaMode lambdaMode, double[][][] inducedDipole, double[][][] inducedDipoleCR, double[][] directDipole, double[][] directDipoleCR) {
        switch (lambdaMode) {
            case CONDENSED_NO_LIGAND: {
                int mode = 1;
                break;
            }
            case VAPOR: {
                int mode = 2;
                break;
            }
            default: {
                int mode = 0;
            }
        }
        --this.predictorStartIndex;
        if (this.predictorStartIndex < 0) {
            this.predictorStartIndex = this.predictorOrder - 1;
        }
        if (this.predictorCount < this.predictorOrder) {
            ++this.predictorCount;
        }
        for (int i = 0; i < this.nAtoms; ++i) {
            for (int j = 0; j < 3; ++j) {
                this.predictorInducedDipole[mode][this.predictorStartIndex][i][j] = inducedDipole[0][i][j] - directDipole[i][j];
                this.predictorInducedDipoleCR[mode][this.predictorStartIndex][i][j] = inducedDipoleCR[0][i][j] - directDipoleCR[i][j];
            }
        }
    }

    private class LeastSquaresPredictor
    implements DifferentiableMultivariateVectorFunction {
        double[] weights;
        double[] target;
        double[] values;
        double[][] jacobian;
        double[] initialSolution;
        private final MultivariateMatrixFunction multivariateMatrixFunction;
        public LambdaMode lambdaMode;
        final /* synthetic */ SCFPredictorParameters this$0;

        LeastSquaresPredictor(SCFPredictorParameters sCFPredictorParameters) {
            SCFPredictorParameters sCFPredictorParameters2 = sCFPredictorParameters;
            Objects.requireNonNull(sCFPredictorParameters2);
            this.this$0 = sCFPredictorParameters2;
            this.multivariateMatrixFunction = this::jacobian;
            this.lambdaMode = null;
            this.weights = new double[2 * sCFPredictorParameters.nAtoms * 3];
            this.target = new double[2 * sCFPredictorParameters.nAtoms * 3];
            this.values = new double[2 * sCFPredictorParameters.nAtoms * 3];
            this.jacobian = new double[2 * sCFPredictorParameters.nAtoms * 3][sCFPredictorParameters.predictorOrder - 1];
            this.initialSolution = new double[sCFPredictorParameters.predictorOrder - 1];
            Arrays.fill(this.weights, 1.0);
            this.initialSolution[0] = 1.0;
        }

        public MultivariateMatrixFunction jacobian() {
            return this.multivariateMatrixFunction;
        }

        public double[] value(double[] variables) {
            int mode = switch (this.lambdaMode) {
                case LambdaMode.CONDENSED_NO_LIGAND -> 1;
                case LambdaMode.VAPOR -> 2;
                default -> 0;
            };
            for (int i = 0; i < this.this$0.nAtoms; ++i) {
                int index = 6 * i;
                this.values[index] = 0.0;
                this.values[index + 1] = 0.0;
                this.values[index + 2] = 0.0;
                this.values[index + 3] = 0.0;
                this.values[index + 4] = 0.0;
                this.values[index + 5] = 0.0;
                int pi = this.this$0.predictorStartIndex + 1;
                if (pi >= this.this$0.predictorOrder) {
                    pi = 0;
                }
                for (int j = 0; j < this.this$0.predictorOrder - 1; ++j) {
                    int n = index;
                    this.values[n] = this.values[n] + variables[j] * this.this$0.predictorInducedDipole[mode][pi][i][0];
                    int n2 = index + 1;
                    this.values[n2] = this.values[n2] + variables[j] * this.this$0.predictorInducedDipole[mode][pi][i][1];
                    int n3 = index + 2;
                    this.values[n3] = this.values[n3] + variables[j] * this.this$0.predictorInducedDipole[mode][pi][i][2];
                    int n4 = index + 3;
                    this.values[n4] = this.values[n4] + variables[j] * this.this$0.predictorInducedDipoleCR[mode][pi][i][0];
                    int n5 = index + 4;
                    this.values[n5] = this.values[n5] + variables[j] * this.this$0.predictorInducedDipoleCR[mode][pi][i][1];
                    int n6 = index + 5;
                    this.values[n6] = this.values[n6] + variables[j] * this.this$0.predictorInducedDipoleCR[mode][pi][i][2];
                    if (++pi < this.this$0.predictorOrder) continue;
                    pi = 0;
                }
            }
            return this.values;
        }

        double[] calculateTarget() {
            return this.target;
        }

        void updateJacobianAndTarget() {
            int mode = switch (this.lambdaMode) {
                case LambdaMode.CONDENSED_NO_LIGAND -> 1;
                case LambdaMode.VAPOR -> 2;
                default -> 0;
            };
            int index = 0;
            for (int i = 0; i < this.this$0.nAtoms; ++i) {
                this.target[index++] = this.this$0.predictorInducedDipole[mode][this.this$0.predictorStartIndex][i][0];
                this.target[index++] = this.this$0.predictorInducedDipole[mode][this.this$0.predictorStartIndex][i][1];
                this.target[index++] = this.this$0.predictorInducedDipole[mode][this.this$0.predictorStartIndex][i][2];
                this.target[index++] = this.this$0.predictorInducedDipoleCR[mode][this.this$0.predictorStartIndex][i][0];
                this.target[index++] = this.this$0.predictorInducedDipoleCR[mode][this.this$0.predictorStartIndex][i][1];
                this.target[index++] = this.this$0.predictorInducedDipoleCR[mode][this.this$0.predictorStartIndex][i][2];
            }
            index = this.this$0.predictorStartIndex + 1;
            if (index >= this.this$0.predictorOrder) {
                index = 0;
            }
            for (int j = 0; j < this.this$0.predictorOrder - 1; ++j) {
                int ji = 0;
                for (int i = 0; i < this.this$0.nAtoms; ++i) {
                    this.jacobian[ji++][j] = this.this$0.predictorInducedDipole[mode][index][i][0];
                    this.jacobian[ji++][j] = this.this$0.predictorInducedDipole[mode][index][i][1];
                    this.jacobian[ji++][j] = this.this$0.predictorInducedDipole[mode][index][i][2];
                    this.jacobian[ji++][j] = this.this$0.predictorInducedDipoleCR[mode][index][i][0];
                    this.jacobian[ji++][j] = this.this$0.predictorInducedDipoleCR[mode][index][i][1];
                    this.jacobian[ji++][j] = this.this$0.predictorInducedDipoleCR[mode][index][i][2];
                }
                if (++index < this.this$0.predictorOrder) continue;
                index = 0;
            }
        }

        private double[][] jacobian(double[] variables) {
            return this.jacobian;
        }
    }
}

