/*
 * Decompiled with CFR 0.152.
 */
package ffx.potential.nonbonded.pme;

import edu.rit.pj.IntegerForLoop;
import edu.rit.pj.IntegerSchedule;
import edu.rit.pj.ParallelRegion;
import edu.rit.pj.ParallelTeam;
import ffx.numerics.atomic.AtomicDoubleArray3D;
import ffx.potential.bonded.Atom;
import ffx.potential.nonbonded.pme.Torque;
import ffx.potential.parameters.ForceField;
import ffx.potential.parameters.MultipoleType;
import ffx.potential.utils.EnergyException;
import java.util.Arrays;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ReduceRegion
extends ParallelRegion {
    private static final Logger logger = Logger.getLogger(ReduceRegion.class.getName());
    private final boolean rotateMultipoles;
    private final TorqueLoop[] torqueLoop;
    private final ReduceLoop[] reduceLoop;
    private boolean lambdaTerm;
    private boolean gradient;
    private Atom[] atoms;
    private double[][][] coordinates;
    private MultipoleType.MultipoleFrameDefinition[] frame;
    private int[][] axisAtom;
    private AtomicDoubleArray3D grad;
    private AtomicDoubleArray3D torque;
    private AtomicDoubleArray3D lambdaGrad;
    private AtomicDoubleArray3D lambdaTorque;

    public ReduceRegion(int threadCount, ForceField forceField) {
        this.torqueLoop = new TorqueLoop[threadCount];
        this.reduceLoop = new ReduceLoop[threadCount];
        this.rotateMultipoles = forceField.getBoolean("ROTATE_MULTIPOLES", true);
    }

    public void executeWith(ParallelTeam parallelTeam) {
        try {
            parallelTeam.execute((ParallelRegion)this);
        }
        catch (Exception e) {
            String message = "Exception calculating torques.";
            logger.log(Level.SEVERE, message, e);
        }
    }

    public void init(boolean lambdaTerm, boolean gradient, Atom[] atoms, double[][][] coordinates, MultipoleType.MultipoleFrameDefinition[] frame, int[][] axisAtom, AtomicDoubleArray3D grad, AtomicDoubleArray3D torque, AtomicDoubleArray3D lambdaGrad, AtomicDoubleArray3D lambdaTorque) {
        this.lambdaTerm = lambdaTerm;
        this.gradient = gradient;
        this.atoms = atoms;
        this.coordinates = coordinates;
        this.frame = frame;
        this.axisAtom = axisAtom;
        this.grad = grad;
        this.torque = torque;
        this.lambdaGrad = lambdaGrad;
        this.lambdaTorque = lambdaTorque;
    }

    public void run() throws EnergyException {
        int nAtoms = this.atoms.length;
        try {
            int threadIndex = this.getThreadIndex();
            if (this.torqueLoop[threadIndex] == null) {
                this.torqueLoop[threadIndex] = new TorqueLoop(this);
                this.reduceLoop[threadIndex] = new ReduceLoop(this);
            }
            if (this.rotateMultipoles) {
                this.execute(0, nAtoms - 1, this.torqueLoop[threadIndex]);
            }
            this.execute(0, nAtoms - 1, this.reduceLoop[threadIndex]);
        }
        catch (Exception e) {
            if (e instanceof EnergyException) {
                throw (EnergyException)e;
            }
            String message = "Fatal exception computing torque in thread " + this.getThreadIndex() + "\n";
            logger.log(Level.SEVERE, message, e);
        }
    }

    private class TorqueLoop
    extends IntegerForLoop {
        private Torque torques;
        private int threadID;
        double[] trq;
        double[][] g;
        int[] frameIndex;
        final /* synthetic */ ReduceRegion this$0;

        TorqueLoop(ReduceRegion reduceRegion) {
            ReduceRegion reduceRegion2 = reduceRegion;
            Objects.requireNonNull(reduceRegion2);
            this.this$0 = reduceRegion2;
            this.trq = new double[3];
            this.g = new double[4][3];
            this.frameIndex = new int[4];
            this.torques = new Torque();
        }

        public void run(int lb, int ub) throws EnergyException {
            double[] gj;
            int index;
            int j;
            int i;
            if (this.this$0.gradient) {
                this.this$0.torque.reduce(lb, ub);
                for (i = lb; i <= ub; ++i) {
                    Arrays.fill(this.frameIndex, -1);
                    this.trq[0] = this.this$0.torque.getX(i);
                    this.trq[1] = this.this$0.torque.getY(i);
                    this.trq[2] = this.this$0.torque.getZ(i);
                    if (Double.isNaN(this.trq[0]) || Double.isInfinite(this.trq[0]) || Double.isNaN(this.trq[1]) || Double.isInfinite(this.trq[1]) || Double.isNaN(this.trq[2]) || Double.isInfinite(this.trq[2])) {
                        Atom a = this.this$0.atoms[i];
                        throw new EnergyException(String.format(" Undefined torque (%8.3f,%8.3f,%8.3f) for atom %s.", this.trq[0], this.trq[1], this.trq[2], a));
                    }
                    this.torques.torque(i, 0, this.trq, this.frameIndex, this.g);
                    for (j = 0; j < 4; ++j) {
                        index = this.frameIndex[j];
                        if (index < 0) continue;
                        gj = this.g[j];
                        if (Double.isNaN(gj[0]) || Double.isInfinite(gj[0]) || Double.isNaN(gj[1]) || Double.isInfinite(gj[1]) || Double.isNaN(gj[2]) || Double.isInfinite(gj[2])) {
                            Atom ai = this.this$0.atoms[i];
                            Atom aj = this.this$0.atoms[index];
                            throw new EnergyException(String.format(" Undefined gradient (%8.3f,%8.3f,%8.3f)\n For atom: %s\n From torque of atom %s", gj[0], gj[1], gj[2], aj, ai));
                        }
                        this.this$0.grad.add(this.threadID, index, gj[0], gj[1], gj[2]);
                    }
                }
            }
            if (this.this$0.lambdaTerm) {
                this.this$0.lambdaTorque.reduce(lb, ub);
                for (i = lb; i <= ub; ++i) {
                    Arrays.fill(this.frameIndex, -1);
                    this.trq[0] = this.this$0.lambdaTorque.getX(i);
                    this.trq[1] = this.this$0.lambdaTorque.getY(i);
                    this.trq[2] = this.this$0.lambdaTorque.getZ(i);
                    this.torques.torque(i, 0, this.trq, this.frameIndex, this.g);
                    for (j = 0; j < 4; ++j) {
                        index = this.frameIndex[j];
                        if (index < 0) continue;
                        gj = this.g[j];
                        this.this$0.lambdaGrad.add(this.threadID, index, gj[0], gj[1], gj[2]);
                    }
                }
            }
        }

        public IntegerSchedule schedule() {
            return IntegerSchedule.fixed();
        }

        public void start() {
            this.threadID = this.getThreadIndex();
            this.torques.init(this.this$0.axisAtom, this.this$0.frame, this.this$0.coordinates);
        }
    }

    private class ReduceLoop
    extends IntegerForLoop {
        final /* synthetic */ ReduceRegion this$0;

        private ReduceLoop(ReduceRegion reduceRegion) {
            ReduceRegion reduceRegion2 = reduceRegion;
            Objects.requireNonNull(reduceRegion2);
            this.this$0 = reduceRegion2;
        }

        public void run(int lb, int ub) throws EnergyException {
            if (this.this$0.gradient) {
                this.this$0.grad.reduce(lb, ub);
                for (int i = lb; i <= ub; ++i) {
                    Atom ai = this.this$0.atoms[i];
                    ai.addToXYZGradient(this.this$0.grad.getX(i), this.this$0.grad.getY(i), this.this$0.grad.getZ(i));
                }
            }
            if (this.this$0.lambdaTerm) {
                this.this$0.lambdaGrad.reduce(lb, ub);
            }
        }

        public IntegerSchedule schedule() {
            return IntegerSchedule.fixed();
        }
    }
}

