/*
 * Decompiled with CFR 0.152.
 */
package ffx.potential.nonbonded.pme;

import edu.rit.pj.IntegerForLoop;
import edu.rit.pj.IntegerSchedule;
import edu.rit.pj.ParallelRegion;
import edu.rit.pj.ParallelTeam;
import edu.rit.pj.reduction.SharedDouble;
import ffx.crystal.Crystal;
import ffx.numerics.atomic.AtomicDoubleArray3D;
import ffx.numerics.multipole.MultipoleUtilities;
import ffx.potential.bonded.Atom;
import ffx.potential.extended.ExtendedSystem;
import ffx.potential.nonbonded.ReciprocalSpace;
import ffx.potential.nonbonded.pme.AlchemicalParameters;
import ffx.potential.nonbonded.pme.Polarization;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.math3.util.FastMath;

public class ReciprocalEnergyRegion
extends ParallelRegion {
    private static final Logger logger = Logger.getLogger(ReciprocalEnergyRegion.class.getName());
    private static final double SQRT_PI = FastMath.sqrt((double)Math.PI);
    private static final int tensorCount = MultipoleUtilities.tensorCount((int)3);
    private final double electric;
    private final double aewald;
    private final double aewald1;
    private final double aewald2;
    private final double aewald3;
    private final double aewald4;
    private final double oneThird;
    private final double twoThirds;
    private final int maxThreads;
    private final SharedDouble inducedDipoleSelfEnergy;
    private final SharedDouble inducedDipoleRecipEnergy;
    private final PermanentReciprocalEnergyLoop[] permanentReciprocalEnergyLoop;
    private final InducedDipoleReciprocalEnergyLoop[] inducedDipoleReciprocalEnergyLoop;
    public double[][][] inducedDipole;
    public double[][][] inducedDipoleCR;
    private double[][] ind;
    private double[][] indCR;
    private double nfftX;
    private double nfftY;
    private double nfftZ;
    private double[][] multipole;
    private double[][] fracMultipole;
    private double[][] fracMultipolePhi;
    private double[][] fracInducedDipolePhi;
    private double[][] fracInducedDipolePhiCR;
    private double chargeCorrectionEnergy;
    private double permanentSelfEnergy;
    private double permanentReciprocalEnergy;
    private Atom[] atoms;
    private Crystal crystal;
    private boolean[] use;
    private double[][][] globalMultipole;
    private double[][][] globalFracMultipole;
    private double[][][] titrationMultipole;
    private double[][][] tautomerMultipole;
    private ExtendedSystem extendedSystem = null;
    private boolean esvTerm = false;
    private double[][] cartMultipolePhi;
    private double[][] cartesianDipolePhi;
    private double[][] cartesianDipolePhiCR;
    private ReciprocalSpace reciprocalSpace;
    private Polarization polarization;
    private AtomicDoubleArray3D grad;
    private AtomicDoubleArray3D torque;
    private AtomicDoubleArray3D lambdaGrad;
    private AtomicDoubleArray3D lambdaTorque;
    private boolean gradient;
    private boolean lambdaTerm;
    private SharedDouble shareddEdLambda;
    private SharedDouble sharedd2EdLambda2;
    private double permanentScale;
    private double dlPowPerm;
    private double d2lPowPerm;
    private double polarizationScale;
    private double dlPowPol;
    private double d2lPowPol;
    private double dEdLSign;

    public ReciprocalEnergyRegion(int nt, double aewald, double electric) {
        this.permanentReciprocalEnergyLoop = new PermanentReciprocalEnergyLoop[nt];
        this.inducedDipoleReciprocalEnergyLoop = new InducedDipoleReciprocalEnergyLoop[nt];
        this.inducedDipoleSelfEnergy = new SharedDouble();
        this.inducedDipoleRecipEnergy = new SharedDouble();
        this.maxThreads = nt;
        this.electric = electric;
        this.aewald = aewald;
        this.aewald1 = -electric * aewald / SQRT_PI;
        this.aewald2 = 2.0 * aewald * aewald;
        this.aewald3 = -0.6666666666666666 * electric * aewald * aewald * aewald / SQRT_PI;
        this.aewald4 = -2.0 * this.aewald3;
        this.oneThird = 0.3333333333333333;
        this.twoThirds = 0.6666666666666666;
    }

    public void executeWith(ParallelTeam parallelTeam) {
        try {
            parallelTeam.execute((ParallelRegion)this);
        }
        catch (Exception e) {
            String message = " Exception computing the electrostatic energy.\n";
            logger.log(Level.SEVERE, message, e);
        }
    }

    public void finish() {
        this.permanentSelfEnergy = 0.0;
        this.permanentReciprocalEnergy = 0.0;
        double totalCharge = 0.0;
        for (int i = 0; i < this.maxThreads; ++i) {
            totalCharge += this.permanentReciprocalEnergyLoop[i].totalCharge;
            this.permanentSelfEnergy += this.permanentReciprocalEnergyLoop[i].eSelf;
            this.permanentReciprocalEnergy += this.permanentReciprocalEnergyLoop[i].eRecip;
        }
        if (totalCharge == 0.0 || this.esvTerm && !this.extendedSystem.useTotalChargeCorrection) {
            this.chargeCorrectionEnergy = 0.0;
        } else {
            Crystal unitCell = this.crystal.getUnitCell();
            int nSymm = unitCell.getNumSymOps();
            double denom = unitCell.volume * this.aewald * this.aewald;
            this.chargeCorrectionEnergy = -0.5 * this.electric * Math.PI * ((totalCharge *= (double)nSymm) * totalCharge) / denom;
            this.chargeCorrectionEnergy /= (double)nSymm;
            if (this.lambdaTerm) {
                this.shareddEdLambda.addAndGet(this.chargeCorrectionEnergy * this.dlPowPerm * this.dEdLSign);
                this.sharedd2EdLambda2.addAndGet(this.chargeCorrectionEnergy * this.d2lPowPerm * this.dEdLSign);
            }
            if (this.esvTerm) {
                for (int i = 0; i < this.atoms.length; ++i) {
                    if (!this.extendedSystem.isTitrating(i)) continue;
                    double[] in = this.globalMultipole[0][i];
                    double[] indot = this.titrationMultipole[0][i];
                    double chargeCorrectiondUdL = -0.5 * this.electric * Math.PI * indot[0] * (2.0 * totalCharge) / denom;
                    this.extendedSystem.addPermElecDeriv(i, chargeCorrectiondUdL, 0.0);
                }
            }
            this.chargeCorrectionEnergy *= this.permanentScale;
        }
    }

    public double getInducedDipoleReciprocalEnergy() {
        return this.inducedDipoleRecipEnergy.get();
    }

    public double getInducedDipoleSelfEnergy() {
        return this.inducedDipoleSelfEnergy.get();
    }

    public double getPermanentReciprocalEnergy() {
        return this.permanentReciprocalEnergy;
    }

    public double getPermanentSelfEnergy() {
        return this.permanentSelfEnergy;
    }

    public double getPermanentChargeCorrectionEnergy() {
        return this.chargeCorrectionEnergy;
    }

    public void init(Atom[] atoms, Crystal crystal, boolean gradient, boolean lambdaTerm, boolean esvTerm, boolean[] use, double[][][] globalMultipole, double[][][] globalFracMultipole, double[][][] titrationMultipole, double[][][] tautomerMultipole, double[][] cartMultipolePhi, double[][] fracMultipolePhi, Polarization polarization, double[][][] inducedDipole, double[][][] inducedDipoleCR, double[][] cartesianDipolePhi, double[][] cartesianDipolePhiCR, double[][] fracInducedDipolePhi, double[][] fracInducedDipolePhiCR, ReciprocalSpace reciprocalSpace, AlchemicalParameters alchemicalParameters, ExtendedSystem extendedSystem, AtomicDoubleArray3D grad, AtomicDoubleArray3D torque, AtomicDoubleArray3D lambdaGrad, AtomicDoubleArray3D lambdaTorque, SharedDouble shareddEdLambda, SharedDouble sharedd2EdLambda2) {
        this.atoms = atoms;
        this.crystal = crystal;
        this.gradient = gradient;
        this.lambdaTerm = lambdaTerm;
        this.esvTerm = esvTerm;
        this.use = use;
        this.globalMultipole = globalMultipole;
        this.globalFracMultipole = globalFracMultipole;
        this.titrationMultipole = titrationMultipole;
        this.tautomerMultipole = tautomerMultipole;
        this.cartMultipolePhi = cartMultipolePhi;
        this.fracMultipolePhi = fracMultipolePhi;
        this.polarization = polarization;
        this.inducedDipole = inducedDipole;
        this.inducedDipoleCR = inducedDipoleCR;
        this.cartesianDipolePhi = cartesianDipolePhi;
        this.cartesianDipolePhiCR = cartesianDipolePhiCR;
        this.fracInducedDipolePhi = fracInducedDipolePhi;
        this.fracInducedDipolePhiCR = fracInducedDipolePhiCR;
        this.reciprocalSpace = reciprocalSpace;
        this.extendedSystem = extendedSystem;
        this.permanentScale = alchemicalParameters.permanentScale;
        this.dlPowPerm = alchemicalParameters.dlPowPerm;
        this.d2lPowPerm = alchemicalParameters.d2lPowPerm;
        this.polarizationScale = alchemicalParameters.polarizationScale;
        this.dlPowPol = alchemicalParameters.dlPowPol;
        this.d2lPowPol = alchemicalParameters.d2lPowPol;
        this.dEdLSign = alchemicalParameters.dEdLSign;
        this.grad = grad;
        this.torque = torque;
        this.lambdaGrad = lambdaGrad;
        this.lambdaTorque = lambdaTorque;
        this.shareddEdLambda = shareddEdLambda;
        this.sharedd2EdLambda2 = sharedd2EdLambda2;
    }

    public void run() throws Exception {
        int threadIndex = this.getThreadIndex();
        if (this.permanentReciprocalEnergyLoop[threadIndex] == null) {
            this.permanentReciprocalEnergyLoop[threadIndex] = new PermanentReciprocalEnergyLoop(this);
            this.inducedDipoleReciprocalEnergyLoop[threadIndex] = new InducedDipoleReciprocalEnergyLoop(this);
        }
        try {
            int nAtoms = this.atoms.length;
            this.execute(0, nAtoms - 1, this.permanentReciprocalEnergyLoop[threadIndex]);
            if (this.polarization != Polarization.NONE) {
                this.execute(0, nAtoms - 1, this.inducedDipoleReciprocalEnergyLoop[threadIndex]);
            }
        }
        catch (Exception e) {
            String message = "Fatal exception computing the real space field in thread " + threadIndex + "\n";
            logger.log(Level.SEVERE, message, e);
        }
    }

    public void start() {
        this.multipole = this.globalMultipole[0];
        this.fracMultipole = this.globalFracMultipole[0];
        this.ind = this.inducedDipole[0];
        this.indCR = this.inducedDipoleCR[0];
        this.inducedDipoleSelfEnergy.set(0.0);
        this.inducedDipoleRecipEnergy.set(0.0);
        this.nfftX = this.reciprocalSpace.getXDim();
        this.nfftY = this.reciprocalSpace.getYDim();
        this.nfftZ = this.reciprocalSpace.getZDim();
    }

    private class PermanentReciprocalEnergyLoop
    extends IntegerForLoop {
        int threadID;
        double totalCharge;
        double eSelf;
        double eRecip;
        final /* synthetic */ ReciprocalEnergyRegion this$0;

        private PermanentReciprocalEnergyLoop(ReciprocalEnergyRegion reciprocalEnergyRegion) {
            ReciprocalEnergyRegion reciprocalEnergyRegion2 = reciprocalEnergyRegion;
            Objects.requireNonNull(reciprocalEnergyRegion2);
            this.this$0 = reciprocalEnergyRegion2;
        }

        public void finish() {
            this.eSelf *= this.this$0.permanentScale;
            this.eRecip *= this.this$0.permanentScale * 0.5 * this.this$0.electric;
        }

        public void run(int lb, int ub) {
            for (int i = lb; i <= ub; ++i) {
                if (!this.this$0.use[i]) continue;
                double[] in = this.this$0.globalMultipole[0][i];
                this.totalCharge += in[0];
                double cii = in[0] * in[0];
                double dii = in[1] * in[1] + in[2] * in[2] + in[3] * in[3];
                double qii = in[4] * in[4] + in[5] * in[5] + in[6] * in[6] + 2.0 * (in[7] * in[7] + in[8] * in[8] + in[9] * in[9]);
                this.eSelf += this.this$0.aewald1 * (cii + this.this$0.aewald2 * (dii / 3.0 + 2.0 * this.this$0.aewald2 * qii / 45.0));
                if (!this.this$0.esvTerm || !this.this$0.extendedSystem.isTitrating(i)) continue;
                double[] indot = this.this$0.titrationMultipole[0][i];
                double ciidot = indot[0] * in[0];
                double diidot = indot[1] * in[1] + indot[2] * in[2] + indot[3] * in[3];
                double qiidot = indot[4] * in[4] + indot[5] * in[5] + indot[6] * in[6] + 2.0 * (indot[7] * in[7] + indot[8] * in[8] + indot[9] * in[9]);
                double eSelfTitrDot = 2.0 * this.this$0.aewald1 * (ciidot + this.this$0.aewald2 * (diidot / 3.0 + 2.0 * this.this$0.aewald2 * qiidot / 45.0));
                double eSelfTautDot = 0.0;
                if (this.this$0.extendedSystem.isTautomerizing(i)) {
                    indot = this.this$0.tautomerMultipole[0][i];
                    ciidot = indot[0] * in[0];
                    diidot = indot[1] * in[1] + indot[2] * in[2] + indot[3] * in[3];
                    qiidot = indot[4] * in[4] + indot[5] * in[5] + indot[6] * in[6] + 2.0 * (indot[7] * in[7] + indot[8] * in[8] + indot[9] * in[9]);
                    eSelfTautDot = 2.0 * this.this$0.aewald1 * (ciidot + this.this$0.aewald2 * (diidot / 3.0 + 2.0 * this.this$0.aewald2 * qiidot / 45.0));
                }
                double factor = this.this$0.permanentScale;
                this.this$0.extendedSystem.addPermElecDeriv(i, eSelfTitrDot * factor, eSelfTautDot * factor);
            }
            if (this.this$0.lambdaTerm) {
                this.this$0.shareddEdLambda.addAndGet(this.eSelf * this.this$0.dlPowPerm * this.this$0.dEdLSign);
                this.this$0.sharedd2EdLambda2.addAndGet(this.eSelf * this.this$0.d2lPowPerm * this.this$0.dEdLSign);
            }
            double[][] recip = this.this$0.crystal.getUnitCell().A;
            double dUdL = 0.0;
            double d2UdL2 = 0.0;
            for (int i = lb; i <= ub; ++i) {
                double factor;
                if (!this.this$0.use[i]) continue;
                double[] phi = this.this$0.cartMultipolePhi[i];
                double[] mpole = this.this$0.multipole[i];
                double[] fmpole = this.this$0.fracMultipole[i];
                double e = mpole[0] * phi[0] + mpole[1] * phi[1] + mpole[2] * phi[2] + mpole[3] * phi[3] + this.this$0.oneThird * (mpole[4] * phi[4] + mpole[5] * phi[5] + mpole[6] * phi[6] + 2.0 * (mpole[7] * phi[7] + mpole[8] * phi[8] + mpole[9] * phi[9]));
                this.eRecip += e;
                if (this.this$0.esvTerm && this.this$0.extendedSystem.isTitrating(i)) {
                    double[] mpoleDot = this.this$0.titrationMultipole[0][i];
                    double edotTitr = mpoleDot[0] * phi[0] + mpoleDot[1] * phi[1] + mpoleDot[2] * phi[2] + mpoleDot[3] * phi[3] + this.this$0.oneThird * (mpoleDot[4] * phi[4] + mpoleDot[5] * phi[5] + mpoleDot[6] * phi[6] + 2.0 * (mpoleDot[7] * phi[7] + mpoleDot[8] * phi[8] + mpoleDot[9] * phi[9]));
                    double edotTaut = 0.0;
                    if (this.this$0.extendedSystem.isTautomerizing(i)) {
                        mpoleDot = this.this$0.tautomerMultipole[0][i];
                        edotTaut = mpoleDot[0] * phi[0] + mpoleDot[1] * phi[1] + mpoleDot[2] * phi[2] + mpoleDot[3] * phi[3] + this.this$0.oneThird * (mpoleDot[4] * phi[4] + mpoleDot[5] * phi[5] + mpoleDot[6] * phi[6] + 2.0 * (mpoleDot[7] * phi[7] + mpoleDot[8] * phi[8] + mpoleDot[9] * phi[9]));
                    }
                    double factor2 = this.this$0.permanentScale * this.this$0.electric;
                    this.this$0.extendedSystem.addPermElecDeriv(i, edotTitr * factor2, edotTaut * factor2);
                }
                if (!this.this$0.gradient && !this.this$0.lambdaTerm) continue;
                double[] fPhi = this.this$0.fracMultipolePhi[i];
                double gx = fmpole[0] * fPhi[1] + fmpole[1] * fPhi[4] + fmpole[2] * fPhi[7] + fmpole[3] * fPhi[8] + fmpole[4] * fPhi[10] + fmpole[5] * fPhi[15] + fmpole[6] * fPhi[17] + fmpole[7] * fPhi[13] + fmpole[8] * fPhi[14] + fmpole[9] * fPhi[19];
                double gy = fmpole[0] * fPhi[2] + fmpole[1] * fPhi[7] + fmpole[2] * fPhi[5] + fmpole[3] * fPhi[9] + fmpole[4] * fPhi[13] + fmpole[5] * fPhi[11] + fmpole[6] * fPhi[18] + fmpole[7] * fPhi[15] + fmpole[8] * fPhi[19] + fmpole[9] * fPhi[16];
                double gz = fmpole[0] * fPhi[3] + fmpole[1] * fPhi[8] + fmpole[2] * fPhi[9] + fmpole[3] * fPhi[6] + fmpole[4] * fPhi[14] + fmpole[5] * fPhi[16] + fmpole[6] * fPhi[12] + fmpole[7] * fPhi[19] + fmpole[8] * fPhi[17] + fmpole[9] * fPhi[18];
                double dfx = recip[0][0] * (gx *= this.this$0.nfftX) + recip[0][1] * (gy *= this.this$0.nfftY) + recip[0][2] * (gz *= this.this$0.nfftZ);
                double dfy = recip[1][0] * gx + recip[1][1] * gy + recip[1][2] * gz;
                double dfz = recip[2][0] * gx + recip[2][1] * gy + recip[2][2] * gz;
                double tqx = -mpole[2] * phi[3] + mpole[3] * phi[2];
                double tqy = -mpole[3] * phi[1] + mpole[1] * phi[3];
                double tqz = -mpole[1] * phi[2] + mpole[2] * phi[1];
                tqx -= this.this$0.twoThirds * (mpole[7] * phi[8] + mpole[5] * phi[9] + mpole[9] * phi[6] - mpole[8] * phi[7] - mpole[9] * phi[5] - mpole[6] * phi[9]);
                tqy -= this.this$0.twoThirds * (mpole[8] * phi[4] + mpole[9] * phi[7] + mpole[6] * phi[8] - mpole[4] * phi[8] - mpole[7] * phi[9] - mpole[8] * phi[6]);
                tqz -= this.this$0.twoThirds * (mpole[4] * phi[7] + mpole[7] * phi[5] + mpole[8] * phi[9] - mpole[7] * phi[4] - mpole[5] * phi[7] - mpole[9] * phi[8]);
                if (this.this$0.gradient) {
                    factor = this.this$0.permanentScale * this.this$0.electric;
                    this.this$0.grad.add(this.threadID, i, factor * dfx, factor * dfy, factor * dfz);
                    this.this$0.torque.add(this.threadID, i, factor * tqx, factor * tqy, factor * tqz);
                }
                if (!this.this$0.lambdaTerm) continue;
                dUdL += this.this$0.dEdLSign * this.this$0.dlPowPerm * e;
                d2UdL2 += this.this$0.dEdLSign * this.this$0.d2lPowPerm * e;
                factor = this.this$0.dEdLSign * this.this$0.dlPowPerm * this.this$0.electric;
                this.this$0.lambdaGrad.add(this.threadID, i, factor * dfx, factor * dfy, factor * dfz);
                this.this$0.lambdaTorque.add(this.threadID, i, factor * tqx, factor * tqy, factor * tqz);
            }
            if (this.this$0.lambdaTerm) {
                this.this$0.shareddEdLambda.addAndGet(0.5 * dUdL * this.this$0.electric);
                this.this$0.sharedd2EdLambda2.addAndGet(0.5 * d2UdL2 * this.this$0.electric);
            }
        }

        public IntegerSchedule schedule() {
            return IntegerSchedule.fixed();
        }

        public void start() {
            this.totalCharge = 0.0;
            this.eSelf = 0.0;
            this.eRecip = 0.0;
            this.threadID = this.getThreadIndex();
        }
    }

    private class InducedDipoleReciprocalEnergyLoop
    extends IntegerForLoop {
        private final double[] sfPhi;
        private final double[] sPhi;
        private double eSelf;
        private double eRecip;
        private int threadID;
        final /* synthetic */ ReciprocalEnergyRegion this$0;

        private InducedDipoleReciprocalEnergyLoop(ReciprocalEnergyRegion reciprocalEnergyRegion) {
            ReciprocalEnergyRegion reciprocalEnergyRegion2 = reciprocalEnergyRegion;
            Objects.requireNonNull(reciprocalEnergyRegion2);
            this.this$0 = reciprocalEnergyRegion2;
            this.sfPhi = new double[tensorCount];
            this.sPhi = new double[tensorCount];
        }

        public void finish() {
            this.this$0.inducedDipoleSelfEnergy.addAndGet(this.this$0.polarizationScale * this.eSelf);
            this.this$0.inducedDipoleRecipEnergy.addAndGet(this.this$0.polarizationScale * this.eRecip);
        }

        public void run(int lb, int ub) throws Exception {
            double[] indi;
            int i;
            for (i = lb; i <= ub; ++i) {
                if (!this.this$0.use[i]) continue;
                indi = this.this$0.ind[i];
                double[] multipolei = this.this$0.multipole[i];
                double dix = multipolei[1];
                double diy = multipolei[2];
                double diz = multipolei[3];
                double dii = indi[0] * dix + indi[1] * diy + indi[2] * diz;
                this.eSelf += this.this$0.aewald3 * dii;
            }
            if (this.this$0.lambdaTerm) {
                this.this$0.shareddEdLambda.addAndGet(this.this$0.dEdLSign * this.this$0.dlPowPol * this.eSelf);
                this.this$0.sharedd2EdLambda2.addAndGet(this.this$0.dEdLSign * this.this$0.d2lPowPol * this.eSelf);
            }
            if (this.this$0.gradient || this.this$0.esvTerm) {
                for (i = lb; i <= ub; ++i) {
                    if (!this.this$0.use[i]) continue;
                    indi = this.this$0.ind[i];
                    double[] indpi = this.this$0.indCR[i];
                    double[] multipolei = this.this$0.multipole[i];
                    double dix = multipolei[1];
                    double diy = multipolei[2];
                    double diz = multipolei[3];
                    double uix = 0.5 * (indi[0] + indpi[0]);
                    double uiy = 0.5 * (indi[1] + indpi[1]);
                    double uiz = 0.5 * (indi[2] + indpi[2]);
                    if (this.this$0.gradient) {
                        double tix = this.this$0.aewald4 * (diy * uiz - diz * uiy);
                        double tiy = this.this$0.aewald4 * (diz * uix - dix * uiz);
                        double tiz = this.this$0.aewald4 * (dix * uiy - diy * uix);
                        this.this$0.torque.add(this.threadID, i, this.this$0.polarizationScale * tix, this.this$0.polarizationScale * tiy, this.this$0.polarizationScale * tiz);
                        if (this.this$0.lambdaTerm) {
                            double factor = this.this$0.dEdLSign * this.this$0.dlPowPol;
                            this.this$0.lambdaTorque.add(this.threadID, i, factor * tix, factor * tiy, factor * tiz);
                        }
                    }
                    if (!this.this$0.esvTerm || !this.this$0.extendedSystem.isTitrating(i)) continue;
                    double[] titrDot = this.this$0.titrationMultipole[0][i];
                    double indiDotMdot = uix * titrDot[1] + uiy * titrDot[2] + uiz * titrDot[3];
                    double dIndSelfTitrdLi = this.this$0.polarizationScale * 2.0 * this.this$0.aewald3 * indiDotMdot;
                    double dIndSelfTautdLi = 0.0;
                    if (this.this$0.extendedSystem.isTautomerizing(i)) {
                        double[] tautDot = this.this$0.tautomerMultipole[0][i];
                        indiDotMdot = uix * tautDot[1] + uiy * tautDot[2] + uiz * tautDot[3];
                        dIndSelfTautdLi = this.this$0.polarizationScale * 2.0 * this.this$0.aewald3 * indiDotMdot;
                    }
                    this.this$0.extendedSystem.addIndElecDeriv(i, dIndSelfTitrdLi, dIndSelfTautdLi);
                }
            }
            for (i = lb; i <= ub; ++i) {
                double[] fracInd = new double[3];
                double[] fracIndCR = new double[3];
                if (!this.this$0.use[i]) continue;
                double[] fPhi = this.this$0.fracMultipolePhi[i];
                this.this$0.reciprocalSpace.cartToFracInducedDipole(this.this$0.inducedDipole[0][i], this.this$0.inducedDipoleCR[0][i], fracInd, fracIndCR);
                double indx = fracInd[0];
                double indy = fracInd[1];
                double indz = fracInd[2];
                this.eRecip += indx * fPhi[1] + indy * fPhi[2] + indz * fPhi[3];
                if (!this.this$0.gradient && !this.this$0.esvTerm) continue;
                double[] iPhi = this.this$0.cartesianDipolePhi[i];
                double[] iCRPhi = this.this$0.cartesianDipolePhiCR[i];
                double[] fiPhi = this.this$0.fracInducedDipolePhi[i];
                double[] fiCRPhi = this.this$0.fracInducedDipolePhiCR[i];
                double[] mpolei = this.this$0.multipole[i];
                double[] fmpolei = this.this$0.fracMultipole[i];
                double inpx = fracIndCR[0];
                double inpy = fracIndCR[1];
                double inpz = fracIndCR[2];
                double insx = indx + inpx;
                double insy = indy + inpy;
                double insz = indz + inpz;
                for (int t = 0; t < tensorCount; ++t) {
                    this.sPhi[t] = 0.5 * (iPhi[t] + iCRPhi[t]);
                    this.sfPhi[t] = fiPhi[t] + fiCRPhi[t];
                }
                double gx = insx * fPhi[4] + insy * fPhi[7] + insz * fPhi[8];
                double gy = insx * fPhi[7] + insy * fPhi[5] + insz * fPhi[9];
                double gz = insx * fPhi[8] + insy * fPhi[9] + insz * fPhi[6];
                if (this.this$0.polarization == Polarization.MUTUAL) {
                    gx += indx * fiCRPhi[4] + inpx * fiPhi[4] + indy * fiCRPhi[7] + inpy * fiPhi[7] + indz * fiCRPhi[8] + inpz * fiPhi[8];
                    gy += indx * fiCRPhi[7] + inpx * fiPhi[7] + indy * fiCRPhi[5] + inpy * fiPhi[5] + indz * fiCRPhi[9] + inpz * fiPhi[9];
                    gz += indx * fiCRPhi[8] + inpx * fiPhi[8] + indy * fiCRPhi[9] + inpy * fiPhi[9] + indz * fiCRPhi[6] + inpz * fiPhi[6];
                }
                gx += fmpolei[0] * this.sfPhi[1] + fmpolei[1] * this.sfPhi[4] + fmpolei[2] * this.sfPhi[7] + fmpolei[3] * this.sfPhi[8] + fmpolei[4] * this.sfPhi[10] + fmpolei[5] * this.sfPhi[15] + fmpolei[6] * this.sfPhi[17] + fmpolei[7] * this.sfPhi[13] + fmpolei[8] * this.sfPhi[14] + fmpolei[9] * this.sfPhi[19];
                gy += fmpolei[0] * this.sfPhi[2] + fmpolei[1] * this.sfPhi[7] + fmpolei[2] * this.sfPhi[5] + fmpolei[3] * this.sfPhi[9] + fmpolei[4] * this.sfPhi[13] + fmpolei[5] * this.sfPhi[11] + fmpolei[6] * this.sfPhi[18] + fmpolei[7] * this.sfPhi[15] + fmpolei[8] * this.sfPhi[19] + fmpolei[9] * this.sfPhi[16];
                gz += fmpolei[0] * this.sfPhi[3] + fmpolei[1] * this.sfPhi[8] + fmpolei[2] * this.sfPhi[9] + fmpolei[3] * this.sfPhi[6] + fmpolei[4] * this.sfPhi[14] + fmpolei[5] * this.sfPhi[16] + fmpolei[6] * this.sfPhi[12] + fmpolei[7] * this.sfPhi[19] + fmpolei[8] * this.sfPhi[17] + fmpolei[9] * this.sfPhi[18];
                double[][] recip = this.this$0.crystal.getUnitCell().A;
                double dfx = recip[0][0] * (gx *= this.this$0.nfftX) + recip[0][1] * (gy *= this.this$0.nfftY) + recip[0][2] * (gz *= this.this$0.nfftZ);
                double dfy = recip[1][0] * gx + recip[1][1] * gy + recip[1][2] * gz;
                double dfz = recip[2][0] * gx + recip[2][1] * gy + recip[2][2] * gz;
                dfx *= 0.5 * this.this$0.electric;
                dfy *= 0.5 * this.this$0.electric;
                dfz *= 0.5 * this.this$0.electric;
                double tqx = -mpolei[2] * this.sPhi[3] + mpolei[3] * this.sPhi[2];
                double tqy = -mpolei[3] * this.sPhi[1] + mpolei[1] * this.sPhi[3];
                double tqz = -mpolei[1] * this.sPhi[2] + mpolei[2] * this.sPhi[1];
                tqx -= this.this$0.twoThirds * (mpolei[7] * this.sPhi[8] + mpolei[5] * this.sPhi[9] + mpolei[9] * this.sPhi[6] - mpolei[8] * this.sPhi[7] - mpolei[9] * this.sPhi[5] - mpolei[6] * this.sPhi[9]);
                tqy -= this.this$0.twoThirds * (mpolei[8] * this.sPhi[4] + mpolei[9] * this.sPhi[7] + mpolei[6] * this.sPhi[8] - mpolei[4] * this.sPhi[8] - mpolei[7] * this.sPhi[9] - mpolei[8] * this.sPhi[6]);
                tqz -= this.this$0.twoThirds * (mpolei[4] * this.sPhi[7] + mpolei[7] * this.sPhi[5] + mpolei[8] * this.sPhi[9] - mpolei[7] * this.sPhi[4] - mpolei[5] * this.sPhi[7] - mpolei[9] * this.sPhi[8]);
                this.this$0.grad.add(this.threadID, i, this.this$0.polarizationScale * dfx, this.this$0.polarizationScale * dfy, this.this$0.polarizationScale * dfz);
                this.this$0.torque.add(this.threadID, i, this.this$0.polarizationScale * (tqx *= this.this$0.electric), this.this$0.polarizationScale * (tqy *= this.this$0.electric), this.this$0.polarizationScale * (tqz *= this.this$0.electric));
                if (this.this$0.lambdaTerm) {
                    double factor = this.this$0.dEdLSign * this.this$0.dlPowPol;
                    this.this$0.lambdaGrad.add(this.threadID, i, factor * dfx, factor * dfy, factor * dfz);
                    this.this$0.lambdaTorque.add(this.threadID, i, factor * tqx, factor * tqy, factor * tqz);
                }
                if (!this.this$0.esvTerm || !this.this$0.extendedSystem.isTitrating(i)) continue;
                double[] mTitrDot = this.this$0.titrationMultipole[0][i];
                double eTitrDot = mTitrDot[0] * this.sPhi[0] + mTitrDot[1] * this.sPhi[1] + mTitrDot[2] * this.sPhi[2] + mTitrDot[3] * this.sPhi[3] + this.this$0.oneThird * (mTitrDot[4] * this.sPhi[4] + mTitrDot[5] * this.sPhi[5] + mTitrDot[6] * this.sPhi[6] + 2.0 * (mTitrDot[7] * this.sPhi[7] + mTitrDot[8] * this.sPhi[8] + mTitrDot[9] * this.sPhi[9]));
                double eTautDot = 0.0;
                if (this.this$0.extendedSystem.isTautomerizing(i)) {
                    double[] mTautDot = this.this$0.tautomerMultipole[0][i];
                    eTautDot = mTautDot[0] * this.sPhi[0] + mTautDot[1] * this.sPhi[1] + mTautDot[2] * this.sPhi[2] + mTautDot[3] * this.sPhi[3] + this.this$0.oneThird * (mTautDot[4] * this.sPhi[4] + mTautDot[5] * this.sPhi[5] + mTautDot[6] * this.sPhi[6] + 2.0 * (mTautDot[7] * this.sPhi[7] + mTautDot[8] * this.sPhi[8] + mTautDot[9] * this.sPhi[9]));
                }
                double factor = this.this$0.polarizationScale * this.this$0.electric;
                this.this$0.extendedSystem.addIndElecDeriv(i, eTitrDot * factor, eTautDot * factor);
            }
            this.eRecip *= 0.5 * this.this$0.electric;
            if (this.this$0.lambdaTerm) {
                this.this$0.shareddEdLambda.addAndGet(this.this$0.dEdLSign * this.this$0.dlPowPol * this.eRecip);
                this.this$0.sharedd2EdLambda2.addAndGet(this.this$0.dEdLSign * this.this$0.d2lPowPol * this.eRecip);
            }
        }

        public IntegerSchedule schedule() {
            return IntegerSchedule.fixed();
        }

        public void start() {
            this.eSelf = 0.0;
            this.eRecip = 0.0;
            this.threadID = this.getThreadIndex();
        }
    }
}

