/*
 * Decompiled with CFR 0.152.
 */
package ffx.potential.nonbonded.pme;

import edu.rit.pj.IntegerForLoop;
import edu.rit.pj.IntegerSchedule;
import edu.rit.pj.ParallelRegion;
import edu.rit.pj.ParallelTeam;
import edu.rit.pj.reduction.SharedDouble;
import ffx.crystal.Crystal;
import ffx.crystal.SymOp;
import ffx.numerics.atomic.AtomicDoubleArray3D;
import ffx.numerics.special.Erf;
import ffx.potential.bonded.Atom;
import ffx.potential.nonbonded.ParticleMeshEwald;
import ffx.potential.nonbonded.pme.EwaldParameters;
import ffx.potential.nonbonded.pme.PMETimings;
import ffx.potential.parameters.ForceField;
import ffx.potential.utils.EnergyException;
import java.util.List;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.math3.util.FastMath;

public class PCGSolver {
    private static final Logger logger = Logger.getLogger(PCGSolver.class.getName());
    private final InitResidualRegion initResidualRegion;
    private final InitConjugateRegion initConjugateRegion;
    private final UpdateResidualRegion updateResidualRegion;
    private final UpdateConjugateRegion updateConjugateRegion;
    private final PreconditionerRegion preconditionerRegion;
    private final double poleps;
    private final double preconditionerCutoff;
    private final double preconditionerEwald;
    private final double preconditionerScale;
    private final PRECONDITION_MODE preconditionMode;
    private int[][][] preconditionerLists;
    private int[][] preconditionerCounts;
    private double[][] r;
    private double[][] rCR;
    private double[][] zpre;
    private double[][] zpreCR;
    private double[][] p;
    private double[][] pCR;
    private double[][] vec;
    private double[][] vecCR;
    private Atom[] atoms;
    private double[][][] coordinates;
    private double[] polarizability;
    private double[] ipdamp;
    private double[] thole;
    private boolean[] use;
    private Crystal crystal;
    private double[][][] inducedDipole;
    private double[][][] inducedDipoleCR;
    private double[][] directDipole;
    private double[][] directDipoleCR;
    private AtomicDoubleArray3D field;
    private AtomicDoubleArray3D fieldCR;
    private EwaldParameters ewaldParameters;
    private ParallelTeam parallelTeam;
    private IntegerSchedule realSpaceSchedule;
    private PMETimings pmeTimings;
    public static final double DEFAULT_CG_PRECONDITIONER_CUTOFF = 4.5;
    public static final double DEFAULT_CG_PRECONDITIONER_EWALD = 0.0;
    public static final double DEFAULT_CG_PRECONDITIONER_SCALE = 2.0;
    private double dieletric;

    public PCGSolver(int maxThreads, double poleps, ForceField forceField, int nAtoms) {
        this.poleps = poleps;
        this.preconditionerRegion = new PreconditionerRegion(this, maxThreads);
        this.initResidualRegion = new InitResidualRegion(this, maxThreads);
        this.initConjugateRegion = new InitConjugateRegion(this, maxThreads);
        this.updateResidualRegion = new UpdateResidualRegion(this, maxThreads);
        this.updateConjugateRegion = new UpdateConjugateRegion(this, maxThreads);
        boolean preconditioner = forceField.getBoolean("USE_SCF_PRECONDITIONER", true);
        if (preconditioner) {
            this.preconditionerCutoff = forceField.getDouble("CG_PRECONDITIONER_CUTOFF", 4.5);
            this.preconditionerEwald = forceField.getDouble("CG_PRECONDITIONER_EWALD", 0.0);
            this.preconditionerScale = forceField.getDouble("CG_PRECONDITIONER_SCALE", 2.0);
            PRECONDITION_MODE mode = PRECONDITION_MODE.FLETCHER_REEVES;
            try {
                String m = forceField.getString("CG_PRECONDITIONER_MODE", PRECONDITION_MODE.FLETCHER_REEVES.toString());
                m = ForceField.toEnumForm(m);
                mode = PRECONDITION_MODE.valueOf(m);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.preconditionMode = mode;
        } else {
            this.preconditionerCutoff = 0.0;
            this.preconditionerEwald = 0.0;
            this.preconditionerScale = 0.0;
            this.preconditionMode = PRECONDITION_MODE.FLETCHER_REEVES;
        }
        this.allocateVectors(nAtoms);
    }

    public void allocateLists(int nSymm, int nAtoms) {
        int preconditionerListSize = 50;
        this.preconditionerLists = new int[nSymm][nAtoms][preconditionerListSize];
        this.preconditionerCounts = new int[nSymm][nAtoms];
    }

    public void allocateVectors(int nAtoms) {
        if (this.r == null || this.r[0].length != nAtoms) {
            this.r = new double[3][nAtoms];
            this.rCR = new double[3][nAtoms];
            this.zpre = new double[3][nAtoms];
            this.zpreCR = new double[3][nAtoms];
            this.p = new double[3][nAtoms];
            this.pCR = new double[3][nAtoms];
            this.vec = new double[3][nAtoms];
            this.vecCR = new double[3][nAtoms];
        }
    }

    public double getPreconditionerCutoff() {
        return this.preconditionerCutoff;
    }

    public double getPreconditionerEwald() {
        return this.preconditionerEwald;
    }

    public double getPreconditionerScale() {
        return this.preconditionerScale;
    }

    public String getPreconditionerMode() {
        return this.preconditionMode.toString();
    }

    public int[][][] getPreconditionerLists() {
        return this.preconditionerLists;
    }

    public int[][] getPreconditionerCounts() {
        return this.preconditionerCounts;
    }

    public void init(Atom[] atoms, double[][][] coordinates, double[] polarizability, double[] ipdamp, double[] thole, boolean[] use, Crystal crystal, double[][][] inducedDipole, double[][][] inducedDipoleCR, double[][] directDipole, double[][] directDipoleCR, AtomicDoubleArray3D field, AtomicDoubleArray3D fieldCR, EwaldParameters ewaldParameters, double dieletric, ParallelTeam parallelTeam, IntegerSchedule realSpaceSchedule, PMETimings pmeTimings) {
        this.atoms = atoms;
        this.coordinates = coordinates;
        this.polarizability = polarizability;
        this.ipdamp = ipdamp;
        this.thole = thole;
        this.use = use;
        this.crystal = crystal;
        this.inducedDipole = inducedDipole;
        this.inducedDipoleCR = inducedDipoleCR;
        this.directDipole = directDipole;
        this.directDipoleCR = directDipoleCR;
        this.field = field;
        this.fieldCR = fieldCR;
        this.ewaldParameters = ewaldParameters;
        this.dieletric = dieletric;
        this.parallelTeam = parallelTeam;
        this.realSpaceSchedule = realSpaceSchedule;
        this.pmeTimings = pmeTimings;
    }

    public int scfByPCG(boolean print, long startTime, ParticleMeshEwald particleMeshEwald) {
        long directTime = System.nanoTime() - startTime;
        StringBuilder sb = null;
        if (print) {
            sb = new StringBuilder("\n Self-Consistent Field\n Iter  RMS Change (Debye)  Time\n");
        }
        particleMeshEwald.computeInduceDipoleField();
        try {
            this.parallelTeam.execute((ParallelRegion)this.initResidualRegion);
            this.computePreconditioner();
            this.parallelTeam.execute((ParallelRegion)this.initConjugateRegion);
        }
        catch (Exception e) {
            String message = "Exception initializing preconditioned conjugate-gradient SCF solver.";
            logger.log(Level.SEVERE, message, e);
        }
        int completedSCFCycles = 0;
        int maxSCFCycles = 1000;
        double eps = 100.0;
        boolean done = false;
        while (!done) {
            String message;
            long cycleTime = -System.nanoTime();
            particleMeshEwald.computeInduceDipoleField();
            try {
                this.parallelTeam.execute((ParallelRegion)this.updateResidualRegion);
            }
            catch (Exception e) {
                message = "Exception updating residual during CG iteration.";
                logger.log(Level.SEVERE, message, e);
            }
            double previousEps = eps;
            eps = FastMath.max((double)this.updateResidualRegion.getEps(), (double)this.updateResidualRegion.getEpsCR());
            ++completedSCFCycles;
            int nAtoms = this.atoms.length;
            eps = 4.80321 * FastMath.sqrt((double)(eps / (double)nAtoms));
            cycleTime += System.nanoTime();
            if (print) {
                sb.append(String.format(" %4d     %15.10f %7.4f\n", completedSCFCycles, eps, (double)cycleTime * 1.0E-9));
            }
            if (eps > previousEps) {
                if (sb != null) {
                    logger.warning(sb.toString());
                }
                message = String.format("SCF convergence failure: (%10.5f > %10.5f)\n", eps, previousEps);
                throw new EnergyException(message);
            }
            if (completedSCFCycles >= maxSCFCycles) {
                if (sb != null) {
                    logger.warning(sb.toString());
                }
                message = String.format("Maximum SCF iterations reached: (%d)\n", completedSCFCycles);
                throw new EnergyException(message);
            }
            if (eps < this.poleps) {
                done = true;
                continue;
            }
            this.computePreconditioner();
            try {
                this.updateConjugateRegion.previousRDotZ = this.updateResidualRegion.getRDotZ();
                this.updateConjugateRegion.previousRDotZCR = this.updateResidualRegion.getRDotZCR();
                this.parallelTeam.execute((ParallelRegion)this.updateConjugateRegion);
            }
            catch (Exception e) {
                String message2 = "Exception updating conjugate search direction during CG iteration.";
                logger.log(Level.SEVERE, message2, e);
            }
        }
        if (print) {
            sb.append(String.format(" Direct:                  %7.4f\n", 1.0E-9 * (double)directTime));
            startTime = System.nanoTime() - startTime;
            sb.append(String.format(" Total:                   %7.4f", (double)startTime * 1.0E-9));
            logger.info(sb.toString());
        }
        particleMeshEwald.computeInduceDipoleField();
        return completedSCFCycles;
    }

    private void computePreconditioner() {
        try {
            this.field.reset(this.parallelTeam);
            this.fieldCR.reset(this.parallelTeam);
            double aewaldTemp = this.ewaldParameters.aewald;
            this.ewaldParameters.setEwaldParameters(this.ewaldParameters.off, this.preconditionerEwald);
            this.parallelTeam.execute((ParallelRegion)this.preconditionerRegion);
            this.ewaldParameters.setEwaldParameters(this.ewaldParameters.off, aewaldTemp);
            this.field.reduce(this.parallelTeam);
            this.fieldCR.reduce(this.parallelTeam);
            if (this.dieletric > 1.0) {
                int nAtoms = this.atoms.length;
                double invDielectric = 1.0 / this.dieletric;
                for (int i = 0; i < nAtoms; ++i) {
                    this.field.scale(0, i, invDielectric);
                    this.fieldCR.scale(0, i, invDielectric);
                }
            }
        }
        catch (Exception e) {
            String message = "Exception computing the induced field for the preconditioner.";
            logger.log(Level.SEVERE, message, e);
        }
    }

    private class PreconditionerRegion
    extends ParallelRegion {
        private final InducedPreconditionerFieldLoop[] inducedPreconditionerFieldLoop;
        final /* synthetic */ PCGSolver this$0;

        PreconditionerRegion(PCGSolver pCGSolver, int threadCount) {
            PCGSolver pCGSolver2 = pCGSolver;
            Objects.requireNonNull(pCGSolver2);
            this.this$0 = pCGSolver2;
            this.inducedPreconditionerFieldLoop = new InducedPreconditionerFieldLoop[threadCount];
        }

        public void start() {
            this.this$0.pmeTimings.realSpaceSCFTotalTime -= System.nanoTime();
        }

        public void finish() {
            this.this$0.pmeTimings.realSpaceSCFTotalTime += System.nanoTime();
        }

        public void run() {
            int threadIndex = this.getThreadIndex();
            if (this.inducedPreconditionerFieldLoop[threadIndex] == null) {
                this.inducedPreconditionerFieldLoop[threadIndex] = new InducedPreconditionerFieldLoop(this);
            }
            try {
                int nAtoms = this.this$0.atoms.length;
                this.execute(0, nAtoms - 1, this.inducedPreconditionerFieldLoop[threadIndex]);
            }
            catch (Exception e) {
                String message = "Fatal exception computing the induced real space field in thread " + this.getThreadIndex() + "\n";
                logger.log(Level.SEVERE, message, e);
            }
        }

        private class InducedPreconditionerFieldLoop
        extends IntegerForLoop {
            private int threadID;
            private double[] x;
            private double[] y;
            private double[] z;
            final /* synthetic */ PreconditionerRegion this$1;

            InducedPreconditionerFieldLoop(PreconditionerRegion preconditionerRegion) {
                PreconditionerRegion preconditionerRegion2 = preconditionerRegion;
                Objects.requireNonNull(preconditionerRegion2);
                this.this$1 = preconditionerRegion2;
            }

            public void finish() {
                int n = this.threadID;
                this.this$1.this$0.pmeTimings.realSpaceSCFTime[n] = this.this$1.this$0.pmeTimings.realSpaceSCFTime[n] + System.nanoTime();
            }

            public void run(int lb, int ub) {
                double[] dx = new double[3];
                double[] rk = new double[3];
                double[] rCRk = new double[3];
                double[][] transOp = new double[3][3];
                int[][] lists = this.this$1.this$0.preconditionerLists[0];
                int[] counts = this.this$1.this$0.preconditionerCounts[0];
                for (int i = lb; i <= ub; ++i) {
                    if (!this.this$1.this$0.use[i]) continue;
                    double fx = 0.0;
                    double fy = 0.0;
                    double fz = 0.0;
                    double px = 0.0;
                    double py = 0.0;
                    double pz = 0.0;
                    double xi = this.x[i];
                    double yi = this.y[i];
                    double zi = this.z[i];
                    double polari = this.this$1.this$0.polarizability[i];
                    double uix = polari * this.this$1.this$0.r[0][i];
                    double uiy = polari * this.this$1.this$0.r[1][i];
                    double uiz = polari * this.this$1.this$0.r[2][i];
                    double pix = polari * this.this$1.this$0.rCR[0][i];
                    double piy = polari * this.this$1.this$0.rCR[1][i];
                    double piz = polari * this.this$1.this$0.rCR[2][i];
                    double pdi = this.this$1.this$0.ipdamp[i];
                    double pti = this.this$1.this$0.thole[i];
                    int[] list = lists[i];
                    int npair = counts[i];
                    for (int j = 0; j < npair; ++j) {
                        double rdamp;
                        int k = list[j];
                        if (!this.this$1.this$0.use[k]) continue;
                        double pdk = this.this$1.this$0.ipdamp[k];
                        double ptk = this.this$1.this$0.thole[k];
                        dx[0] = this.x[k] - xi;
                        dx[1] = this.y[k] - yi;
                        dx[2] = this.z[k] - zi;
                        double r2 = this.this$1.this$0.crystal.image(dx);
                        double r = FastMath.sqrt((double)r2);
                        double rr1 = 1.0 / r;
                        double rr2 = rr1 * rr1;
                        double ralpha = this.this$1.this$0.ewaldParameters.aewald * r;
                        double exp2a = FastMath.exp((double)(-ralpha * ralpha));
                        double bn0 = Erf.erfc((double)ralpha) * rr1;
                        double bn1 = (bn0 + this.this$1.this$0.ewaldParameters.an0 * exp2a) * rr2;
                        double bn2 = (3.0 * bn1 + this.this$1.this$0.ewaldParameters.an1 * exp2a) * rr2;
                        double scale3 = 1.0;
                        double scale5 = 1.0;
                        double damp = pdi * pdk;
                        double pgamma = FastMath.min((double)pti, (double)ptk);
                        damp = -pgamma * (rdamp = r * damp) * rdamp * rdamp;
                        if (damp > -50.0) {
                            double expdamp = FastMath.exp((double)damp);
                            scale3 = 1.0 - expdamp;
                            scale5 = 1.0 - expdamp * (1.0 - damp);
                        }
                        double rr3 = rr1 * rr2;
                        double rr5 = 3.0 * rr3 * rr2;
                        rr3 *= 1.0 - scale3;
                        rr5 *= 1.0 - scale5;
                        double xr = dx[0];
                        double yr = dx[1];
                        double zr = dx[2];
                        double polarK = this.this$1.this$0.polarizability[k];
                        double ukx = polarK * this.this$1.this$0.r[0][k];
                        double uky = polarK * this.this$1.this$0.r[1][k];
                        double ukz = polarK * this.this$1.this$0.r[2][k];
                        double ukr = ukx * xr + uky * yr + ukz * zr;
                        double bn2ukr = bn2 * ukr;
                        double fimx = -bn1 * ukx + bn2ukr * xr;
                        double fimy = -bn1 * uky + bn2ukr * yr;
                        double fimz = -bn1 * ukz + bn2ukr * zr;
                        double rr5ukr = rr5 * ukr;
                        double fidx = -rr3 * ukx + rr5ukr * xr;
                        double fidy = -rr3 * uky + rr5ukr * yr;
                        double fidz = -rr3 * ukz + rr5ukr * zr;
                        fx += fimx - fidx;
                        fy += fimy - fidy;
                        fz += fimz - fidz;
                        double pkx = polarK * this.this$1.this$0.rCR[0][k];
                        double pky = polarK * this.this$1.this$0.rCR[1][k];
                        double pkz = polarK * this.this$1.this$0.rCR[2][k];
                        double pkr = pkx * xr + pky * yr + pkz * zr;
                        double bn2pkr = bn2 * pkr;
                        double pimx = -bn1 * pkx + bn2pkr * xr;
                        double pimy = -bn1 * pky + bn2pkr * yr;
                        double pimz = -bn1 * pkz + bn2pkr * zr;
                        double rr5pkr = rr5 * pkr;
                        double pidx = -rr3 * pkx + rr5pkr * xr;
                        double pidy = -rr3 * pky + rr5pkr * yr;
                        double pidz = -rr3 * pkz + rr5pkr * zr;
                        px += pimx - pidx;
                        py += pimy - pidy;
                        pz += pimz - pidz;
                        double uir = uix * xr + uiy * yr + uiz * zr;
                        double bn2uir = bn2 * uir;
                        double fkmx = -bn1 * uix + bn2uir * xr;
                        double fkmy = -bn1 * uiy + bn2uir * yr;
                        double fkmz = -bn1 * uiz + bn2uir * zr;
                        double rr5uir = rr5 * uir;
                        double fkdx = -rr3 * uix + rr5uir * xr;
                        double fkdy = -rr3 * uiy + rr5uir * yr;
                        double fkdz = -rr3 * uiz + rr5uir * zr;
                        this.this$1.this$0.field.add(this.threadID, k, fkmx - fkdx, fkmy - fkdy, fkmz - fkdz);
                        double pir = pix * xr + piy * yr + piz * zr;
                        double bn2pir = bn2 * pir;
                        double pkmx = -bn1 * pix + bn2pir * xr;
                        double pkmy = -bn1 * piy + bn2pir * yr;
                        double pkmz = -bn1 * piz + bn2pir * zr;
                        double rr5pir = rr5 * pir;
                        double pkdx = -rr3 * pix + rr5pir * xr;
                        double pkdy = -rr3 * piy + rr5pir * yr;
                        double pkdz = -rr3 * piz + rr5pir * zr;
                        this.this$1.this$0.fieldCR.add(this.threadID, k, pkmx - pkdx, pkmy - pkdy, pkmz - pkdz);
                    }
                    this.this$1.this$0.field.add(this.threadID, i, fx, fy, fz);
                    this.this$1.this$0.fieldCR.add(this.threadID, i, px, py, pz);
                }
                List symOps = this.this$1.this$0.crystal.spaceGroup.symOps;
                int nSymm = symOps.size();
                for (int iSymm = 1; iSymm < nSymm; ++iSymm) {
                    SymOp symOp = this.this$1.this$0.crystal.spaceGroup.getSymOp(iSymm);
                    this.this$1.this$0.crystal.getTransformationOperator(symOp, transOp);
                    lists = this.this$1.this$0.preconditionerLists[iSymm];
                    counts = this.this$1.this$0.preconditionerCounts[iSymm];
                    double[] xs = this.this$1.this$0.coordinates[iSymm][0];
                    double[] ys = this.this$1.this$0.coordinates[iSymm][1];
                    double[] zs = this.this$1.this$0.coordinates[iSymm][2];
                    for (int i = lb; i <= ub; ++i) {
                        if (!this.this$1.this$0.use[i]) continue;
                        double fx = 0.0;
                        double fy = 0.0;
                        double fz = 0.0;
                        double px = 0.0;
                        double py = 0.0;
                        double pz = 0.0;
                        double xi = this.x[i];
                        double yi = this.y[i];
                        double zi = this.z[i];
                        double polar = this.this$1.this$0.polarizability[i];
                        double uix = polar * this.this$1.this$0.r[0][i];
                        double uiy = polar * this.this$1.this$0.r[1][i];
                        double uiz = polar * this.this$1.this$0.r[2][i];
                        double pix = polar * this.this$1.this$0.rCR[0][i];
                        double piy = polar * this.this$1.this$0.rCR[1][i];
                        double piz = polar * this.this$1.this$0.rCR[2][i];
                        double pdi = this.this$1.this$0.ipdamp[i];
                        double pti = this.this$1.this$0.thole[i];
                        int[] list = lists[i];
                        int npair = counts[i];
                        for (int j = 0; j < npair; ++j) {
                            double rdamp;
                            int k = list[j];
                            if (!this.this$1.this$0.use[k]) continue;
                            double selfScale = 1.0;
                            if (i == k) {
                                selfScale = 0.5;
                            }
                            double pdk = this.this$1.this$0.ipdamp[k];
                            double ptk = this.this$1.this$0.thole[k];
                            dx[0] = xs[k] - xi;
                            dx[1] = ys[k] - yi;
                            dx[2] = zs[k] - zi;
                            double r2 = this.this$1.this$0.crystal.image(dx);
                            double r = FastMath.sqrt((double)r2);
                            double rr1 = 1.0 / r;
                            double rr2 = rr1 * rr1;
                            double ralpha = this.this$1.this$0.ewaldParameters.aewald * r;
                            double exp2a = FastMath.exp((double)(-ralpha * ralpha));
                            double bn0 = Erf.erfc((double)ralpha) * rr1;
                            double bn1 = (bn0 + this.this$1.this$0.ewaldParameters.an0 * exp2a) * rr2;
                            double bn2 = (3.0 * bn1 + this.this$1.this$0.ewaldParameters.an1 * exp2a) * rr2;
                            double scale3 = 1.0;
                            double scale5 = 1.0;
                            double damp = pdi * pdk;
                            double pgamma = FastMath.min((double)pti, (double)ptk);
                            damp = -pgamma * (rdamp = r * damp) * rdamp * rdamp;
                            if (damp > -50.0) {
                                double expdamp = FastMath.exp((double)damp);
                                scale3 = 1.0 - expdamp;
                                scale5 = 1.0 - expdamp * (1.0 - damp);
                            }
                            double rr3 = rr1 * rr2;
                            double rr5 = 3.0 * rr3 * rr2;
                            rr3 *= 1.0 - scale3;
                            rr5 *= 1.0 - scale5;
                            double xr = dx[0];
                            double yr = dx[1];
                            double zr = dx[2];
                            rk[0] = this.this$1.this$0.r[0][k];
                            rk[1] = this.this$1.this$0.r[1][k];
                            rk[2] = this.this$1.this$0.r[2][k];
                            this.this$1.this$0.crystal.applySymRot(rk, rk, symOp);
                            rCRk[0] = this.this$1.this$0.rCR[0][k];
                            rCRk[1] = this.this$1.this$0.rCR[1][k];
                            rCRk[2] = this.this$1.this$0.rCR[2][k];
                            this.this$1.this$0.crystal.applySymRot(rCRk, rCRk, symOp);
                            double polarK = this.this$1.this$0.polarizability[k];
                            double ukx = polarK * rk[0];
                            double uky = polarK * rk[1];
                            double ukz = polarK * rk[2];
                            double pkx = polarK * rCRk[0];
                            double pky = polarK * rCRk[1];
                            double pkz = polarK * rCRk[2];
                            double ukr = ukx * xr + uky * yr + ukz * zr;
                            double bn2ukr = bn2 * ukr;
                            double fimx = -bn1 * ukx + bn2ukr * xr;
                            double fimy = -bn1 * uky + bn2ukr * yr;
                            double fimz = -bn1 * ukz + bn2ukr * zr;
                            double rr5ukr = rr5 * ukr;
                            double fidx = -rr3 * ukx + rr5ukr * xr;
                            double fidy = -rr3 * uky + rr5ukr * yr;
                            double fidz = -rr3 * ukz + rr5ukr * zr;
                            fx += selfScale * (fimx - fidx);
                            fy += selfScale * (fimy - fidy);
                            fz += selfScale * (fimz - fidz);
                            double pkr = pkx * xr + pky * yr + pkz * zr;
                            double bn2pkr = bn2 * pkr;
                            double pimx = -bn1 * pkx + bn2pkr * xr;
                            double pimy = -bn1 * pky + bn2pkr * yr;
                            double pimz = -bn1 * pkz + bn2pkr * zr;
                            double rr5pkr = rr5 * pkr;
                            double pidx = -rr3 * pkx + rr5pkr * xr;
                            double pidy = -rr3 * pky + rr5pkr * yr;
                            double pidz = -rr3 * pkz + rr5pkr * zr;
                            px += selfScale * (pimx - pidx);
                            py += selfScale * (pimy - pidy);
                            pz += selfScale * (pimz - pidz);
                            double uir = uix * xr + uiy * yr + uiz * zr;
                            double bn2uir = bn2 * uir;
                            double fkmx = -bn1 * uix + bn2uir * xr;
                            double fkmy = -bn1 * uiy + bn2uir * yr;
                            double fkmz = -bn1 * uiz + bn2uir * zr;
                            double rr5uir = rr5 * uir;
                            double fkdx = -rr3 * uix + rr5uir * xr;
                            double fkdy = -rr3 * uiy + rr5uir * yr;
                            double fkdz = -rr3 * uiz + rr5uir * zr;
                            double xc = selfScale * (fkmx - fkdx);
                            double yc = selfScale * (fkmy - fkdy);
                            double zc = selfScale * (fkmz - fkdz);
                            double fkx = xc * transOp[0][0] + yc * transOp[1][0] + zc * transOp[2][0];
                            double fky = xc * transOp[0][1] + yc * transOp[1][1] + zc * transOp[2][1];
                            double fkz = xc * transOp[0][2] + yc * transOp[1][2] + zc * transOp[2][2];
                            this.this$1.this$0.field.add(this.threadID, k, fkx, fky, fkz);
                            double pir = pix * xr + piy * yr + piz * zr;
                            double bn2pir = bn2 * pir;
                            double pkmx = -bn1 * pix + bn2pir * xr;
                            double pkmy = -bn1 * piy + bn2pir * yr;
                            double pkmz = -bn1 * piz + bn2pir * zr;
                            double rr5pir = rr5 * pir;
                            double pkdx = -rr3 * pix + rr5pir * xr;
                            double pkdy = -rr3 * piy + rr5pir * yr;
                            double pkdz = -rr3 * piz + rr5pir * zr;
                            xc = selfScale * (pkmx - pkdx);
                            yc = selfScale * (pkmy - pkdy);
                            zc = selfScale * (pkmz - pkdz);
                            fkx = xc * transOp[0][0] + yc * transOp[1][0] + zc * transOp[2][0];
                            fky = xc * transOp[0][1] + yc * transOp[1][1] + zc * transOp[2][1];
                            fkz = xc * transOp[0][2] + yc * transOp[1][2] + zc * transOp[2][2];
                            this.this$1.this$0.fieldCR.add(this.threadID, k, fkx, fky, fkz);
                        }
                        this.this$1.this$0.field.add(this.threadID, i, fx, fy, fz);
                        this.this$1.this$0.fieldCR.add(this.threadID, i, px, py, pz);
                    }
                }
            }

            public IntegerSchedule schedule() {
                return this.this$1.this$0.realSpaceSchedule;
            }

            public void start() {
                int n = this.threadID = this.getThreadIndex();
                this.this$1.this$0.pmeTimings.realSpaceSCFTime[n] = this.this$1.this$0.pmeTimings.realSpaceSCFTime[n] - System.nanoTime();
                this.x = this.this$1.this$0.coordinates[0][0];
                this.y = this.this$1.this$0.coordinates[0][1];
                this.z = this.this$1.this$0.coordinates[0][2];
            }
        }
    }

    private class InitResidualRegion
    extends ParallelRegion {
        private final InitResidualLoop[] initResidualLoops;
        final /* synthetic */ PCGSolver this$0;

        public InitResidualRegion(PCGSolver pCGSolver, int nt) {
            PCGSolver pCGSolver2 = pCGSolver;
            Objects.requireNonNull(pCGSolver2);
            this.this$0 = pCGSolver2;
            this.initResidualLoops = new InitResidualLoop[nt];
        }

        public void run() throws Exception {
            try {
                int ti = this.getThreadIndex();
                if (this.initResidualLoops[ti] == null) {
                    this.initResidualLoops[ti] = new InitResidualLoop(this);
                }
                int nAtoms = this.this$0.atoms.length;
                this.execute(0, nAtoms - 1, this.initResidualLoops[ti]);
            }
            catch (Exception e) {
                String message = "Fatal exception computing the mutual induced dipoles in thread " + this.getThreadIndex() + "\n";
                logger.log(Level.SEVERE, message, e);
            }
        }

        private class InitResidualLoop
        extends IntegerForLoop {
            final /* synthetic */ InitResidualRegion this$1;

            private InitResidualLoop(InitResidualRegion initResidualRegion) {
                InitResidualRegion initResidualRegion2 = initResidualRegion;
                Objects.requireNonNull(initResidualRegion2);
                this.this$1 = initResidualRegion2;
            }

            public void run(int lb, int ub) throws Exception {
                for (int i = lb; i <= ub; ++i) {
                    if (this.this$1.this$0.use[i] && this.this$1.this$0.polarizability[i] > 0.0) {
                        double ipolar = 1.0 / this.this$1.this$0.polarizability[i];
                        this.this$1.this$0.r[0][i] = (this.this$1.this$0.directDipole[i][0] - this.this$1.this$0.inducedDipole[0][i][0]) * ipolar + this.this$1.this$0.field.getX(i);
                        this.this$1.this$0.r[1][i] = (this.this$1.this$0.directDipole[i][1] - this.this$1.this$0.inducedDipole[0][i][1]) * ipolar + this.this$1.this$0.field.getY(i);
                        this.this$1.this$0.r[2][i] = (this.this$1.this$0.directDipole[i][2] - this.this$1.this$0.inducedDipole[0][i][2]) * ipolar + this.this$1.this$0.field.getZ(i);
                        this.this$1.this$0.rCR[0][i] = (this.this$1.this$0.directDipoleCR[i][0] - this.this$1.this$0.inducedDipoleCR[0][i][0]) * ipolar + this.this$1.this$0.fieldCR.getX(i);
                        this.this$1.this$0.rCR[1][i] = (this.this$1.this$0.directDipoleCR[i][1] - this.this$1.this$0.inducedDipoleCR[0][i][1]) * ipolar + this.this$1.this$0.fieldCR.getY(i);
                        this.this$1.this$0.rCR[2][i] = (this.this$1.this$0.directDipoleCR[i][2] - this.this$1.this$0.inducedDipoleCR[0][i][2]) * ipolar + this.this$1.this$0.fieldCR.getZ(i);
                        continue;
                    }
                    this.this$1.this$0.r[0][i] = 0.0;
                    this.this$1.this$0.r[1][i] = 0.0;
                    this.this$1.this$0.r[2][i] = 0.0;
                    this.this$1.this$0.rCR[0][i] = 0.0;
                    this.this$1.this$0.rCR[1][i] = 0.0;
                    this.this$1.this$0.rCR[2][i] = 0.0;
                }
            }

            public IntegerSchedule schedule() {
                return IntegerSchedule.fixed();
            }
        }
    }

    private class InitConjugateRegion
    extends ParallelRegion {
        private final InitConjugateLoop[] initConjugateLoops;
        final /* synthetic */ PCGSolver this$0;

        public InitConjugateRegion(PCGSolver pCGSolver, int nt) {
            PCGSolver pCGSolver2 = pCGSolver;
            Objects.requireNonNull(pCGSolver2);
            this.this$0 = pCGSolver2;
            this.initConjugateLoops = new InitConjugateLoop[nt];
        }

        public void run() throws Exception {
            try {
                int ti = this.getThreadIndex();
                if (this.initConjugateLoops[ti] == null) {
                    this.initConjugateLoops[ti] = new InitConjugateLoop(this);
                }
                int nAtoms = this.this$0.atoms.length;
                this.execute(0, nAtoms - 1, this.initConjugateLoops[ti]);
            }
            catch (Exception e) {
                String message = "Fatal exception computing the mutual induced dipoles in thread " + this.getThreadIndex() + "\n";
                logger.log(Level.SEVERE, message, e);
            }
        }

        private class InitConjugateLoop
        extends IntegerForLoop {
            final /* synthetic */ InitConjugateRegion this$1;

            private InitConjugateLoop(InitConjugateRegion initConjugateRegion) {
                InitConjugateRegion initConjugateRegion2 = initConjugateRegion;
                Objects.requireNonNull(initConjugateRegion2);
                this.this$1 = initConjugateRegion2;
            }

            public void run(int lb, int ub) throws Exception {
                for (int i = lb; i <= ub; ++i) {
                    if (this.this$1.this$0.use[i]) {
                        double polar = this.this$1.this$0.polarizability[i];
                        this.this$1.this$0.zpre[0][i] = polar * (this.this$1.this$0.field.getX(i) + this.this$1.this$0.preconditionerScale * this.this$1.this$0.r[0][i]);
                        this.this$1.this$0.zpre[1][i] = polar * (this.this$1.this$0.field.getY(i) + this.this$1.this$0.preconditionerScale * this.this$1.this$0.r[1][i]);
                        this.this$1.this$0.zpre[2][i] = polar * (this.this$1.this$0.field.getZ(i) + this.this$1.this$0.preconditionerScale * this.this$1.this$0.r[2][i]);
                        this.this$1.this$0.zpreCR[0][i] = polar * (this.this$1.this$0.fieldCR.getX(i) + this.this$1.this$0.preconditionerScale * this.this$1.this$0.rCR[0][i]);
                        this.this$1.this$0.zpreCR[1][i] = polar * (this.this$1.this$0.fieldCR.getY(i) + this.this$1.this$0.preconditionerScale * this.this$1.this$0.rCR[1][i]);
                        this.this$1.this$0.zpreCR[2][i] = polar * (this.this$1.this$0.fieldCR.getZ(i) + this.this$1.this$0.preconditionerScale * this.this$1.this$0.rCR[2][i]);
                        this.this$1.this$0.p[0][i] = this.this$1.this$0.zpre[0][i];
                        this.this$1.this$0.p[1][i] = this.this$1.this$0.zpre[1][i];
                        this.this$1.this$0.p[2][i] = this.this$1.this$0.zpre[2][i];
                        this.this$1.this$0.pCR[0][i] = this.this$1.this$0.zpreCR[0][i];
                        this.this$1.this$0.pCR[1][i] = this.this$1.this$0.zpreCR[1][i];
                        this.this$1.this$0.pCR[2][i] = this.this$1.this$0.zpreCR[2][i];
                        this.this$1.this$0.vec[0][i] = this.this$1.this$0.inducedDipole[0][i][0];
                        this.this$1.this$0.vec[1][i] = this.this$1.this$0.inducedDipole[0][i][1];
                        this.this$1.this$0.vec[2][i] = this.this$1.this$0.inducedDipole[0][i][2];
                        this.this$1.this$0.vecCR[0][i] = this.this$1.this$0.inducedDipoleCR[0][i][0];
                        this.this$1.this$0.vecCR[1][i] = this.this$1.this$0.inducedDipoleCR[0][i][1];
                        this.this$1.this$0.vecCR[2][i] = this.this$1.this$0.inducedDipoleCR[0][i][2];
                        this.this$1.this$0.inducedDipole[0][i][0] = this.this$1.this$0.p[0][i];
                        this.this$1.this$0.inducedDipole[0][i][1] = this.this$1.this$0.p[1][i];
                        this.this$1.this$0.inducedDipole[0][i][2] = this.this$1.this$0.p[2][i];
                        this.this$1.this$0.inducedDipoleCR[0][i][0] = this.this$1.this$0.pCR[0][i];
                        this.this$1.this$0.inducedDipoleCR[0][i][1] = this.this$1.this$0.pCR[1][i];
                        this.this$1.this$0.inducedDipoleCR[0][i][2] = this.this$1.this$0.pCR[2][i];
                        continue;
                    }
                    this.this$1.this$0.zpre[0][i] = 0.0;
                    this.this$1.this$0.zpre[1][i] = 0.0;
                    this.this$1.this$0.zpre[2][i] = 0.0;
                    this.this$1.this$0.zpreCR[0][i] = 0.0;
                    this.this$1.this$0.zpreCR[1][i] = 0.0;
                    this.this$1.this$0.zpreCR[2][i] = 0.0;
                    this.this$1.this$0.p[0][i] = 0.0;
                    this.this$1.this$0.p[1][i] = 0.0;
                    this.this$1.this$0.p[2][i] = 0.0;
                    this.this$1.this$0.pCR[0][i] = 0.0;
                    this.this$1.this$0.pCR[1][i] = 0.0;
                    this.this$1.this$0.pCR[2][i] = 0.0;
                    this.this$1.this$0.vec[0][i] = 0.0;
                    this.this$1.this$0.vec[1][i] = 0.0;
                    this.this$1.this$0.vec[2][i] = 0.0;
                    this.this$1.this$0.vecCR[0][i] = 0.0;
                    this.this$1.this$0.vecCR[1][i] = 0.0;
                    this.this$1.this$0.vecCR[2][i] = 0.0;
                    this.this$1.this$0.inducedDipole[0][i][0] = 0.0;
                    this.this$1.this$0.inducedDipole[0][i][1] = 0.0;
                    this.this$1.this$0.inducedDipole[0][i][2] = 0.0;
                    this.this$1.this$0.inducedDipoleCR[0][i][0] = 0.0;
                    this.this$1.this$0.inducedDipoleCR[0][i][1] = 0.0;
                    this.this$1.this$0.inducedDipoleCR[0][i][2] = 0.0;
                }
            }

            public IntegerSchedule schedule() {
                return IntegerSchedule.fixed();
            }
        }
    }

    private class UpdateResidualRegion
    extends ParallelRegion {
        private final UpdateApLoop[] updateApLoops;
        private final UpdateResidualAndInducedLoop[] updateResidualAndInducedLoops;
        private final SharedDouble pDotApShared;
        private final SharedDouble pDotApCRShared;
        private final SharedDouble rDotZShared;
        private final SharedDouble rDotZCRShared;
        private final SharedDouble epsShared;
        private final SharedDouble epsCRShared;
        final /* synthetic */ PCGSolver this$0;

        public UpdateResidualRegion(PCGSolver pCGSolver, int nt) {
            PCGSolver pCGSolver2 = pCGSolver;
            Objects.requireNonNull(pCGSolver2);
            this.this$0 = pCGSolver2;
            this.updateApLoops = new UpdateApLoop[nt];
            this.updateResidualAndInducedLoops = new UpdateResidualAndInducedLoop[nt];
            this.pDotApShared = new SharedDouble();
            this.pDotApCRShared = new SharedDouble();
            this.rDotZShared = new SharedDouble();
            this.rDotZCRShared = new SharedDouble();
            this.epsShared = new SharedDouble();
            this.epsCRShared = new SharedDouble();
        }

        public double getRDotZ() {
            return this.rDotZShared.get();
        }

        public double getRDotZCR() {
            return this.rDotZCRShared.get();
        }

        public double getEps() {
            return this.epsShared.get();
        }

        public double getEpsCR() {
            return this.epsCRShared.get();
        }

        public void run() throws Exception {
            try {
                int ti = this.getThreadIndex();
                int nAtoms = this.this$0.atoms.length;
                if (this.updateApLoops[ti] == null) {
                    this.updateApLoops[ti] = new UpdateApLoop(this);
                    this.updateResidualAndInducedLoops[ti] = new UpdateResidualAndInducedLoop(this);
                }
                this.execute(0, nAtoms - 1, this.updateApLoops[ti]);
                this.execute(0, nAtoms - 1, this.updateResidualAndInducedLoops[ti]);
            }
            catch (Exception e) {
                String message = "Fatal exception computing the mutual induced dipoles in thread " + this.getThreadIndex() + "\n";
                logger.log(Level.SEVERE, message, e);
            }
        }

        public void start() {
            this.pDotApShared.set(0.0);
            this.pDotApCRShared.set(0.0);
            this.rDotZShared.set(0.0);
            this.rDotZCRShared.set(0.0);
            this.epsShared.set(0.0);
            this.epsCRShared.set(0.0);
        }

        private class UpdateApLoop
        extends IntegerForLoop {
            public double pDotAp;
            public double pDotApCR;
            public double rDotZ;
            public double rDotZCR;
            final /* synthetic */ UpdateResidualRegion this$1;

            private UpdateApLoop(UpdateResidualRegion updateResidualRegion) {
                UpdateResidualRegion updateResidualRegion2 = updateResidualRegion;
                Objects.requireNonNull(updateResidualRegion2);
                this.this$1 = updateResidualRegion2;
            }

            public void finish() {
                this.this$1.pDotApShared.addAndGet(this.pDotAp);
                this.this$1.pDotApCRShared.addAndGet(this.pDotApCR);
                this.this$1.rDotZShared.addAndGet(this.rDotZ);
                this.this$1.rDotZCRShared.addAndGet(this.rDotZCR);
            }

            public void run(int lb, int ub) throws Exception {
                for (int i = lb; i <= ub; ++i) {
                    if (this.this$1.this$0.use[i] && this.this$1.this$0.polarizability[i] > 0.0) {
                        double ipolar = 1.0 / this.this$1.this$0.polarizability[i];
                        this.this$1.this$0.inducedDipole[0][i][0] = this.this$1.this$0.vec[0][i];
                        this.this$1.this$0.inducedDipole[0][i][1] = this.this$1.this$0.vec[1][i];
                        this.this$1.this$0.inducedDipole[0][i][2] = this.this$1.this$0.vec[2][i];
                        this.this$1.this$0.inducedDipoleCR[0][i][0] = this.this$1.this$0.vecCR[0][i];
                        this.this$1.this$0.inducedDipoleCR[0][i][1] = this.this$1.this$0.vecCR[1][i];
                        this.this$1.this$0.inducedDipoleCR[0][i][2] = this.this$1.this$0.vecCR[2][i];
                        this.this$1.this$0.vec[0][i] = this.this$1.this$0.p[0][i] * ipolar - this.this$1.this$0.field.getX(i);
                        this.this$1.this$0.vec[1][i] = this.this$1.this$0.p[1][i] * ipolar - this.this$1.this$0.field.getY(i);
                        this.this$1.this$0.vec[2][i] = this.this$1.this$0.p[2][i] * ipolar - this.this$1.this$0.field.getZ(i);
                        this.this$1.this$0.vecCR[0][i] = this.this$1.this$0.pCR[0][i] * ipolar - this.this$1.this$0.fieldCR.getX(i);
                        this.this$1.this$0.vecCR[1][i] = this.this$1.this$0.pCR[1][i] * ipolar - this.this$1.this$0.fieldCR.getY(i);
                        this.this$1.this$0.vecCR[2][i] = this.this$1.this$0.pCR[2][i] * ipolar - this.this$1.this$0.fieldCR.getZ(i);
                    } else {
                        this.this$1.this$0.inducedDipole[0][i][0] = 0.0;
                        this.this$1.this$0.inducedDipole[0][i][1] = 0.0;
                        this.this$1.this$0.inducedDipole[0][i][2] = 0.0;
                        this.this$1.this$0.inducedDipoleCR[0][i][0] = 0.0;
                        this.this$1.this$0.inducedDipoleCR[0][i][1] = 0.0;
                        this.this$1.this$0.inducedDipoleCR[0][i][2] = 0.0;
                        this.this$1.this$0.vec[0][i] = 0.0;
                        this.this$1.this$0.vec[1][i] = 0.0;
                        this.this$1.this$0.vec[2][i] = 0.0;
                        this.this$1.this$0.vecCR[0][i] = 0.0;
                        this.this$1.this$0.vecCR[1][i] = 0.0;
                        this.this$1.this$0.vecCR[2][i] = 0.0;
                    }
                    this.pDotAp += this.this$1.this$0.p[0][i] * this.this$1.this$0.vec[0][i] + this.this$1.this$0.p[1][i] * this.this$1.this$0.vec[1][i] + this.this$1.this$0.p[2][i] * this.this$1.this$0.vec[2][i];
                    this.pDotApCR += this.this$1.this$0.pCR[0][i] * this.this$1.this$0.vecCR[0][i] + this.this$1.this$0.pCR[1][i] * this.this$1.this$0.vecCR[1][i] + this.this$1.this$0.pCR[2][i] * this.this$1.this$0.vecCR[2][i];
                    this.rDotZ += this.this$1.this$0.r[0][i] * this.this$1.this$0.zpre[0][i] + this.this$1.this$0.r[1][i] * this.this$1.this$0.zpre[1][i] + this.this$1.this$0.r[2][i] * this.this$1.this$0.zpre[2][i];
                    this.rDotZCR += this.this$1.this$0.rCR[0][i] * this.this$1.this$0.zpreCR[0][i] + this.this$1.this$0.rCR[1][i] * this.this$1.this$0.zpreCR[1][i] + this.this$1.this$0.rCR[2][i] * this.this$1.this$0.zpreCR[2][i];
                }
            }

            public IntegerSchedule schedule() {
                return IntegerSchedule.fixed();
            }

            public void start() {
                this.pDotAp = 0.0;
                this.pDotApCR = 0.0;
                this.rDotZ = 0.0;
                this.rDotZCR = 0.0;
            }
        }

        private class UpdateResidualAndInducedLoop
        extends IntegerForLoop {
            double eps;
            double epsCR;
            final /* synthetic */ UpdateResidualRegion this$1;

            private UpdateResidualAndInducedLoop(UpdateResidualRegion updateResidualRegion) {
                UpdateResidualRegion updateResidualRegion2 = updateResidualRegion;
                Objects.requireNonNull(updateResidualRegion2);
                this.this$1 = updateResidualRegion2;
            }

            public void start() {
                this.eps = 0.0;
                this.epsCR = 0.0;
            }

            public void finish() {
                this.this$1.epsShared.addAndGet(this.eps);
                this.this$1.epsCRShared.addAndGet(this.epsCR);
            }

            public void run(int lb, int ub) throws Exception {
                double alpha = this.this$1.rDotZShared.get();
                if (this.this$1.pDotApShared.get() != 0.0) {
                    alpha /= this.this$1.pDotApShared.get();
                }
                double alphaCR = this.this$1.rDotZCRShared.get();
                if (this.this$1.pDotApCRShared.get() != 0.0) {
                    alphaCR /= this.this$1.pDotApCRShared.get();
                }
                for (int i = lb; i <= ub; ++i) {
                    if (this.this$1.this$0.use[i]) {
                        double[] dArray = this.this$1.this$0.r[0];
                        int n = i;
                        dArray[n] = dArray[n] - alpha * this.this$1.this$0.vec[0][i];
                        double[] dArray2 = this.this$1.this$0.r[1];
                        int n2 = i;
                        dArray2[n2] = dArray2[n2] - alpha * this.this$1.this$0.vec[1][i];
                        double[] dArray3 = this.this$1.this$0.r[2];
                        int n3 = i;
                        dArray3[n3] = dArray3[n3] - alpha * this.this$1.this$0.vec[2][i];
                        double[] dArray4 = this.this$1.this$0.rCR[0];
                        int n4 = i;
                        dArray4[n4] = dArray4[n4] - alphaCR * this.this$1.this$0.vecCR[0][i];
                        double[] dArray5 = this.this$1.this$0.rCR[1];
                        int n5 = i;
                        dArray5[n5] = dArray5[n5] - alphaCR * this.this$1.this$0.vecCR[1][i];
                        double[] dArray6 = this.this$1.this$0.rCR[2];
                        int n6 = i;
                        dArray6[n6] = dArray6[n6] - alphaCR * this.this$1.this$0.vecCR[2][i];
                        double[] dArray7 = this.this$1.this$0.inducedDipole[0][i];
                        dArray7[0] = dArray7[0] + alpha * this.this$1.this$0.p[0][i];
                        double[] dArray8 = this.this$1.this$0.inducedDipole[0][i];
                        dArray8[1] = dArray8[1] + alpha * this.this$1.this$0.p[1][i];
                        double[] dArray9 = this.this$1.this$0.inducedDipole[0][i];
                        dArray9[2] = dArray9[2] + alpha * this.this$1.this$0.p[2][i];
                        double[] dArray10 = this.this$1.this$0.inducedDipoleCR[0][i];
                        dArray10[0] = dArray10[0] + alphaCR * this.this$1.this$0.pCR[0][i];
                        double[] dArray11 = this.this$1.this$0.inducedDipoleCR[0][i];
                        dArray11[1] = dArray11[1] + alphaCR * this.this$1.this$0.pCR[1][i];
                        double[] dArray12 = this.this$1.this$0.inducedDipoleCR[0][i];
                        dArray12[2] = dArray12[2] + alphaCR * this.this$1.this$0.pCR[2][i];
                        this.eps += this.this$1.this$0.r[0][i] * this.this$1.this$0.r[0][i] + this.this$1.this$0.r[1][i] * this.this$1.this$0.r[1][i] + this.this$1.this$0.r[2][i] * this.this$1.this$0.r[2][i];
                        this.epsCR += this.this$1.this$0.rCR[0][i] * this.this$1.this$0.rCR[0][i] + this.this$1.this$0.rCR[1][i] * this.this$1.this$0.rCR[1][i] + this.this$1.this$0.rCR[2][i] * this.this$1.this$0.rCR[2][i];
                        continue;
                    }
                    this.this$1.this$0.r[0][i] = 0.0;
                    this.this$1.this$0.r[1][i] = 0.0;
                    this.this$1.this$0.r[2][i] = 0.0;
                    this.this$1.this$0.rCR[0][i] = 0.0;
                    this.this$1.this$0.rCR[1][i] = 0.0;
                    this.this$1.this$0.rCR[2][i] = 0.0;
                    this.this$1.this$0.inducedDipole[0][i][0] = 0.0;
                    this.this$1.this$0.inducedDipole[0][i][1] = 0.0;
                    this.this$1.this$0.inducedDipole[0][i][2] = 0.0;
                    this.this$1.this$0.inducedDipoleCR[0][i][0] = 0.0;
                    this.this$1.this$0.inducedDipoleCR[0][i][1] = 0.0;
                    this.this$1.this$0.inducedDipoleCR[0][i][2] = 0.0;
                }
            }

            public IntegerSchedule schedule() {
                return IntegerSchedule.fixed();
            }
        }
    }

    private class UpdateConjugateRegion
    extends ParallelRegion {
        private final UpdatePreconditionerLoop[] updatePreconditionerLoops;
        private final UpdateConjugateLoop[] updateConjugateLoops;
        private final SharedDouble betaShared;
        private final SharedDouble betaCRShared;
        public double previousRDotZ;
        public double previousRDotZCR;
        final /* synthetic */ PCGSolver this$0;

        public UpdateConjugateRegion(PCGSolver pCGSolver, int nt) {
            PCGSolver pCGSolver2 = pCGSolver;
            Objects.requireNonNull(pCGSolver2);
            this.this$0 = pCGSolver2;
            this.updatePreconditionerLoops = new UpdatePreconditionerLoop[nt];
            this.updateConjugateLoops = new UpdateConjugateLoop[nt];
            this.betaShared = new SharedDouble();
            this.betaCRShared = new SharedDouble();
        }

        public void run() throws Exception {
            try {
                int ti = this.getThreadIndex();
                if (this.updatePreconditionerLoops[ti] == null) {
                    this.updatePreconditionerLoops[ti] = new UpdatePreconditionerLoop(this);
                    this.updateConjugateLoops[ti] = new UpdateConjugateLoop(this);
                }
                int nAtoms = this.this$0.atoms.length;
                this.execute(0, nAtoms - 1, this.updatePreconditionerLoops[ti]);
                this.execute(0, nAtoms - 1, this.updateConjugateLoops[ti]);
            }
            catch (Exception e) {
                String message = "Fatal exception computing the mutual induced dipoles in thread " + this.getThreadIndex() + "\n";
                logger.log(Level.SEVERE, message, e);
            }
        }

        public void start() {
            this.betaShared.set(0.0);
            this.betaCRShared.set(0.0);
            if (this.previousRDotZ == 0.0) {
                this.previousRDotZ = 1.0;
            }
            if (this.previousRDotZCR == 0.0) {
                this.previousRDotZCR = 1.0;
            }
        }

        private class UpdatePreconditionerLoop
        extends IntegerForLoop {
            public double rDotZ;
            public double rDotZCR;
            private final double[] deltaZ;
            private final double[] deltaZCR;
            final /* synthetic */ UpdateConjugateRegion this$1;

            private UpdatePreconditionerLoop(UpdateConjugateRegion updateConjugateRegion) {
                UpdateConjugateRegion updateConjugateRegion2 = updateConjugateRegion;
                Objects.requireNonNull(updateConjugateRegion2);
                this.this$1 = updateConjugateRegion2;
                this.deltaZ = new double[3];
                this.deltaZCR = new double[3];
            }

            public void finish() {
                this.this$1.betaShared.addAndGet(this.rDotZ / this.this$1.previousRDotZ);
                this.this$1.betaCRShared.addAndGet(this.rDotZCR / this.this$1.previousRDotZCR);
            }

            public void run(int lb, int ub) throws Exception {
                for (int i = lb; i <= ub; ++i) {
                    if (this.this$1.this$0.use[i]) {
                        this.deltaZ[0] = -this.this$1.this$0.zpre[0][i];
                        this.deltaZ[1] = -this.this$1.this$0.zpre[1][i];
                        this.deltaZ[2] = -this.this$1.this$0.zpre[2][i];
                        this.deltaZCR[0] = -this.this$1.this$0.zpreCR[0][i];
                        this.deltaZCR[1] = -this.this$1.this$0.zpreCR[1][i];
                        this.deltaZCR[2] = -this.this$1.this$0.zpreCR[2][i];
                        double polar = this.this$1.this$0.polarizability[i];
                        this.this$1.this$0.zpre[0][i] = polar * (this.this$1.this$0.field.getX(i) + this.this$1.this$0.preconditionerScale * this.this$1.this$0.r[0][i]);
                        this.this$1.this$0.zpre[1][i] = polar * (this.this$1.this$0.field.getY(i) + this.this$1.this$0.preconditionerScale * this.this$1.this$0.r[1][i]);
                        this.this$1.this$0.zpre[2][i] = polar * (this.this$1.this$0.field.getZ(i) + this.this$1.this$0.preconditionerScale * this.this$1.this$0.r[2][i]);
                        this.this$1.this$0.zpreCR[0][i] = polar * (this.this$1.this$0.fieldCR.getX(i) + this.this$1.this$0.preconditionerScale * this.this$1.this$0.rCR[0][i]);
                        this.this$1.this$0.zpreCR[1][i] = polar * (this.this$1.this$0.fieldCR.getY(i) + this.this$1.this$0.preconditionerScale * this.this$1.this$0.rCR[1][i]);
                        this.this$1.this$0.zpreCR[2][i] = polar * (this.this$1.this$0.fieldCR.getZ(i) + this.this$1.this$0.preconditionerScale * this.this$1.this$0.rCR[2][i]);
                        switch (this.this$1.this$0.preconditionMode.ordinal()) {
                            case 1: {
                                this.deltaZ[0] = this.deltaZ[0] + this.this$1.this$0.zpre[0][i];
                                this.deltaZ[1] = this.deltaZ[1] + this.this$1.this$0.zpre[1][i];
                                this.deltaZ[2] = this.deltaZ[2] + this.this$1.this$0.zpre[2][i];
                                this.deltaZCR[0] = this.deltaZCR[0] + this.this$1.this$0.zpreCR[0][i];
                                this.deltaZCR[1] = this.deltaZCR[1] + this.this$1.this$0.zpreCR[1][i];
                                this.deltaZCR[2] = this.deltaZCR[2] + this.this$1.this$0.zpreCR[2][i];
                                this.rDotZ += this.this$1.this$0.r[0][i] * this.deltaZ[0] + this.this$1.this$0.r[1][i] * this.deltaZ[1] + this.this$1.this$0.r[2][i] * this.deltaZ[2];
                                this.rDotZCR += this.this$1.this$0.rCR[0][i] * this.deltaZCR[0] + this.this$1.this$0.rCR[1][i] * this.deltaZCR[1] + this.this$1.this$0.rCR[2][i] * this.deltaZCR[2];
                                break;
                            }
                            case 2: {
                                break;
                            }
                            default: {
                                this.rDotZ += this.this$1.this$0.r[0][i] * this.this$1.this$0.zpre[0][i] + this.this$1.this$0.r[1][i] * this.this$1.this$0.zpre[1][i] + this.this$1.this$0.r[2][i] * this.this$1.this$0.zpre[2][i];
                                this.rDotZCR += this.this$1.this$0.rCR[0][i] * this.this$1.this$0.zpreCR[0][i] + this.this$1.this$0.rCR[1][i] * this.this$1.this$0.zpreCR[1][i] + this.this$1.this$0.rCR[2][i] * this.this$1.this$0.zpreCR[2][i];
                                break;
                            }
                        }
                        continue;
                    }
                    this.this$1.this$0.zpre[0][i] = 0.0;
                    this.this$1.this$0.zpre[1][i] = 0.0;
                    this.this$1.this$0.zpre[2][i] = 0.0;
                    this.this$1.this$0.zpreCR[0][i] = 0.0;
                    this.this$1.this$0.zpreCR[1][i] = 0.0;
                    this.this$1.this$0.zpreCR[2][i] = 0.0;
                }
            }

            public IntegerSchedule schedule() {
                return IntegerSchedule.fixed();
            }

            public void start() {
                this.rDotZ = 0.0;
                this.rDotZCR = 0.0;
            }
        }

        private class UpdateConjugateLoop
        extends IntegerForLoop {
            final /* synthetic */ UpdateConjugateRegion this$1;

            private UpdateConjugateLoop(UpdateConjugateRegion updateConjugateRegion) {
                UpdateConjugateRegion updateConjugateRegion2 = updateConjugateRegion;
                Objects.requireNonNull(updateConjugateRegion2);
                this.this$1 = updateConjugateRegion2;
            }

            public void run(int lb, int ub) throws Exception {
                double beta = this.this$1.betaShared.get();
                double betaCR = this.this$1.betaCRShared.get();
                for (int i = lb; i <= ub; ++i) {
                    if (this.this$1.this$0.use[i]) {
                        this.this$1.this$0.p[0][i] = this.this$1.this$0.zpre[0][i] + beta * this.this$1.this$0.p[0][i];
                        this.this$1.this$0.p[1][i] = this.this$1.this$0.zpre[1][i] + beta * this.this$1.this$0.p[1][i];
                        this.this$1.this$0.p[2][i] = this.this$1.this$0.zpre[2][i] + beta * this.this$1.this$0.p[2][i];
                        this.this$1.this$0.pCR[0][i] = this.this$1.this$0.zpreCR[0][i] + betaCR * this.this$1.this$0.pCR[0][i];
                        this.this$1.this$0.pCR[1][i] = this.this$1.this$0.zpreCR[1][i] + betaCR * this.this$1.this$0.pCR[1][i];
                        this.this$1.this$0.pCR[2][i] = this.this$1.this$0.zpreCR[2][i] + betaCR * this.this$1.this$0.pCR[2][i];
                        this.this$1.this$0.vec[0][i] = this.this$1.this$0.inducedDipole[0][i][0];
                        this.this$1.this$0.vec[1][i] = this.this$1.this$0.inducedDipole[0][i][1];
                        this.this$1.this$0.vec[2][i] = this.this$1.this$0.inducedDipole[0][i][2];
                        this.this$1.this$0.vecCR[0][i] = this.this$1.this$0.inducedDipoleCR[0][i][0];
                        this.this$1.this$0.vecCR[1][i] = this.this$1.this$0.inducedDipoleCR[0][i][1];
                        this.this$1.this$0.vecCR[2][i] = this.this$1.this$0.inducedDipoleCR[0][i][2];
                        this.this$1.this$0.inducedDipole[0][i][0] = this.this$1.this$0.p[0][i];
                        this.this$1.this$0.inducedDipole[0][i][1] = this.this$1.this$0.p[1][i];
                        this.this$1.this$0.inducedDipole[0][i][2] = this.this$1.this$0.p[2][i];
                        this.this$1.this$0.inducedDipoleCR[0][i][0] = this.this$1.this$0.pCR[0][i];
                        this.this$1.this$0.inducedDipoleCR[0][i][1] = this.this$1.this$0.pCR[1][i];
                        this.this$1.this$0.inducedDipoleCR[0][i][2] = this.this$1.this$0.pCR[2][i];
                        continue;
                    }
                    this.this$1.this$0.p[0][i] = 0.0;
                    this.this$1.this$0.p[1][i] = 0.0;
                    this.this$1.this$0.p[2][i] = 0.0;
                    this.this$1.this$0.pCR[0][i] = 0.0;
                    this.this$1.this$0.pCR[1][i] = 0.0;
                    this.this$1.this$0.pCR[2][i] = 0.0;
                    this.this$1.this$0.vec[0][i] = 0.0;
                    this.this$1.this$0.vec[1][i] = 0.0;
                    this.this$1.this$0.vec[2][i] = 0.0;
                    this.this$1.this$0.vecCR[0][i] = 0.0;
                    this.this$1.this$0.vecCR[1][i] = 0.0;
                    this.this$1.this$0.vecCR[2][i] = 0.0;
                    this.this$1.this$0.inducedDipole[0][i][0] = 0.0;
                    this.this$1.this$0.inducedDipole[0][i][1] = 0.0;
                    this.this$1.this$0.inducedDipole[0][i][2] = 0.0;
                    this.this$1.this$0.inducedDipoleCR[0][i][0] = 0.0;
                    this.this$1.this$0.inducedDipoleCR[0][i][1] = 0.0;
                    this.this$1.this$0.inducedDipoleCR[0][i][2] = 0.0;
                }
            }

            public IntegerSchedule schedule() {
                return IntegerSchedule.fixed();
            }
        }
    }

    private static enum PRECONDITION_MODE {
        FLETCHER_REEVES,
        FLEXIBLE,
        STEEPEST_DECENT;

    }
}

