/*
 * Decompiled with CFR 0.152.
 */
package ffx.potential.nonbonded.pme;

import edu.rit.pj.IntegerForLoop;
import edu.rit.pj.IntegerSchedule;
import edu.rit.pj.ParallelRegion;
import edu.rit.pj.ParallelTeam;
import ffx.numerics.atomic.AtomicDoubleArray3D;
import ffx.potential.bonded.Atom;
import ffx.potential.nonbonded.GeneralizedKirkwood;
import ffx.potential.nonbonded.pme.DirectRegion;
import ffx.potential.nonbonded.pme.EwaldParameters;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;

public class InducedDipoleFieldReduceRegion
extends ParallelRegion {
    private static final Logger logger = Logger.getLogger(DirectRegion.class.getName());
    private final InducedDipoleFieldReduceLoop[] inducedDipoleFieldReduceLoop;
    public double[][][] inducedDipole;
    public double[][][] inducedDipoleCR;
    private Atom[] atoms;
    private double[][] cartesianDipolePhi;
    private double[][] cartesianDipolePhiCR;
    private AtomicDoubleArray3D field;
    private AtomicDoubleArray3D fieldCR;
    private boolean generalizedKirkwoodTerm;
    private GeneralizedKirkwood generalizedKirkwood;
    private double aewald;
    private double aewald3;
    private double soluteDielectric;

    public InducedDipoleFieldReduceRegion(int nt) {
        this.inducedDipoleFieldReduceLoop = new InducedDipoleFieldReduceLoop[nt];
    }

    public void executeWith(ParallelTeam parallelTeam) {
        try {
            parallelTeam.execute((ParallelRegion)this);
        }
        catch (Exception e) {
            String message = " Exception computing induced dipole field.\n";
            logger.log(Level.WARNING, message, e);
        }
    }

    public void init(Atom[] atoms, double[][][] inducedDipole, double[][][] inducedDipoleCR, boolean generalizedKirkwoodTerm, GeneralizedKirkwood generalizedKirkwood, EwaldParameters ewaldParameters, double soluteDielectric, double[][] cartesianDipolePhi, double[][] cartesianDipolePhiCR, AtomicDoubleArray3D field, AtomicDoubleArray3D fieldCR) {
        this.atoms = atoms;
        this.inducedDipole = inducedDipole;
        this.inducedDipoleCR = inducedDipoleCR;
        this.generalizedKirkwoodTerm = generalizedKirkwoodTerm;
        this.generalizedKirkwood = generalizedKirkwood;
        this.aewald = ewaldParameters.aewald;
        this.aewald3 = ewaldParameters.aewald3;
        this.soluteDielectric = soluteDielectric;
        this.cartesianDipolePhi = cartesianDipolePhi;
        this.cartesianDipolePhiCR = cartesianDipolePhiCR;
        this.field = field;
        this.fieldCR = fieldCR;
    }

    public void run() throws Exception {
        try {
            int threadID = this.getThreadIndex();
            if (this.inducedDipoleFieldReduceLoop[threadID] == null) {
                this.inducedDipoleFieldReduceLoop[threadID] = new InducedDipoleFieldReduceLoop(this);
            }
            int nAtoms = this.atoms.length;
            this.execute(0, nAtoms - 1, this.inducedDipoleFieldReduceLoop[threadID]);
        }
        catch (Exception e) {
            String message = " Fatal exception computing the mutual induced dipoles in thread " + this.getThreadIndex() + "\n";
            logger.log(Level.SEVERE, message, e);
        }
    }

    private class InducedDipoleFieldReduceLoop
    extends IntegerForLoop {
        final /* synthetic */ InducedDipoleFieldReduceRegion this$0;

        private InducedDipoleFieldReduceLoop(InducedDipoleFieldReduceRegion inducedDipoleFieldReduceRegion) {
            InducedDipoleFieldReduceRegion inducedDipoleFieldReduceRegion2 = inducedDipoleFieldReduceRegion;
            Objects.requireNonNull(inducedDipoleFieldReduceRegion2);
            this.this$0 = inducedDipoleFieldReduceRegion2;
        }

        public void run(int lb, int ub) throws Exception {
            int threadID = this.getThreadIndex();
            double[][] induced0 = this.this$0.inducedDipole[0];
            double[][] inducedCR0 = this.this$0.inducedDipoleCR[0];
            if (this.this$0.aewald > 0.0) {
                for (int i = lb; i <= ub; ++i) {
                    double[] dipolei = induced0[i];
                    double[] dipoleCRi = inducedCR0[i];
                    double[] phii = this.this$0.cartesianDipolePhi[i];
                    double[] phiCRi = this.this$0.cartesianDipolePhiCR[i];
                    double fx = this.this$0.aewald3 * dipolei[0] - phii[1];
                    double fy = this.this$0.aewald3 * dipolei[1] - phii[2];
                    double fz = this.this$0.aewald3 * dipolei[2] - phii[3];
                    double fxCR = this.this$0.aewald3 * dipoleCRi[0] - phiCRi[1];
                    double fyCR = this.this$0.aewald3 * dipoleCRi[1] - phiCRi[2];
                    double fzCR = this.this$0.aewald3 * dipoleCRi[2] - phiCRi[3];
                    this.this$0.field.add(threadID, i, fx, fy, fz);
                    this.this$0.fieldCR.add(threadID, i, fxCR, fyCR, fzCR);
                }
            }
            this.this$0.field.reduce(lb, ub);
            this.this$0.fieldCR.reduce(lb, ub);
            if (this.this$0.soluteDielectric > 1.0) {
                double inverseDielectric = 1.0 / this.this$0.soluteDielectric;
                for (int i = lb; i <= ub; ++i) {
                    this.this$0.field.scale(0, i, inverseDielectric);
                    this.this$0.fieldCR.scale(0, i, inverseDielectric);
                }
            }
            if (this.this$0.generalizedKirkwoodTerm) {
                AtomicDoubleArray3D fieldGK = this.this$0.generalizedKirkwood.getFieldGK();
                AtomicDoubleArray3D fieldGKCR = this.this$0.generalizedKirkwood.getFieldGKCR();
                for (int i = lb; i <= ub; ++i) {
                    this.this$0.field.add(0, i, fieldGK.getX(i), fieldGK.getY(i), fieldGK.getZ(i));
                    this.this$0.fieldCR.add(0, i, fieldGKCR.getX(i), fieldGKCR.getY(i), fieldGKCR.getZ(i));
                }
            }
        }

        public IntegerSchedule schedule() {
            return IntegerSchedule.fixed();
        }
    }
}

