/*
 * Decompiled with CFR 0.152.
 */
package ffx.potential.nonbonded.pme;

import edu.rit.pj.IntegerSchedule;
import edu.rit.util.Range;
import ffx.crystal.Crystal;
import ffx.potential.nonbonded.pme.Polarization;
import ffx.potential.parameters.ForceField;
import java.util.logging.Logger;
import org.apache.commons.math3.util.FastMath;

public class AlchemicalParameters {
    private static final Logger logger = Logger.getLogger(AlchemicalParameters.class.getName());
    private final Polarization polarization;
    public final AlchemicalMode mode;
    public double permLambdaAlpha = 1.0;
    public double permLambdaExponent = 3.0;
    public double permLambdaStart = 0.4;
    public double permLambdaEnd = 1.0;
    public double polLambdaStart = 0.75;
    public double polLambdaEnd = 1.0;
    public double polLambdaExponent = 3.0;
    public boolean doLigandVaporElec = true;
    public boolean doLigandGKElec = false;
    public boolean doNoLigandCondensedSCF = true;
    public double lAlpha = 0.0;
    public double dlAlpha = 0.0;
    public double d2lAlpha = 0.0;
    public double dEdLSign = 1.0;
    public double lPowPerm = 1.0;
    public double dlPowPerm = 0.0;
    public double d2lPowPerm = 0.0;
    public boolean doPermanentRealSpace = true;
    public double permanentScale = 1.0;
    public double lPowPol = 1.0;
    public double dlPowPol = 0.0;
    public double d2lPowPol = 0.0;
    public boolean doPolarization = true;
    public double polarizationScale = 1.0;
    public double polLambda = 1.0;
    public double permLambda = 1.0;
    public Crystal vaporCrystal = null;
    public int[][][] vaporLists = null;
    public Range[] vacuumRanges = null;
    public IntegerSchedule vaporPermanentSchedule = null;
    public IntegerSchedule vaporEwaldSchedule = null;

    public AlchemicalParameters(ForceField forceField, boolean lambdaTerm, boolean nnTerm, Polarization polarization) {
        AlchemicalMode tempMode;
        this.polarization = polarization;
        try {
            tempMode = AlchemicalMode.valueOf(forceField.getString("ALCHEMICAL_MODE", "OST").toUpperCase());
        }
        catch (IllegalArgumentException e) {
            logger.info(" Invalid value for alchemical-mode; reverting to OST");
            tempMode = AlchemicalMode.OST;
        }
        this.mode = tempMode;
        if (lambdaTerm) {
            this.permLambdaAlpha = forceField.getDouble("PERMANENT_LAMBDA_ALPHA", 2.0);
            if (this.permLambdaAlpha < 0.0 || this.permLambdaAlpha > 3.0) {
                logger.warning("Invalid value for permanent-lambda-alpha (<0.0 || >3.0); reverting to 2.0");
                this.permLambdaAlpha = 2.0;
            }
            this.permLambdaExponent = forceField.getDouble("PERMANENT_LAMBDA_EXPONENT", 3.0);
            if (this.permLambdaExponent < 0.0) {
                logger.warning("Invalid value for permanent-lambda-exponent (<0.0); reverting to 3.0");
                this.permLambdaExponent = 3.0;
            }
            this.polLambdaExponent = forceField.getDouble("POLARIZATION_LAMBDA_EXPONENT", 3.0);
            if (this.polLambdaExponent < 0.0) {
                logger.warning("Invalid value for polarization-lambda-exponent (<0.0); reverting to 3.0");
                this.polLambdaExponent = 3.0;
            }
            this.permLambdaStart = forceField.getDouble("PERMANENT_LAMBDA_START", 0.4);
            if (this.permLambdaStart < 0.0 || this.permLambdaStart > 1.0) {
                logger.warning("Invalid value for perm-lambda-start (<0.0 || >1.0); reverting to 0.4");
                this.permLambdaStart = 0.4;
            }
            this.permLambdaEnd = forceField.getDouble("PERMANENT_LAMBDA_END", 1.0);
            if (this.permLambdaEnd < this.permLambdaStart || this.permLambdaEnd > 1.0) {
                logger.warning("Invalid value for perm-lambda-end (<start || >1.0); reverting to 1.0");
                this.permLambdaEnd = 1.0;
            }
            this.polLambdaStart = forceField.getDouble("POLARIZATION_LAMBDA_START", 0.75);
            if (this.polLambdaStart < 0.0 || this.polLambdaStart > 1.0) {
                logger.warning("Invalid value for polarization-lambda-start; reverting to 0.75");
                this.polLambdaStart = 0.75;
            }
            this.polLambdaEnd = forceField.getDouble("POLARIZATION_LAMBDA_END", 1.0);
            if (this.polLambdaEnd < this.polLambdaStart || this.polLambdaEnd > 1.0) {
                logger.warning("Invalid value for polarization-lambda-end (<start || >1.0); reverting to 1.0");
                this.polLambdaEnd = 1.0;
            }
            if (this.mode == AlchemicalMode.OST) {
                this.doLigandVaporElec = forceField.getBoolean("LIGAND_VAPOR_ELEC", true);
                this.doLigandGKElec = forceField.getBoolean("LIGAND_GK_ELEC", false);
                this.doNoLigandCondensedSCF = forceField.getBoolean("NO_LIGAND_CONDENSED_SCF", true);
            } else {
                this.doLigandVaporElec = false;
                this.doLigandGKElec = false;
                this.doNoLigandCondensedSCF = false;
            }
        } else if (nnTerm) {
            this.permLambdaAlpha = 0.0;
            this.permLambdaExponent = 1.0;
            this.polLambdaExponent = 1.0;
            this.permLambdaStart = 0.0;
            this.permLambdaEnd = 1.0;
            this.polLambdaStart = 0.0;
            this.polLambdaEnd = 1.0;
            this.doLigandVaporElec = this.mode == AlchemicalMode.OST ? forceField.getBoolean("LIGAND_VAPOR_ELEC", true) : false;
            this.doLigandGKElec = false;
            this.doNoLigandCondensedSCF = false;
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("   Alchemical Parameters\n");
        sb.append(String.format("    Permanent Multipole Range:      %5.3f-%5.3f\n", this.permLambdaStart, this.permLambdaEnd));
        sb.append(String.format("    Permanent Multipole Softcore Alpha:   %5.3f\n", this.permLambdaAlpha));
        sb.append(String.format("    Permanent Multipole Lambda Exponent:  %5.3f\n", this.permLambdaExponent));
        if (this.polarization != Polarization.NONE) {
            sb.append(String.format("    Polarization Lambda Exponent:         %5.3f\n", this.polLambdaExponent));
            sb.append(String.format("    Polarization Range:             %5.3f-%5.3f\n", this.polLambdaStart, this.polLambdaEnd));
            sb.append(String.format("    Condensed SCF Without Ligand:         %B\n", this.doNoLigandCondensedSCF));
        }
        if (!this.doLigandGKElec) {
            sb.append(String.format("    Vapor Electrostatics:                 %B\n", this.doLigandVaporElec));
        } else {
            sb.append(String.format("    GK Electrostatics at L=0:             %B\n", this.doLigandGKElec));
        }
        return sb.toString();
    }

    public void update(double lambda) {
        this.lPowPerm = 1.0;
        this.permLambda = 1.0;
        this.dlPowPerm = 0.0;
        this.d2lPowPerm = 0.0;
        this.lAlpha = 0.0;
        this.dlAlpha = 0.0;
        this.d2lAlpha = 0.0;
        if (lambda < this.permLambdaStart) {
            this.lPowPerm = 0.0;
            this.permLambda = 0.0;
        } else if (lambda <= this.permLambdaEnd) {
            double permWindow = this.permLambdaEnd - this.permLambdaStart;
            double permLambdaScale = 1.0 / permWindow;
            this.permLambda = permLambdaScale * (lambda - this.permLambdaStart);
            if (this.mode == AlchemicalMode.OST) {
                this.lAlpha = this.permLambdaAlpha * (1.0 - this.permLambda) * (1.0 - this.permLambda);
                this.dlAlpha = this.permLambdaAlpha * (1.0 - this.permLambda);
                this.d2lAlpha = -this.permLambdaAlpha;
                this.lPowPerm = FastMath.pow((double)this.permLambda, (double)this.permLambdaExponent);
                this.dlPowPerm = this.permLambdaExponent * FastMath.pow((double)this.permLambda, (double)(this.permLambdaExponent - 1.0));
                this.d2lPowPerm = 0.0;
                if (this.permLambdaExponent >= 2.0) {
                    this.d2lPowPerm = this.permLambdaExponent * (this.permLambdaExponent - 1.0) * FastMath.pow((double)this.permLambda, (double)(this.permLambdaExponent - 2.0));
                }
                this.dlAlpha *= permLambdaScale;
                this.d2lAlpha *= permLambdaScale * permLambdaScale;
                this.dlPowPerm *= permLambdaScale;
                this.d2lPowPerm *= permLambdaScale * permLambdaScale;
            }
        }
        this.lPowPol = 1.0;
        this.polLambda = 1.0;
        this.dlPowPol = 0.0;
        this.d2lPowPol = 0.0;
        if (lambda < this.polLambdaStart) {
            this.lPowPol = 0.0;
            this.polLambda = 0.0;
        } else if (lambda <= this.polLambdaEnd) {
            double polWindow = this.polLambdaEnd - this.polLambdaStart;
            double polLambdaScale = 1.0 / polWindow;
            this.polLambda = polLambdaScale * (lambda - this.polLambdaStart);
            if (this.mode == AlchemicalMode.OST) {
                if (this.polLambdaExponent > 0.0) {
                    this.lPowPol = FastMath.pow((double)this.polLambda, (double)this.polLambdaExponent);
                    if (this.polLambdaExponent >= 1.0) {
                        this.dlPowPol = this.polLambdaExponent * FastMath.pow((double)this.polLambda, (double)(this.polLambdaExponent - 1.0));
                        if (this.polLambdaExponent >= 2.0) {
                            this.d2lPowPol = this.polLambdaExponent * (this.polLambdaExponent - 1.0) * FastMath.pow((double)this.polLambda, (double)(this.polLambdaExponent - 2.0));
                        }
                    }
                }
                this.dlPowPol *= polLambdaScale;
                this.d2lPowPol *= polLambdaScale * polLambdaScale;
            }
        }
        logger.fine("PermLambda: " + this.lPowPerm + " PolLambda: " + this.lPowPol);
        logger.fine("permLambdaExponent = " + this.permLambdaExponent + " polLambdaExponent = " + this.polLambdaExponent);
        logger.fine("permlambdaalpha = " + this.permLambdaAlpha);
    }

    public static enum AlchemicalMode {
        OST,
        SCALE;

    }
}

