/*
 * Decompiled with CFR 0.152.
 */
package ffx.potential.nonbonded.implicit;

import edu.rit.pj.IntegerForLoop;
import edu.rit.pj.ParallelRegion;
import edu.rit.pj.reduction.SharedDouble;
import ffx.potential.bonded.Angle;
import ffx.potential.bonded.Atom;
import ffx.potential.bonded.Bond;
import ffx.potential.bonded.Torsion;
import java.util.List;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.math3.util.FastMath;

public class HydrophobicPMFRegion
extends ParallelRegion {
    private static final Logger logger = Logger.getLogger(HydrophobicPMFRegion.class.getName());
    private final double rCarbon = 1.7;
    private final double rWater = 1.4;
    private final double safact = 0.3516;
    private final double acSurf = 120.7628;
    private final double tSlope = 100.0;
    private final double tOffset = 6.0;
    private final double hpmfCut = 11.0;
    private final double hpmfCut2 = 121.0;
    private final double h1 = -0.7308004860404441;
    private final double h2 = 0.20016450515787607;
    private final double h3 = -0.09054999534184735;
    private final double c1 = 3.8167879266271396;
    private final double c2 = 5.466916228601642;
    private final double c3 = 7.116769486138535;
    private final double w1 = 1.6858993102248638;
    private final double w2 = 1.390640562162998;
    private final double w3 = 1.5741657341338335;
    private final double rSurf = 4.5;
    private final double piSurf = 9.738937226128357;
    private final double[] rPMF;
    private final int nCarbon;
    private final int[] iCarbon;
    private final double[] carbonSASA;
    private final double[] tanhSA;
    private final CarbonSASALoop[] carbonSASALoop;
    private final HydrophobicPMFLoop[] hydrophobicPMFLoop;
    private final CarbonSASACRLoop[] carbonSASACRLoop;
    private final SharedDouble sharedEnergy;
    private final double[] dtanhSA;
    private final double[] sasa;
    private final double[] carbonSASACR;
    private Atom[] atoms;
    private int nAtoms;
    private double[] x;
    private double[] y;
    private double[] z;
    private boolean[] use;
    private double[][][] grad;
    private boolean gradient;

    public HydrophobicPMFRegion(Atom[] atoms, double[] x, double[] y, double[] z, boolean[] use, double[][][] grad, int nt) {
        int i;
        int i2;
        logger.info(String.format(" Hydrophobic PMF cut-off:              %8.2f (A)", 11.0));
        this.atoms = atoms;
        this.nAtoms = atoms.length;
        this.x = x;
        this.y = y;
        this.z = z;
        this.use = use;
        this.grad = grad;
        int count = 0;
        for (i2 = 0; i2 < this.nAtoms; ++i2) {
            List<Bond> bonds;
            int bondCount;
            Atom atom = atoms[i2];
            int atomicNumber = atom.getAtomicNumber();
            if (atomicNumber != 6 || (bondCount = (bonds = atom.getBonds()).size()) <= 2) continue;
            boolean keep = true;
            for (int j = 0; j < bondCount; ++j) {
                Atom atom2 = bonds.get(j).get1_2(atom);
                int atomicNumber2 = atom2.getAtomicNumber();
                if (bondCount != 3 || atomicNumber2 != 8) continue;
                keep = false;
                break;
            }
            if (!keep) continue;
            ++count;
        }
        this.rPMF = new double[this.nAtoms];
        this.nCarbon = count;
        this.iCarbon = new int[this.nCarbon];
        this.carbonSASA = new double[this.nCarbon];
        this.carbonSASACR = new double[this.nCarbon];
        this.tanhSA = new double[this.nCarbon];
        this.dtanhSA = new double[this.nCarbon];
        this.sasa = new double[this.nCarbon];
        this.carbonSASALoop = new CarbonSASALoop[nt];
        this.hydrophobicPMFLoop = new HydrophobicPMFLoop[nt];
        this.carbonSASACRLoop = new CarbonSASACRLoop[nt];
        for (i2 = 0; i2 < nt; ++i2) {
            this.carbonSASALoop[i2] = new CarbonSASALoop(this);
            this.hydrophobicPMFLoop[i2] = new HydrophobicPMFLoop(this);
            this.carbonSASACRLoop[i2] = new CarbonSASACRLoop(this);
        }
        this.sharedEnergy = new SharedDouble();
        int index = 0;
        for (i = 0; i < this.nAtoms; ++i) {
            Atom atom = atoms[i];
            int atomicNumber = atom.getAtomicNumber();
            if (atomicNumber != 6) continue;
            int nh = 0;
            List<Bond> bonds = atom.getBonds();
            int bondCount = bonds.size();
            if (bondCount <= 2) continue;
            boolean keep = true;
            for (int j = 0; j < bondCount; ++j) {
                Atom atom2 = bonds.get(j).get1_2(atom);
                int atomicNumber2 = atom2.getAtomicNumber();
                if (atomicNumber2 == 1) {
                    ++nh;
                }
                if (bondCount != 3 || atomicNumber2 != 8) continue;
                keep = false;
            }
            if (!keep) continue;
            this.iCarbon[index] = i;
            this.carbonSASA[index] = 1.0;
            if (bondCount == 3 && nh == 0) {
                this.carbonSASA[index] = 1.554;
            } else if (bondCount == 3 && nh == 1) {
                this.carbonSASA[index] = 1.073;
            } else if (bondCount == 4 && nh == 1) {
                this.carbonSASA[index] = 1.276;
            } else if (bondCount == 4 && nh == 2) {
                this.carbonSASA[index] = 1.045;
            } else if (bondCount == 4 && nh == 3) {
                this.carbonSASA[index] = 0.88;
            }
            this.carbonSASA[index] = this.carbonSASA[index] * 0.3516 / 120.7628;
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest(String.format(" %d Base HPMF SASA for atom %d: %10.8f", index + 1, i + 1, this.carbonSASA[index]));
            }
            ++index;
        }
        block26: for (i = 0; i < this.nAtoms; ++i) {
            this.rPMF[i] = 2.0;
            int atmnum = atoms[i].getAtomicNumber();
            switch (atmnum) {
                case 0: {
                    this.rPMF[i] = 0.0;
                    continue block26;
                }
                case 1: {
                    this.rPMF[i] = 1.2;
                    continue block26;
                }
                case 2: {
                    this.rPMF[i] = 1.4;
                    continue block26;
                }
                case 5: {
                    this.rPMF[i] = 1.8;
                    continue block26;
                }
                case 6: {
                    this.rPMF[i] = 1.7;
                    continue block26;
                }
                case 7: {
                    this.rPMF[i] = 1.55;
                    continue block26;
                }
                case 8: {
                    this.rPMF[i] = 1.5;
                    continue block26;
                }
                case 9: {
                    this.rPMF[i] = 1.47;
                    continue block26;
                }
                case 10: {
                    this.rPMF[i] = 1.54;
                    continue block26;
                }
                case 14: {
                    this.rPMF[i] = 2.1;
                    continue block26;
                }
                case 15: {
                    this.rPMF[i] = 1.8;
                    continue block26;
                }
                case 16: {
                    this.rPMF[i] = 1.8;
                    continue block26;
                }
                case 17: {
                    this.rPMF[i] = 1.75;
                    continue block26;
                }
                case 18: {
                    this.rPMF[i] = 1.88;
                    continue block26;
                }
                case 34: {
                    this.rPMF[i] = 1.9;
                    continue block26;
                }
                case 35: {
                    this.rPMF[i] = 1.85;
                    continue block26;
                }
                case 36: {
                    this.rPMF[i] = 2.02;
                    continue block26;
                }
                case 53: {
                    this.rPMF[i] = 1.98;
                    continue block26;
                }
                case 54: {
                    this.rPMF[i] = 2.16;
                }
            }
        }
    }

    public double getEnergy() {
        return this.sharedEnergy.get();
    }

    public void run() {
        int ti = this.getThreadIndex();
        try {
            this.execute(0, this.nCarbon - 1, this.carbonSASALoop[ti]);
            this.execute(0, this.nCarbon - 2, this.hydrophobicPMFLoop[ti]);
            if (this.gradient) {
                this.execute(0, this.nCarbon - 1, this.carbonSASACRLoop[ti]);
            }
        }
        catch (Exception e) {
            String message = "Fatal exception computing Born radii in thread " + ti + "\n";
            logger.log(Level.SEVERE, message, e);
        }
    }

    public void setGradient(boolean gradient) {
        this.gradient = gradient;
    }

    public void start() {
        this.sharedEnergy.set(0.0);
    }

    private class CarbonSASALoop
    extends IntegerForLoop {
        final /* synthetic */ HydrophobicPMFRegion this$0;

        private CarbonSASALoop(HydrophobicPMFRegion hydrophobicPMFRegion) {
            HydrophobicPMFRegion hydrophobicPMFRegion2 = hydrophobicPMFRegion;
            Objects.requireNonNull(hydrophobicPMFRegion2);
            this.this$0 = hydrophobicPMFRegion2;
        }

        public void run(int lb, int ub) {
            for (int ii = lb; ii <= ub; ++ii) {
                int i = this.this$0.iCarbon[ii];
                if (!this.this$0.use[i]) continue;
                double carbonSA = this.this$0.carbonSASA[ii];
                double sa = 120.7628;
                double xi = this.this$0.x[i];
                double yi = this.this$0.y[i];
                double zi = this.this$0.z[i];
                int count = 0;
                for (int k = 0; k < this.this$0.nAtoms; ++k) {
                    double rk;
                    double rBig;
                    double zr;
                    double yr;
                    double xr;
                    double r2;
                    if (i == k || !this.this$0.use[k] || !((r2 = (xr = this.this$0.x[k] - xi) * xr + (yr = this.this$0.y[k] - yi) * yr + (zr = this.this$0.z[k] - zi) * zr) < (rBig = (rk = this.this$0.rPMF[k]) + 4.5) * rBig)) continue;
                    double r = FastMath.sqrt((double)r2);
                    double rSmall = rk - 1.7;
                    double part = 9.738937226128357 * (rBig - r) * (1.0 + rSmall / r);
                    sa *= 1.0 - carbonSA * part;
                    ++count;
                }
                this.this$0.sasa[ii] = sa;
                double tSA = FastMath.tanh((double)(100.0 * (sa - 6.0)));
                this.this$0.tanhSA[ii] = 0.5 * (1.0 + tSA);
                this.this$0.dtanhSA[ii] = 50.0 * (1.0 - tSA * tSA);
            }
        }
    }

    private class HydrophobicPMFLoop
    extends IntegerForLoop {
        private final int[] omit;
        private double energy;
        private double[] gX;
        private double[] gY;
        private double[] gZ;
        final /* synthetic */ HydrophobicPMFRegion this$0;

        public HydrophobicPMFLoop(HydrophobicPMFRegion hydrophobicPMFRegion) {
            HydrophobicPMFRegion hydrophobicPMFRegion2 = hydrophobicPMFRegion;
            Objects.requireNonNull(hydrophobicPMFRegion2);
            this.this$0 = hydrophobicPMFRegion2;
            this.omit = new int[hydrophobicPMFRegion.nAtoms];
        }

        public void finish() {
            this.this$0.sharedEnergy.addAndGet(this.energy);
        }

        public void run(int lb, int ub) {
            for (int ii = lb; ii <= ub; ++ii) {
                Object angle2;
                int i = this.this$0.iCarbon[ii];
                if (!this.this$0.use[i]) continue;
                double tanhSAi = this.this$0.tanhSA[ii];
                Atom ssAtom = null;
                Atom atom = this.this$0.atoms[i];
                List<Bond> bonds = atom.getBonds();
                for (Bond bond : bonds) {
                    Atom atom2 = bond.get1_2(atom);
                    int k = atom2.getIndex() - 1;
                    if (!this.this$0.use[k]) continue;
                    this.omit[k] = i;
                    if (atom2.getAtomicNumber() != 16) continue;
                    ssAtom = atom2;
                }
                List<Angle> angles = atom.getAngles();
                for (Object angle2 : angles) {
                    int k;
                    Atom atom2 = ((Angle)angle2).get1_3(atom);
                    if (atom2 == null || !this.this$0.use[k = atom2.getIndex() - 1]) continue;
                    this.omit[k] = i;
                }
                List<Torsion> list = atom.getTorsions();
                angle2 = list.iterator();
                while (angle2.hasNext()) {
                    int k;
                    Torsion torsion = (Torsion)angle2.next();
                    Atom atom2 = torsion.get1_4(atom);
                    if (atom2 == null || !this.this$0.use[k = atom2.getIndex() - 1]) continue;
                    this.omit[k] = i;
                    if (ssAtom == null) continue;
                    List<Bond> bonds2 = atom2.getBonds();
                    for (Bond bond3 : bonds2) {
                        Atom s = bond3.get1_2(atom2);
                        if (s.getAtomicNumber() != 16) continue;
                        List<Bond> sBonds = s.getBonds();
                        for (Bond sBond : sBonds) {
                            Atom s2 = sBond.get1_2(s);
                            if (s2 != ssAtom) continue;
                            this.omit[k] = -1;
                        }
                    }
                }
                double xi = this.this$0.x[i];
                double yi = this.this$0.y[i];
                double zi = this.this$0.z[i];
                double e = 0.0;
                for (int kk = ii + 1; kk < this.this$0.nCarbon; ++kk) {
                    double zr;
                    double yr;
                    double xr;
                    double r2;
                    int k = this.this$0.iCarbon[kk];
                    if (!this.this$0.use[k] || this.omit[k] == i || !((r2 = (xr = xi - this.this$0.x[k]) * xr + (yr = yi - this.this$0.y[k]) * yr + (zr = zi - this.this$0.z[k]) * zr) < 121.0)) continue;
                    double r = FastMath.sqrt((double)r2);
                    double a1 = (r - 3.8167879266271396) * 1.6858993102248638;
                    double a2 = (r - 5.466916228601642) * 1.390640562162998;
                    double a3 = (r - 7.116769486138535) * 1.5741657341338335;
                    double e1 = -0.7308004860404441 * FastMath.exp((double)(-a1 * a1));
                    double e2 = 0.20016450515787607 * FastMath.exp((double)(-a2 * a2));
                    double e3 = -0.09054999534184735 * FastMath.exp((double)(-a3 * a3));
                    double t1t2 = tanhSAi * this.this$0.tanhSA[kk];
                    double sum = e1 + e2 + e3;
                    e += sum * t1t2;
                    if (!this.this$0.gradient) continue;
                    double de1 = -2.0 * e1 * a1 * 1.6858993102248638;
                    double de2 = -2.0 * e2 * a2 * 1.390640562162998;
                    double de3 = -2.0 * e3 * a3 * 1.5741657341338335;
                    double dsum = (de1 + de2 + de3) * t1t2 / r;
                    double dedx = dsum * xr;
                    double dedy = dsum * yr;
                    double dedz = dsum * zr;
                    int n = i;
                    this.gX[n] = this.gX[n] + dedx;
                    int n2 = i;
                    this.gY[n2] = this.gY[n2] + dedy;
                    int n3 = i;
                    this.gZ[n3] = this.gZ[n3] + dedz;
                    int n4 = k;
                    this.gX[n4] = this.gX[n4] - dedx;
                    int n5 = k;
                    this.gY[n5] = this.gY[n5] - dedy;
                    int n6 = k;
                    this.gZ[n6] = this.gZ[n6] - dedz;
                    int n7 = ii;
                    this.this$0.carbonSASACR[n7] = this.this$0.carbonSASACR[n7] + sum * this.this$0.tanhSA[kk] * this.this$0.dtanhSA[ii];
                    int n8 = kk;
                    this.this$0.carbonSASACR[n8] = this.this$0.carbonSASACR[n8] + sum * this.this$0.tanhSA[ii] * this.this$0.dtanhSA[kk];
                }
                this.energy += e;
            }
        }

        public void start() {
            this.energy = 0.0;
            for (int i = 0; i < this.this$0.nAtoms; ++i) {
                this.omit[i] = -1;
            }
            int threadID = this.getThreadIndex();
            this.gX = this.this$0.grad[threadID][0];
            this.gY = this.this$0.grad[threadID][1];
            this.gZ = this.this$0.grad[threadID][2];
            if (this.this$0.gradient) {
                for (int i = 0; i < this.this$0.nCarbon; ++i) {
                    this.this$0.carbonSASACR[i] = 0.0;
                }
            }
        }
    }

    private class CarbonSASACRLoop
    extends IntegerForLoop {
        private double[] gX;
        private double[] gY;
        private double[] gZ;
        final /* synthetic */ HydrophobicPMFRegion this$0;

        public CarbonSASACRLoop(HydrophobicPMFRegion hydrophobicPMFRegion) {
            HydrophobicPMFRegion hydrophobicPMFRegion2 = hydrophobicPMFRegion;
            Objects.requireNonNull(hydrophobicPMFRegion2);
            this.this$0 = hydrophobicPMFRegion2;
        }

        public void run(int lb, int ub) {
            for (int ii = lb; ii <= ub; ++ii) {
                int i = this.this$0.iCarbon[ii];
                if (!this.this$0.use[i]) continue;
                double carbonSA = this.this$0.carbonSASA[ii];
                double xi = this.this$0.x[i];
                double yi = this.this$0.y[i];
                double zi = this.this$0.z[i];
                for (int k = 0; k < this.this$0.nAtoms; ++k) {
                    double rk;
                    double rBig;
                    double zr;
                    double yr;
                    double xr;
                    double r2;
                    if (i == k || !this.this$0.use[k] || !((r2 = (xr = xi - this.this$0.x[k]) * xr + (yr = yi - this.this$0.y[k]) * yr + (zr = zi - this.this$0.z[k]) * zr) <= (rBig = (rk = this.this$0.rPMF[k]) + 4.5) * rBig)) continue;
                    double r = FastMath.sqrt((double)r2);
                    double rSmall = rk - 1.7;
                    double rr = 1.0 / r;
                    double rr2 = rr * rr;
                    double part = 9.738937226128357 * (rBig - r) * (1.0 + rSmall * rr);
                    double t1b = -9.738937226128357 * (1.0 + rBig * rSmall * rr2);
                    double t1a = -this.this$0.sasa[ii] / (1.0 / carbonSA - part);
                    double de = t1a * t1b * rr * this.this$0.carbonSASACR[ii];
                    double dedx = de * xr;
                    double dedy = de * yr;
                    double dedz = de * zr;
                    int n = i;
                    this.gX[n] = this.gX[n] + dedx;
                    int n2 = i;
                    this.gY[n2] = this.gY[n2] + dedy;
                    int n3 = i;
                    this.gZ[n3] = this.gZ[n3] + dedz;
                    int n4 = k;
                    this.gX[n4] = this.gX[n4] - dedx;
                    int n5 = k;
                    this.gY[n5] = this.gY[n5] - dedy;
                    int n6 = k;
                    this.gZ[n6] = this.gZ[n6] - dedz;
                }
            }
        }

        public void start() {
            int threadID = this.getThreadIndex();
            this.gX = this.this$0.grad[threadID][0];
            this.gY = this.this$0.grad[threadID][1];
            this.gZ = this.this$0.grad[threadID][2];
        }
    }
}

