/*
 * Decompiled with CFR 0.152.
 */
package ffx.potential.nonbonded.implicit;

import edu.rit.pj.IntegerForLoop;
import edu.rit.pj.ParallelRegion;
import edu.rit.pj.ParallelTeam;
import edu.rit.pj.reduction.SharedDouble;
import ffx.numerics.math.DoubleMath;
import ffx.potential.bonded.Atom;
import ffx.potential.utils.EnergyException;
import java.util.Arrays;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.math3.util.FastMath;

public class ConnollyRegion
extends ParallelRegion {
    public static final double DEFAULT_WIGGLE = 1.0E-8;
    private static final Logger logger = Logger.getLogger(ConnollyRegion.class.getName());
    private static final int MAXCUBE = 40;
    private static final int MAXCYEP = 30;
    private static final int MAXFPCY = 10;
    private final int nAtoms;
    private final double[] baseRadius;
    private final double[] radius;
    private final boolean[] skip;
    private final double[][] volumeGradient;
    private final int[] itab;
    private final ParallelTeam parallelTeam;
    private final VolumeLoop[] volumeLoop;
    private final SharedDouble sharedVolume;
    private final SharedDouble sharedArea;
    private final int maxSaddleFace;
    private final int maxConvexEdges;
    private final int maxAtomPairs;
    private final int maxCircles;
    private final int maxTori;
    private final int maxTempTori;
    private final int maxConcaveEdges;
    private final int maxVertices;
    private final int maxProbePositions;
    private final int maxConcaveFaces;
    private final int maxConvexFaces;
    private final int maxCycles;
    private final double[][] atomCoords;
    private final double[] x;
    private final double[] y;
    private final double[] z;
    private final boolean[] noFreeSurface;
    private final boolean[] atomFreeOfNeighbors;
    private final boolean[] atomBuried;
    private final int[][] atomNeighborPointers;
    private final int[] neighborAtomNumbers;
    private final int[] neighborToTorus;
    private final int[][] tempToriAtomNumbers;
    private final int[] tempToriFirstEdge;
    private final int[] tempToriLastEdge;
    private final int[] tempToriNextEdge;
    private final boolean[] tempToriBuried;
    private final boolean[] tempToriFree;
    private final double[][] torusCenter;
    private final double[] torusRadius;
    private final double[][] torusAxis;
    private final int[][] torusAtomNumber;
    private final int[] torusFirstEdge;
    private final boolean[] torusNeighborFreeEdge;
    private final double[][] probeCoords;
    private final int[][] probeAtomNumbers;
    private final double[][] vertexCoords;
    private final int[] vertexAtomNumbers;
    private final int[] vertexProbeNumber;
    private final int[][] concaveEdgeVertexNumbers;
    private final int[][] concaveFaceEdgeNumbers;
    private final double[][] circleCenter;
    private final double[] circleRadius;
    private final int[] circleAtomNumber;
    private final int[] circleTorusNumber;
    private final int[] convexEdgeCircleNumber;
    private final int[][] convexEdgeVertexNumber;
    private final int[] convexEdgeFirst;
    private final int[] convexEdgeLast;
    private final int[] convexEdgeNext;
    private final int[][] saddleConcaveEdgeNumbers;
    private final int[][] saddleConvexEdgeNumbers;
    private final int[] convexEdgeCycleNum;
    private final int[][] convexEdgeCycleNumbers;
    private final int[] convexFaceAtomNumber;
    private final int[][] convexFaceCycleNumbers;
    private final int[] convexFaceNumCycles;
    private final boolean[] activeCube;
    private final boolean[] activeAdjacentCube;
    private final int[] firstAtomPointer;
    private final int[][] cubeCoordinates;
    private final int[] nextAtomPointer;
    private Atom[] atoms;
    private boolean gradient = false;
    private double probe = 0.0;
    private double exclude = 1.4;
    private double wiggle = 1.0E-8;
    private int nTempTori;
    private int nTori;
    private int nProbePositions;
    private int nConcaveFaces;
    private int nConcaveVerts;
    private int nConcaveEdges;
    private int nCircles;
    private int nConvexEdges;
    private int nSaddleFaces;
    private int nCycles;
    private int nConvexFaces;

    public ConnollyRegion(Atom[] atoms, double[] baseRadius, int nThreads) {
        this.atoms = atoms;
        this.nAtoms = atoms.length;
        this.baseRadius = baseRadius;
        this.parallelTeam = new ParallelTeam(1);
        this.volumeLoop = new VolumeLoop[nThreads];
        for (int i = 0; i < nThreads; ++i) {
            this.volumeLoop[i] = new VolumeLoop(this);
        }
        this.sharedVolume = new SharedDouble();
        this.sharedArea = new SharedDouble();
        this.radius = new double[this.nAtoms];
        this.skip = new boolean[this.nAtoms];
        this.atomCoords = new double[3][this.nAtoms];
        this.x = this.atomCoords[0];
        this.y = this.atomCoords[1];
        this.z = this.atomCoords[2];
        this.noFreeSurface = new boolean[this.nAtoms];
        this.atomFreeOfNeighbors = new boolean[this.nAtoms];
        this.atomBuried = new boolean[this.nAtoms];
        this.atomNeighborPointers = new int[2][this.nAtoms];
        this.maxAtomPairs = 240 * this.nAtoms;
        this.neighborAtomNumbers = new int[this.maxAtomPairs];
        this.neighborToTorus = new int[this.maxAtomPairs];
        this.maxTempTori = 120 * this.nAtoms;
        this.maxConcaveEdges = 12 * this.nAtoms;
        this.tempToriAtomNumbers = new int[2][this.maxTempTori];
        this.tempToriFirstEdge = new int[this.maxTempTori];
        this.tempToriLastEdge = new int[this.maxTempTori];
        this.tempToriBuried = new boolean[this.maxTempTori];
        this.tempToriFree = new boolean[this.maxTempTori];
        this.tempToriNextEdge = new int[this.maxConcaveEdges];
        this.maxTori = 4 * this.nAtoms;
        this.torusCenter = new double[3][this.maxTori];
        this.torusRadius = new double[this.maxTori];
        this.torusAxis = new double[3][this.maxTori];
        this.torusAtomNumber = new int[2][this.maxTori];
        this.torusFirstEdge = new int[this.maxTori];
        this.torusNeighborFreeEdge = new boolean[this.maxTori];
        this.maxProbePositions = 4 * this.nAtoms;
        this.probeCoords = new double[3][this.maxProbePositions];
        this.probeAtomNumbers = new int[3][this.maxProbePositions];
        this.maxVertices = 12 * this.nAtoms;
        this.vertexCoords = new double[3][this.maxVertices];
        this.vertexAtomNumbers = new int[this.maxVertices];
        this.vertexProbeNumber = new int[this.maxVertices];
        this.maxConcaveFaces = 4 * this.nAtoms;
        this.concaveFaceEdgeNumbers = new int[3][this.maxConcaveFaces];
        this.concaveEdgeVertexNumbers = new int[2][this.maxConcaveEdges];
        this.maxCircles = 8 * this.nAtoms;
        this.circleCenter = new double[3][this.maxCircles];
        this.circleRadius = new double[this.maxCircles];
        this.circleAtomNumber = new int[this.maxCircles];
        this.circleTorusNumber = new int[this.maxCircles];
        this.maxConvexEdges = 12 * this.nAtoms;
        this.maxConvexFaces = 2 * this.nAtoms;
        this.maxCycles = 3 * this.nAtoms;
        this.convexEdgeCircleNumber = new int[this.maxConvexEdges];
        this.convexEdgeVertexNumber = new int[2][this.maxConvexEdges];
        this.convexEdgeFirst = new int[this.nAtoms];
        this.convexEdgeLast = new int[this.nAtoms];
        this.convexEdgeNext = new int[this.maxConvexEdges];
        this.convexEdgeCycleNum = new int[this.maxCycles];
        this.convexEdgeCycleNumbers = new int[30][this.maxCycles];
        this.convexFaceAtomNumber = new int[this.maxConvexFaces];
        this.convexFaceNumCycles = new int[this.maxConvexFaces];
        this.convexFaceCycleNumbers = new int[10][this.maxConvexFaces];
        this.maxSaddleFace = 6 * this.nAtoms;
        this.saddleConcaveEdgeNumbers = new int[2][this.maxSaddleFace];
        this.saddleConvexEdgeNumbers = new int[2][this.maxSaddleFace];
        this.activeCube = new boolean[64000];
        this.activeAdjacentCube = new boolean[64000];
        this.firstAtomPointer = new int[64000];
        this.cubeCoordinates = new int[3][this.nAtoms];
        this.nextAtomPointer = new int[this.nAtoms];
        this.volumeGradient = new double[3][this.nAtoms];
        this.itab = new int[this.nAtoms];
    }

    public double getExclude() {
        return this.exclude;
    }

    public void setExclude(double exclude) {
        this.exclude = exclude;
    }

    public double getProbe() {
        return this.probe;
    }

    public void setProbe(double probe) {
        this.probe = probe;
    }

    public double getSurfaceArea() {
        return this.sharedArea.get();
    }

    public double getVolume() {
        return this.sharedVolume.get();
    }

    public double[][] getVolumeGradient() {
        return this.volumeGradient;
    }

    public void init(Atom[] atoms, boolean gradient) {
        this.atoms = atoms;
        this.gradient = gradient;
    }

    public void run() {
        try {
            this.execute(0, this.nAtoms - 1, this.volumeLoop[this.getThreadIndex()]);
        }
        catch (Exception e) {
            String message = "Fatal exception computing Volume energy in thread " + this.getThreadIndex() + "\n";
            logger.log(Level.SEVERE, message, e);
        }
    }

    public void runVolume() {
        try {
            this.parallelTeam.execute((ParallelRegion)this);
        }
        catch (Exception e) {
            String message = " Fatal exception computing the Connolly surface area and volume.";
            logger.log(Level.SEVERE, message, e);
        }
    }

    public void setWiggle(double wiggle) {
        this.wiggle = wiggle;
    }

    public void start() {
        this.sharedVolume.set(0.0);
        this.sharedArea.set(0.0);
        double[] vector = new double[3];
        for (int i = 0; i < this.nAtoms; ++i) {
            this.getRandomVector(vector);
            Atom atom = this.atoms[i];
            this.atomCoords[0][i] = atom.getX() + this.wiggle * vector[0];
            this.atomCoords[1][i] = atom.getY() + this.wiggle * vector[1];
            this.atomCoords[2][i] = atom.getZ() + this.wiggle * vector[2];
        }
    }

    private void getRandomVector(double[] vector) {
        double x = 0.0;
        double y = 0.0;
        double s = 2.0;
        while (s >= 1.0) {
            x = 2.0 * Math.random() - 1.0;
            y = 2.0 * Math.random() - 1.0;
            s = x * x + y * y;
        }
        vector[2] = 1.0 - 2.0 * s;
        s = 2.0 * FastMath.sqrt((double)(1.0 - s));
        vector[1] = s * y;
        vector[0] = s * x;
    }

    private class VolumeLoop
    extends IntegerForLoop {
        private static final int MXCUBE = 30;
        private static final int MAXARC = 1000;
        private static final int MAXMNB = 500;
        private double localVolume;
        private double localSurfaceArea;
        final /* synthetic */ ConnollyRegion this$0;

        private VolumeLoop(ConnollyRegion connollyRegion) {
            ConnollyRegion connollyRegion2 = connollyRegion;
            Objects.requireNonNull(connollyRegion2);
            this.this$0 = connollyRegion2;
        }

        public void finish() {
            this.this$0.sharedVolume.addAndGet(this.localVolume);
            this.this$0.sharedArea.addAndGet(this.localSurfaceArea);
        }

        public void run(int lb, int ub) {
            this.setRadius();
            this.computeVolumeAndArea();
            if (this.this$0.gradient) {
                this.computeVolumeGradient();
            }
        }

        public void start() {
            this.localVolume = 0.0;
            this.localSurfaceArea = 0.0;
            if (this.this$0.gradient) {
                Arrays.fill(this.this$0.volumeGradient[0], 0.0);
                Arrays.fill(this.this$0.volumeGradient[1], 0.0);
                Arrays.fill(this.this$0.volumeGradient[2], 0.0);
            }
        }

        private void setRadius() {
            for (int i = 0; i < this.this$0.nAtoms; ++i) {
                if (this.this$0.baseRadius[i] == 0.0) {
                    this.this$0.radius[i] = 0.0;
                    this.this$0.skip[i] = true;
                    continue;
                }
                this.this$0.skip[i] = false;
                this.this$0.radius[i] = this.this$0.baseRadius[i] + this.this$0.exclude;
            }
        }

        private void computeVolumeAndArea() {
            this.nearby();
            this.torus();
            this.place();
            this.compress();
            this.saddles();
            this.contact();
            this.vam();
        }

        private boolean getTorus(int ia, int ja, double[] torusCenter, double[] torusRadius, double[] torusAxis) {
            double temp2;
            boolean foundTorus = false;
            double[] ai = new double[3];
            double[] aj = new double[3];
            this.getVector(ai, this.this$0.atomCoords, ia);
            this.getVector(aj, this.this$0.atomCoords, ja);
            double dij = DoubleMath.dist((double[])ai, (double[])aj);
            double[] vij = new double[3];
            double[] uij = new double[3];
            for (int k = 0; k < 3; ++k) {
                vij[k] = this.this$0.atomCoords[k][ja] - this.this$0.atomCoords[k][ia];
                uij[k] = vij[k] / dij;
            }
            double temp = 1.0 + ((this.this$0.radius[ia] + this.this$0.probe) * (this.this$0.radius[ia] + this.this$0.probe) - (this.this$0.radius[ja] + this.this$0.probe) * (this.this$0.radius[ja] + this.this$0.probe)) / (dij * dij);
            double[] bij = new double[3];
            for (int k = 0; k < 3; ++k) {
                bij[k] = this.this$0.atomCoords[k][ia] + 0.5 * vij[k] * temp;
            }
            double temp1 = (this.this$0.radius[ia] + this.this$0.radius[ja] + 2.0 * this.this$0.probe) * (this.this$0.radius[ia] + this.this$0.radius[ja] + 2.0 * this.this$0.probe) - dij * dij;
            if (temp1 >= 0.0 && (temp2 = dij * dij - (this.this$0.radius[ia] - this.this$0.radius[ja]) * (this.this$0.radius[ia] - this.this$0.radius[ja])) >= 0.0) {
                foundTorus = true;
                torusRadius[0] = FastMath.sqrt((double)(temp1 * temp2)) / (2.0 * dij);
                for (int k = 0; k < 3; ++k) {
                    torusCenter[k] = bij[k];
                    torusAxis[k] = uij[k];
                }
            }
            return foundTorus;
        }

        private void nearby() {
            int i;
            int maxclsa = 1000;
            int[] clsa = new int[maxclsa];
            int[] tempNeighborList = new int[maxclsa];
            double[] minAtomicCoordinates = new double[3];
            double[] ai = new double[3];
            double[] aj = new double[3];
            for (int i2 = 0; i2 < this.this$0.nAtoms - 1; ++i2) {
                if (this.this$0.skip[i2]) continue;
                this.getVector(ai, this.this$0.atomCoords, i2);
                for (int j = i2 + 1; j < this.this$0.nAtoms; ++j) {
                    this.getVector(aj, this.this$0.atomCoords, j);
                    double d2 = DoubleMath.dist2((double[])ai, (double[])aj);
                    double r2 = (this.this$0.radius[i2] - this.this$0.radius[j]) * (this.this$0.radius[i2] - this.this$0.radius[j]);
                    if (this.this$0.skip[j] || !(d2 < r2)) continue;
                    if (this.this$0.radius[i2] < this.this$0.radius[j]) {
                        this.this$0.skip[i2] = true;
                        continue;
                    }
                    this.this$0.skip[j] = true;
                }
            }
            double radmax = 0.0;
            for (int k = 0; k < 3; ++k) {
                minAtomicCoordinates[k] = this.this$0.atomCoords[k][0];
            }
            for (int i3 = 0; i3 < this.this$0.nAtoms; ++i3) {
                for (int k = 0; k < 3; ++k) {
                    if (!(this.this$0.atomCoords[k][i3] < minAtomicCoordinates[k])) continue;
                    minAtomicCoordinates[k] = this.this$0.atomCoords[k][i3];
                }
                if (!(this.this$0.radius[i3] > radmax)) continue;
                radmax = this.this$0.radius[i3];
            }
            double width = 2.0 * (radmax + this.this$0.probe);
            for (int i4 = 0; i4 < this.this$0.nAtoms; ++i4) {
                for (int k = 0; k < 3; ++k) {
                    this.this$0.cubeCoordinates[k][i4] = (int)((this.this$0.atomCoords[k][i4] - minAtomicCoordinates[k]) / width);
                    if (this.this$0.cubeCoordinates[k][i4] < 0) {
                        throw new EnergyException(" Cube Coordinate Too Small");
                    }
                    if (this.this$0.cubeCoordinates[k][i4] <= 40) continue;
                    throw new EnergyException(" Cube Coordinate Too Large");
                }
            }
            Arrays.fill(this.this$0.firstAtomPointer, -1);
            Arrays.fill(this.this$0.activeCube, false);
            Arrays.fill(this.this$0.activeAdjacentCube, false);
            Arrays.fill(this.this$0.nextAtomPointer, -1);
            block7: for (int iatom = 0; iatom < this.this$0.nAtoms; ++iatom) {
                if (this.this$0.skip[iatom]) continue;
                this.getVector(ai, this.this$0.atomCoords, iatom);
                i = this.this$0.cubeCoordinates[0][iatom];
                int j = this.this$0.cubeCoordinates[1][iatom];
                int k = this.this$0.cubeCoordinates[2][iatom];
                if (this.this$0.firstAtomPointer[this.index(i, j, k)] <= -1) {
                    this.this$0.firstAtomPointer[this.index((int)i, (int)j, (int)k)] = iatom;
                } else {
                    int iptr = this.this$0.firstAtomPointer[this.index(i, j, k)];
                    boolean done = false;
                    while (!done) {
                        this.getVector(aj, this.this$0.atomCoords, iptr);
                        if (DoubleMath.dist2((double[])ai, (double[])aj) <= 0.0) {
                            this.this$0.skip[iatom] = true;
                            continue block7;
                        }
                        if ((double)this.this$0.nextAtomPointer[iptr] <= -1.0) {
                            done = true;
                            continue;
                        }
                        iptr = this.this$0.nextAtomPointer[iptr];
                    }
                    this.this$0.nextAtomPointer[iptr] = iatom;
                }
                if (this.this$0.skip[iatom]) continue;
                this.this$0.activeCube[this.index((int)i, (int)j, (int)k)] = true;
            }
            for (int k = 0; k < 40; ++k) {
                for (int j = 0; j < 40; ++j) {
                    for (int i5 = 0; i5 < 40; ++i5) {
                        if (this.this$0.firstAtomPointer[this.index(i5, j, k)] == -1) continue;
                        this.checkCube(i5, j, k);
                    }
                }
            }
            int ncls = -1;
            for (i = 0; i < this.this$0.nAtoms; ++i) {
                int ick;
                int icj;
                int ici;
                int nclsa = -1;
                this.this$0.noFreeSurface[i] = this.this$0.skip[i];
                this.this$0.atomNeighborPointers[0][i] = -1;
                this.this$0.atomNeighborPointers[1][i] = -1;
                if (this.this$0.skip[i] || !this.this$0.activeAdjacentCube[this.index(ici = this.this$0.cubeCoordinates[0][i], icj = this.this$0.cubeCoordinates[1][i], ick = this.this$0.cubeCoordinates[2][i])]) continue;
                double sumi = 2.0 * this.this$0.probe + this.this$0.radius[i];
                for (int jck = FastMath.max((int)(ick - 1), (int)0); jck < FastMath.min((int)(ick + 2), (int)40); ++jck) {
                    for (int jcj = FastMath.max((int)(icj - 1), (int)0); jcj < FastMath.min((int)(icj + 2), (int)40); ++jcj) {
                        block15: for (int jci = FastMath.max((int)(ici - 1), (int)0); jci < FastMath.min((int)(ici + 2), (int)40); ++jci) {
                            int j = this.this$0.firstAtomPointer[this.index(jci, jcj, jck)];
                            int counter = 1;
                            for (int q = 0; q < counter; ++counter, ++q) {
                                for (int z = 0; z < 1; ++z) {
                                    double d2;
                                    double vect3;
                                    double vect2;
                                    if (j <= -1) continue block15;
                                    if (i == j || this.this$0.skip[j]) continue;
                                    double sum = sumi + this.this$0.radius[j];
                                    double vect1 = FastMath.abs((double)(this.this$0.atomCoords[0][j] - this.this$0.atomCoords[0][i]));
                                    if (vect1 >= sum || (vect2 = FastMath.abs((double)(this.this$0.atomCoords[1][j] - this.this$0.atomCoords[1][i]))) >= sum || (vect3 = FastMath.abs((double)(this.this$0.atomCoords[2][j] - this.this$0.atomCoords[2][i]))) >= sum || (d2 = vect1 * vect1 + vect2 * vect2 + vect3 * vect3) >= sum * sum) continue;
                                    if (!this.this$0.skip[j]) {
                                        this.this$0.noFreeSurface[i] = false;
                                    }
                                    if (++nclsa >= maxclsa) {
                                        throw new EnergyException(" Too many Neighbors for Atom");
                                    }
                                    tempNeighborList[nclsa] = j;
                                }
                                j = this.this$0.nextAtomPointer[j];
                            }
                        }
                    }
                }
                if (this.this$0.noFreeSurface[i]) continue;
                int jmold = -1;
                for (int juse = 0; juse <= nclsa; ++juse) {
                    int jatom;
                    int jcls;
                    int jmin = this.this$0.nAtoms;
                    int jmincls = 0;
                    for (jcls = 0; jcls < nclsa + 1; ++jcls) {
                        if (tempNeighborList[jcls] <= jmold || tempNeighborList[jcls] >= jmin) continue;
                        jmin = tempNeighborList[jcls];
                        jmincls = jcls;
                    }
                    jmold = jmin;
                    jcls = jmincls;
                    clsa[juse] = jatom = tempNeighborList[jcls];
                }
                if (nclsa <= -1) continue;
                this.this$0.atomNeighborPointers[0][i] = ncls + 1;
                for (int m = 0; m < nclsa + 1; ++m) {
                    if (++ncls >= this.this$0.maxAtomPairs) {
                        throw new EnergyException(" Too many Neighboring Atom Pairs");
                    }
                    this.this$0.neighborAtomNumbers[ncls] = clsa[m];
                }
                this.this$0.atomNeighborPointers[1][i] = ncls;
            }
        }

        private int index(int i, int j, int k) {
            return k + 40 * (j + 40 * i);
        }

        private void checkCube(int i, int j, int k) {
            for (int k1 = FastMath.max((int)(k - 1), (int)0); k1 < FastMath.min((int)(k + 2), (int)40); ++k1) {
                for (int j1 = FastMath.max((int)(j - 1), (int)0); j1 < FastMath.min((int)(j + 2), (int)40); ++j1) {
                    for (int i1 = FastMath.max((int)(i - 1), (int)0); i1 < FastMath.min((int)(i + 2), (int)40); ++i1) {
                        if (!this.this$0.activeCube[this.index(i1, j1, k1)]) continue;
                        this.this$0.activeAdjacentCube[this.index((int)i, (int)j, (int)k)] = true;
                        return;
                    }
                }
            }
        }

        private void torus() {
            this.this$0.nTempTori = -1;
            Arrays.fill(this.this$0.atomFreeOfNeighbors, true);
            if (this.this$0.nAtoms <= 1) {
                return;
            }
            double[] tt = new double[3];
            double[] ttax = new double[3];
            for (int ia = 0; ia < this.this$0.nAtoms; ++ia) {
                if (this.this$0.noFreeSurface[ia]) continue;
                int ibeg = this.this$0.atomNeighborPointers[0][ia];
                int iend = this.this$0.atomNeighborPointers[1][ia];
                if (ibeg <= -1) continue;
                for (int jn = ibeg; jn <= iend; ++jn) {
                    double[] ttr;
                    boolean ttok;
                    this.this$0.neighborToTorus[jn] = -1;
                    int ja = this.this$0.neighborAtomNumbers[jn];
                    if (ja < ia || !(ttok = this.getTorus(ia, ja, tt, ttr = new double[]{0.0}, ttax))) continue;
                    ++this.this$0.nTempTori;
                    if (this.this$0.nTempTori >= this.this$0.maxTempTori) {
                        throw new EnergyException(" Too many Temporary Tori");
                    }
                    this.this$0.atomFreeOfNeighbors[ia] = false;
                    this.this$0.atomFreeOfNeighbors[ja] = false;
                    this.this$0.tempToriAtomNumbers[0][this.this$0.nTempTori] = ia;
                    this.this$0.tempToriAtomNumbers[1][this.this$0.nTempTori] = ja;
                    this.this$0.neighborToTorus[jn] = this.this$0.nTempTori;
                    this.this$0.tempToriFree[this.this$0.nTempTori] = true;
                    this.this$0.tempToriBuried[this.this$0.nTempTori] = true;
                    this.this$0.tempToriFirstEdge[this.this$0.nTempTori] = -1;
                    this.this$0.tempToriLastEdge[this.this$0.nTempTori] = -1;
                }
            }
        }

        private void place() {
            int[] mnb = new int[500];
            int[] ikt = new int[500];
            int[] jkt = new int[500];
            int[] lkcls = new int[500];
            double[] tik = new double[3];
            double[] tij = new double[3];
            double[] uij = new double[3];
            double[] uik = new double[3];
            double[] uijk = new double[3];
            double[] bij = new double[3];
            double[] bijk = new double[3];
            double[] aijk = new double[3];
            double[] pijk = new double[3];
            double[] tijik = new double[3];
            double[] tempv = new double[3];
            double[] utb = new double[3];
            double[] ai = new double[3];
            double[] ak = new double[3];
            double[] discls = new double[500];
            double[] sumcls = new double[500];
            this.this$0.nProbePositions = -1;
            this.this$0.nConcaveFaces = -1;
            this.this$0.nConcaveEdges = -1;
            this.this$0.nConcaveVerts = -1;
            if (this.this$0.nTempTori <= -1) {
                return;
            }
            for (int itt = 0; itt < this.this$0.nTempTori + 1; ++itt) {
                int ia = this.this$0.tempToriAtomNumbers[0][itt];
                int ja = this.this$0.tempToriAtomNumbers[1][itt];
                int nmnb = -1;
                int iptr = this.this$0.atomNeighborPointers[0][ia];
                int jptr = this.this$0.atomNeighborPointers[0][ja];
                block1: for (int i = 0; i < 1; ++i) {
                    if (iptr <= -1 || jptr <= -1) continue;
                    int iend = this.this$0.atomNeighborPointers[1][ia];
                    int jend = this.this$0.atomNeighborPointers[1][ja];
                    int counter = 1;
                    int counter2 = 1;
                    for (int t = 0; t < counter2; ++counter2, ++t) {
                        for (int q = 0; q < counter; ++q) {
                            if (iptr > iend || jptr > jend) continue block1;
                            if (this.this$0.neighborAtomNumbers[iptr] < this.this$0.neighborAtomNumbers[jptr]) {
                                ++iptr;
                                ++counter;
                                continue;
                            }
                            if (this.this$0.neighborAtomNumbers[jptr] >= this.this$0.neighborAtomNumbers[iptr]) continue;
                            ++jptr;
                            ++counter;
                        }
                        if (++nmnb >= 500) {
                            throw new EnergyException(" Too many Mutual Neighbors");
                        }
                        mnb[nmnb] = this.this$0.neighborAtomNumbers[iptr];
                        ikt[nmnb] = this.this$0.neighborToTorus[iptr];
                        jkt[nmnb] = this.this$0.neighborToTorus[jptr];
                        ++iptr;
                    }
                }
                if (nmnb == -1) {
                    this.this$0.tempToriBuried[itt] = false;
                    continue;
                }
                double[] hij = new double[]{0.0};
                boolean ttok = this.getTorus(ia, ja, bij, hij, uij);
                for (int km = 0; km < nmnb + 1; ++km) {
                    int ka = mnb[km];
                    this.getVector(ak, this.this$0.atomCoords, ka);
                    discls[km] = DoubleMath.dist2((double[])bij, (double[])ak);
                    sumcls[km] = (this.this$0.probe + this.this$0.radius[ka]) * (this.this$0.probe + this.this$0.radius[ka]);
                    lkcls[km] = -1;
                }
                int lkf = 0;
                for (int z = 0; z < 1; ++z) {
                    if (nmnb == 0) continue;
                    for (int l = 1; l < nmnb + 1; ++l) {
                        int l1 = -1;
                        int l2 = lkf;
                        int counter2 = 1;
                        for (int w = 0; w < counter2; ++w) {
                            if (discls[l] < discls[l2]) continue;
                            l1 = l2;
                            if ((l2 = lkcls[l2]) == -1) continue;
                            ++counter2;
                        }
                        if (l1 == -1) {
                            lkf = l;
                        } else {
                            lkcls[l1] = l;
                        }
                        lkcls[l] = l2;
                    }
                }
                for (int km = 0; km < nmnb + 1; ++km) {
                    int ka = mnb[km];
                    if (this.this$0.skip[ia] && this.this$0.skip[ja] && this.this$0.skip[ka]) continue;
                    int ik = ikt[km];
                    int jk = jkt[km];
                    boolean prbok = false;
                    boolean tb = false;
                    double[] rij = new double[]{0.0};
                    double hijk = 0.0;
                    boolean tok = this.getTorus(ia, ja, tij, rij, uij);
                    for (int w = 0; w < 1; ++w) {
                        int k;
                        double[] rik;
                        if (!tok) continue;
                        this.getVector(ai, this.this$0.atomCoords, ka);
                        double dat2 = DoubleMath.dist2((double[])ai, (double[])tij);
                        double rad2 = (this.this$0.radius[ka] + this.this$0.probe) * (this.this$0.radius[ka] + this.this$0.probe) - rij[0] * rij[0];
                        if (ka < ja && (rad2 <= 0.0 || dat2 > rad2) || !(tok = this.getTorus(ia, ka, tik, rik = new double[]{0.0}, uik))) continue;
                        double dotijk = this.check(DoubleMath.dot((double[])uij, (double[])uik));
                        double wijk = FastMath.acos((double)dotijk);
                        double swijk = FastMath.sin((double)wijk);
                        if (swijk == 0.0) {
                            tb = rad2 > 0.0 && dat2 <= rad2;
                            continue;
                        }
                        DoubleMath.X((double[])uij, (double[])uik, (double[])uijk);
                        for (k = 0; k < 3; ++k) {
                            uijk[k] = uijk[k] / swijk;
                        }
                        DoubleMath.X((double[])uijk, (double[])uij, (double[])utb);
                        for (k = 0; k < 3; ++k) {
                            tijik[k] = tik[k] - tij[k];
                        }
                        double dotut = DoubleMath.dot((double[])uik, (double[])tijik);
                        double fact = dotut / swijk;
                        for (int k2 = 0; k2 < 3; ++k2) {
                            bijk[k2] = tij[k2] + utb[k2] * fact;
                        }
                        this.getVector(ai, this.this$0.atomCoords, ia);
                        double dba = DoubleMath.dist2((double[])ai, (double[])bijk);
                        double rip2 = (this.this$0.radius[ia] + this.this$0.probe) * (this.this$0.radius[ia] + this.this$0.probe);
                        double rad = rip2 - dba;
                        if (rad < 0.0) {
                            tb = rad2 > 0.0 && dat2 <= rad2;
                            continue;
                        }
                        prbok = true;
                        hijk = FastMath.sqrt((double)rad);
                    }
                    if (tb) {
                        this.this$0.tempToriBuried[itt] = true;
                        this.this$0.tempToriFree[itt] = false;
                        continue;
                    }
                    if (ka < ja || !prbok) continue;
                    for (int k = 0; k < 3; ++k) {
                        aijk[k] = hijk * uijk[k];
                    }
                    block14: for (int ip = 0; ip < 2; ++ip) {
                        int k;
                        int k3;
                        for (int k4 = 0; k4 < 3; ++k4) {
                            pijk[k4] = ip == 0 ? bijk[k4] + aijk[k4] : bijk[k4] - aijk[k4];
                        }
                        this.this$0.tempToriFree[itt] = false;
                        this.this$0.tempToriFree[ik] = false;
                        this.this$0.tempToriFree[jk] = false;
                        int lm = lkf;
                        int counter3 = 1;
                        block16: for (int t = 0; t < counter3; ++t) {
                            for (int p = 0; p < 1; ++p) {
                                if (lm < 0) continue block16;
                                int la = mnb[lm];
                                if (la == ka) continue;
                                this.getVector(ak, this.this$0.atomCoords, la);
                                if (DoubleMath.dist2((double[])pijk, (double[])ak) <= sumcls[lm]) continue block14;
                            }
                            lm = lkcls[lm];
                            ++counter3;
                        }
                        ++this.this$0.nProbePositions;
                        if (this.this$0.nProbePositions >= this.this$0.maxProbePositions) {
                            throw new EnergyException(" Too many Probe Positions");
                        }
                        this.this$0.tempToriBuried[itt] = false;
                        this.this$0.tempToriBuried[ik] = false;
                        this.this$0.tempToriBuried[jk] = false;
                        for (k3 = 0; k3 < 3; ++k3) {
                            this.this$0.probeCoords[k3][this.this$0.nProbePositions] = pijk[k3];
                        }
                        if (this.this$0.nConcaveVerts + 3 >= this.this$0.maxVertices) {
                            throw new EnergyException(" Too many Vertices");
                        }
                        for (k3 = 0; k3 < 3; ++k3) {
                            this.this$0.vertexCoords[k3][this.this$0.nConcaveVerts + 1] = this.this$0.atomCoords[k3][ia] - this.this$0.probeCoords[k3][this.this$0.nProbePositions];
                            this.this$0.vertexCoords[k3][this.this$0.nConcaveVerts + 2] = this.this$0.atomCoords[k3][ja] - this.this$0.probeCoords[k3][this.this$0.nProbePositions];
                            this.this$0.vertexCoords[k3][this.this$0.nConcaveVerts + 3] = this.this$0.atomCoords[k3][ka] - this.this$0.probeCoords[k3][this.this$0.nProbePositions];
                        }
                        double det = this.this$0.vertexCoords[0][this.this$0.nConcaveVerts + 1] * this.this$0.vertexCoords[1][this.this$0.nConcaveVerts + 2] * this.this$0.vertexCoords[2][this.this$0.nConcaveVerts + 3] + this.this$0.vertexCoords[0][this.this$0.nConcaveVerts + 2] * this.this$0.vertexCoords[1][this.this$0.nConcaveVerts + 3] * this.this$0.vertexCoords[2][this.this$0.nConcaveVerts + 1] + this.this$0.vertexCoords[0][this.this$0.nConcaveVerts + 3] * this.this$0.vertexCoords[1][this.this$0.nConcaveVerts + 1] * this.this$0.vertexCoords[2][this.this$0.nConcaveVerts + 2] - this.this$0.vertexCoords[0][this.this$0.nConcaveVerts + 3] * this.this$0.vertexCoords[1][this.this$0.nConcaveVerts + 2] * this.this$0.vertexCoords[2][this.this$0.nConcaveVerts + 1] - this.this$0.vertexCoords[0][this.this$0.nConcaveVerts + 2] * this.this$0.vertexCoords[1][this.this$0.nConcaveVerts + 1] * this.this$0.vertexCoords[2][this.this$0.nConcaveVerts + 3] - this.this$0.vertexCoords[0][this.this$0.nConcaveVerts + 1] * this.this$0.vertexCoords[1][this.this$0.nConcaveVerts + 3] * this.this$0.vertexCoords[2][this.this$0.nConcaveVerts + 2];
                        for (k = 0; k < 3; ++k) {
                            this.this$0.vertexCoords[k][this.this$0.nConcaveVerts + 1] = this.this$0.probeCoords[k][this.this$0.nProbePositions] + this.this$0.vertexCoords[k][this.this$0.nConcaveVerts + 1] * this.this$0.probe / (this.this$0.radius[ia] + this.this$0.probe);
                            this.this$0.vertexCoords[k][this.this$0.nConcaveVerts + 2] = this.this$0.probeCoords[k][this.this$0.nProbePositions] + this.this$0.vertexCoords[k][this.this$0.nConcaveVerts + 2] * this.this$0.probe / (this.this$0.radius[ja] + this.this$0.probe);
                            this.this$0.vertexCoords[k][this.this$0.nConcaveVerts + 3] = this.this$0.probeCoords[k][this.this$0.nProbePositions] + this.this$0.vertexCoords[k][this.this$0.nConcaveVerts + 3] * this.this$0.probe / (this.this$0.radius[ka] + this.this$0.probe);
                        }
                        if (det > 0.0) {
                            for (k = 0; k < 3; ++k) {
                                tempv[k] = this.this$0.vertexCoords[k][this.this$0.nConcaveVerts + 2];
                                this.this$0.vertexCoords[k][this.this$0.nConcaveVerts + 2] = this.this$0.vertexCoords[k][this.this$0.nConcaveVerts + 3];
                                this.this$0.vertexCoords[k][this.this$0.nConcaveVerts + 3] = tempv[k];
                            }
                            this.this$0.probeAtomNumbers[0][this.this$0.nProbePositions] = ia;
                            this.this$0.probeAtomNumbers[1][this.this$0.nProbePositions] = ka;
                            this.this$0.probeAtomNumbers[2][this.this$0.nProbePositions] = ja;
                            this.this$0.vertexAtomNumbers[this.this$0.nConcaveVerts + 1] = ia;
                            this.this$0.vertexAtomNumbers[this.this$0.nConcaveVerts + 2] = ka;
                            this.this$0.vertexAtomNumbers[this.this$0.nConcaveVerts + 3] = ja;
                            this.insertEdge(this.this$0.nConcaveEdges + 1, ik);
                            this.insertEdge(this.this$0.nConcaveEdges + 2, jk);
                            this.insertEdge(this.this$0.nConcaveEdges + 3, itt);
                        } else {
                            this.this$0.probeAtomNumbers[0][this.this$0.nProbePositions] = ia;
                            this.this$0.probeAtomNumbers[1][this.this$0.nProbePositions] = ja;
                            this.this$0.probeAtomNumbers[2][this.this$0.nProbePositions] = ka;
                            this.this$0.vertexAtomNumbers[this.this$0.nConcaveVerts + 1] = ia;
                            this.this$0.vertexAtomNumbers[this.this$0.nConcaveVerts + 2] = ja;
                            this.this$0.vertexAtomNumbers[this.this$0.nConcaveVerts + 3] = ka;
                            this.insertEdge(this.this$0.nConcaveEdges + 1, itt);
                            this.insertEdge(this.this$0.nConcaveEdges + 2, jk);
                            this.insertEdge(this.this$0.nConcaveEdges + 3, ik);
                        }
                        for (int kv = 1; kv < 4; ++kv) {
                            this.this$0.vertexProbeNumber[this.this$0.nConcaveVerts + kv] = this.this$0.nProbePositions;
                        }
                        if (this.this$0.nConcaveEdges + 3 >= this.this$0.maxConcaveEdges) {
                            throw new EnergyException(" Too many Concave Edges");
                        }
                        this.this$0.concaveEdgeVertexNumbers[0][this.this$0.nConcaveEdges + 1] = this.this$0.nConcaveVerts + 1;
                        this.this$0.concaveEdgeVertexNumbers[1][this.this$0.nConcaveEdges + 1] = this.this$0.nConcaveVerts + 2;
                        this.this$0.concaveEdgeVertexNumbers[0][this.this$0.nConcaveEdges + 2] = this.this$0.nConcaveVerts + 2;
                        this.this$0.concaveEdgeVertexNumbers[1][this.this$0.nConcaveEdges + 2] = this.this$0.nConcaveVerts + 3;
                        this.this$0.concaveEdgeVertexNumbers[0][this.this$0.nConcaveEdges + 3] = this.this$0.nConcaveVerts + 3;
                        this.this$0.concaveEdgeVertexNumbers[1][this.this$0.nConcaveEdges + 3] = this.this$0.nConcaveVerts + 1;
                        if (this.this$0.nConcaveFaces + 1 >= this.this$0.maxConcaveFaces) {
                            throw new EnergyException(" Too many Concave Faces");
                        }
                        for (int ke = 0; ke < 3; ++ke) {
                            this.this$0.concaveFaceEdgeNumbers[ke][this.this$0.nConcaveFaces + 1] = this.this$0.nConcaveEdges + ke + 1;
                        }
                        ++this.this$0.nConcaveFaces;
                        this.this$0.nConcaveEdges += 3;
                        this.this$0.nConcaveVerts += 3;
                    }
                }
            }
        }

        private void insertEdge(int edgeNumber, int torusNumber) {
            if (edgeNumber <= -1) {
                throw new EnergyException(" Bad Edge Number in INEDGE");
            }
            if (torusNumber <= -1) {
                throw new EnergyException(" Bad Torus Number in INEDGE");
            }
            if (this.this$0.tempToriFirstEdge[torusNumber] == -1) {
                this.this$0.tempToriFirstEdge[torusNumber] = edgeNumber;
            } else {
                this.this$0.tempToriNextEdge[this.this$0.tempToriLastEdge[torusNumber]] = edgeNumber;
            }
            this.this$0.tempToriNextEdge[edgeNumber] = -1;
            this.this$0.tempToriLastEdge[torusNumber] = edgeNumber;
        }

        private void compress() {
            double[] torCenter = new double[3];
            double[] torAxis = new double[3];
            this.this$0.nTori = -1;
            if (this.this$0.nTempTori <= -1) {
                return;
            }
            double[] torRad = new double[]{0.0};
            for (int itt = 0; itt <= this.this$0.nTempTori; ++itt) {
                if (this.this$0.tempToriFree[itt]) {
                    this.this$0.tempToriBuried[itt] = false;
                }
                if (this.this$0.tempToriBuried[itt]) continue;
                ++this.this$0.nTori;
                if (this.this$0.nTori >= this.this$0.maxTori) {
                    throw new EnergyException(" Too many non-buried tori.");
                }
                int ia = this.this$0.tempToriAtomNumbers[0][itt];
                int ja = this.this$0.tempToriAtomNumbers[1][itt];
                this.getVector(torCenter, this.this$0.torusCenter, this.this$0.nTori);
                this.getVector(torAxis, this.this$0.torusAxis, this.this$0.nTori);
                this.getTorus(ia, ja, torCenter, torRad, torAxis);
                this.this$0.torusCenter[0][this.this$0.nTori] = torCenter[0];
                this.this$0.torusCenter[1][this.this$0.nTori] = torCenter[1];
                this.this$0.torusCenter[2][this.this$0.nTori] = torCenter[2];
                this.this$0.torusAxis[0][this.this$0.nTori] = torAxis[0];
                this.this$0.torusAxis[1][this.this$0.nTori] = torAxis[1];
                this.this$0.torusAxis[2][this.this$0.nTori] = torAxis[2];
                this.this$0.torusRadius[this.this$0.nTori] = torRad[0];
                this.this$0.torusAtomNumber[0][this.this$0.nTori] = ia;
                this.this$0.torusAtomNumber[1][this.this$0.nTori] = ja;
                this.this$0.torusNeighborFreeEdge[this.this$0.nTori] = this.this$0.tempToriFree[itt];
                this.this$0.torusFirstEdge[this.this$0.nTori] = this.this$0.tempToriFirstEdge[itt];
                int iptr = this.this$0.torusFirstEdge[this.this$0.nTori];
                int ned = -1;
                while (iptr != -1) {
                    ++ned;
                    iptr = this.this$0.tempToriNextEdge[iptr];
                }
                if (ned % 2 != 0) continue;
                iptr = this.this$0.torusFirstEdge[this.this$0.nTori];
                while (iptr != -1) {
                    int iv1 = this.this$0.concaveEdgeVertexNumbers[0][iptr];
                    int iv2 = this.this$0.concaveEdgeVertexNumbers[1][iptr];
                    int ip1 = this.this$0.vertexProbeNumber[iv1];
                    int ip2 = this.this$0.vertexProbeNumber[iv2];
                    logger.warning(String.format(" Odd Torus for Probes IP1 %d and IP2 %d", ip1, ip2));
                    iptr = this.this$0.tempToriNextEdge[iptr];
                }
            }
        }

        private void saddles() {
            int maxent = 500;
            int[] ten = new int[500];
            int[] nxtang = new int[500];
            double[] ai = new double[3];
            double[] aj = new double[3];
            double[] ak = new double[3];
            double[] atvect = new double[3];
            double[] teang = new double[500];
            double[][] tev = new double[3][500];
            boolean[] sdstrt = new boolean[500];
            this.this$0.nCircles = -1;
            this.this$0.nConvexEdges = -1;
            this.this$0.nSaddleFaces = -1;
            Arrays.fill(this.this$0.convexEdgeFirst, -1);
            Arrays.fill(this.this$0.convexEdgeLast, -1);
            Arrays.fill(this.this$0.atomBuried, true);
            if (this.this$0.nTori < 0) {
                return;
            }
            block0: for (int it = 0; it <= this.this$0.nTori; ++it) {
                if (this.this$0.skip[this.this$0.torusAtomNumber[0][it]] && this.this$0.skip[this.this$0.torusAtomNumber[1][it]]) continue;
                for (int in = 0; in < 2; ++in) {
                    int ia = this.this$0.torusAtomNumber[in][it];
                    this.this$0.atomBuried[ia] = false;
                    for (int k = 0; k < 3; ++k) {
                        atvect[k] = this.this$0.torusCenter[k][it] - this.this$0.atomCoords[k][ia];
                    }
                    double factor = this.this$0.radius[ia] / (this.this$0.radius[ia] + this.this$0.probe);
                    ++this.this$0.nCircles;
                    if (this.this$0.nCircles >= this.this$0.maxCircles) {
                        throw new EnergyException(" Too many Circles");
                    }
                    for (int k = 0; k < 3; ++k) {
                        this.this$0.circleCenter[k][this.this$0.nCircles] = this.this$0.atomCoords[k][ia] + factor * atvect[k];
                    }
                    this.this$0.circleAtomNumber[this.this$0.nCircles] = ia;
                    this.this$0.circleTorusNumber[this.this$0.nCircles] = it;
                    this.this$0.circleRadius[this.this$0.nCircles] = factor * this.this$0.torusRadius[it];
                }
                if (!this.this$0.torusNeighborFreeEdge[it]) {
                    int ient;
                    int nent = -1;
                    int ien = this.this$0.torusFirstEdge[it];
                    while (ien >= 0) {
                        int k;
                        if (++nent >= 500) {
                            throw new EnergyException(" Too many Edges for Torus");
                        }
                        int iv = this.this$0.concaveEdgeVertexNumbers[0][ien];
                        int ip = this.this$0.vertexProbeNumber[iv];
                        for (int k2 = 0; k2 < 3; ++k2) {
                            tev[k2][nent] = this.this$0.probeCoords[k2][ip] - this.this$0.torusCenter[k2][it];
                        }
                        double dtev = 0.0;
                        for (k = 0; k < 3; ++k) {
                            dtev += tev[k][nent] * tev[k][nent];
                        }
                        if (dtev <= 0.0) {
                            throw new EnergyException(" Probe on Torus Axis");
                        }
                        dtev = FastMath.sqrt((double)dtev);
                        for (k = 0; k < 3; ++k) {
                            tev[k][nent] = tev[k][nent] / dtev;
                        }
                        ten[nent] = ien;
                        if (nent > 0) {
                            double dt = 0.0;
                            for (int k3 = 0; k3 < 3; ++k3) {
                                dt += tev[k3][0] * tev[k3][nent];
                            }
                            if (dt > 1.0) {
                                dt = 1.0;
                            }
                            if (dt < -1.0) {
                                dt = -1.0;
                            }
                            teang[nent] = FastMath.acos((double)dt);
                            ai[0] = tev[0][0];
                            ai[1] = tev[1][0];
                            ai[2] = tev[2][0];
                            aj[0] = tev[0][nent];
                            aj[1] = tev[1][nent];
                            aj[2] = tev[2][nent];
                            ak[0] = this.this$0.torusAxis[0][it];
                            ak[1] = this.this$0.torusAxis[1][it];
                            ak[2] = this.this$0.torusAxis[2][it];
                            double triple = this.tripleProduct(ai, aj, ak);
                            if (triple < 0.0) {
                                teang[nent] = Math.PI * 2 - teang[nent];
                            }
                        } else {
                            teang[0] = 0.0;
                        }
                        sdstrt[nent] = this.this$0.vertexAtomNumbers[iv] == this.this$0.torusAtomNumber[0][it];
                        ien = this.this$0.tempToriNextEdge[ien];
                    }
                    if (nent == -1) {
                        logger.severe(" No Edges for Non-free Torus");
                    }
                    if (nent % 2 == 0) {
                        throw new EnergyException(" Odd Number of Edges for Torus");
                    }
                    for (ient = 0; ient <= nent; ++ient) {
                        nxtang[ient] = -1;
                    }
                    for (ient = 1; ient <= nent; ++ient) {
                        int l1 = -1;
                        int l2 = 0;
                        while (l2 != -1 && teang[ient] >= teang[l2]) {
                            l1 = l2;
                            l2 = nxtang[l2];
                        }
                        if (l1 == -1) {
                            throw new EnergyException(" Logic Error in SADDLES", true);
                        }
                        nxtang[l1] = ient;
                        nxtang[ient] = l2;
                    }
                    int l1 = 0;
                    while (l1 > -1) {
                        if (sdstrt[l1]) {
                            ++this.this$0.nSaddleFaces;
                            if (this.this$0.nSaddleFaces >= this.this$0.maxSaddleFace) {
                                throw new EnergyException(" Too many Saddle Faces");
                            }
                            this.this$0.saddleConcaveEdgeNumbers[0][this.this$0.nSaddleFaces] = ien = ten[l1];
                            ++this.this$0.nConvexEdges;
                            if (this.this$0.nConvexEdges >= this.this$0.maxConvexEdges) {
                                throw new EnergyException(" Too many Convex Edges");
                            }
                            this.this$0.convexEdgeCircleNumber[this.this$0.nConvexEdges] = this.this$0.nCircles;
                            int ia = this.this$0.circleAtomNumber[this.this$0.nCircles];
                            this.insertConvexEdgeForAtom(this.this$0.nConvexEdges, ia);
                            this.this$0.convexEdgeVertexNumber[0][this.this$0.nConvexEdges] = this.this$0.concaveEdgeVertexNumbers[1][ien];
                            this.this$0.saddleConvexEdgeNumbers[0][this.this$0.nSaddleFaces] = this.this$0.nConvexEdges++;
                            if (this.this$0.nConvexEdges >= this.this$0.maxConvexEdges) {
                                throw new EnergyException(" Too many Convex Edges");
                            }
                            this.this$0.convexEdgeCircleNumber[this.this$0.nConvexEdges] = this.this$0.nCircles - 1;
                            ia = this.this$0.circleAtomNumber[this.this$0.nCircles - 1];
                            this.insertConvexEdgeForAtom(this.this$0.nConvexEdges, ia);
                            this.this$0.convexEdgeVertexNumber[1][this.this$0.nConvexEdges] = this.this$0.concaveEdgeVertexNumbers[0][ien];
                            l1 = nxtang[l1];
                            if (l1 <= -1) {
                                l1 = 0;
                            }
                            if (sdstrt[l1]) {
                                int n1;
                                int m1 = nxtang[l1];
                                if (m1 <= -1) {
                                    m1 = 0;
                                }
                                if (sdstrt[m1]) {
                                    throw new EnergyException(" Three Starts in a Row");
                                }
                                nxtang[l1] = n1 = nxtang[m1];
                                nxtang[m1] = l1;
                                l1 = m1;
                            }
                            this.this$0.saddleConcaveEdgeNumbers[1][this.this$0.nSaddleFaces] = ien = ten[l1];
                            this.this$0.convexEdgeVertexNumber[1][this.this$0.nConvexEdges - 1] = this.this$0.concaveEdgeVertexNumbers[0][ien];
                            this.this$0.convexEdgeVertexNumber[0][this.this$0.nConvexEdges] = this.this$0.concaveEdgeVertexNumbers[1][ien];
                            this.this$0.saddleConvexEdgeNumbers[1][this.this$0.nSaddleFaces] = this.this$0.nConvexEdges;
                            if (l1 == 0) continue block0;
                        }
                        l1 = nxtang[l1];
                    }
                    continue;
                }
                ++this.this$0.nSaddleFaces;
                if (this.this$0.nSaddleFaces >= this.this$0.maxSaddleFace) {
                    throw new EnergyException(" Too many Saddle Faces");
                }
                this.this$0.saddleConcaveEdgeNumbers[0][this.this$0.nSaddleFaces] = -1;
                this.this$0.saddleConcaveEdgeNumbers[1][this.this$0.nSaddleFaces] = -1;
                ++this.this$0.nConvexEdges;
                int ia = this.this$0.circleAtomNumber[this.this$0.nCircles];
                this.insertConvexEdgeForAtom(this.this$0.nConvexEdges, ia);
                this.this$0.convexEdgeVertexNumber[0][this.this$0.nConvexEdges] = -1;
                this.this$0.convexEdgeVertexNumber[1][this.this$0.nConvexEdges] = -1;
                this.this$0.convexEdgeCircleNumber[this.this$0.nConvexEdges] = this.this$0.nCircles;
                this.this$0.saddleConvexEdgeNumbers[0][this.this$0.nSaddleFaces] = this.this$0.nConvexEdges++;
                ia = this.this$0.circleAtomNumber[this.this$0.nCircles - 1];
                this.insertConvexEdgeForAtom(this.this$0.nConvexEdges, ia);
                this.this$0.convexEdgeVertexNumber[0][this.this$0.nConvexEdges] = -1;
                this.this$0.convexEdgeVertexNumber[1][this.this$0.nConvexEdges] = -1;
                this.this$0.convexEdgeCircleNumber[this.this$0.nConvexEdges] = this.this$0.nCircles - 1;
                this.this$0.saddleConvexEdgeNumbers[1][this.this$0.nSaddleFaces] = this.this$0.nConvexEdges;
            }
            logger.fine(String.format(" Number of circles      %d", this.this$0.nCircles + 1));
            logger.fine(String.format(" Number of convex edges %d", this.this$0.nConvexEdges + 1));
            logger.fine(String.format(" Number of saddle faces %d", this.this$0.nSaddleFaces + 1));
        }

        private void contact() {
            int ia;
            int maxepa = 300;
            int maxcypa = 100;
            int[] aic = new int[300];
            int[] aia = new int[300];
            int[] aep = new int[300];
            int[][] av = new int[2][300];
            int[] ncyepa = new int[100];
            int[][] cyepa = new int[30][100];
            double[] ai = new double[3];
            double[][] acvect = new double[3][300];
            double[][] aavect = new double[3][300];
            double[] pole = new double[3];
            double[] acr = new double[300];
            double[] unvect = new double[3];
            boolean[] epused = new boolean[300];
            boolean[][] cycy = new boolean[100][100];
            boolean[] cyused = new boolean[100];
            boolean[][] samef = new boolean[100][100];
            this.this$0.nCycles = -1;
            this.this$0.nConvexFaces = -1;
            for (ia = 0; ia < this.this$0.nAtoms; ++ia) {
                if (!this.this$0.atomFreeOfNeighbors[ia]) continue;
                this.this$0.atomBuried[ia] = false;
            }
            block1: for (ia = 0; ia < this.this$0.nAtoms; ++ia) {
                if (this.this$0.skip[ia] || this.this$0.atomBuried[ia]) continue;
                for (int o = 0; o < 1; ++o) {
                    int kcya;
                    int jcya;
                    int icya;
                    if (this.this$0.atomFreeOfNeighbors[ia]) continue;
                    int nepa = -1;
                    int iep = this.this$0.convexEdgeFirst[ia];
                    while (iep > -1) {
                        int ic;
                        if (++nepa >= 300) {
                            throw new EnergyException(" Too many Convex Edges for Atom");
                        }
                        av[0][nepa] = this.this$0.convexEdgeVertexNumber[0][iep];
                        av[1][nepa] = this.this$0.convexEdgeVertexNumber[1][iep];
                        aep[nepa] = iep;
                        aic[nepa] = ic = this.this$0.convexEdgeCircleNumber[iep];
                        int it = this.this$0.circleTorusNumber[ic];
                        int ia2 = this.this$0.torusAtomNumber[0][it] == ia ? this.this$0.torusAtomNumber[1][it] : this.this$0.torusAtomNumber[0][it];
                        aia[nepa] = ia2;
                        for (int k = 0; k < 3; ++k) {
                            acvect[k][nepa] = this.this$0.circleCenter[k][ic] - this.this$0.atomCoords[k][ia];
                            aavect[k][nepa] = this.this$0.atomCoords[k][ia2] - this.this$0.atomCoords[k][ia];
                        }
                        acr[nepa] = this.this$0.circleRadius[ic];
                        iep = this.this$0.convexEdgeNext[iep];
                    }
                    if (nepa == -1) {
                        throw new EnergyException(" No Edges for Non-buried, Non-free Atom");
                    }
                    for (int iepa = 0; iepa < nepa + 1; ++iepa) {
                        epused[iepa] = false;
                    }
                    int ncyold = this.this$0.nCycles;
                    int nused = -1;
                    int ncypa = -1;
                    while (nused < nepa) {
                        int iepa;
                        for (iepa = 0; iepa <= nepa && epused[iepa]; ++iepa) {
                        }
                        if (iepa > nepa) break;
                        iep = aep[iepa];
                        int ncyep = 0;
                        if (++ncypa >= 100) {
                            throw new EnergyException(" Too many Cycles per Atom");
                        }
                        epused[iepa] = true;
                        ++nused;
                        ++this.this$0.nCycles;
                        if (this.this$0.nCycles >= this.this$0.maxCycles) {
                            throw new EnergyException(" Too many Cycles");
                        }
                        cyepa[ncyep][ncypa] = iepa;
                        this.this$0.convexEdgeCycleNumbers[ncyep][this.this$0.nCycles] = iep;
                        int lookv = av[1][iepa];
                        if (lookv > -1) {
                            for (int jepa = 0; jepa < nepa + 1; ++jepa) {
                                if (epused[jepa] || av[0][jepa] != lookv) continue;
                                iep = aep[jepa];
                                if (++ncyep >= 30) {
                                    throw new EnergyException(" Too many Edges per Cycle");
                                }
                                epused[jepa] = true;
                                ++nused;
                                cyepa[ncyep][ncypa] = jepa;
                                this.this$0.convexEdgeCycleNumbers[ncyep][this.this$0.nCycles] = iep;
                                lookv = av[1][jepa];
                                if (lookv <= -1) {
                                    throw new EnergyException(" Pointer Error in Cycle", true);
                                }
                                jepa = 0;
                            }
                            if (lookv != av[0][iepa]) {
                                throw new EnergyException(" Cycle does not Close", true);
                            }
                        }
                        ncyepa[ncypa] = ncyep;
                        this.this$0.convexEdgeCycleNum[this.this$0.nCycles] = ncyep;
                    }
                    for (icya = 0; icya <= ncypa; ++icya) {
                        block10: for (jcya = 0; jcya <= ncypa; ++jcya) {
                            int jcy = ncyold + jcya + 1;
                            cycy[icya][jcya] = true;
                            if (icya == jcya || ncyepa[jcya] < 2) continue;
                            for (int icyep = 0; icyep <= ncyepa[icya]; ++icyep) {
                                int iepa = cyepa[icyep][icya];
                                int ic = aic[iepa];
                                for (int jcyep = 0; jcyep <= ncyepa[jcya]; ++jcyep) {
                                    int jepa = cyepa[jcyep][jcya];
                                    int jc = aic[jepa];
                                    if (ic != jc) continue;
                                    cycy[icya][jcya] = false;
                                    continue block10;
                                }
                            }
                            int iepa = cyepa[0][icya];
                            ai[0] = aavect[0][iepa];
                            ai[1] = aavect[1][iepa];
                            ai[2] = aavect[2][iepa];
                            double anaa = DoubleMath.length((double[])ai);
                            double factor = this.this$0.radius[ia] / anaa;
                            for (int k = 0; k < 3; ++k) {
                                pole[k] = factor * aavect[k][iepa] + this.this$0.atomCoords[k][ia];
                                unvect[k] = -aavect[k][iepa] / anaa;
                            }
                            cycy[icya][jcya] = this.ptincy(pole, unvect, jcy);
                        }
                    }
                    for (icya = 0; icya <= ncypa; ++icya) {
                        for (jcya = 0; jcya <= ncypa; ++jcya) {
                            samef[icya][jcya] = cycy[icya][jcya] && cycy[jcya][icya];
                        }
                    }
                    for (icya = 0; icya <= ncypa; ++icya) {
                        for (jcya = 0; jcya <= ncypa; ++jcya) {
                            if (icya == jcya) continue;
                            for (kcya = 0; kcya <= ncypa; ++kcya) {
                                if (kcya == icya || kcya == jcya || !cycy[kcya][icya] || !cycy[kcya][jcya] || cycy[icya][kcya]) continue;
                                samef[icya][jcya] = false;
                                samef[jcya][icya] = false;
                            }
                        }
                    }
                    for (icya = 0; icya < ncypa - 1; ++icya) {
                        for (jcya = icya + 1; jcya < ncypa; ++jcya) {
                            if (!samef[icya][jcya]) continue;
                            for (kcya = jcya + 1; kcya <= ncypa; ++kcya) {
                                if (!samef[jcya][kcya]) continue;
                                samef[icya][kcya] = true;
                                samef[kcya][icya] = true;
                            }
                        }
                    }
                    for (icya = 0; icya <= ncypa; ++icya) {
                        cyused[icya] = false;
                    }
                    nused = -1;
                    for (icya = 0; icya <= ncypa; ++icya) {
                        if (cyused[icya]) continue;
                        ++this.this$0.nConvexFaces;
                        if (this.this$0.nConvexFaces >= this.this$0.maxConvexFaces) {
                            throw new EnergyException(" Too many Convex Faces");
                        }
                        this.this$0.convexFaceNumCycles[this.this$0.nConvexFaces] = -1;
                        this.this$0.convexFaceAtomNumber[this.this$0.nConvexFaces] = ia;
                        for (jcya = 0; jcya <= ncypa; ++jcya) {
                            if (cyused[jcya] || !samef[icya][jcya]) continue;
                            cyused[jcya] = true;
                            ++nused;
                            int n = this.this$0.nConvexFaces;
                            this.this$0.convexFaceNumCycles[n] = this.this$0.convexFaceNumCycles[n] + 1;
                            if (this.this$0.convexFaceNumCycles[this.this$0.nConvexFaces] >= 10) {
                                throw new EnergyException(" Too many Cycles bounding Convex Face");
                            }
                            int i = this.this$0.convexFaceNumCycles[this.this$0.nConvexFaces];
                            this.this$0.convexFaceCycleNumbers[i][this.this$0.nConvexFaces] = ncyold + jcya + 1;
                            if (nused >= ncypa) continue block1;
                        }
                    }
                    throw new EnergyException(" Not all Cycles grouped into Convex Faces", true);
                }
                ++this.this$0.nConvexFaces;
                if (this.this$0.nConvexFaces >= this.this$0.maxConvexFaces) {
                    throw new EnergyException(" Too many Convex Faces");
                }
                this.this$0.convexFaceAtomNumber[this.this$0.nConvexFaces] = ia;
                this.this$0.convexFaceNumCycles[this.this$0.nConvexFaces] = -1;
            }
        }

        private void vam() {
            int maxdot = 1000;
            int maxop = 100;
            int nscale = 20;
            int[] ivs = new int[3];
            int[] ispind = new int[3];
            int[] ispnd2 = new int[3];
            int[] ifnop = new int[100];
            int[] enfs = new int[20 * this.this$0.nAtoms];
            double[][] cenop = new double[3][100];
            double[] sdot = new double[3];
            double[] dotv = new double[20];
            double[] tau = new double[3];
            double[] ppm = new double[3];
            double[] xpnt1 = new double[3];
            double[] xpnt2 = new double[3];
            double[] qij = new double[3];
            double[] qji = new double[3];
            double[][] vects = new double[3][3];
            double[] vect1 = new double[3];
            double[] vect2 = new double[3];
            double[] vect3 = new double[3];
            double[] vect4 = new double[3];
            double[] vect5 = new double[3];
            double[] vect6 = new double[3];
            double[] vect7 = new double[3];
            double[] vect8 = new double[3];
            double[] upp = new double[3];
            double[] thetaq = new double[3];
            double[] sigmaq = new double[3];
            double[] umq = new double[3];
            double[] upq = new double[3];
            double[] uc = new double[3];
            double[] uq = new double[3];
            double[] uij = new double[3];
            double[] ai = new double[3];
            double[] aj = new double[3];
            double[] ak = new double[3];
            double[] al = new double[3];
            double[][] dots = new double[3][1000];
            double[][] tdots = new double[3][1000];
            double[] atomArea = new double[this.this$0.nAtoms];
            boolean[] ate = new boolean[100];
            boolean[] vip = new boolean[3];
            boolean[] cinsp = new boolean[1];
            int[] nlap = null;
            int[][] fnt = null;
            int[][] nspt = null;
            double[] depths = null;
            double[] cora = null;
            double[] corv = null;
            double[][] alts = null;
            double[][] fncen = null;
            double[][][] fnvect = null;
            boolean[] badav = null;
            boolean[] badt = null;
            boolean[][] fcins = null;
            boolean[][] fcint = null;
            boolean[][] fntrev = null;
            if (this.this$0.nConcaveFaces >= 0) {
                nlap = new int[this.this$0.nConcaveFaces + 1];
                fnt = new int[3][this.this$0.nConcaveFaces + 1];
                nspt = new int[3][this.this$0.nConcaveFaces + 1];
                depths = new double[this.this$0.nConcaveFaces + 1];
                cora = new double[this.this$0.nConcaveFaces + 1];
                corv = new double[this.this$0.nConcaveFaces + 1];
                alts = new double[3][this.this$0.nConcaveFaces + 1];
                fncen = new double[3][this.this$0.nConcaveFaces + 1];
                fnvect = new double[3][3][this.this$0.nConcaveFaces + 1];
                badav = new boolean[this.this$0.nConcaveFaces + 1];
                badt = new boolean[this.this$0.nConcaveFaces + 1];
                fcins = new boolean[3][this.this$0.nConcaveFaces + 1];
                fcint = new boolean[3][this.this$0.nConcaveFaces + 1];
                fntrev = new boolean[3][this.this$0.nConcaveFaces + 1];
            }
            double polyhedronVolume = 0.0;
            for (int i = 0; i <= this.this$0.nConcaveFaces; ++i) {
                polyhedronVolume += this.measurePrism(i);
            }
            double convexFaceArea = 0.0;
            double convexFaceVolume = 0.0;
            Arrays.fill(atomArea, 0.0);
            double[] convexFaces = new double[]{0.0, 0.0};
            for (int i = 0; i <= this.this$0.nConvexFaces; ++i) {
                int ia;
                this.measureConvexFace(i, convexFaces);
                int n = ia = this.this$0.convexFaceAtomNumber[i];
                atomArea[n] = atomArea[n] + convexFaces[0];
                convexFaceArea += convexFaces[0];
                convexFaceVolume += convexFaces[1];
            }
            double saddleFaceArea = 0.0;
            double saddleFaceVolume = 0.0;
            double spindleArea = 0.0;
            double spindleVolume = 0.0;
            double[] saddle = new double[]{0.0, 0.0, 0.0, 0.0};
            for (int i = 0; i <= this.this$0.nSaddleFaces; ++i) {
                for (int k = 0; k < 2; ++k) {
                    int ien = this.this$0.saddleConcaveEdgeNumbers[k][i];
                    if (ien <= -1) continue;
                    enfs[ien] = i;
                }
                this.measureSaddleFace(i, saddle);
                double areas = saddle[0];
                double vols = saddle[1];
                double areasp = saddle[2];
                double volsp = saddle[3];
                saddleFaceArea += areas;
                saddleFaceVolume += vols;
                spindleArea += areasp;
                spindleVolume += volsp;
                if (!(areas - areasp < 0.0)) continue;
                throw new EnergyException(" Negative Area for Saddle Face", true);
            }
            double concaveFaceArea = 0.0;
            double concaveFaceVolume = 0.0;
            double[] concaveFaces = new double[]{0.0, 0.0};
            for (int i = 0; i <= this.this$0.nConcaveFaces; ++i) {
                this.measureConcaveFace(i, concaveFaces);
                double arean = concaveFaces[0];
                double voln = concaveFaces[1];
                concaveFaceArea += arean;
                concaveFaceVolume += voln;
            }
            double lensArea = 0.0;
            double lensAreaNumeric = 0.0;
            double lensVolume = 0.0;
            double lensVolumeNumeric = 0.0;
            if (this.this$0.probe > 0.0) {
                int k;
                int ifn;
                int ndots = this.genDots(1000, dots, this.this$0.probe);
                double dota = Math.PI * 4 * this.this$0.probe * this.this$0.probe / (double)ndots;
                for (ifn = 0; ifn <= this.this$0.nConcaveFaces; ++ifn) {
                    int ke;
                    nlap[ifn] = -1;
                    cora[ifn] = 0.0;
                    corv[ifn] = 0.0;
                    badav[ifn] = false;
                    badt[ifn] = false;
                    for (int k2 = 0; k2 < 3; ++k2) {
                        nspt[k2][ifn] = -1;
                    }
                    int ien = this.this$0.concaveFaceEdgeNumbers[0][ifn];
                    int iv = this.this$0.concaveEdgeVertexNumbers[0][ien];
                    int ip = this.this$0.vertexProbeNumber[iv];
                    this.getVector(ai, alts, ifn);
                    depths[ifn] = this.depth(ip, ai);
                    for (int k3 = 0; k3 < 3; ++k3) {
                        fncen[k3][ifn] = this.this$0.probeCoords[k3][ip];
                    }
                    for (ke = 0; ke < 3; ++ke) {
                        int it;
                        ien = this.this$0.concaveFaceEdgeNumbers[ke][ifn];
                        ivs[ke] = this.this$0.concaveEdgeVertexNumbers[0][ien];
                        int ia = this.this$0.vertexAtomNumbers[ivs[ke]];
                        int ifs = enfs[ien];
                        int iep = this.this$0.saddleConvexEdgeNumbers[0][ifs];
                        int ic = this.this$0.convexEdgeCircleNumber[iep];
                        fnt[ke][ifn] = it = this.this$0.circleTorusNumber[ic];
                        fntrev[ke][ifn] = this.this$0.torusAtomNumber[0][it] != ia;
                    }
                    for (ke = 0; ke < 3; ++ke) {
                        for (int k4 = 0; k4 < 3; ++k4) {
                            vects[k4][ke] = this.this$0.vertexCoords[k4][ivs[ke]] - this.this$0.probeCoords[k4][ip];
                        }
                    }
                    this.getVector(ai, vects, 0);
                    this.getVector(aj, vects, 1);
                    DoubleMath.X((double[])ai, (double[])aj, (double[])ak);
                    DoubleMath.normalize((double[])ak, (double[])ak);
                    this.putVector(ak, fnvect, 0, ifn);
                    this.getVector(ak, vects, 2);
                    DoubleMath.X((double[])aj, (double[])ak, (double[])ai);
                    DoubleMath.normalize((double[])ai, (double[])ai);
                    this.putVector(ai, fnvect, 1, ifn);
                    this.getVector(ai, vects, 0);
                    DoubleMath.X((double[])ak, (double[])ai, (double[])aj);
                    DoubleMath.normalize((double[])aj, (double[])aj);
                    this.putVector(aj, fnvect, 2, ifn);
                }
                for (ifn = 0; ifn <= this.this$0.nConcaveFaces - 1; ++ifn) {
                    for (int jfn = ifn + 1; jfn <= this.this$0.nConcaveFaces; ++jfn) {
                        int k5;
                        boolean cintp;
                        int ke2;
                        int k6;
                        int iv2;
                        int iv1;
                        int ke;
                        boolean case2;
                        this.getVector(ai, fncen, ifn);
                        this.getVector(aj, fncen, jfn);
                        double dij2 = DoubleMath.dist2((double[])ai, (double[])aj);
                        if (dij2 > 4.0 * this.this$0.probe * this.this$0.probe || depths[ifn] > this.this$0.probe && depths[jfn] > this.this$0.probe) continue;
                        double dpp = DoubleMath.dist((double[])ai, (double[])aj);
                        for (int k7 = 0; k7 < 3; ++k7) {
                            ppm[k7] = (fncen[k7][ifn] + fncen[k7][jfn]) / 2.0;
                            upp[k7] = (fncen[k7][jfn] - fncen[k7][ifn]) / dpp;
                        }
                        double rm = this.this$0.probe * this.this$0.probe - dpp / 2.0 * (dpp / 2.0);
                        if (rm < 0.0) {
                            rm = 0.0;
                        }
                        rm = FastMath.sqrt((double)rm);
                        double rat = this.check(dpp / (2.0 * this.this$0.probe));
                        double rho = FastMath.asin((double)rat);
                        boolean alli = true;
                        boolean anyi = false;
                        boolean spindl = false;
                        for (k = 0; k < 3; ++k) {
                            ispind[k] = -1;
                            ispnd2[k] = -1;
                        }
                        for (int ke3 = 0; ke3 < 3; ++ke3) {
                            int k8;
                            int it;
                            thetaq[ke3] = 0.0;
                            sigmaq[ke3] = 0.0;
                            tau[ke3] = 0.0;
                            this.getVector(ai, fncen, ifn);
                            this.getVector(aj, fnvect, ke3, ifn);
                            boolean cintp2 = this.circlePlane(ppm, rm, upp, ai, aj, cinsp, xpnt1, xpnt2);
                            fcins[ke3][ifn] = cinsp[0];
                            fcint[ke3][ifn] = cintp2;
                            if (!cinsp[0]) {
                                alli = false;
                            }
                            if (cintp2) {
                                anyi = true;
                            }
                            if (!cintp2 || this.this$0.torusRadius[it = fnt[ke3][ifn]] > this.this$0.probe) continue;
                            for (int ke22 = 0; ke22 < 3; ++ke22) {
                                if (it != fnt[ke22][jfn]) continue;
                                ispind[ke3] = it;
                                int[] nArray = nspt[ke3];
                                int n = ifn;
                                nArray[n] = nArray[n] + 1;
                                ispnd2[ke22] = it;
                                int[] nArray2 = nspt[ke22];
                                int n2 = jfn;
                                nArray2[n2] = nArray2[n2] + 1;
                                spindl = true;
                            }
                            if (ispind[ke3] == -1) continue;
                            rat = this.check(this.this$0.torusRadius[it] / this.this$0.probe);
                            thetaq[ke3] = FastMath.acos((double)rat);
                            double stq = FastMath.sin((double)thetaq[ke3]);
                            if (fntrev[ke3][ifn]) {
                                for (k8 = 0; k8 < 3; ++k8) {
                                    uij[k8] = -this.this$0.torusAxis[k8][it];
                                }
                            } else {
                                for (k8 = 0; k8 < 3; ++k8) {
                                    uij[k8] = this.this$0.torusAxis[k8][it];
                                }
                            }
                            for (k8 = 0; k8 < 3; ++k8) {
                                qij[k8] = this.this$0.torusCenter[k8][it] - stq * this.this$0.probe * uij[k8];
                                qji[k8] = this.this$0.torusCenter[k8][it] + stq * this.this$0.probe * uij[k8];
                            }
                            for (k8 = 0; k8 < 3; ++k8) {
                                umq[k8] = (qij[k8] - ppm[k8]) / rm;
                                upq[k8] = (qij[k8] - fncen[k8][ifn]) / this.this$0.probe;
                            }
                            DoubleMath.X((double[])uij, (double[])upp, (double[])vect1);
                            double dt = this.check(DoubleMath.dot((double[])umq, (double[])vect1));
                            sigmaq[ke3] = FastMath.acos((double)dt);
                            this.getVector(ai, fnvect, ke3, ifn);
                            DoubleMath.X((double[])upq, (double[])ai, (double[])vect1);
                            DoubleMath.normalize((double[])vect1, (double[])uc);
                            DoubleMath.X((double[])upp, (double[])upq, (double[])vect1);
                            DoubleMath.normalize((double[])vect1, (double[])uq);
                            dt = this.check(DoubleMath.dot((double[])uc, (double[])uq));
                            tau[ke3] = Math.PI - FastMath.acos((double)dt);
                        }
                        boolean allj = true;
                        boolean anyj = false;
                        for (int ke4 = 0; ke4 < 3; ++ke4) {
                            this.getVector(ai, fncen, jfn);
                            this.getVector(aj, fnvect, ke4, jfn);
                            boolean cintp3 = this.circlePlane(ppm, rm, upp, ai, aj, cinsp, xpnt1, xpnt2);
                            fcins[ke4][jfn] = cinsp[0];
                            fcint[ke4][jfn] = cintp3;
                            if (!cinsp[0]) {
                                allj = false;
                            }
                            if (!cintp3) continue;
                            anyj = true;
                        }
                        boolean case1 = alli && allj && !anyi && !anyj;
                        boolean bl = case2 = anyi && anyj && spindl;
                        if (!case1 && !case2) continue;
                        int n = ifn;
                        nlap[n] = nlap[n] + 1;
                        int n3 = jfn;
                        nlap[n3] = nlap[n3] + 1;
                        for (ke = 0; ke < 3; ++ke) {
                            int ien = this.this$0.concaveFaceEdgeNumbers[ke][ifn];
                            iv1 = this.this$0.concaveEdgeVertexNumbers[0][ien];
                            iv2 = this.this$0.concaveEdgeVertexNumbers[1][ien];
                            for (k6 = 0; k6 < 3; ++k6) {
                                vect3[k6] = this.this$0.vertexCoords[k6][iv1] - fncen[k6][ifn];
                                vect4[k6] = this.this$0.vertexCoords[k6][iv2] - fncen[k6][ifn];
                            }
                            for (ke2 = 0; ke2 < 3; ++ke2) {
                                if (ispind[ke] == ispnd2[ke2] || ispind[ke] == -1) continue;
                                this.getVector(ai, fncen, ifn);
                                this.getVector(aj, fnvect, ke, ifn);
                                this.getVector(ak, fncen, jfn);
                                this.getVector(al, fnvect, ke2, jfn);
                                cintp = this.circlePlane(ai, this.this$0.probe, aj, ak, al, cinsp, xpnt1, xpnt2);
                                if (!cintp) continue;
                                ien = this.this$0.concaveFaceEdgeNumbers[ke2][jfn];
                                iv1 = this.this$0.concaveEdgeVertexNumbers[0][ien];
                                iv2 = this.this$0.concaveEdgeVertexNumbers[1][ien];
                                for (k5 = 0; k5 < 3; ++k5) {
                                    vect7[k5] = this.this$0.vertexCoords[k5][iv1] - fncen[k5][jfn];
                                    vect8[k5] = this.this$0.vertexCoords[k5][iv2] - fncen[k5][jfn];
                                }
                                for (k5 = 0; k5 < 3; ++k5) {
                                    vect1[k5] = xpnt1[k5] - fncen[k5][ifn];
                                    vect2[k5] = xpnt2[k5] - fncen[k5][ifn];
                                    vect5[k5] = xpnt1[k5] - fncen[k5][jfn];
                                    vect6[k5] = xpnt2[k5] - fncen[k5][jfn];
                                }
                                this.getVector(ai, fnvect, ke, ifn);
                                this.getVector(aj, fnvect, ke2, jfn);
                                if (this.tripleProduct(vect3, vect1, ai) < 0.0 || this.tripleProduct(vect1, vect4, ai) < 0.0 || this.tripleProduct(vect7, vect5, aj) < 0.0 || this.tripleProduct(vect5, vect8, aj) < 0.0) {
                                    if (this.tripleProduct(vect3, vect2, ai) < 0.0 || this.tripleProduct(vect2, vect4, ai) < 0.0 || this.tripleProduct(vect7, vect6, aj) < 0.0 || this.tripleProduct(vect6, vect8, aj) < 0.0) continue;
                                    badav[ifn] = true;
                                    continue;
                                }
                                badav[ifn] = true;
                            }
                        }
                        for (ke = 0; ke < 3; ++ke) {
                            int ien = this.this$0.concaveFaceEdgeNumbers[ke][ifn];
                            iv1 = this.this$0.concaveEdgeVertexNumbers[0][ien];
                            iv2 = this.this$0.concaveEdgeVertexNumbers[1][ien];
                            for (k6 = 0; k6 < 3; ++k6) {
                                vect3[k6] = this.this$0.vertexCoords[k6][iv1] - fncen[k6][ifn];
                                vect4[k6] = this.this$0.vertexCoords[k6][iv2] - fncen[k6][ifn];
                            }
                            for (ke2 = 0; ke2 < 3; ++ke2) {
                                if (ispind[ke] == ispnd2[ke2] || ispnd2[ke2] == -1) continue;
                                this.getVector(ai, fncen, ifn);
                                this.getVector(aj, fnvect, ke, ifn);
                                this.getVector(ak, fncen, jfn);
                                this.getVector(al, fnvect, ke2, jfn);
                                cintp = this.circlePlane(ak, this.this$0.probe, al, ai, aj, cinsp, xpnt1, xpnt2);
                                if (!cintp) continue;
                                ien = this.this$0.concaveFaceEdgeNumbers[ke2][jfn];
                                iv1 = this.this$0.concaveEdgeVertexNumbers[0][ien];
                                iv2 = this.this$0.concaveEdgeVertexNumbers[1][ien];
                                for (k5 = 0; k5 < 3; ++k5) {
                                    vect7[k5] = this.this$0.vertexCoords[k5][iv1] - fncen[k5][jfn];
                                    vect8[k5] = this.this$0.vertexCoords[k5][iv2] - fncen[k5][jfn];
                                }
                                for (k5 = 0; k5 < 3; ++k5) {
                                    vect1[k5] = xpnt1[k5] - fncen[k5][ifn];
                                    vect2[k5] = xpnt2[k5] - fncen[k5][ifn];
                                    vect5[k5] = xpnt1[k5] - fncen[k5][jfn];
                                    vect6[k5] = xpnt2[k5] - fncen[k5][jfn];
                                }
                                this.getVector(ai, fnvect, ke, ifn);
                                this.getVector(aj, fnvect, ke2, jfn);
                                if (this.tripleProduct(vect3, vect1, ai) < 0.0 || this.tripleProduct(vect1, vect4, ai) < 0.0 || this.tripleProduct(vect7, vect5, aj) < 0.0 || this.tripleProduct(vect5, vect8, aj) < 0.0) {
                                    if (this.tripleProduct(vect3, vect2, ai) < 0.0 || this.tripleProduct(vect2, vect4, ai) < 0.0 || this.tripleProduct(vect7, vect6, aj) < 0.0 || this.tripleProduct(vect6, vect8, aj) < 0.0) continue;
                                    badav[jfn] = true;
                                    continue;
                                }
                                badav[jfn] = true;
                            }
                        }
                        double sumlam = 0.0;
                        double sumsig = 0.0;
                        double sumsc = 0.0;
                        for (int ke5 = 0; ke5 < 3; ++ke5) {
                            if (ispind[ke5] == -1) continue;
                            sumlam += Math.PI - tau[ke5];
                            sumsig += sigmaq[ke5] - Math.PI;
                            sumsc += FastMath.sin((double)sigmaq[ke5]) * FastMath.cos((double)sigmaq[ke5]);
                        }
                        double alens = 2.0 * this.this$0.probe * this.this$0.probe * (Math.PI - sumlam - FastMath.sin((double)rho) * (Math.PI + sumsig));
                        double vint = alens * this.this$0.probe / 3.0;
                        double vcone = this.this$0.probe * rm * rm * FastMath.sin((double)rho) * (Math.PI + sumsig) / 3.0;
                        double vpyr = this.this$0.probe * rm * rm * FastMath.sin((double)rho) * sumsc / 3.0;
                        double vlens = vint - vcone + vpyr;
                        int n4 = ifn;
                        cora[n4] = cora[n4] + alens;
                        int n5 = jfn;
                        cora[n5] = cora[n5] + alens;
                        int n6 = ifn;
                        corv[n6] = corv[n6] + vlens;
                        int n7 = jfn;
                        corv[n7] = corv[n7] + vlens;
                        block33: for (int kv = 0; kv < 3; ++kv) {
                            vip[kv] = false;
                            int ien = this.this$0.concaveFaceEdgeNumbers[kv][jfn];
                            int iv = this.this$0.concaveEdgeVertexNumbers[0][ien];
                            for (int k9 = 0; k9 < 3; ++k9) {
                                vect1[k9] = this.this$0.vertexCoords[k9][iv] - fncen[k9][ifn];
                            }
                            DoubleMath.normalize((double[])vect1, (double[])vect1);
                            for (int ke6 = 0; ke6 < 3; ++ke6) {
                                this.getVector(ai, fnvect, ke6, ifn);
                                this.getVector(aj, this.this$0.vertexCoords, iv);
                                double dt = DoubleMath.dot((double[])ai, (double[])aj);
                                if (dt > 0.0) continue block33;
                                vip[kv] = true;
                            }
                        }
                    }
                }
                block36: for (ifn = 0; ifn <= this.this$0.nConcaveFaces; ++ifn) {
                    for (int ke = 0; ke < 3; ++ke) {
                        if (nspt[ke][ifn] <= 0) continue;
                        badt[ifn] = true;
                        break block36;
                    }
                }
                double fourProbe2 = 4.0 * this.this$0.probe * this.this$0.probe;
                for (int ifn2 = 0; ifn2 <= this.this$0.nConcaveFaces; ++ifn2) {
                    boolean usenum;
                    int iop;
                    if (nlap[ifn2] <= -1) continue;
                    int nop = -1;
                    for (int jfn = 0; jfn <= this.this$0.nConcaveFaces; ++jfn) {
                        if (ifn2 == jfn) continue;
                        this.getVector(ai, fncen, ifn2);
                        this.getVector(aj, fncen, jfn);
                        double dij2 = DoubleMath.dist2((double[])ai, (double[])aj);
                        if (!(dij2 <= fourProbe2) || !(depths[jfn] <= this.this$0.probe)) continue;
                        if (++nop >= 100) {
                            throw new EnergyException(" NOP Overflow in VAM");
                        }
                        ifnop[nop] = jfn;
                        for (int k10 = 0; k10 < 3; ++k10) {
                            cenop[k10][nop] = fncen[k10][jfn];
                        }
                    }
                    double areado = 0.0;
                    double voldo = 0.0;
                    double scinc = 0.05;
                    for (int isc = 0; isc < 20; ++isc) {
                        double rsc = (double)(isc + 1) - 0.5;
                        dotv[isc] = this.this$0.probe * dota * rsc * rsc * scinc * scinc * scinc;
                    }
                    for (int iop2 = 0; iop2 <= nop; ++iop2) {
                        ate[iop2] = false;
                    }
                    int neatmx = 0;
                    block43: for (int idot = 0; idot < ndots; ++idot) {
                        for (int ke = 0; ke < 3; ++ke) {
                            this.getVector(ai, fnvect, ke, ifn2);
                            this.getVector(aj, dots, idot);
                            double dt = DoubleMath.dot((double[])ai, (double[])aj);
                            if (dt > 0.0) continue block43;
                        }
                        for (int k11 = 0; k11 < 3; ++k11) {
                            tdots[k11][idot] = fncen[k11][ifn2] + dots[k11][idot];
                        }
                        for (int iop3 = 0; iop3 <= nop; ++iop3) {
                            int jfn = ifnop[iop3];
                            this.getVector(ai, tdots, idot);
                            this.getVector(aj, fncen, jfn);
                            double ds2 = DoubleMath.dist2((double[])ai, (double[])aj);
                            if (!(ds2 < this.this$0.probe * this.this$0.probe)) continue;
                            areado += dota;
                            break;
                        }
                        for (int isc = 0; isc < 20; ++isc) {
                            double rsc = (double)(isc + 1) - 0.5;
                            for (k = 0; k < 3; ++k) {
                                sdot[k] = fncen[k][ifn2] + rsc * scinc * dots[k][idot];
                            }
                            int neat = 0;
                            block49: for (iop = 0; iop <= nop; ++iop) {
                                int jfn = ifnop[iop];
                                this.getVector(ai, fncen, jfn);
                                double ds2 = DoubleMath.dist2((double[])sdot, (double[])ai);
                                if (!(ds2 < this.this$0.probe * this.this$0.probe)) continue;
                                for (int k12 = 0; k12 < 3; ++k12) {
                                    vect1[k12] = sdot[k12] - fncen[k12][jfn];
                                }
                                for (int ke = 0; ke < 3; ++ke) {
                                    this.getVector(ai, fnvect, ke, jfn);
                                    double dt = DoubleMath.dot((double[])ai, (double[])vect1);
                                    if (dt > 0.0) continue block49;
                                }
                                ++neat;
                                ate[iop] = true;
                            }
                            if (neat > neatmx) {
                                neatmx = neat;
                            }
                            if (neat <= 0) continue;
                            voldo += dotv[isc] * ((double)neat / (1.0 + (double)neat));
                        }
                    }
                    double coran = areado;
                    double corvn = voldo;
                    int nate = 0;
                    for (iop = 0; iop <= nop; ++iop) {
                        if (!ate[iop]) continue;
                        ++nate;
                    }
                    boolean bl = usenum = nate > nlap[ifn2] + 1 || neatmx > 1 || badt[ifn2];
                    if (usenum) {
                        cora[ifn2] = coran;
                        corv[ifn2] = corvn;
                        lensAreaNumeric += cora[ifn2];
                        lensVolumeNumeric += corv[ifn2];
                    } else if (badav[ifn2]) {
                        corv[ifn2] = corvn;
                        lensVolumeNumeric += corv[ifn2];
                    }
                    lensArea += cora[ifn2];
                    lensVolume += corv[ifn2];
                }
            }
            if (logger.isLoggable(Level.FINE)) {
                logger.fine(String.format(" Convex Faces:     %6d Area: %12.6f Volume: %12.6f", this.this$0.nConvexFaces + 1, convexFaceArea, convexFaceVolume));
                logger.fine(String.format(" Saddle Faces:     %6d Area: %12.6f Volume: %12.6f", this.this$0.nSaddleFaces + 1, saddleFaceArea, saddleFaceVolume));
                logger.fine(String.format(" Concave Faces:    %6d Area: %12.6f Volume: %12.6f", this.this$0.nConcaveFaces + 1, concaveFaceArea, concaveFaceVolume));
                logger.fine(String.format(" Buried Polyhedron:                          Volume: %12.6f", polyhedronVolume));
                if (this.this$0.probe > 0.0) {
                    logger.fine(String.format("\n Spindle Correction:            Area: %12.6f Volume: %12.6f", -spindleArea, -spindleVolume));
                    logger.fine(String.format(" Lens Analytic Correction:      Area: %12.6f Volume: %12.6f", -lensArea - lensAreaNumeric, lensVolume - lensVolumeNumeric));
                    logger.fine(String.format(" Lens Numerical Correction:     Area: %12.6f Volume: %12.6f", lensAreaNumeric, lensVolumeNumeric));
                }
            }
            double area = convexFaceArea + saddleFaceArea + concaveFaceArea - spindleArea - lensArea;
            double volume = convexFaceVolume + saddleFaceVolume + concaveFaceVolume + polyhedronVolume - spindleVolume + lensVolume;
            this.localVolume += volume;
            this.localSurfaceArea += area;
        }

        private double tripleProduct(double[] x, double[] y, double[] z) {
            double[] xy = new double[3];
            DoubleMath.X((double[])x, (double[])y, (double[])xy);
            return DoubleMath.dot((double[])xy, (double[])z);
        }

        private void insertConvexEdgeForAtom(int edgeNumber, int atomNumber) {
            if (edgeNumber <= -1) {
                throw new EnergyException(" Bad Edge Number in IPEDGE", true);
            }
            if (atomNumber <= -1) {
                throw new EnergyException(" Bad Atom Number in IPEDGE", true);
            }
            if (this.this$0.convexEdgeFirst[atomNumber] == -1) {
                this.this$0.convexEdgeFirst[atomNumber] = edgeNumber;
            } else {
                this.this$0.convexEdgeNext[this.this$0.convexEdgeLast[atomNumber]] = edgeNumber;
            }
            this.this$0.convexEdgeNext[edgeNumber] = -1;
            this.this$0.convexEdgeLast[atomNumber] = edgeNumber;
        }

        private boolean ptincy(double[] northPole, double[] unitVector, int icy) {
            double[] acvect = new double[3];
            double[] cpvect = new double[3];
            double[][] projectedVertsForConvexEdges = new double[3][30];
            double[][] unitVectorsAlongEdges = new double[3][30];
            int iatom = -1;
            for (int ke = 0; ke <= this.this$0.convexEdgeCycleNum[icy]; ++ke) {
                int iep = this.this$0.convexEdgeCycleNumbers[ke][icy];
                int ic = this.this$0.convexEdgeCircleNumber[iep];
                int it = this.this$0.circleTorusNumber[ic];
                iatom = this.this$0.circleAtomNumber[ic];
                int iaoth = this.this$0.torusAtomNumber[0][it] == iatom ? this.this$0.torusAtomNumber[1][it] : this.this$0.torusAtomNumber[0][it];
                for (int k = 0; k < 3; ++k) {
                    acvect[k] = this.this$0.atomCoords[k][iaoth] - this.this$0.atomCoords[k][iatom];
                    cpvect[k] = northPole[k] - this.this$0.circleCenter[k][ic];
                }
                if (!(DoubleMath.dot((double[])acvect, (double[])cpvect) >= 0.0)) continue;
                return false;
            }
            if (this.this$0.convexEdgeCycleNum[icy] <= 1) {
                return true;
            }
            if (this.projectedVertexForEachConvexEdge(northPole, unitVector, icy, iatom, projectedVertsForConvexEdges)) {
                return true;
            }
            int nEdges = this.this$0.convexEdgeCycleNum[icy];
            this.unitVectorsAlongEdges(projectedVertsForConvexEdges, nEdges, unitVectorsAlongEdges);
            double angleSum = this.sumOfAnglesAtVerticesForCycle(unitVectorsAlongEdges, nEdges, unitVector);
            return angleSum > 0.0;
        }

        private boolean projectedVertexForEachConvexEdge(double[] northPole, double[] unitVector, int icy, int ia, double[][] projectedVertsForConvexEdges) {
            double[] polev = new double[3];
            for (int ke = 0; ke <= this.this$0.convexEdgeCycleNum[icy]; ++ke) {
                int iep = this.this$0.convexEdgeCycleNumbers[ke][icy];
                int iv = this.this$0.convexEdgeVertexNumber[0][iep];
                if (iv == -1) continue;
                for (int k = 0; k < 3; ++k) {
                    polev[k] = this.this$0.vertexCoords[k][iv] - northPole[k];
                }
                double dt = DoubleMath.dot((double[])polev, (double[])unitVector);
                if (dt == 0.0) {
                    return true;
                }
                double f = 2.0 * this.this$0.radius[ia] / dt;
                if (f < 1.0) {
                    return true;
                }
                for (int k = 0; k < 3; ++k) {
                    projectedVertsForConvexEdges[k][ke] = northPole[k] + f * polev[k];
                }
            }
            return false;
        }

        private double sumOfAnglesAtVerticesForCycle(double[][] unitVectorsAlongEdges, int nEdges, double[] unitVector) {
            double[] crs = new double[3];
            double[] ai = new double[3];
            double[] aj = new double[3];
            double sumOfAngles = 0.0;
            for (int ke = 0; ke <= nEdges; ++ke) {
                double dt;
                if (ke < nEdges) {
                    this.getVector(ai, unitVectorsAlongEdges, ke);
                    this.getVector(aj, unitVectorsAlongEdges, ke + 1);
                    dt = DoubleMath.dot((double[])ai, (double[])aj);
                    DoubleMath.X((double[])ai, (double[])aj, (double[])crs);
                } else {
                    this.getVector(ai, unitVectorsAlongEdges, ke);
                    this.getVector(aj, unitVectorsAlongEdges, 0);
                    dt = DoubleMath.dot((double[])ai, (double[])aj);
                    DoubleMath.X((double[])ai, (double[])aj, (double[])crs);
                }
                dt = this.check(dt);
                double ang = FastMath.acos((double)dt);
                if (DoubleMath.dot((double[])crs, (double[])unitVector) > 0.0) {
                    ang = -ang;
                }
                sumOfAngles += ang;
            }
            return sumOfAngles;
        }

        private void unitVectorsAlongEdges(double[][] projectedVertsForConvexEdges, int nEdges, double[][] unitVectorsAlongEdges) {
            int ke;
            double[] ai = new double[3];
            for (ke = 0; ke <= nEdges; ++ke) {
                int k;
                int ke2 = ke < nEdges ? ke + 1 : 0;
                for (int k2 = 0; k2 < 3; ++k2) {
                    unitVectorsAlongEdges[k2][ke] = projectedVertsForConvexEdges[k2][ke2] - projectedVertsForConvexEdges[k2][ke];
                }
                this.getVector(ai, unitVectorsAlongEdges, ke);
                double epun = DoubleMath.length((double[])ai);
                if (epun <= 0.0) {
                    throw new EnergyException(" Null Edge in Cycle", true);
                }
                if (epun > 0.0) {
                    for (k = 0; k < 3; ++k) {
                        unitVectorsAlongEdges[k][ke] = unitVectorsAlongEdges[k][ke] / epun;
                    }
                    continue;
                }
                for (k = 0; k < 3; ++k) {
                    unitVectorsAlongEdges[k][ke] = 0.0;
                }
            }
            for (ke = 0; ke <= nEdges; ++ke) {
                this.getVector(ai, unitVectorsAlongEdges, ke);
                if (!(DoubleMath.length((double[])ai) <= 0.0)) continue;
                int le = ke - 1;
                if (le < 0) {
                    le = nEdges;
                }
                for (int k = 0; k < 3; ++k) {
                    unitVectorsAlongEdges[k][ke] = unitVectorsAlongEdges[k][le];
                }
            }
        }

        private double measurePrism(int ifn) {
            double[][] pav = new double[3][3];
            double[] vect1 = new double[3];
            double[] vect2 = new double[3];
            double[] vect3 = new double[3];
            double height = 0.0;
            for (int ke = 0; ke < 3; ++ke) {
                int ien = this.this$0.concaveFaceEdgeNumbers[ke][ifn];
                int iv = this.this$0.concaveEdgeVertexNumbers[0][ien];
                int ia = this.this$0.vertexAtomNumbers[iv];
                height += this.this$0.atomCoords[2][ia];
                int ip = this.this$0.vertexProbeNumber[iv];
                for (int k = 0; k < 3; ++k) {
                    pav[k][ke] = this.this$0.atomCoords[k][ia] - this.this$0.probeCoords[k][ip];
                }
            }
            height *= 0.3333333333333333;
            for (int k = 0; k < 3; ++k) {
                vect1[k] = pav[k][1] - pav[k][0];
                vect2[k] = pav[k][2] - pav[k][0];
            }
            DoubleMath.X((double[])vect1, (double[])vect2, (double[])vect3);
            return height * vect3[2] / 2.0;
        }

        private void measureConvexFace(int iConvexFace, double[] areaVolume) {
            double[] ai = new double[3];
            double[] aj = new double[3];
            double[] ak = new double[3];
            double[] vect1 = new double[3];
            double[] vect2 = new double[3];
            double[] acvect = new double[3];
            double[] aavect = new double[3];
            double[][][] tanv = new double[3][2][30];
            double[][] radial = new double[3][30];
            double pcurve = 0.0;
            double gcurve = 0.0;
            int ia = this.this$0.convexFaceAtomNumber[iConvexFace];
            int ncycle = this.this$0.convexFaceNumCycles[iConvexFace];
            int ieuler = ncycle > -1 ? 1 - ncycle : 2;
            for (int icyptr = 0; icyptr < ncycle + 1; ++icyptr) {
                double angle;
                int icy = this.this$0.convexFaceCycleNumbers[icyptr][iConvexFace];
                int nedge = this.this$0.convexEdgeCycleNum[icy];
                for (int ke = 0; ke < nedge + 1; ++ke) {
                    int iep = this.this$0.convexEdgeCycleNumbers[ke][icy];
                    int ic = this.this$0.convexEdgeCircleNumber[iep];
                    int it = this.this$0.circleTorusNumber[ic];
                    int ia2 = ia == this.this$0.torusAtomNumber[0][it] ? this.this$0.torusAtomNumber[1][it] : this.this$0.torusAtomNumber[0][it];
                    for (int k = 0; k < 3; ++k) {
                        acvect[k] = this.this$0.circleCenter[k][ic] - this.this$0.atomCoords[k][ia];
                        aavect[k] = this.this$0.atomCoords[k][ia2] - this.this$0.atomCoords[k][ia];
                    }
                    DoubleMath.normalize((double[])aavect, (double[])aavect);
                    double dt = DoubleMath.dot((double[])acvect, (double[])aavect);
                    double geo = -dt / (this.this$0.radius[ia] * this.this$0.circleRadius[ic]);
                    int iv1 = this.this$0.convexEdgeVertexNumber[0][iep];
                    int iv2 = this.this$0.convexEdgeVertexNumber[1][iep];
                    if (iv1 == -1 || iv2 == -1) {
                        angle = Math.PI * 2;
                    } else {
                        for (int k = 0; k < 3; ++k) {
                            vect1[k] = this.this$0.vertexCoords[k][iv1] - this.this$0.circleCenter[k][ic];
                            vect2[k] = this.this$0.vertexCoords[k][iv2] - this.this$0.circleCenter[k][ic];
                            radial[k][ke] = this.this$0.vertexCoords[k][iv1] - this.this$0.atomCoords[k][ia];
                        }
                        this.getVector(ai, radial, ke);
                        DoubleMath.normalize((double[])ai, (double[])ai);
                        radial[0][ke] = ai[0];
                        radial[1][ke] = ai[1];
                        radial[2][ke] = ai[2];
                        this.getVector(ai, tanv, 0, ke);
                        DoubleMath.X((double[])vect1, (double[])aavect, (double[])aj);
                        DoubleMath.normalize((double[])aj, (double[])aj);
                        tanv[0][0][ke] = aj[0];
                        tanv[1][0][ke] = aj[1];
                        tanv[2][0][ke] = aj[2];
                        this.getVector(ak, tanv, 1, ke);
                        DoubleMath.X((double[])vect2, (double[])aavect, (double[])ak);
                        DoubleMath.normalize((double[])ak, (double[])ak);
                        tanv[0][1][ke] = ak[0];
                        tanv[1][1][ke] = ak[1];
                        tanv[2][1][ke] = ak[2];
                        angle = this.vectorAngle(vect1, vect2, aavect, -1.0);
                    }
                    gcurve += this.this$0.circleRadius[ic] * angle * geo;
                    if (nedge == 0 || ke <= 0) continue;
                    this.getVector(ai, tanv, 1, ke - 1);
                    this.getVector(aj, tanv, 0, ke);
                    this.getVector(ak, radial, ke);
                    angle = this.vectorAngle(ai, aj, ak, 1.0);
                    if (angle < 0.0) {
                        throw new EnergyException(" Negative Angle in measureConvexFace", true);
                    }
                    pcurve += angle;
                }
                if (nedge <= 0) continue;
                this.getVector(ai, tanv, 1, nedge);
                this.getVector(aj, tanv, 0, 0);
                this.getVector(ak, radial, 0);
                angle = this.vectorAngle(ai, aj, ak, 1.0);
                if (angle < 0.0) {
                    throw new EnergyException(" Negative Angle in measureConvexFace", true);
                }
                pcurve += angle;
            }
            double gauss = Math.PI * 2 * (double)ieuler - pcurve - gcurve;
            double areap = gauss * (this.this$0.radius[ia] * this.this$0.radius[ia]);
            double volp = areap * this.this$0.radius[ia] / 3.0;
            areaVolume[0] = areap;
            areaVolume[1] = volp;
        }

        private void measureSaddleFace(int iSaddleFace, double[] areaVolume) {
            double thetaq;
            boolean cusp;
            int k;
            double phi;
            double areasp = 0.0;
            double volsp = 0.0;
            int iep = this.this$0.saddleConvexEdgeNumbers[0][iSaddleFace];
            int ic = this.this$0.convexEdgeCircleNumber[iep];
            int it = this.this$0.circleTorusNumber[ic];
            int ia1 = this.this$0.torusAtomNumber[0][it];
            int ia2 = this.this$0.torusAtomNumber[1][it];
            double[] aavect = new double[3];
            for (int k2 = 0; k2 < 3; ++k2) {
                aavect[k2] = this.this$0.atomCoords[k2][ia2] - this.this$0.atomCoords[k2][ia1];
            }
            DoubleMath.normalize((double[])aavect, (double[])aavect);
            int iv1 = this.this$0.convexEdgeVertexNumber[0][iep];
            int iv2 = this.this$0.convexEdgeVertexNumber[1][iep];
            double[] vect1 = new double[3];
            double[] vect2 = new double[3];
            if (iv1 == -1 || iv2 == -1) {
                phi = Math.PI * 2;
            } else {
                for (k = 0; k < 3; ++k) {
                    vect1[k] = this.this$0.vertexCoords[k][iv1] - this.this$0.circleCenter[k][ic];
                    vect2[k] = this.this$0.vertexCoords[k][iv2] - this.this$0.circleCenter[k][ic];
                }
                phi = this.vectorAngle(vect1, vect2, aavect, 1.0);
            }
            for (k = 0; k < 3; ++k) {
                vect1[k] = this.this$0.atomCoords[k][ia1] - this.this$0.torusCenter[k][it];
                vect2[k] = this.this$0.atomCoords[k][ia2] - this.this$0.torusCenter[k][it];
            }
            double d1 = -1.0 * DoubleMath.dot((double[])vect1, (double[])aavect);
            double d2 = DoubleMath.dot((double[])vect2, (double[])aavect);
            double theta1 = FastMath.atan2((double)d1, (double)this.this$0.torusRadius[it]);
            double theta2 = FastMath.atan2((double)d2, (double)this.this$0.torusRadius[it]);
            if (this.this$0.torusRadius[it] < this.this$0.probe && theta1 > 0.0 && theta2 > 0.0) {
                cusp = true;
                double rat = this.this$0.torusRadius[it] / this.this$0.probe;
                if (rat > 1.0) {
                    rat = 1.0;
                } else if (rat < -1.0) {
                    rat = -1.0;
                }
                thetaq = FastMath.acos((double)rat);
            } else {
                cusp = false;
                thetaq = 0.0;
                areasp = 0.0;
                volsp = 0.0;
            }
            double term1 = this.this$0.torusRadius[it] * this.this$0.probe * (theta1 + theta2);
            double term2 = this.this$0.probe * this.this$0.probe * (FastMath.sin((double)theta1) + FastMath.sin((double)theta2));
            double areas = phi * (term1 - term2);
            if (cusp) {
                double spin = this.this$0.torusRadius[it] * this.this$0.probe * thetaq - this.this$0.probe * this.this$0.probe * FastMath.sin((double)thetaq);
                areasp = 2.0 * phi * spin;
            }
            iep = this.this$0.saddleConvexEdgeNumbers[0][iSaddleFace];
            int ic2 = this.this$0.convexEdgeCircleNumber[iep];
            iep = this.this$0.saddleConvexEdgeNumbers[1][iSaddleFace];
            int ic1 = this.this$0.convexEdgeCircleNumber[iep];
            if (this.this$0.circleAtomNumber[ic1] != ia1) {
                throw new EnergyException(" Atom number inconsistency in measureSaddleFace", true);
            }
            for (int k3 = 0; k3 < 3; ++k3) {
                vect1[k3] = this.this$0.circleCenter[k3][ic1] - this.this$0.atomCoords[k3][ia1];
                vect2[k3] = this.this$0.circleCenter[k3][ic2] - this.this$0.atomCoords[k3][ia2];
            }
            double w1 = DoubleMath.dot((double[])vect1, (double[])aavect);
            double w2 = -1.0 * DoubleMath.dot((double[])vect2, (double[])aavect);
            double cone1 = phi * (w1 * this.this$0.circleRadius[ic1] * this.this$0.circleRadius[ic1]) / 6.0;
            double cone2 = phi * (w2 * this.this$0.circleRadius[ic2] * this.this$0.circleRadius[ic2]) / 6.0;
            term1 = this.this$0.torusRadius[it] * this.this$0.torusRadius[it] * this.this$0.probe * (FastMath.sin((double)theta1) + FastMath.sin((double)theta2));
            term2 = FastMath.sin((double)theta1) * FastMath.cos((double)theta1) + theta1 + FastMath.sin((double)theta2) * FastMath.cos((double)theta2) + theta2;
            term2 = this.this$0.torusRadius[it] * (this.this$0.probe * this.this$0.probe) * term2;
            double term3 = FastMath.sin((double)theta1) * FastMath.cos((double)theta1) * FastMath.cos((double)theta1) + 2.0 * FastMath.sin((double)theta1) + FastMath.sin((double)theta2) * FastMath.cos((double)theta2) * FastMath.cos((double)theta2) + 2.0 * FastMath.sin((double)theta2);
            term3 = this.this$0.probe * this.this$0.probe * this.this$0.probe / 3.0 * term3;
            double volt = phi / 2.0 * (term1 - term2 + term3);
            double vols = volt + cone1 + cone2;
            if (cusp) {
                term1 = this.this$0.torusRadius[it] * this.this$0.torusRadius[it] * this.this$0.probe * FastMath.sin((double)thetaq);
                term2 = FastMath.sin((double)thetaq) * FastMath.cos((double)thetaq) + thetaq;
                term2 = this.this$0.torusRadius[it] * (this.this$0.probe * this.this$0.probe) * term2;
                term3 = FastMath.sin((double)thetaq) * FastMath.cos((double)thetaq) * FastMath.cos((double)thetaq) + 2.0 * FastMath.sin((double)thetaq);
                term3 = this.this$0.probe * this.this$0.probe * this.this$0.probe / 3.0 * term3;
                volsp = phi * (term1 - term2 + term3);
            }
            areaVolume[0] = areas;
            areaVolume[1] = vols;
            areaVolume[2] = areasp;
            areaVolume[3] = volsp;
        }

        private void measureConcaveFace(int iConcaveFace, double[] areaVolume) {
            double arean;
            int ke;
            double[] ai = new double[3];
            double[] aj = new double[3];
            double[] ak = new double[3];
            double[] angle = new double[3];
            double[][] pvv = new double[3][3];
            double[][] pav = new double[3][3];
            double[][] planev = new double[3][3];
            for (ke = 0; ke < 3; ++ke) {
                int ien = this.this$0.concaveFaceEdgeNumbers[ke][iConcaveFace];
                int iv = this.this$0.concaveEdgeVertexNumbers[0][ien];
                int ia = this.this$0.vertexAtomNumbers[iv];
                int ip = this.this$0.vertexProbeNumber[iv];
                for (int k = 0; k < 3; ++k) {
                    pvv[k][ke] = this.this$0.vertexCoords[k][iv] - this.this$0.probeCoords[k][ip];
                    pav[k][ke] = this.this$0.atomCoords[k][ia] - this.this$0.probeCoords[k][ip];
                }
                if (!(this.this$0.probe > 0.0)) continue;
                this.getVector(ai, pvv, ke);
                DoubleMath.normalize((double[])ai, (double[])ai);
                this.putVector(ai, pvv, ke);
            }
            if (this.this$0.probe <= 0.0) {
                arean = 0.0;
            } else {
                int je;
                for (ke = 0; ke < 3; ++ke) {
                    je = ke + 1;
                    if (je > 2) {
                        je = 0;
                    }
                    this.getVector(ai, pvv, ke);
                    this.getVector(aj, pvv, je);
                    DoubleMath.X((double[])ai, (double[])aj, (double[])ak);
                    DoubleMath.normalize((double[])ak, (double[])ak);
                    this.putVector(ak, planev, ke);
                }
                for (ke = 0; ke < 3; ++ke) {
                    je = ke - 1;
                    if (je < 0) {
                        je = 2;
                    }
                    this.getVector(ai, planev, je);
                    this.getVector(aj, planev, ke);
                    this.getVector(ak, pvv, ke);
                    angle[ke] = this.vectorAngle(ai, aj, ak, -1.0);
                    if (!(angle[ke] < 0.0)) continue;
                    throw new EnergyException(" Negative angle in measureConcaveFace", true);
                }
                double defect = Math.PI * 2 - (angle[0] + angle[1] + angle[2]);
                arean = this.this$0.probe * this.this$0.probe * defect;
            }
            this.getVector(ai, pav, 0);
            this.getVector(aj, pav, 1);
            this.getVector(ak, pav, 2);
            double simplx = -this.tripleProduct(ai, aj, ak) / 6.0;
            double voln = simplx - arean * this.this$0.probe / 3.0;
            areaVolume[0] = arean;
            areaVolume[1] = voln;
        }

        private int genDots(int ndots, double[][] dots, double radius) {
            int nequat = (int)FastMath.sqrt((double)(Math.PI * (double)ndots));
            int nvert = (int)(0.5 * (double)nequat);
            if (nvert < 1) {
                nvert = 1;
            }
            int k = -1;
            block0: for (int i = 0; i <= nvert; ++i) {
                double fi = Math.PI * (double)i / (double)nvert;
                double z = FastMath.cos((double)fi);
                double xy = FastMath.sin((double)fi);
                int nhoriz = (int)((double)nequat * xy);
                if (nhoriz < 1) {
                    nhoriz = 1;
                }
                for (int j = 0; j < nhoriz; ++j) {
                    double fj = Math.PI * 2 * (double)j / (double)nhoriz;
                    double x = FastMath.cos((double)fj) * xy;
                    double y = FastMath.sin((double)fj) * xy;
                    dots[0][++k] = x * radius;
                    dots[1][k] = y * radius;
                    dots[2][k] = z * radius;
                    if (k >= ndots) break block0;
                }
            }
            return k;
        }

        private boolean circlePlane(double[] circen, double cirrad, double[] cirvec, double[] plncen, double[] plnvec, boolean[] cinsp, double[] xpnt1, double[] xpnt2) {
            double[] cpvect = new double[3];
            double[] pnt1 = new double[3];
            double[] vect1 = new double[3];
            double[] vect2 = new double[3];
            double[] uvect1 = new double[3];
            double[] uvect2 = new double[3];
            for (int k = 0; k < 3; ++k) {
                cpvect[k] = plncen[k] - circen[k];
            }
            double dcp = DoubleMath.dot((double[])cpvect, (double[])plnvec);
            cinsp[0] = dcp > 0.0;
            DoubleMath.X((double[])plnvec, (double[])cirvec, (double[])vect1);
            if (DoubleMath.length((double[])vect1) > 0.0) {
                DoubleMath.normalize((double[])vect1, (double[])uvect1);
                DoubleMath.X((double[])cirvec, (double[])uvect1, (double[])vect2);
                if (DoubleMath.length((double[])vect2) > 0.0) {
                    double ratio;
                    DoubleMath.normalize((double[])vect2, (double[])uvect2);
                    double dir = DoubleMath.dot((double[])uvect2, (double[])plnvec);
                    if (dir != 0.0 && FastMath.abs((double)(ratio = dcp / dir)) <= cirrad) {
                        for (int k = 0; k < 3; ++k) {
                            pnt1[k] = circen[k] + ratio * uvect2[k];
                        }
                        double rlen = cirrad * cirrad - ratio * ratio;
                        if (rlen < 0.0) {
                            rlen = 0.0;
                        }
                        rlen = FastMath.sqrt((double)rlen);
                        for (int k = 0; k < 3; ++k) {
                            xpnt1[k] = pnt1[k] - rlen * uvect1[k];
                            xpnt2[k] = pnt1[k] + rlen * uvect1[k];
                        }
                        return true;
                    }
                }
            }
            return false;
        }

        private double vectorAngle(double[] v1, double[] v2, double[] axis, double hand) {
            double a1 = DoubleMath.length((double[])v1);
            double a2 = DoubleMath.length((double[])v2);
            double dt = DoubleMath.dot((double[])v1, (double[])v2);
            double a12 = a1 * a2;
            if (FastMath.abs((double)a12) != 0.0) {
                dt /= a12;
            }
            dt = this.check(dt);
            double angle = FastMath.acos((double)dt);
            if (hand * this.tripleProduct(v1, v2, axis) < 0.0) {
                return Math.PI * 2 - angle;
            }
            return angle;
        }

        private double depth(int ip, double[] alt) {
            double[] vect1 = new double[3];
            double[] vect2 = new double[3];
            double[] vect3 = new double[3];
            double[] vect4 = new double[3];
            int ia1 = this.this$0.probeAtomNumbers[0][ip];
            int ia2 = this.this$0.probeAtomNumbers[1][ip];
            int ia3 = this.this$0.probeAtomNumbers[2][ip];
            for (int k = 0; k < 3; ++k) {
                vect1[k] = this.this$0.atomCoords[k][ia1] - this.this$0.atomCoords[k][ia3];
                vect2[k] = this.this$0.atomCoords[k][ia2] - this.this$0.atomCoords[k][ia3];
                vect3[k] = this.this$0.probeCoords[k][ip] - this.this$0.atomCoords[k][ia3];
            }
            DoubleMath.X((double[])vect1, (double[])vect2, (double[])vect4);
            DoubleMath.normalize((double[])vect4, (double[])vect4);
            double dot = DoubleMath.dot((double[])vect4, (double[])vect3);
            System.arraycopy(vect4, 0, alt, 0, 3);
            return dot;
        }

        private double check(double angle) {
            return FastMath.max((double)FastMath.min((double)angle, (double)1.0), (double)-1.0);
        }

        private int index2(int i, int j, int k) {
            return k + 30 * (j + 30 * i);
        }

        private void getVector(double[] ai, double[][] temp, int index) {
            ai[0] = temp[0][index];
            ai[1] = temp[1][index];
            ai[2] = temp[2][index];
        }

        private void putVector(double[] ai, double[][] temp, int index) {
            temp[0][index] = ai[0];
            temp[1][index] = ai[1];
            temp[2][index] = ai[2];
        }

        private void getVector(double[] ai, double[][][] temp, int index1, int index2) {
            ai[0] = temp[0][index1][index2];
            ai[1] = temp[1][index1][index2];
            ai[2] = temp[2][index1][index2];
        }

        private void putVector(double[] ai, double[][][] temp, int index1, int index2) {
            temp[0][index1][index2] = ai[0];
            temp[1][index1][index2] = ai[1];
            temp[2][index1][index2] = ai[2];
        }

        private void computeVolumeGradient() {
            int tcube;
            int k;
            int j;
            int i;
            int[][] cube = new int[2][27000];
            int[] inov = new int[1000];
            double[] arci = new double[1000];
            double[] arcf = new double[1000];
            double[] dx = new double[1000];
            double[] dy = new double[1000];
            double[] dsq = new double[1000];
            double[] d = new double[1000];
            double rmax = 0.0;
            double xmin = this.this$0.x[0];
            double xmax = this.this$0.x[0];
            double ymin = this.this$0.y[0];
            double ymax = this.this$0.y[0];
            double zmin = this.this$0.z[0];
            double zmax = this.this$0.z[0];
            for (int i2 = 0; i2 < this.this$0.nAtoms; ++i2) {
                if (!(this.this$0.radius[i2] > 0.0)) continue;
                if (this.this$0.radius[i2] > rmax) {
                    rmax = this.this$0.radius[i2];
                }
                if (this.this$0.x[i2] < xmin) {
                    xmin = this.this$0.x[i2];
                }
                if (this.this$0.x[i2] > xmax) {
                    xmax = this.this$0.x[i2];
                }
                if (this.this$0.y[i2] < ymin) {
                    ymin = this.this$0.y[i2];
                }
                if (this.this$0.y[i2] > ymax) {
                    ymax = this.this$0.y[i2];
                }
                if (this.this$0.z[i2] < zmin) {
                    zmin = this.this$0.z[i2];
                }
                if (!(this.this$0.z[i2] > zmax)) continue;
                zmax = this.this$0.z[i2];
            }
            double zstep = 0.0601;
            double edge = 2.0 * rmax;
            int nx = (int)((xmax - xmin) / edge);
            int ny = (int)((ymax - ymin) / edge);
            int nz = (int)((zmax - zmin) / edge);
            if (FastMath.max((int)FastMath.max((int)nx, (int)ny), (int)nz) > 30) {
                throw new EnergyException(" VolumeRegion derivative  --  Increase the Value of mxcube");
            }
            Arrays.fill(cube[0], -1);
            Arrays.fill(cube[1], -1);
            for (int m = 0; m < this.this$0.nAtoms; ++m) {
                if (this.this$0.skip[m]) continue;
                int i3 = (int)((this.this$0.x[m] - xmin) / edge);
                int j2 = (int)((this.this$0.y[m] - ymin) / edge);
                int k2 = (int)((this.this$0.z[m] - zmin) / edge);
                int[] nArray = cube[0];
                int n = this.index2(i3, j2, k2);
                nArray[n] = nArray[n] + 1;
            }
            int isum = 0;
            for (i = 0; i <= nx; ++i) {
                for (j = 0; j <= ny; ++j) {
                    for (k = 0; k <= nz; ++k) {
                        tcube = cube[0][this.index2(i, j, k)];
                        if (tcube == -1) continue;
                        cube[1][this.index2((int)i, (int)j, (int)k)] = isum += tcube;
                    }
                }
            }
            for (int m = 0; m < this.this$0.nAtoms; ++m) {
                if (this.this$0.skip[m]) continue;
                int i4 = (int)((this.this$0.x[m] - xmin) / edge);
                int j3 = (int)((this.this$0.y[m] - ymin) / edge);
                int k3 = (int)((this.this$0.z[m] - zmin) / edge);
                tcube = cube[1][this.index2(i4, j3, k3)];
                this.this$0.itab[tcube] = m;
                int[] nArray = cube[1];
                int n = this.index2(i4, j3, k3);
                nArray[n] = nArray[n] - 1;
            }
            isum = 0;
            for (i = 0; i <= nx; ++i) {
                for (j = 0; j <= ny; ++j) {
                    for (k = 0; k <= nz; ++k) {
                        tcube = cube[0][this.index2(i, j, k)];
                        if (tcube == -1) continue;
                        cube[0][this.index2((int)i, (int)j, (int)k)] = isum += tcube;
                        int[] nArray = cube[1];
                        int n = this.index2(i, j, k);
                        nArray[n] = nArray[n] + 1;
                    }
                }
            }
            for (int ir = 0; ir < this.this$0.nAtoms; ++ir) {
                int in;
                double pre_dx = 0.0;
                double pre_dy = 0.0;
                double pre_dz = 0.0;
                if (this.this$0.skip[ir]) continue;
                double rr = this.this$0.radius[ir];
                double rrx2 = 2.0 * rr;
                double rrsq = rr * rr;
                double xr = this.this$0.x[ir];
                double yr = this.this$0.y[ir];
                double zr = this.this$0.z[ir];
                int istart = (int)((xr - xmin) / edge);
                int istop = FastMath.min((int)(istart + 2), (int)(nx + 1));
                istart = FastMath.max((int)istart, (int)1);
                int jstart = (int)((yr - ymin) / edge);
                int jstop = FastMath.min((int)(jstart + 2), (int)(ny + 1));
                jstart = FastMath.max((int)jstart, (int)1);
                int kstart = (int)((zr - zmin) / edge);
                int kstop = FastMath.min((int)(kstart + 2), (int)(nz + 1));
                kstart = FastMath.max((int)kstart, (int)1);
                int io = -1;
                for (int i5 = istart - 1; i5 < istop; ++i5) {
                    for (int j4 = jstart - 1; j4 < jstop; ++j4) {
                        for (int k4 = kstart - 1; k4 < kstop; ++k4) {
                            int mstart = cube[1][this.index2(i5, j4, k4)];
                            if (mstart == -1) continue;
                            int mstop = cube[0][this.index2(i5, j4, k4)];
                            for (int m = mstart; m <= mstop; ++m) {
                                in = this.this$0.itab[m];
                                if (in == ir) continue;
                                if (++io > 1000) {
                                    logger.severe(" VolumeRegion gradient  --  Increase the Value of MAXARC");
                                }
                                dx[io] = this.this$0.x[in] - xr;
                                dy[io] = this.this$0.y[in] - yr;
                                dsq[io] = dx[io] * dx[io] + dy[io] * dy[io];
                                double dist2 = dsq[io] + (this.this$0.z[in] - zr) * (this.this$0.z[in] - zr);
                                double vdwsum = (rr + this.this$0.radius[in]) * (rr + this.this$0.radius[in]);
                                if (dist2 > vdwsum || dist2 == 0.0) {
                                    --io;
                                    continue;
                                }
                                d[io] = FastMath.sqrt((double)dsq[io]);
                                inov[io] = in;
                            }
                        }
                    }
                }
                if (io != -1) {
                    double ztop = zr + rr;
                    double ztopshave = ztop - zstep;
                    double zgrid = zr - rr;
                    double zstart = zgrid += 0.5 * (rrx2 - (double)((int)(rrx2 / zstep)) * zstep);
                    while (zgrid <= ztop) {
                        double phi2;
                        double cos_phi2;
                        double phi1;
                        double cos_phi1;
                        double rsec2r = rrsq - (zgrid - zr) * (zgrid - zr);
                        if (rsec2r < 0.0) {
                            rsec2r = 1.0E-6;
                        }
                        double rsecr = FastMath.sqrt((double)rsec2r);
                        if (zgrid >= ztopshave) {
                            cos_phi1 = 1.0;
                            phi1 = 0.0;
                        } else {
                            cos_phi1 = (zgrid + 0.5 * zstep - zr) / rr;
                            phi1 = FastMath.acos((double)cos_phi1);
                        }
                        if (zgrid == zstart) {
                            cos_phi2 = -1.0;
                            phi2 = Math.PI;
                        } else {
                            cos_phi2 = (zgrid - 0.5 * zstep - zr) / rr;
                            phi2 = FastMath.acos((double)cos_phi2);
                        }
                        int narc = -1;
                        double twoPI = Math.PI * 2;
                        for (int k5 = 0; k5 <= io; ++k5) {
                            double rsecn;
                            in = inov[k5];
                            double rinsq = this.this$0.radius[in] * this.this$0.radius[in];
                            double rsec2n = rinsq - (zgrid - this.this$0.z[in]) * (zgrid - this.this$0.z[in]);
                            if (!(rsec2n > 0.0) || !(d[k5] < rsecr + (rsecn = FastMath.sqrt((double)rsec2n)))) continue;
                            double rdiff = rsecr - rsecn;
                            if (d[k5] <= FastMath.abs((double)rdiff)) {
                                if (!(rdiff < 0.0)) continue;
                                narc = 0;
                                arci[narc] = 0.0;
                                arcf[narc] = twoPI;
                                continue;
                            }
                            if (++narc > 1000) {
                                logger.severe(" VolumeRegion gradient  --  Increase the Value of MAXARC");
                            }
                            double cosine = (dsq[k5] + rsec2r - rsec2n) / (2.0 * d[k5] * rsecr);
                            cosine = FastMath.min((double)1.0, (double)FastMath.max((double)-1.0, (double)cosine));
                            double alpha = FastMath.acos((double)cosine);
                            double beta = FastMath.atan2((double)dy[k5], (double)dx[k5]);
                            if (dy[k5] < 0.0) {
                                beta += twoPI;
                            }
                            double ti = beta - alpha;
                            double tf = beta + alpha;
                            if (ti < 0.0) {
                                ti += twoPI;
                            }
                            if (tf > twoPI) {
                                tf -= twoPI;
                            }
                            arci[narc] = ti;
                            if (tf < ti) {
                                arcf[narc] = twoPI;
                                arci[++narc] = 0.0;
                            }
                            arcf[narc] = tf;
                        }
                        if (narc == -1) {
                            double seg_dz = twoPI * (cos_phi1 * cos_phi1 - cos_phi2 * cos_phi2);
                            pre_dz += seg_dz;
                        } else {
                            int k6;
                            for (int k7 = 0; k7 < narc; ++k7) {
                                double aa = arci[k7];
                                double bb = arcf[k7];
                                double temp = 1000000.0;
                                int itemp = 0;
                                for (int i6 = k7; i6 <= narc; ++i6) {
                                    if (!(arci[i6] <= temp)) continue;
                                    temp = arci[i6];
                                    itemp = i6;
                                }
                                arci[k7] = arci[itemp];
                                arcf[k7] = arcf[itemp];
                                arci[itemp] = aa;
                                arcf[itemp] = bb;
                            }
                            double temp = arcf[0];
                            int j5 = 0;
                            for (k6 = 1; k6 <= narc; ++k6) {
                                if (temp < arci[k6]) {
                                    arcf[j5] = temp;
                                    arci[++j5] = arci[k6];
                                    temp = arcf[k6];
                                    continue;
                                }
                                if (!(temp < arcf[k6])) continue;
                                temp = arcf[k6];
                            }
                            arcf[j5] = temp;
                            narc = j5;
                            if (narc == 0) {
                                narc = 1;
                                arcf[1] = twoPI;
                                arci[1] = arcf[0];
                                arcf[0] = arci[0];
                                arci[0] = 0.0;
                            } else {
                                temp = arci[0];
                                for (k6 = 0; k6 < narc; ++k6) {
                                    arci[k6] = arcf[k6];
                                    arcf[k6] = arci[k6 + 1];
                                }
                                if (temp == 0.0 && arcf[narc] == twoPI) {
                                    --narc;
                                } else {
                                    arci[narc] = arcf[narc];
                                    arcf[narc] = temp;
                                }
                            }
                            for (k6 = 0; k6 <= narc; ++k6) {
                                double theta2 = arcf[k6];
                                double theta1 = arci[k6];
                                double dtheta = theta2 >= theta1 ? theta2 - theta1 : theta2 + twoPI - theta1;
                                double phi_term = phi2 - phi1 - 0.5 * (FastMath.sin((double)(2.0 * phi2)) - FastMath.sin((double)(2.0 * phi1)));
                                double seg_dx = (FastMath.sin((double)theta2) - FastMath.sin((double)theta1)) * phi_term;
                                double seg_dy = (FastMath.cos((double)theta1) - FastMath.cos((double)theta2)) * phi_term;
                                double seg_dz = dtheta * (cos_phi1 * cos_phi1 - cos_phi2 * cos_phi2);
                                pre_dx += seg_dx;
                                pre_dy += seg_dy;
                                pre_dz += seg_dz;
                            }
                        }
                        zgrid += zstep;
                    }
                }
                this.this$0.volumeGradient[0][ir] = 0.5 * rrsq * pre_dx;
                this.this$0.volumeGradient[1][ir] = 0.5 * rrsq * pre_dy;
                this.this$0.volumeGradient[2][ir] = 0.5 * rrsq * pre_dz;
            }
        }
    }
}

