/*
 * Decompiled with CFR 0.152.
 */
package ffx.potential.nonbonded.implicit;

import ffx.numerics.atomic.AtomicDoubleArray3D;
import ffx.numerics.switching.MultiplicativeSwitch;
import ffx.potential.bonded.Atom;
import ffx.potential.nonbonded.implicit.ConnollyRegion;
import ffx.potential.nonbonded.implicit.GaussVol;
import ffx.potential.parameters.ForceField;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.math3.util.FastMath;

public class ChandlerCavitation {
    private static final Logger logger = Logger.getLogger(ChandlerCavitation.class.getName());
    private final double HALF_SWITCH_RANGE = 3.5;
    private final double SA_SWITCH_OFFSET = 0.2;
    private final boolean doVolume;
    private final boolean doSurfaceArea;
    private final GaussVol gaussVol;
    private final ConnollyRegion connollyRegion;
    private double surfaceArea;
    private double surfaceAreaEnergy;
    private double volume;
    private double volumeEnergy;
    private double cavitationEnergy;
    private double effectiveRadius;
    private double solventPressure = 0.0334;
    private double surfaceTension = 0.08;
    private double crossOver = 7.18562874251497;
    private double beginVolumeOff = this.crossOver - 3.5;
    private double endVolumeOff = this.beginVolumeOff + 7.0;
    private double beginSurfaceAreaOff = this.crossOver + 0.2 + 3.5;
    private double endSurfaceAreaOff = this.beginSurfaceAreaOff - 7.0;
    private MultiplicativeSwitch volumeSwitch = new MultiplicativeSwitch(this.beginVolumeOff, this.endVolumeOff);
    private MultiplicativeSwitch surfaceAreaSwitch = new MultiplicativeSwitch(this.beginSurfaceAreaOff, this.endSurfaceAreaOff);
    private final int nAtoms;
    private final Atom[] atoms;

    public ChandlerCavitation(Atom[] atoms, GaussVol gaussVol, ForceField forceField) {
        this.atoms = atoms;
        this.nAtoms = atoms.length;
        this.gaussVol = gaussVol;
        this.connollyRegion = null;
        this.doVolume = forceField.getBoolean("VOLUMETERM", true);
        this.doSurfaceArea = forceField.getBoolean("AREATERM", true);
    }

    public ChandlerCavitation(Atom[] atoms, ConnollyRegion connollyRegion, ForceField forceField) {
        this.atoms = atoms;
        this.nAtoms = atoms.length;
        this.connollyRegion = connollyRegion;
        this.gaussVol = null;
        this.doVolume = forceField.getBoolean("VOLUMETERM", true);
        this.doSurfaceArea = forceField.getBoolean("AREATERM", true);
    }

    public double energyAndGradient(double[][] positions, AtomicDoubleArray3D gradient) {
        if (this.gaussVol != null) {
            return this.energyAndGradientGausVol(positions, gradient);
        }
        return this.energyAndGradientConnolly(gradient);
    }

    public double energyAndGradientConnolly(AtomicDoubleArray3D gradient) {
        this.cavitationEnergy = 0.0;
        this.connollyRegion.init(this.atoms, true);
        this.connollyRegion.runVolume();
        this.surfaceArea = this.connollyRegion.getSurfaceArea();
        this.surfaceAreaEnergy = this.surfaceArea * this.surfaceTension;
        this.volume = this.connollyRegion.getVolume();
        this.volumeEnergy = this.volume * this.solventPressure;
        double reff = this.effectiveRadius = FastMath.cbrt((double)(3.0 * this.volume / (Math.PI * 4)));
        double reff2 = reff * reff;
        double reff3 = reff2 * reff;
        double reff4 = reff3 * reff;
        double reff5 = reff4 * reff;
        double vdWVolPI23 = FastMath.pow((double)(this.volume / Math.PI), (double)0.6666666666666666);
        double dReffdvdW = 1.0 / (FastMath.pow((double)6.0, (double)0.6666666666666666) * Math.PI * vdWVolPI23);
        if (this.doVolume) {
            if (!this.doSurfaceArea || reff < this.beginVolumeOff) {
                this.cavitationEnergy = this.volumeEnergy;
                double[][] volumeGradient = this.connollyRegion.getVolumeGradient();
                for (int i = 0; i < this.nAtoms; ++i) {
                    double dx = this.solventPressure * volumeGradient[0][i];
                    double dy = this.solventPressure * volumeGradient[1][i];
                    double dz = this.solventPressure * volumeGradient[2][i];
                    gradient.add(0, i, dx, dy, dz);
                }
            } else if (reff <= this.endVolumeOff) {
                double taper = this.volumeSwitch.taper(reff, reff2, reff3, reff4, reff5);
                this.cavitationEnergy = taper * this.volumeEnergy;
                double dtaper = this.volumeSwitch.dtaper(reff, reff2, reff3, reff4) * dReffdvdW;
                double factor = dtaper * this.volumeEnergy + taper * this.solventPressure;
                double[][] volumeGradient = this.connollyRegion.getVolumeGradient();
                for (int i = 0; i < this.nAtoms; ++i) {
                    double dx = factor * volumeGradient[0][i];
                    double dy = factor * volumeGradient[1][i];
                    double dz = factor * volumeGradient[2][i];
                    gradient.add(0, i, dx, dy, dz);
                }
            }
        }
        if (this.doSurfaceArea) {
            if (!this.doVolume || reff > this.beginSurfaceAreaOff) {
                this.cavitationEnergy = this.surfaceAreaEnergy;
            } else if (reff >= this.endSurfaceAreaOff) {
                double taperSA = this.surfaceAreaSwitch.taper(reff, reff2, reff3, reff4, reff5);
                this.cavitationEnergy += taperSA * this.surfaceAreaEnergy;
            }
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("\n Connolly");
            logger.fine(String.format(" Volume:              %8.3f (Ang^3)", this.volume));
            logger.fine(String.format(" Volume Energy:       %8.3f (kcal/mol)", this.volumeEnergy));
            logger.fine(String.format(" Surface Area:        %8.3f (Ang^2)", this.surfaceArea));
            logger.fine(String.format(" Surface Area Energy: %8.3f (kcal/mol)", this.surfaceAreaEnergy));
            logger.fine(String.format(" Volume + SA Energy:  %8.3f (kcal/mol)", this.cavitationEnergy));
            logger.fine(String.format(" Effective Radius:    %8.3f (Ang)", reff));
        }
        return this.cavitationEnergy;
    }

    public double energyAndGradientGausVol(double[][] positions, AtomicDoubleArray3D gradient) {
        this.cavitationEnergy = 0.0;
        this.gaussVol.computeVolumeAndSA(positions);
        this.volume = this.gaussVol.getVolume();
        double[] volumeGradient = this.gaussVol.getVolumeGradient();
        this.volumeEnergy = this.volume * this.solventPressure;
        this.surfaceArea = this.gaussVol.getSurfaceArea();
        double[] surfaceAreaGradient = this.gaussVol.getSurfaceAreaGradient();
        this.surfaceAreaEnergy = this.surfaceArea * this.surfaceTension;
        double reff = this.effectiveRadius = 0.5 * FastMath.sqrt((double)(this.surfaceArea / Math.PI));
        double reff2 = reff * reff;
        double reff3 = reff2 * reff;
        double reff4 = reff3 * reff;
        double reff5 = reff4 * reff;
        double dRdSA = reff / (2.0 * this.surfaceArea);
        if (this.doVolume) {
            if (!this.doSurfaceArea || reff < this.beginVolumeOff) {
                this.cavitationEnergy = this.volumeEnergy;
                this.addVolumeGradient(0.0, this.solventPressure, surfaceAreaGradient, volumeGradient, gradient);
            } else if (reff <= this.endVolumeOff) {
                double taper = this.volumeSwitch.taper(reff, reff2, reff3, reff4, reff5);
                double dtaper = this.volumeSwitch.dtaper(reff, reff2, reff3, reff4) * dRdSA;
                this.cavitationEnergy = taper * this.volumeEnergy;
                double factorSA = dtaper * this.volumeEnergy;
                double factorVol = taper * this.solventPressure;
                this.addVolumeGradient(factorSA, factorVol, surfaceAreaGradient, volumeGradient, gradient);
            }
        }
        if (this.doSurfaceArea) {
            if (!this.doVolume || reff > this.beginSurfaceAreaOff) {
                this.cavitationEnergy = this.surfaceAreaEnergy;
                this.addSurfaceAreaGradient(this.surfaceTension, surfaceAreaGradient, gradient);
            } else if (reff >= this.endSurfaceAreaOff) {
                double taperSA = this.surfaceAreaSwitch.taper(reff, reff2, reff3, reff4, reff5);
                double dtaperSA = this.surfaceAreaSwitch.dtaper(reff, reff2, reff3, reff4) * dRdSA;
                this.cavitationEnergy += taperSA * this.surfaceAreaEnergy;
                double factor = dtaperSA * this.surfaceAreaEnergy + taperSA * this.surfaceTension;
                this.addSurfaceAreaGradient(factor, surfaceAreaGradient, gradient);
            }
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("\n GaussVol");
            logger.fine(String.format(" Volume:              %8.3f (Ang^3)", this.volume));
            logger.fine(String.format(" Volume Energy:       %8.3f (kcal/mol)", this.volumeEnergy));
            logger.fine(String.format(" Surface Area:        %8.3f (Ang^2)", this.surfaceArea));
            logger.fine(String.format(" Surface Area Energy: %8.3f (kcal/mol)", this.surfaceAreaEnergy));
            logger.fine(String.format(" Volume + SA Energy:  %8.3f (kcal/mol)", this.cavitationEnergy));
            logger.fine(String.format(" Effective Radius:    %8.3f (Ang)", reff));
        }
        return this.cavitationEnergy;
    }

    public ConnollyRegion getConnollyRegion() {
        return this.connollyRegion;
    }

    public double getCrossOver() {
        return this.crossOver;
    }

    public void setCrossOver(double crossOver) {
        if (crossOver < 3.5) {
            logger.severe(String.format(" The cross-over point (%8.6f A) must be greater than 3.5 A", crossOver));
            return;
        }
        this.crossOver = crossOver;
        this.beginVolumeOff = crossOver - 3.5;
        this.endVolumeOff = this.beginVolumeOff + 7.0;
        this.beginSurfaceAreaOff = crossOver + 0.2 + 3.5;
        this.endSurfaceAreaOff = this.beginSurfaceAreaOff - 7.0;
        this.volumeSwitch = new MultiplicativeSwitch(this.beginVolumeOff, this.endVolumeOff);
        this.surfaceAreaSwitch = new MultiplicativeSwitch(this.beginSurfaceAreaOff, this.endSurfaceAreaOff);
    }

    public double getEffectiveRadius() {
        return this.effectiveRadius;
    }

    public double getEnergy() {
        return this.cavitationEnergy;
    }

    public GaussVol getGaussVol() {
        return this.gaussVol;
    }

    public double getSolventPressure() {
        return this.solventPressure;
    }

    public void setSolventPressure(double solventPressure) {
        double newCrossOver = 3.0 * this.surfaceTension / solventPressure;
        if (newCrossOver < 3.5) {
            logger.severe(String.format(" The solvent pressure (%8.6f kcal/mol/A^3) and surface tension (%8.6f kcal/mol/A^2) combination is not supported.", solventPressure, this.surfaceTension));
            return;
        }
        this.solventPressure = solventPressure;
        this.setCrossOver(newCrossOver);
    }

    public double getSurfaceArea() {
        return this.surfaceArea;
    }

    public double getSurfaceAreaEnergy() {
        return this.surfaceAreaEnergy;
    }

    public double getSurfaceTension() {
        return this.surfaceTension;
    }

    public void setSurfaceTension(double surfaceTension) {
        double newCrossOver = 3.0 * surfaceTension / this.solventPressure;
        if (newCrossOver < 3.5) {
            logger.severe(String.format(" The solvent pressure (%8.6f kcal/mol/A^3) and surface tension (%8.6f kcal/mol/A^2) combination is not supported.", this.solventPressure, surfaceTension));
            return;
        }
        this.surfaceTension = surfaceTension;
        this.setCrossOver(newCrossOver);
    }

    public double getVolume() {
        return this.volume;
    }

    public double getVolumeEnergy() {
        return this.volumeEnergy;
    }

    private void addVolumeGradient(double factorSA, double factorVol, double[] surfaceAreaGradient, double[] volumeGradient, AtomicDoubleArray3D gradient) {
        for (int i = 0; i < this.nAtoms; ++i) {
            int index = i * 3;
            double gx = factorSA * surfaceAreaGradient[index] + factorVol * volumeGradient[index++];
            double gy = factorSA * surfaceAreaGradient[index] + factorVol * volumeGradient[index++];
            double gz = factorSA * surfaceAreaGradient[index] + factorVol * volumeGradient[index];
            gradient.add(0, i, gx, gy, gz);
        }
    }

    private void addSurfaceAreaGradient(double factor, double[] surfaceAreaGradient, AtomicDoubleArray3D gradient) {
        for (int i = 0; i < this.nAtoms; ++i) {
            int index = i * 3;
            double gx = factor * surfaceAreaGradient[index++];
            double gy = factor * surfaceAreaGradient[index++];
            double gz = factor * surfaceAreaGradient[index];
            gradient.add(0, i, gx, gy, gz);
        }
    }
}

