/*
 * Decompiled with CFR 0.152.
 */
package ffx.potential.nonbonded;

import edu.rit.pj.BarrierAction;
import edu.rit.pj.IntegerForLoop;
import edu.rit.pj.IntegerSchedule;
import edu.rit.pj.ParallelRegion;
import edu.rit.pj.ParallelTeam;
import edu.rit.pj.reduction.SharedDouble;
import edu.rit.pj.reduction.SharedInteger;
import ffx.crystal.Crystal;
import ffx.crystal.SymOp;
import ffx.numerics.atomic.AtomicDoubleArray;
import ffx.numerics.atomic.AtomicDoubleArray3D;
import ffx.numerics.switching.MultiplicativeSwitch;
import ffx.potential.bonded.Atom;
import ffx.potential.bonded.Bond;
import ffx.potential.bonded.LambdaInterface;
import ffx.potential.extended.ExtendedSystem;
import ffx.potential.nonbonded.MaskingInterface;
import ffx.potential.nonbonded.NeighborList;
import ffx.potential.nonbonded.NonbondedCutoff;
import ffx.potential.nonbonded.VanDerWaalsForm;
import ffx.potential.parameters.AtomType;
import ffx.potential.parameters.ForceField;
import ffx.potential.parameters.VDWType;
import ffx.utilities.FFXProperty;
import ffx.utilities.PropertyGroup;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.math3.util.FastMath;

public class VanDerWaals
implements MaskingInterface,
LambdaInterface {
    private static final Logger logger = Logger.getLogger(VanDerWaals.class.getName());
    private static final byte HARD = 0;
    private static final byte SOFT = 1;
    private static final byte XX = 0;
    private static final byte YY = 1;
    private static final byte ZZ = 2;
    private final boolean doLongRangeCorrection;
    private final ParallelTeam parallelTeam;
    private final int threadCount;
    private final IntegerSchedule pairwiseSchedule;
    private final SharedInteger sharedInteractions;
    private final SharedDouble sharedEnergy;
    private final SharedDouble shareddEdL;
    private final SharedDouble sharedd2EdL2;
    private final VanDerWaalsRegion vanDerWaalsRegion;
    private final VanDerWaalsForm vdwForm;
    @FFXProperty(name="vdwindex", clazz=String.class, propertyGroup=PropertyGroup.VanDerWaalsFunctionalForm, defaultValue="class", description="[CLASS / TYPE]\nSpecifies whether van der Waals parameters are provided for atom classes or atom types.\nWhile most force fields are indexed by atom class, in OPLS models the vdW values are indexed by atom type.\nThe default in the absence of the vdwindex property is to index vdW parameters by atom class.\n")
    private final String vdwIndex;
    @FFXProperty(name="vdw-taper", propertyGroup=PropertyGroup.NonBondedCutoff, defaultValue="0.9", description="Allows modification of the cutoff windows for van der Waals potential energy interactions. \"\nThe default value in the absence of the vdw-taper keyword is to begin the cutoff window\nat 0.9 of the vdw cutoff distance.\n")
    private final double vdwTaper;
    private final NonbondedCutoff nonbondedCutoff;
    private final MultiplicativeSwitch multiplicativeSwitch;
    private Crystal crystal;
    private Atom[] atoms;
    private int[] molecule;
    private boolean[] neuralNetwork;
    private ForceField forceField;
    private boolean[] use = null;
    private int nAtoms;
    private int nSymm;
    private boolean gradient;
    private boolean lambdaTerm;
    private boolean esvTerm;
    private boolean[] isSoft;
    private boolean[][] softCore;
    private boolean intermolecularSoftcore = false;
    private boolean intramolecularSoftcore = false;
    private double lambda = 1.0;
    private double vdwLambdaEnd = 1.0;
    private double vdwLambdaExponent = 3.0;
    private double vdwLambdaAlpha = 0.25;
    private LambdaFactors[] lambdaFactors = null;
    private double sc1 = 0.0;
    private double sc2 = 1.0;
    private double dsc1dL = 0.0;
    private double dsc2dL = 0.0;
    private double d2sc1dL2 = 0.0;
    private double d2sc2dL2 = 0.0;
    private ExtendedSystem esvSystem;
    private double[] coordinates;
    private double[][] reduced;
    private double[] reducedXYZ;
    private int[][][] neighborLists;
    private int[] atomClass;
    private int[] reductionIndex;
    private int[][] mask12;
    private int[][] mask13;
    private int[][] mask14;
    private double[] reductionValue;
    private boolean reducedHydrogen;
    private double longRangeCorrection;
    private AtomicDoubleArray.AtomicDoubleArrayImpl atomicDoubleArrayImpl;
    private AtomicDoubleArray3D grad;
    private AtomicDoubleArray3D lambdaGrad;
    private NeighborList neighborList;
    private boolean forceNeighborListRebuild = true;

    public VanDerWaals() {
        this.doLongRangeCorrection = false;
        this.parallelTeam = null;
        this.threadCount = 0;
        this.pairwiseSchedule = null;
        this.sharedInteractions = null;
        this.sharedEnergy = null;
        this.shareddEdL = null;
        this.sharedd2EdL2 = null;
        this.vanDerWaalsRegion = null;
        this.vdwForm = null;
        this.nonbondedCutoff = null;
        this.multiplicativeSwitch = null;
        this.vdwIndex = null;
        this.vdwTaper = 0.9;
    }

    public VanDerWaals(Atom[] atoms, int[] molecule, boolean[] neuralNetwork, Crystal crystal, ForceField forceField, ParallelTeam parallelTeam, double vdwCutoff, double neighborListCutoff) {
        this.atoms = atoms;
        this.molecule = molecule;
        this.neuralNetwork = neuralNetwork;
        this.crystal = crystal;
        this.parallelTeam = parallelTeam;
        this.forceField = forceField;
        this.nAtoms = atoms.length;
        this.nSymm = crystal.spaceGroup.getNumberOfSymOps();
        this.vdwForm = new VanDerWaalsForm(forceField);
        this.vdwLambdaEnd = forceField.getDouble("VDW_LAMBDA_END", 1.0);
        this.vdwIndex = forceField.getString("VDWINDEX", "Class");
        this.reducedHydrogen = forceField.getBoolean("REDUCE_HYDROGENS", true);
        this.lambdaTerm = forceField.getBoolean("VDW_LAMBDATERM", forceField.getBoolean("LAMBDATERM", false));
        if (this.lambdaTerm) {
            this.shareddEdL = new SharedDouble();
            this.sharedd2EdL2 = new SharedDouble();
            this.vdwLambdaAlpha = forceField.getDouble("VDW_LAMBDA_ALPHA", 0.25);
            this.vdwLambdaExponent = forceField.getDouble("VDW_LAMBDA_EXPONENT", 3.0);
            if (this.vdwLambdaAlpha < 0.0) {
                logger.warning(String.format(" Invalid value %8.3g for vdw-lambda-alpha; must be greater than or equal to 0. Resetting to 0.25.", this.vdwLambdaAlpha));
                this.vdwLambdaAlpha = 0.25;
            }
            if (this.vdwLambdaExponent < 1.0) {
                logger.warning(String.format(" Invalid value %8.3g for vdw-lambda-exponent; must be greater than or equal to 1. Resetting to 3.", this.vdwLambdaExponent));
                this.vdwLambdaExponent = 3.0;
            }
            if (this.vdwLambdaEnd < 0.0 || this.vdwLambdaEnd > 1.0) {
                logger.warning(String.format(" Invalid value %8.3g for vdw-lambda-end; must be between 0 and 1. Resetting to 1.", this.vdwLambdaEnd));
                this.vdwLambdaEnd = 1.0;
            }
            this.intermolecularSoftcore = forceField.getBoolean("INTERMOLECULAR_SOFTCORE", false);
            this.intramolecularSoftcore = forceField.getBoolean("INTRAMOLECULAR_SOFTCORE", false);
        } else {
            this.shareddEdL = null;
            this.sharedd2EdL2 = null;
        }
        this.threadCount = parallelTeam.getThreadCount();
        this.sharedInteractions = new SharedInteger();
        this.sharedEnergy = new SharedDouble();
        this.doLongRangeCorrection = forceField.getBoolean("VDW_CORRECTION", false);
        this.vanDerWaalsRegion = new VanDerWaalsRegion(this);
        this.atomicDoubleArrayImpl = AtomicDoubleArray.AtomicDoubleArrayImpl.MULTI;
        String value = forceField.getString("ARRAY_REDUCTION", "MULTI");
        try {
            this.atomicDoubleArrayImpl = AtomicDoubleArray.AtomicDoubleArrayImpl.valueOf((String)ForceField.toEnumForm(value));
        }
        catch (Exception e) {
            logger.info(String.format(" Unrecognized ARRAY-REDUCTION %s; defaulting to %s", value, this.atomicDoubleArrayImpl));
        }
        this.initAtomArrays();
        double taper = forceField.getDouble("VDW_TAPER", 0.9);
        this.vdwTaper = taper * vdwCutoff;
        double buff = 2.0;
        this.nonbondedCutoff = new NonbondedCutoff(vdwCutoff, this.vdwTaper, buff);
        this.multiplicativeSwitch = new MultiplicativeSwitch(this.vdwTaper, vdwCutoff);
        this.neighborList = new NeighborList(crystal, atoms, neighborListCutoff, buff, parallelTeam);
        this.pairwiseSchedule = this.neighborList.getPairwiseSchedule();
        this.neighborLists = new int[this.nSymm][][];
        this.buildNeighborList(atoms);
        this.neighborList.setDisableUpdates(forceField.getBoolean("DISABLE_NEIGHBOR_UPDATES", false));
        logger.info(this.toString());
    }

    @Override
    public void applyMask(int i, boolean[] is14, double[] ... masks) {
        int[] m14;
        int[] m13;
        int[] m12;
        double[] mask = masks[0];
        for (int value : m12 = this.mask12[i]) {
            mask[value] = this.vdwForm.scale12;
        }
        for (int value : m13 = this.mask13[i]) {
            mask[value] = this.vdwForm.scale13;
        }
        for (int value : m14 = this.mask14[i]) {
            mask[value] = this.vdwForm.scale14;
            is14[value] = true;
        }
    }

    public void attachExtendedSystem(ExtendedSystem system) {
        if (system == null) {
            logger.severe("Tried to attach null extended system.");
        }
        this.esvTerm = true;
        this.esvSystem = system;
        this.vdwLambdaAlpha = this.forceField.getDouble("VDW_LAMBDA_ALPHA", 0.05);
        this.vdwLambdaExponent = this.forceField.getDouble("VDW_LAMBDA_EXPONENT", 1.0);
        if (this.vdwLambdaExponent != 1.0) {
            logger.warning(String.format("ESVs are compatible only with a vdwLambdaExponent of unity! (found %g, resetting to 1.0)", this.vdwLambdaExponent));
            this.vdwLambdaExponent = 1.0;
        }
        if (this.vdwLambdaAlpha < 0.0) {
            this.vdwLambdaAlpha = 0.05;
        }
        this.intermolecularSoftcore = this.forceField.getBoolean("INTERMOLECULAR_SOFTCORE", false);
        this.intramolecularSoftcore = this.forceField.getBoolean("INTRAMOLECULAR_SOFTCORE", false);
        Atom[] atomsExt = this.esvSystem.getExtendedAtoms();
        int[] moleculeExt = this.esvSystem.getExtendedMolecule();
        boolean[] nn = new boolean[atomsExt.length];
        Arrays.fill(nn, false);
        for (Atom a : atomsExt) {
            if (!a.isNeuralNetwork()) continue;
            logger.severe("The combination of an extended system and neural networks are not supported.");
        }
        this.setAtoms(atomsExt, moleculeExt, nn);
    }

    public ExtendedSystem getExtendedSystem() {
        return this.esvSystem;
    }

    public void destroy() throws Exception {
        if (this.neighborList != null) {
            this.neighborList.destroy();
        }
    }

    public double energy(boolean gradient, boolean print) {
        this.gradient = gradient;
        try {
            this.parallelTeam.execute((ParallelRegion)this.vanDerWaalsRegion);
        }
        catch (Exception e) {
            String message = " Fatal exception expanding coordinates.\n";
            logger.log(Level.SEVERE, message, e);
        }
        return this.sharedEnergy.get();
    }

    public boolean getLambdaTerm() {
        return this.lambdaTerm;
    }

    public boolean getIntramolecularSoftcore() {
        return this.intramolecularSoftcore;
    }

    public double getAlpha() {
        return this.vdwLambdaAlpha;
    }

    public double getBeta() {
        return this.vdwLambdaExponent;
    }

    public double getBuffer() {
        return this.nonbondedCutoff.buff;
    }

    public boolean getDoLongRangeCorrection() {
        return this.doLongRangeCorrection;
    }

    public double getEnergy() {
        return this.sharedEnergy.get();
    }

    public int getInteractions() {
        return this.sharedInteractions.get();
    }

    @Override
    public double getLambda() {
        return this.lambda;
    }

    @Override
    public void setLambda(double lambda) {
        assert (lambda >= 0.0 && lambda <= 1.0);
        if (!this.lambdaTerm) {
            return;
        }
        lambda = lambda > this.vdwLambdaEnd ? 1.0 : (lambda /= this.vdwLambdaEnd);
        this.lambda = lambda;
        this.sc1 = this.vdwLambdaAlpha * (1.0 - lambda) * (1.0 - lambda);
        this.dsc1dL = -2.0 * this.vdwLambdaAlpha * (1.0 - lambda);
        this.d2sc1dL2 = 2.0 * this.vdwLambdaAlpha;
        this.sc2 = FastMath.pow((double)lambda, (double)this.vdwLambdaExponent);
        this.dsc2dL = this.vdwLambdaExponent * FastMath.pow((double)lambda, (double)(this.vdwLambdaExponent - 1.0));
        this.d2sc2dL2 = this.vdwLambdaExponent >= 2.0 ? this.vdwLambdaExponent * (this.vdwLambdaExponent - 1.0) * FastMath.pow((double)lambda, (double)(this.vdwLambdaExponent - 2.0)) : 0.0;
        if (!this.esvTerm) {
            for (LambdaFactors lf : this.lambdaFactors) {
                lf.setFactors();
            }
        }
        this.initSoftCore();
        if (this.doLongRangeCorrection) {
            this.longRangeCorrection = this.computeLongRangeCorrection();
            logger.fine(String.format(" Long-range VdW correction %12.8f (kcal/mole).", this.longRangeCorrection));
        } else {
            this.longRangeCorrection = 0.0;
        }
        logger.fine(String.format(" VdW lambda %8.3f", lambda));
    }

    public int[][] getMask12() {
        return this.mask12;
    }

    public int[][] getMask13() {
        return this.mask13;
    }

    public int[][] getMask14() {
        return this.mask14;
    }

    public NeighborList getNeighborList() {
        return this.neighborList;
    }

    public int[][][] getNeighborLists() {
        return this.neighborLists;
    }

    public NonbondedCutoff getNonbondedCutoff() {
        return this.nonbondedCutoff;
    }

    public int[] getReductionIndex() {
        return this.reductionIndex;
    }

    public VanDerWaalsForm getVDWForm() {
        return this.vdwForm;
    }

    @Override
    public double getd2EdL2() {
        if (this.sharedd2EdL2 == null || !this.lambdaTerm) {
            return 0.0;
        }
        return this.sharedd2EdL2.get();
    }

    @Override
    public double getdEdL() {
        if (this.shareddEdL == null || !this.lambdaTerm) {
            return 0.0;
        }
        return this.shareddEdL.get();
    }

    @Override
    public void getdEdXdL(double[] lambdaGradient) {
        if (this.lambdaGrad == null || !this.lambdaTerm) {
            return;
        }
        int index = 0;
        for (int i = 0; i < this.nAtoms; ++i) {
            if (!this.atoms[i].isActive()) continue;
            int n = index++;
            lambdaGradient[n] = lambdaGradient[n] + this.lambdaGrad.getX(i);
            int n2 = index++;
            lambdaGradient[n2] = lambdaGradient[n2] + this.lambdaGrad.getY(i);
            int n3 = index++;
            lambdaGradient[n3] = lambdaGradient[n3] + this.lambdaGrad.getZ(i);
        }
    }

    @Override
    public void removeMask(int i, boolean[] is14, double[] ... masks) {
        int[] m14;
        int[] m13;
        int[] m12;
        double[] mask = masks[0];
        for (int value : m12 = this.mask12[i]) {
            mask[value] = 1.0;
        }
        for (int value : m13 = this.mask13[i]) {
            mask[value] = 1.0;
        }
        for (int value : m14 = this.mask14[i]) {
            mask[value] = 1.0;
            is14[value] = false;
        }
    }

    public void setAtoms(Atom[] atoms, int[] molecule, boolean[] neuralNetwork) {
        this.atoms = atoms;
        this.nAtoms = atoms.length;
        this.molecule = molecule;
        this.neuralNetwork = neuralNetwork;
        if (this.nAtoms != molecule.length) {
            logger.warning("Atom and molecule arrays are of different lengths.");
            throw new IllegalArgumentException();
        }
        this.initAtomArrays();
        this.buildNeighborList(atoms);
    }

    public void setCrystal(Crystal crystal) {
        int newNSymm = crystal.getNumSymOps();
        if (this.crystal.equals((Object)crystal) && newNSymm == this.nSymm) {
            return;
        }
        this.crystal = crystal;
        if (this.nSymm != newNSymm) {
            this.nSymm = newNSymm;
            if (this.reduced == null || this.reduced.length < this.nSymm) {
                this.reduced = new double[this.nSymm][this.nAtoms * 3];
                this.reducedXYZ = this.reduced[0];
                this.neighborLists = new int[this.nSymm][][];
            }
        }
        this.neighborList.setCrystal(crystal);
        this.forceNeighborListRebuild = true;
        try {
            this.parallelTeam.execute((ParallelRegion)this.vanDerWaalsRegion);
        }
        catch (Exception e) {
            String message = " Fatal exception expanding coordinates.\n";
            logger.log(Level.SEVERE, message, e);
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("\n  Van der Waals\n");
        if (this.multiplicativeSwitch.getSwitchStart() != Double.POSITIVE_INFINITY) {
            sb.append(String.format("   Switch Start:                         %6.3f (A)\n", this.multiplicativeSwitch.getSwitchStart()));
            sb.append(String.format("   Cut-Off:                              %6.3f (A)", this.multiplicativeSwitch.getSwitchEnd()));
        } else {
            sb.append("   Cut-Off:                                NONE");
        }
        sb.append(String.format("\n   Long-Range Correction:                %6B", this.doLongRangeCorrection));
        if (!this.reducedHydrogen) {
            sb.append(String.format("\n   Reduce Hydrogen:                      %6B", this.reducedHydrogen));
        }
        if (this.lambdaTerm) {
            sb.append("\n   Alchemical Parameters\n");
            sb.append(String.format("    Softcore Alpha:                       %5.3f\n", this.vdwLambdaAlpha));
            sb.append(String.format("    Lambda Exponent:                      %5.3f\n", this.vdwLambdaExponent));
            sb.append(String.format("    Lambda End:                           %5.3f", this.vdwLambdaEnd));
        }
        return sb.toString();
    }

    private void initAtomArrays() {
        int i;
        if (this.esvTerm) {
            this.atoms = this.esvSystem.getExtendedAtoms();
            this.nAtoms = this.atoms.length;
        }
        if (this.atomClass == null || this.nAtoms > this.atomClass.length || this.lambdaTerm || this.esvTerm) {
            this.atomClass = new int[this.nAtoms];
            this.coordinates = new double[this.nAtoms * 3];
            this.reduced = new double[this.nSymm][this.nAtoms * 3];
            this.reducedXYZ = this.reduced[0];
            this.reductionIndex = new int[this.nAtoms];
            this.reductionValue = new double[this.nAtoms];
            this.mask12 = new int[this.nAtoms][];
            this.mask13 = new int[this.nAtoms][];
            this.mask14 = new int[this.nAtoms][];
            this.use = new boolean[this.nAtoms];
            this.isSoft = new boolean[this.nAtoms];
            this.softCore = new boolean[2][this.nAtoms];
            this.grad = new AtomicDoubleArray3D(this.atomicDoubleArrayImpl, this.nAtoms, this.threadCount);
            this.lambdaGrad = this.lambdaTerm ? new AtomicDoubleArray3D(this.atomicDoubleArrayImpl, this.nAtoms, this.threadCount) : null;
        }
        Arrays.fill(this.use, true);
        Arrays.fill(this.isSoft, false);
        Arrays.fill(this.softCore[0], false);
        Arrays.fill(this.softCore[1], false);
        this.lambdaFactors = new LambdaFactors[this.threadCount];
        for (i = 0; i < this.threadCount; ++i) {
            this.lambdaFactors[i] = this.lambdaTerm ? new LambdaFactorsOST(this) : new LambdaFactors();
        }
        for (i = 0; i < this.nAtoms; ++i) {
            Atom ai = this.atoms[i];
            assert (i == ai.getXyzIndex() - 1);
            double[] xyz = ai.getXYZ(null);
            int i3 = i * 3;
            this.coordinates[i3 + 0] = xyz[0];
            this.coordinates[i3 + 1] = xyz[1];
            this.coordinates[i3 + 2] = xyz[2];
            VDWType vdwType = ai.getVDWType();
            if (vdwType == null) {
                AtomType atomType = ai.getAtomType();
                if (atomType == null) {
                    logger.severe(ai.toString());
                    return;
                }
                this.atomClass[i] = this.vdwIndex.equalsIgnoreCase("Type") ? atomType.type : atomType.atomClass;
                vdwType = this.forceField.getVDWType(Integer.toString(this.atomClass[i]));
                if (vdwType == null) {
                    logger.info(" No VdW type for atom class " + this.atomClass[i]);
                    logger.severe(" No VdW type for atom " + String.valueOf(ai));
                    return;
                }
                ai.setVDWType(vdwType);
            }
            this.atomClass[i] = vdwType.atomClass;
            List<Bond> bonds = ai.getBonds();
            int numBonds = bonds.size();
            if (this.reducedHydrogen && vdwType.reductionFactor > 0.0 && numBonds == 1) {
                Bond bond = bonds.get(0);
                Atom heavyAtom = bond.get1_2(ai);
                this.reductionIndex[i] = heavyAtom.getIndex() - 1;
                this.reductionValue[i] = vdwType.reductionFactor;
            } else {
                this.reductionIndex[i] = i;
                this.reductionValue[i] = 0.0;
            }
            List<Atom> n12 = ai.get12List();
            this.mask12[i] = new int[n12.size()];
            int j = 0;
            for (Atom atom : n12) {
                this.mask12[i][j++] = atom.getIndex() - 1;
            }
            List<Atom> n13 = ai.get13List();
            this.mask13[i] = new int[n13.size()];
            j = 0;
            for (Atom a13 : n13) {
                this.mask13[i][j++] = a13.getIndex() - 1;
            }
            List<Atom> list = ai.get14List();
            this.mask14[i] = new int[list.size()];
            j = 0;
            for (Atom a14 : list) {
                this.mask14[i][j++] = a14.getIndex() - 1;
            }
        }
    }

    private void buildNeighborList(Atom[] atoms) {
        this.neighborList.setAtoms(atoms);
        this.forceNeighborListRebuild = true;
        try {
            this.parallelTeam.execute((ParallelRegion)this.vanDerWaalsRegion);
        }
        catch (Exception e) {
            String message = " Fatal exception expanding coordinates.\n";
            logger.log(Level.SEVERE, message, e);
        }
        this.forceNeighborListRebuild = false;
    }

    private double computeLongRangeCorrection() {
        if (this.esvTerm) {
            throw new UnsupportedOperationException();
        }
        if (this.crystal.aperiodic()) {
            return 0.0;
        }
        int stepsPerAngstrom = 2;
        double range = 100.0;
        int nDelta = (int)((double)stepsPerAngstrom * (range - this.nonbondedCutoff.cut));
        double rDelta = (range - this.nonbondedCutoff.cut) / (double)nDelta;
        double offset = this.nonbondedCutoff.cut - 0.5 * rDelta;
        double oneMinLambda = 1.0 - this.lambda;
        int maxClass = this.vdwForm.maxClass;
        int[] radCount = new int[maxClass + 1];
        int[] softRadCount = new int[maxClass + 1];
        Arrays.fill(radCount, 0);
        Arrays.fill(softRadCount, 0);
        for (int i = 0; i < this.nAtoms; ++i) {
            int n = this.atomClass[i];
            radCount[n] = radCount[n] + 1;
            if (!this.isSoft[i]) continue;
            int n2 = this.atomClass[i];
            softRadCount[n2] = softRadCount[n2] + 1;
        }
        double total = 0.0;
        for (int i = 1; i < maxClass + 1; ++i) {
            for (int j = i; j < maxClass + 1; ++j) {
                if (radCount[i] == 0 || radCount[j] == 0) continue;
                double irv = this.vdwForm.getCombinedInverseRmin(i, j);
                double ev = this.vdwForm.getCombinedEps(i, j);
                if (Double.isNaN(irv) || irv == 0.0 || Double.isNaN(ev)) continue;
                double sume = 0.0;
                for (int k = 1; k <= nDelta; ++k) {
                    double t1;
                    double r = offset + (double)k * rDelta;
                    double r2 = r * r;
                    double rho = r * irv;
                    double rho3 = rho * rho * rho;
                    double rhod = rho + this.vdwForm.delta;
                    double rhod3 = rhod * rhod * rhod;
                    double eij = ev * t1 * (switch (this.vdwForm.vdwType) {
                        case VDWType.VDW_TYPE.LENNARD_JONES -> {
                            double rho6 = rho3 * rho3;
                            double rhod6 = rhod3 * rhod3;
                            t1 = this.vdwForm.t1n / rhod6;
                            yield this.vdwForm.gamma1 / (rho6 + this.vdwForm.gamma) - 2.0;
                        }
                        case VDWType.VDW_TYPE.BUFFERED_14_7 -> {
                            double rho7 = rho3 * rho3 * rho;
                            double rhod7 = rhod3 * rhod3 * rhod;
                            t1 = this.vdwForm.t1n / rhod7;
                            yield this.vdwForm.gamma1 / (rho7 + this.vdwForm.gamma) - 2.0;
                        }
                        default -> {
                            double rhoN = FastMath.pow((double)rho, (int)this.vdwForm.dispersivePower);
                            double rhodN = FastMath.pow((double)rhod, (int)this.vdwForm.dispersivePower);
                            t1 = this.vdwForm.t1n / rhodN;
                            yield this.vdwForm.gamma1 / (rhoN + this.vdwForm.gamma) - 2.0;
                        }
                    });
                    double taper = 1.0;
                    if (r2 < this.nonbondedCutoff.off2) {
                        double r3 = r * r2;
                        double r4 = r2 * r2;
                        double r5 = r2 * r3;
                        taper = this.multiplicativeSwitch.taper(r, r2, r3, r4, r5);
                        taper = 1.0 - taper;
                    }
                    double jacobian = Math.PI * 4 * r2;
                    double e = jacobian * eij * taper;
                    if (j != i) {
                        sume += e;
                        continue;
                    }
                    sume += 0.5 * e;
                }
                double trapezoid = rDelta * sume;
                total += (double)(radCount[i] * radCount[j]) * trapezoid;
                if (!(this.lambda < 1.0)) continue;
                total -= (double)(softRadCount[i] * radCount[j] + (radCount[i] - softRadCount[i]) * softRadCount[j]) * oneMinLambda * trapezoid;
            }
        }
        Crystal unitCell = this.crystal.getUnitCell();
        double asymmetricUnitVolume = unitCell.volume / (double)unitCell.getNumSymOps();
        logger.fine(String.format(" Long-range vdW correction: %16.8f", total /= asymmetricUnitVolume));
        return total;
    }

    private void log(int i, int k, double minr, double r, double eij) {
        Atom ai = this.atoms[i];
        Atom ak = this.atoms[k];
        logger.info(String.format("VDW %6d-%s %d %6d-%s %d %10.4f  %10.4f  %10.4f", ai.getIndex(), ai.getAtomType().name, ai.getVDWType().atomClass, ak.getIndex(), ak.getAtomType().name, ak.getVDWType().atomClass, minr, r, eij));
        logger.info(String.format("    %d %s\n    %d %s", i + 1, Arrays.toString(ai.getXYZ(null)), k + 1, Arrays.toString(ak.getXYZ(null))));
    }

    private void initSoftCore() {
        int i;
        boolean rebuild = false;
        for (i = 0; i < this.nAtoms; ++i) {
            boolean soft = this.atoms[i].applyLambda();
            if (soft == this.isSoft[i]) continue;
            this.isSoft[i] = soft;
            rebuild = true;
        }
        if (!rebuild) {
            return;
        }
        for (i = 0; i < this.nAtoms; ++i) {
            if (this.isSoft[i]) {
                this.softCore[0][i] = true;
                this.softCore[1][i] = false;
                continue;
            }
            this.softCore[0][i] = false;
            this.softCore[1][i] = true;
        }
    }

    public static class LambdaFactors {
        double sc1 = 0.0;
        double dsc1dL = 0.0;
        double d2sc1dL2 = 0.0;
        double sc2 = 1.0;
        double dsc2dL = 0.0;
        double d2sc2dL2 = 0.0;

        public void setFactors() {
        }
    }

    private class VanDerWaalsRegion
    extends ParallelRegion {
        private final InitializationLoop[] initializationLoop;
        private final ExpandLoop[] expandLoop;
        private final VanDerWaalsLoop[] vanDerWaalsLoop;
        private final ReductionLoop[] reductionLoop;
        private final NeighborListBarrier neighborListAction;
        private long initLoopTotalTime;
        private long vdWLoopTotalTime;
        private long reductionLoopTimeTotal;
        private long neighborListTotalTime;
        private long vdwTimeTotal;
        final /* synthetic */ VanDerWaals this$0;

        VanDerWaalsRegion(VanDerWaals vanDerWaals) {
            VanDerWaals vanDerWaals2 = vanDerWaals;
            Objects.requireNonNull(vanDerWaals2);
            this.this$0 = vanDerWaals2;
            this.initializationLoop = new InitializationLoop[vanDerWaals.threadCount];
            this.expandLoop = new ExpandLoop[vanDerWaals.threadCount];
            this.vanDerWaalsLoop = new VanDerWaalsLoop[vanDerWaals.threadCount];
            this.reductionLoop = new ReductionLoop[vanDerWaals.threadCount];
            this.neighborListAction = new NeighborListBarrier(this);
        }

        public void finish() {
            this.this$0.forceNeighborListRebuild = false;
            this.vdwTimeTotal += System.nanoTime();
            if (logger.isLoggable(Level.FINE)) {
                logger.fine(String.format("\n Neighbor-List:  %7.4f (sec)", (double)this.neighborListTotalTime * 1.0E-9));
                logger.fine(String.format(" Van der Waals:  %7.4f (sec)", (double)(this.vdwTimeTotal - this.neighborListTotalTime) * 1.0E-9));
                logger.fine(" Thread    Init    Energy  Reduce  Total     Counts");
                long initMax = 0L;
                long vdwMax = 0L;
                long reductionMax = 0L;
                long initMin = Long.MAX_VALUE;
                long vdwMin = Long.MAX_VALUE;
                long reductionMin = Long.MAX_VALUE;
                int countMin = Integer.MAX_VALUE;
                int countMax = 0;
                for (int i = 0; i < this.this$0.threadCount; ++i) {
                    int count = this.vanDerWaalsLoop[i].getCount();
                    long initTime = this.initializationLoop[i].time + this.expandLoop[i].time;
                    long vdWTime = this.vanDerWaalsLoop[i].time;
                    long reduceTime = this.reductionLoop[i].time;
                    long totalTime = initTime + vdWTime + reduceTime;
                    logger.fine(String.format("    %3d   %7.4f %7.4f %7.4f %7.4f %10d", i, (double)initTime * 1.0E-9, (double)vdWTime * 1.0E-9, (double)reduceTime * 1.0E-9, (double)totalTime * 1.0E-9, count));
                    initMax = FastMath.max((long)initTime, (long)initMax);
                    vdwMax = FastMath.max((long)vdWTime, (long)vdwMax);
                    reductionMax = FastMath.max((long)reduceTime, (long)reductionMax);
                    countMax = FastMath.max((int)countMax, (int)count);
                    initMin = FastMath.min((long)initTime, (long)initMin);
                    vdwMin = FastMath.min((long)vdWTime, (long)vdwMin);
                    reductionMin = FastMath.min((long)reduceTime, (long)reductionMin);
                    countMin = FastMath.min((int)countMin, (int)count);
                }
                long totalMin = initMin + vdwMin + reductionMin;
                long totalMax = initMax + vdwMax + reductionMax;
                long totalActual = this.initLoopTotalTime + this.vdWLoopTotalTime + this.reductionLoopTimeTotal;
                logger.fine(String.format(" Min      %7.4f %7.4f %7.4f %7.4f %10d", (double)initMin * 1.0E-9, (double)vdwMin * 1.0E-9, (double)reductionMin * 1.0E-9, (double)totalMin * 1.0E-9, countMin));
                logger.fine(String.format(" Max      %7.4f %7.4f %7.4f %7.4f %10d", (double)initMax * 1.0E-9, (double)vdwMax * 1.0E-9, (double)reductionMax * 1.0E-9, (double)totalMax * 1.0E-9, countMax));
                logger.fine(String.format(" Delta    %7.4f %7.4f %7.4f %7.4f %10d", (double)(initMax - initMin) * 1.0E-9, (double)(vdwMax - vdwMin) * 1.0E-9, (double)(reductionMax - reductionMin) * 1.0E-9, (double)(totalMax - totalMin) * 1.0E-9, countMax - countMin));
                logger.fine(String.format(" Actual   %7.4f %7.4f %7.4f %7.4f %10d\n", (double)this.initLoopTotalTime * 1.0E-9, (double)this.vdWLoopTotalTime * 1.0E-9, (double)this.reductionLoopTimeTotal * 1.0E-9, (double)totalActual * 1.0E-9, this.this$0.sharedInteractions.get()));
            }
        }

        public void run() throws Exception {
            String message;
            int threadIndex = this.getThreadIndex();
            if (this.initializationLoop[threadIndex] == null) {
                this.initializationLoop[threadIndex] = new InitializationLoop(this);
                this.expandLoop[threadIndex] = new ExpandLoop(this);
                this.vanDerWaalsLoop[threadIndex] = new VanDerWaalsLoop(this);
                this.reductionLoop[threadIndex] = new ReductionLoop(this);
            }
            try {
                if (threadIndex == 0) {
                    this.initLoopTotalTime = -System.nanoTime();
                }
                this.execute(0, this.this$0.nAtoms - 1, this.initializationLoop[threadIndex]);
                this.execute(0, this.this$0.nAtoms - 1, this.expandLoop[threadIndex]);
                if (threadIndex == 0) {
                    this.initLoopTotalTime += System.nanoTime();
                }
            }
            catch (RuntimeException ex) {
                logger.warning("Runtime exception expanding coordinates in thread: " + threadIndex);
                throw ex;
            }
            catch (Exception e) {
                message = "Fatal exception expanding coordinates in thread: " + threadIndex + "\n";
                logger.log(Level.SEVERE, message, e);
            }
            this.barrier(this.neighborListAction);
            if (this.this$0.forceNeighborListRebuild) {
                return;
            }
            try {
                if (threadIndex == 0) {
                    this.vdWLoopTotalTime = -System.nanoTime();
                }
                this.execute(0, this.this$0.nAtoms - 1, this.vanDerWaalsLoop[threadIndex]);
                if (threadIndex == 0) {
                    this.vdWLoopTotalTime += System.nanoTime();
                }
            }
            catch (RuntimeException ex) {
                logger.warning("Runtime exception evaluating van der Waals energy in thread: " + threadIndex);
                throw ex;
            }
            catch (Exception e) {
                message = "Fatal exception evaluating van der Waals energy in thread: " + threadIndex + "\n";
                logger.log(Level.SEVERE, message, e);
            }
            if (this.this$0.gradient || this.this$0.lambdaTerm) {
                try {
                    if (threadIndex == 0) {
                        this.reductionLoopTimeTotal = -System.nanoTime();
                    }
                    this.execute(0, this.this$0.nAtoms - 1, this.reductionLoop[threadIndex]);
                    if (threadIndex == 0) {
                        this.reductionLoopTimeTotal += System.nanoTime();
                    }
                }
                catch (RuntimeException ex) {
                    logger.warning("Runtime exception reducing van der Waals gradient in thread: " + threadIndex);
                    throw ex;
                }
                catch (Exception e) {
                    message = "Fatal exception reducing van der Waals gradient in thread: " + threadIndex + "\n";
                    logger.log(Level.SEVERE, message, e);
                }
            }
        }

        public void start() {
            this.vdwTimeTotal = -System.nanoTime();
            if (this.this$0.doLongRangeCorrection) {
                this.this$0.longRangeCorrection = this.this$0.computeLongRangeCorrection();
                this.this$0.sharedEnergy.set(this.this$0.longRangeCorrection);
            } else {
                this.this$0.sharedEnergy.set(0.0);
            }
            this.this$0.sharedInteractions.set(0);
            if (this.this$0.lambdaTerm) {
                this.this$0.shareddEdL.set(0.0);
                this.this$0.sharedd2EdL2.set(0.0);
            }
            if (this.this$0.esvTerm) {
                this.this$0.esvSystem.initEsvVdw();
                this.this$0.lambdaFactors = new LambdaFactors[this.this$0.threadCount];
                for (int i = 0; i < this.this$0.threadCount; ++i) {
                    this.this$0.lambdaFactors[i] = new LambdaFactors();
                }
            }
            this.this$0.grad.alloc(this.this$0.nAtoms);
            if (this.this$0.lambdaTerm) {
                this.this$0.lambdaGrad.alloc(this.this$0.nAtoms);
            }
        }

        private class InitializationLoop
        extends IntegerForLoop {
            private int threadID;
            protected long time;
            final /* synthetic */ VanDerWaalsRegion this$1;

            private InitializationLoop(VanDerWaalsRegion vanDerWaalsRegion) {
                VanDerWaalsRegion vanDerWaalsRegion2 = vanDerWaalsRegion;
                Objects.requireNonNull(vanDerWaalsRegion2);
                this.this$1 = vanDerWaalsRegion2;
            }

            public void run(int lb, int ub) {
                int i = lb;
                int i3 = 3 * lb;
                while (i <= ub) {
                    Atom atom = this.this$1.this$0.atoms[i];
                    this.this$1.this$0.coordinates[i3 + 0] = atom.getX();
                    this.this$1.this$0.coordinates[i3 + 1] = atom.getY();
                    this.this$1.this$0.coordinates[i3 + 2] = atom.getZ();
                    this.this$1.this$0.use[i] = atom.getUse();
                    VDWType vdwType = atom.getVDWType();
                    if (vdwType == null) {
                        logger.severe(" No VdW type for atom " + String.valueOf(atom));
                        return;
                    }
                    this.this$1.this$0.atomClass[i] = vdwType.atomClass;
                    List<Bond> bonds = atom.getBonds();
                    int numBonds = bonds.size();
                    if (this.this$1.this$0.reducedHydrogen && vdwType.reductionFactor > 0.0 && numBonds == 1) {
                        Bond bond = bonds.get(0);
                        Atom heavyAtom = bond.get1_2(atom);
                        this.this$1.this$0.reductionIndex[i] = heavyAtom.getIndex() - 1;
                        this.this$1.this$0.reductionValue[i] = vdwType.reductionFactor;
                    } else {
                        this.this$1.this$0.reductionIndex[i] = i;
                        this.this$1.this$0.reductionValue[i] = 0.0;
                    }
                    List<Atom> n12 = atom.get12List();
                    if (this.this$1.this$0.mask12[i] == null || this.this$1.this$0.mask12[i].length != n12.size()) {
                        this.this$1.this$0.mask12[i] = new int[n12.size()];
                    }
                    int j = 0;
                    for (Atom atom2 : n12) {
                        this.this$1.this$0.mask12[i][j++] = atom2.getIndex() - 1;
                    }
                    List<Atom> n13 = atom.get13List();
                    if (this.this$1.this$0.mask13[i] == null || this.this$1.this$0.mask13[i].length != n13.size()) {
                        this.this$1.this$0.mask13[i] = new int[n13.size()];
                    }
                    j = 0;
                    for (Atom a13 : n13) {
                        this.this$1.this$0.mask13[i][j++] = a13.getIndex() - 1;
                    }
                    List<Atom> list = atom.get14List();
                    if (this.this$1.this$0.mask14[i] == null || this.this$1.this$0.mask14[i].length != list.size()) {
                        this.this$1.this$0.mask14[i] = new int[list.size()];
                    }
                    j = 0;
                    for (Atom a14 : list) {
                        this.this$1.this$0.mask14[i][j++] = a14.getIndex() - 1;
                    }
                    ++i;
                    i3 += 3;
                }
                if (this.this$1.this$0.gradient) {
                    this.this$1.this$0.grad.reset(this.threadID, lb, ub);
                }
                if (this.this$1.this$0.lambdaTerm) {
                    this.this$1.this$0.lambdaGrad.reset(this.threadID, lb, ub);
                }
            }

            public IntegerSchedule schedule() {
                return IntegerSchedule.fixed();
            }

            public void finish() {
                this.time += System.nanoTime();
            }

            public void start() {
                this.threadID = this.getThreadIndex();
                this.time = -System.nanoTime();
            }
        }

        private class ExpandLoop
        extends IntegerForLoop {
            private final double[] in;
            private final double[] out;
            private long time;
            final /* synthetic */ VanDerWaalsRegion this$1;

            private ExpandLoop(VanDerWaalsRegion vanDerWaalsRegion) {
                VanDerWaalsRegion vanDerWaalsRegion2 = vanDerWaalsRegion;
                Objects.requireNonNull(vanDerWaalsRegion2);
                this.this$1 = vanDerWaalsRegion2;
                this.in = new double[3];
                this.out = new double[3];
            }

            public void finish() {
                this.time += System.nanoTime();
            }

            public void run(int lb, int ub) {
                for (int i = lb; i <= ub; ++i) {
                    int i3 = i * 3;
                    int iX = i3 + 0;
                    int iY = i3 + 1;
                    int iZ = i3 + 2;
                    double x = this.this$1.this$0.coordinates[iX];
                    double y = this.this$1.this$0.coordinates[iY];
                    double z = this.this$1.this$0.coordinates[iZ];
                    int redIndex = this.this$1.this$0.reductionIndex[i];
                    if (redIndex >= 0) {
                        int r3 = redIndex * 3;
                        double rx = this.this$1.this$0.coordinates[r3++];
                        double ry = this.this$1.this$0.coordinates[r3++];
                        double rz = this.this$1.this$0.coordinates[r3];
                        double a = this.this$1.this$0.reductionValue[i];
                        this.this$1.this$0.reducedXYZ[iX] = a * (x - rx) + rx;
                        this.this$1.this$0.reducedXYZ[iY] = a * (y - ry) + ry;
                        this.this$1.this$0.reducedXYZ[iZ] = a * (z - rz) + rz;
                        this.in[0] = this.this$1.this$0.reducedXYZ[iX];
                        this.in[1] = this.this$1.this$0.reducedXYZ[iY];
                        this.in[2] = this.this$1.this$0.reducedXYZ[iZ];
                        this.this$1.this$0.atoms[i].setRedXYZ(this.in);
                        continue;
                    }
                    this.this$1.this$0.reducedXYZ[iX] = x;
                    this.this$1.this$0.reducedXYZ[iY] = y;
                    this.this$1.this$0.reducedXYZ[iZ] = z;
                }
                List symOps = this.this$1.this$0.crystal.spaceGroup.symOps;
                if (symOps.size() != this.this$1.this$0.nSymm) {
                    String message = String.format(" Programming Error: nSymm %d != symOps.size %d", this.this$1.this$0.nSymm, symOps.size());
                    logger.log(Level.WARNING, message);
                    logger.log(Level.WARNING, " Replicates\n{0}", this.this$1.this$0.crystal.toString());
                    logger.log(Level.WARNING, " Unit Cell\n{0}", this.this$1.this$0.crystal.getUnitCell().toString());
                }
                double sp2 = this.this$1.this$0.crystal.getSpecialPositionCutoff();
                sp2 *= sp2;
                for (int iSymOp = 1; iSymOp < this.this$1.this$0.nSymm; ++iSymOp) {
                    SymOp symOp = (SymOp)symOps.get(iSymOp);
                    double[] xyz = this.this$1.this$0.reduced[iSymOp];
                    for (int i = lb; i <= ub; ++i) {
                        int i3 = i * 3;
                        int iX = i3 + 0;
                        int iY = i3 + 1;
                        int iZ = i3 + 2;
                        this.in[0] = this.this$1.this$0.reducedXYZ[iX];
                        this.in[1] = this.this$1.this$0.reducedXYZ[iY];
                        this.in[2] = this.this$1.this$0.reducedXYZ[iZ];
                        this.this$1.this$0.crystal.applySymOp(this.in, this.out, symOp);
                        xyz[iX] = this.out[0];
                        xyz[iY] = this.out[1];
                        xyz[iZ] = this.out[2];
                        double dx = this.in[0] - this.out[0];
                        double dy = this.in[1] - this.out[1];
                        double dz = this.in[2] - this.out[2];
                        double r2 = dx * dx + dy * dy + dz * dz;
                        if (!(r2 < sp2) || !logger.isLoggable(Level.FINEST)) continue;
                        logger.log(Level.FINEST, " Atom may be at a special position: {0}", this.this$1.this$0.atoms[i].toString());
                    }
                }
            }

            public IntegerSchedule schedule() {
                return IntegerSchedule.fixed();
            }

            public void start() {
                this.time = -System.nanoTime();
            }
        }

        private class VanDerWaalsLoop
        extends IntegerForLoop {
            protected long time;
            private final double[] dx_local;
            private final double[][] transOp;
            private int count;
            private double energy;
            private int threadID;
            private double dEdL;
            private double d2EdL2;
            private double[] mask;
            private boolean[] vdw14;
            private LambdaFactors lambdaFactorsLocal;
            final /* synthetic */ VanDerWaalsRegion this$1;

            VanDerWaalsLoop(VanDerWaalsRegion vanDerWaalsRegion) {
                VanDerWaalsRegion vanDerWaalsRegion2 = vanDerWaalsRegion;
                Objects.requireNonNull(vanDerWaalsRegion2);
                this.this$1 = vanDerWaalsRegion2;
                this.dx_local = new double[3];
                this.transOp = new double[3][3];
            }

            public void finish() {
                this.this$1.this$0.sharedEnergy.addAndGet(this.energy);
                this.this$1.this$0.sharedInteractions.addAndGet(this.count);
                if (this.this$1.this$0.lambdaTerm) {
                    this.this$1.this$0.shareddEdL.addAndGet(this.dEdL);
                    this.this$1.this$0.sharedd2EdL2.addAndGet(this.d2EdL2);
                }
                this.time += System.nanoTime();
            }

            public int getCount() {
                return this.count;
            }

            public void run(int lb, int ub) {
                double dedldz;
                double dedldy;
                double dedldx;
                double t22;
                double dedz;
                double dedy;
                double dedx;
                double e = 0.0;
                double[] xyzS = this.this$1.this$0.reduced[0];
                int[][] list = this.this$1.this$0.neighborLists[0];
                double[] esvVdwPrefactori = new double[3];
                double[] esvVdwPrefactork = new double[3];
                for (int i = lb; i <= ub; ++i) {
                    int[] neighbors;
                    boolean esvi;
                    if (!this.this$1.this$0.use[i]) continue;
                    boolean bl = esvi = this.this$1.this$0.esvTerm && this.this$1.this$0.esvSystem.isTitratingHydrogen(i);
                    if (this.this$1.this$0.esvTerm) {
                        this.this$1.this$0.esvSystem.getVdwPrefactor(i, esvVdwPrefactori);
                    }
                    int i3 = i * 3;
                    double xi = this.this$1.this$0.reducedXYZ[i3++];
                    double yi = this.this$1.this$0.reducedXYZ[i3++];
                    double zi = this.this$1.this$0.reducedXYZ[i3];
                    int redi = this.this$1.this$0.reductionIndex[i];
                    double redv = this.this$1.this$0.reductionValue[i];
                    double rediv = 1.0 - redv;
                    int classI = this.this$1.this$0.atomClass[i];
                    int moleculei = this.this$1.this$0.molecule[i];
                    boolean iNN = this.this$1.this$0.neuralNetwork[i];
                    double gxi = 0.0;
                    double gyi = 0.0;
                    double gzi = 0.0;
                    double gxredi = 0.0;
                    double gyredi = 0.0;
                    double gzredi = 0.0;
                    double lxi = 0.0;
                    double lyi = 0.0;
                    double lzi = 0.0;
                    double lxredi = 0.0;
                    double lyredi = 0.0;
                    double lzredi = 0.0;
                    this.this$1.this$0.applyMask(i, this.vdw14, new double[][]{this.mask});
                    boolean[] softCorei = this.this$1.this$0.softCore[0];
                    if (this.this$1.this$0.isSoft[i]) {
                        softCorei = this.this$1.this$0.softCore[1];
                    }
                    for (int k : neighbors = list[i]) {
                        double d2sc2dL2;
                        double dsc2dL;
                        double sc2;
                        double d2sc1dL2;
                        double dsc1dL;
                        double sc1;
                        boolean esvk;
                        if (!this.this$1.this$0.use[k] || iNN && this.this$1.this$0.neuralNetwork[k]) continue;
                        boolean bl2 = esvk = this.this$1.this$0.esvTerm && this.this$1.this$0.esvSystem.isTitratingHydrogen(k);
                        if (this.this$1.this$0.esvTerm) {
                            this.this$1.this$0.esvSystem.getVdwPrefactor(k, esvVdwPrefactork);
                        }
                        int k3 = k * 3;
                        double xk = xyzS[k3++];
                        double yk = xyzS[k3++];
                        double zk = xyzS[k3];
                        this.dx_local[0] = xi - xk;
                        this.dx_local[1] = yi - yk;
                        this.dx_local[2] = zi - zk;
                        double r2 = this.this$1.this$0.crystal.image(this.dx_local);
                        int classK = this.this$1.this$0.atomClass[k];
                        double irv = this.this$1.this$0.vdwForm.getCombinedInverseRmin(classI, classK);
                        if (this.vdw14[k]) {
                            irv = this.this$1.this$0.vdwForm.getCombinedInverseRmin14(classI, classK);
                        }
                        if (!(r2 <= this.this$1.this$0.nonbondedCutoff.off2) || !(this.mask[k] > 0.0) || !(irv > 0.0)) continue;
                        double r = FastMath.sqrt((double)r2);
                        boolean sameMolecule = moleculei == this.this$1.this$0.molecule[k];
                        boolean soft = softCorei[k];
                        if (this.this$1.this$0.isSoft[i] && this.this$1.this$0.isSoft[k]) {
                            if (this.this$1.this$0.intermolecularSoftcore && !sameMolecule) {
                                soft = true;
                            } else if (this.this$1.this$0.intramolecularSoftcore && sameMolecule) {
                                soft = true;
                            }
                        }
                        if (soft) {
                            sc1 = this.lambdaFactorsLocal.sc1;
                            dsc1dL = this.lambdaFactorsLocal.dsc1dL;
                            d2sc1dL2 = this.lambdaFactorsLocal.d2sc1dL2;
                            sc2 = this.lambdaFactorsLocal.sc2;
                            dsc2dL = this.lambdaFactorsLocal.dsc2dL;
                            d2sc2dL2 = this.lambdaFactorsLocal.d2sc2dL2;
                        } else {
                            sc1 = 0.0;
                            dsc1dL = 0.0;
                            d2sc1dL2 = 0.0;
                            sc2 = 1.0;
                            dsc2dL = 0.0;
                            d2sc2dL2 = 0.0;
                        }
                        double alpha = sc1;
                        double lambda5 = sc2;
                        double ev = this.mask[k] * this.this$1.this$0.vdwForm.getCombinedEps(classI, classK);
                        if (this.vdw14[k]) {
                            ev = this.mask[k] * this.this$1.this$0.vdwForm.getCombinedEps14(classI, classK);
                        }
                        double eps_lambda = ev * lambda5;
                        double rho = r * irv;
                        double rhoDisp1 = this.this$1.this$0.vdwForm.rhoDisp1(rho);
                        double rhoDisp = rhoDisp1 * rho;
                        double rhoDelta1 = this.this$1.this$0.vdwForm.rhoDelta1(rho + this.this$1.this$0.vdwForm.delta);
                        double rhoDelta = rhoDelta1 * (rho + this.this$1.this$0.vdwForm.delta);
                        double alphaRhoDelta = alpha + rhoDelta;
                        double alphaRhoDispGamma = alpha + rhoDisp + this.this$1.this$0.vdwForm.gamma;
                        double t1d = 1.0 / alphaRhoDelta;
                        double t2d = 1.0 / alphaRhoDispGamma;
                        double t1 = this.this$1.this$0.vdwForm.t1n * t1d;
                        double t2a = this.this$1.this$0.vdwForm.gamma1 * t2d;
                        double t2 = t2a - 2.0;
                        double eik = eps_lambda * t1 * t2;
                        double taper = 1.0;
                        double dtaper = 0.0;
                        if (r2 > this.this$1.this$0.nonbondedCutoff.cut2) {
                            double r3 = r2 * r;
                            double r4 = r2 * r2;
                            double r5 = r2 * r3;
                            taper = this.this$1.this$0.multiplicativeSwitch.taper(r, r2, r3, r4, r5);
                            dtaper = this.this$1.this$0.multiplicativeSwitch.dtaper(r, r2, r3, r4);
                        }
                        double esvik = 1.0;
                        if (esvi || esvk) {
                            esvik = esvVdwPrefactori[0] * esvVdwPrefactork[0];
                        }
                        e += eik * taper * esvik;
                        ++this.count;
                        if (!this.this$1.this$0.gradient && !soft) continue;
                        int redk = this.this$1.this$0.reductionIndex[k];
                        double red = this.this$1.this$0.reductionValue[k];
                        double redkv = 1.0 - red;
                        double dt1d_dr = (double)this.this$1.this$0.vdwForm.repDispPower * rhoDelta1 * irv;
                        double dt2d_dr = (double)this.this$1.this$0.vdwForm.dispersivePower * rhoDisp1 * irv;
                        double dt1_dr = t1 * dt1d_dr * t1d;
                        double dt2_dr = t2a * dt2d_dr * t2d;
                        double dedr = -eps_lambda * (dt1_dr * t2 + t1 * dt2_dr);
                        double ir = 1.0 / r;
                        double drdx = this.dx_local[0] * ir;
                        double drdy = this.dx_local[1] * ir;
                        double drdz = this.dx_local[2] * ir;
                        if (this.this$1.this$0.gradient) {
                            double dswitch = esvik * (eik * dtaper + dedr * taper);
                            dedx = dswitch * drdx;
                            dedy = dswitch * drdy;
                            dedz = dswitch * drdz;
                            gxi += dedx * redv;
                            gyi += dedy * redv;
                            gzi += dedz * redv;
                            gxredi += dedx * rediv;
                            gyredi += dedy * rediv;
                            gzredi += dedz * rediv;
                            this.this$1.this$0.grad.sub(this.threadID, k, red * dedx, red * dedy, red * dedz);
                            this.this$1.this$0.grad.sub(this.threadID, redk, redkv * dedx, redkv * dedy, redkv * dedz);
                            if (esvi) {
                                this.this$1.this$0.esvSystem.addVdwDeriv(i, eik * taper, esvVdwPrefactori, esvVdwPrefactork[0]);
                            }
                            if (esvk) {
                                this.this$1.this$0.esvSystem.addVdwDeriv(k, eik * taper, esvVdwPrefactork, esvVdwPrefactori[0]);
                            }
                        }
                        if (!this.this$1.this$0.gradient || !soft) continue;
                        double dt1 = -t1 * t1d * dsc1dL;
                        double dt2 = -t2a * t2d * dsc1dL;
                        double f1 = dsc2dL * t1 * t2;
                        double f2 = sc2 * dt1 * t2;
                        double f3 = sc2 * t1 * dt2;
                        double dedl = ev * (f1 + f2 + f3);
                        this.dEdL += dedl * taper * esvik;
                        double t1d2 = -dsc1dL * t1d * t1d;
                        double t2d2 = -dsc1dL * t2d * t2d;
                        double d2t1 = -dt1 * t1d * dsc1dL - t1 * t1d * d2sc1dL2 - t1 * t1d2 * dsc1dL;
                        double d2t2 = -dt2 * t2d * dsc1dL - t2a * t2d * d2sc1dL2 - t2a * t2d2 * dsc1dL;
                        double df1 = d2sc2dL2 * t1 * t2 + dsc2dL * dt1 * t2 + dsc2dL * t1 * dt2;
                        double df2 = dsc2dL * dt1 * t2 + sc2 * d2t1 * t2 + sc2 * dt1 * dt2;
                        double df3 = dsc2dL * t1 * dt2 + sc2 * dt1 * dt2 + sc2 * t1 * d2t2;
                        double de2dl2 = ev * (df1 + df2 + df3);
                        this.d2EdL2 += de2dl2 * taper * esvik;
                        double t11 = -dsc2dL * t2 * dt1_dr;
                        double t21 = -dsc2dL * t1 * dt2_dr;
                        double t13 = 2.0 * sc2 * t2 * dt1_dr * dsc1dL * t1d;
                        double t23 = 2.0 * sc2 * t1 * dt2_dr * dsc1dL * t2d;
                        double t12 = -sc2 * dt2 * dt1_dr;
                        t22 = -sc2 * dt1 * dt2_dr;
                        double dedldr = ev * (t11 + t12 + t13 + t21 + t22 + t23);
                        double dswitch = esvik * (dedl * dtaper + dedldr * taper);
                        dedldx = dswitch * drdx;
                        dedldy = dswitch * drdy;
                        dedldz = dswitch * drdz;
                        lxi += dedldx * redv;
                        lyi += dedldy * redv;
                        lzi += dedldz * redv;
                        lxredi += dedldx * rediv;
                        lyredi += dedldy * rediv;
                        lzredi += dedldz * rediv;
                        if (!this.this$1.this$0.lambdaTerm) continue;
                        this.this$1.this$0.lambdaGrad.sub(this.threadID, k, red * dedldx, red * dedldy, red * dedldz);
                        this.this$1.this$0.lambdaGrad.sub(this.threadID, redk, redkv * dedldx, redkv * dedldy, redkv * dedldz);
                    }
                    if (this.this$1.this$0.gradient) {
                        this.this$1.this$0.grad.add(this.threadID, i, gxi, gyi, gzi);
                        this.this$1.this$0.grad.add(this.threadID, redi, gxredi, gyredi, gzredi);
                        if (this.this$1.this$0.lambdaTerm) {
                            this.this$1.this$0.lambdaGrad.add(this.threadID, i, lxi, lyi, lzi);
                            this.this$1.this$0.lambdaGrad.add(this.threadID, redi, lxredi, lyredi, lzredi);
                        }
                    }
                    this.this$1.this$0.removeMask(i, this.vdw14, new double[][]{this.mask});
                }
                this.energy += e;
                List symOps = this.this$1.this$0.crystal.spaceGroup.symOps;
                for (int iSymOp = 1; iSymOp < this.this$1.this$0.nSymm; ++iSymOp) {
                    e = 0.0;
                    SymOp symOp = (SymOp)symOps.get(iSymOp);
                    this.this$1.this$0.crystal.getTransformationOperator(symOp, this.transOp);
                    xyzS = this.this$1.this$0.reduced[iSymOp];
                    list = this.this$1.this$0.neighborLists[iSymOp];
                    for (int i = lb; i <= ub; ++i) {
                        int[] neighbors;
                        boolean esvi;
                        int i3 = i * 3;
                        if (!this.this$1.this$0.use[i]) continue;
                        boolean bl = esvi = this.this$1.this$0.esvTerm && this.this$1.this$0.esvSystem.isTitratingHydrogen(i);
                        if (this.this$1.this$0.esvTerm) {
                            this.this$1.this$0.esvSystem.getVdwPrefactor(i, esvVdwPrefactori);
                        }
                        double xi = this.this$1.this$0.reducedXYZ[i3++];
                        double yi = this.this$1.this$0.reducedXYZ[i3++];
                        double zi = this.this$1.this$0.reducedXYZ[i3];
                        int redi = this.this$1.this$0.reductionIndex[i];
                        double redv = this.this$1.this$0.reductionValue[i];
                        double rediv = 1.0 - redv;
                        int classI = this.this$1.this$0.atomClass[i];
                        double gxi = 0.0;
                        double gyi = 0.0;
                        double gzi = 0.0;
                        double gxredi = 0.0;
                        double gyredi = 0.0;
                        double gzredi = 0.0;
                        double lxi = 0.0;
                        double lyi = 0.0;
                        double lzi = 0.0;
                        double lxredi = 0.0;
                        double lyredi = 0.0;
                        double lzredi = 0.0;
                        boolean[] softCorei = this.this$1.this$0.softCore[0];
                        if (this.this$1.this$0.isSoft[i]) {
                            softCorei = this.this$1.this$0.softCore[1];
                        }
                        for (int k : neighbors = list[i]) {
                            double d2sc2dL2;
                            double dsc2dL;
                            double sc2;
                            double d2sc1dL2;
                            double dsc1dL;
                            double sc1;
                            boolean soft;
                            boolean esvk;
                            if (!this.this$1.this$0.use[k]) continue;
                            boolean bl3 = esvk = this.this$1.this$0.esvTerm && this.this$1.this$0.esvSystem.isTitratingHydrogen(k);
                            if (this.this$1.this$0.esvTerm) {
                                this.this$1.this$0.esvSystem.getVdwPrefactor(k, esvVdwPrefactork);
                            }
                            int k3 = k * 3;
                            double xk = xyzS[k3++];
                            double yk = xyzS[k3++];
                            double zk = xyzS[k3];
                            this.dx_local[0] = xi - xk;
                            this.dx_local[1] = yi - yk;
                            this.dx_local[2] = zi - zk;
                            double r2 = this.this$1.this$0.crystal.image(this.dx_local);
                            int classK = this.this$1.this$0.atomClass[k];
                            double irv = this.this$1.this$0.vdwForm.getCombinedInverseRmin(classI, classK);
                            if (!(r2 <= this.this$1.this$0.nonbondedCutoff.off2) || !(irv > 0.0)) continue;
                            double selfScale = i == k ? 0.5 : 1.0;
                            double r = FastMath.sqrt((double)r2);
                            boolean bl4 = soft = this.this$1.this$0.isSoft[i] || softCorei[k];
                            if (soft) {
                                sc1 = this.lambdaFactorsLocal.sc1;
                                dsc1dL = this.lambdaFactorsLocal.dsc1dL;
                                d2sc1dL2 = this.lambdaFactorsLocal.d2sc1dL2;
                                sc2 = this.lambdaFactorsLocal.sc2;
                                dsc2dL = this.lambdaFactorsLocal.dsc2dL;
                                d2sc2dL2 = this.lambdaFactorsLocal.d2sc2dL2;
                            } else {
                                sc1 = 0.0;
                                dsc1dL = 0.0;
                                d2sc1dL2 = 0.0;
                                sc2 = 1.0;
                                dsc2dL = 0.0;
                                d2sc2dL2 = 0.0;
                            }
                            double alpha = sc1;
                            double lambdaN = sc2;
                            double ev = this.this$1.this$0.vdwForm.getCombinedEps(classI, classK);
                            double eps_lambda = ev * lambdaN;
                            double rho = r * irv;
                            double rhoDisp1 = this.this$1.this$0.vdwForm.rhoDisp1(rho);
                            double rhoDisp = rhoDisp1 * rho;
                            double rhoDelta1 = this.this$1.this$0.vdwForm.rhoDelta1(rho + this.this$1.this$0.vdwForm.delta);
                            double rhoDelta = rhoDelta1 * (rho + this.this$1.this$0.vdwForm.delta);
                            double alphaRhoDelta = alpha + rhoDelta;
                            double alphaRhoDispGamma = alpha + rhoDisp + this.this$1.this$0.vdwForm.gamma;
                            double t1d = 1.0 / alphaRhoDelta;
                            double t2d = 1.0 / alphaRhoDispGamma;
                            double t1 = this.this$1.this$0.vdwForm.t1n * t1d;
                            double t2a = this.this$1.this$0.vdwForm.gamma1 * t2d;
                            double t2 = t2a - 2.0;
                            double eik = eps_lambda * t1 * t2;
                            double taper = 1.0;
                            double dtaper = 0.0;
                            if (r2 > this.this$1.this$0.nonbondedCutoff.cut2) {
                                double r3 = r2 * r;
                                double r4 = r2 * r2;
                                double r5 = r2 * r3;
                                taper = this.this$1.this$0.multiplicativeSwitch.taper(r, r2, r3, r4, r5);
                                dtaper = this.this$1.this$0.multiplicativeSwitch.dtaper(r, r2, r3, r4);
                            }
                            double esvik = 1.0;
                            if (esvi || esvk) {
                                esvik = esvVdwPrefactori[0] * esvVdwPrefactork[0];
                            }
                            e += selfScale * eik * taper * esvik;
                            ++this.count;
                            if (!this.this$1.this$0.gradient && !soft) continue;
                            int redk = this.this$1.this$0.reductionIndex[k];
                            double red = this.this$1.this$0.reductionValue[k];
                            double redkv = 1.0 - red;
                            double dt1d_dr = (double)this.this$1.this$0.vdwForm.repDispPower * rhoDelta1 * irv;
                            double dt2d_dr = (double)this.this$1.this$0.vdwForm.dispersivePower * rhoDisp1 * irv;
                            double dt1_dr = t1 * dt1d_dr * t1d;
                            double dt2_dr = t2a * dt2d_dr * t2d;
                            double dedr = -eps_lambda * (dt1_dr * t2 + t1 * dt2_dr);
                            double ir = 1.0 / r;
                            double drdx = this.dx_local[0] * ir;
                            double drdy = this.dx_local[1] * ir;
                            double drdz = this.dx_local[2] * ir;
                            dedr = selfScale * esvik * (eik * dtaper + dedr * taper);
                            if (this.this$1.this$0.gradient) {
                                dedx = dedr * drdx;
                                dedy = dedr * drdy;
                                dedz = dedr * drdz;
                                gxi += dedx * redv;
                                gyi += dedy * redv;
                                gzi += dedz * redv;
                                gxredi += dedx * rediv;
                                gyredi += dedy * rediv;
                                gzredi += dedz * rediv;
                                double dedxk = dedx * this.transOp[0][0] + dedy * this.transOp[1][0] + dedz * this.transOp[2][0];
                                double dedyk = dedx * this.transOp[0][1] + dedy * this.transOp[1][1] + dedz * this.transOp[2][1];
                                double dedzk = dedx * this.transOp[0][2] + dedy * this.transOp[1][2] + dedz * this.transOp[2][2];
                                this.this$1.this$0.grad.sub(this.threadID, k, red * dedxk, red * dedyk, red * dedzk);
                                this.this$1.this$0.grad.sub(this.threadID, redk, redkv * dedxk, redkv * dedyk, redkv * dedzk);
                                if (esvi) {
                                    this.this$1.this$0.esvSystem.addVdwDeriv(i, selfScale * eik * taper, esvVdwPrefactori, esvVdwPrefactork[0]);
                                }
                                if (esvk) {
                                    this.this$1.this$0.esvSystem.addVdwDeriv(k, selfScale * eik * taper, esvVdwPrefactork, esvVdwPrefactori[0]);
                                }
                            }
                            if (!this.this$1.this$0.gradient || !this.this$1.this$0.lambdaTerm || !soft) continue;
                            double dt1 = -t1 * t1d * dsc1dL;
                            double dt2 = -t2a * t2d * dsc1dL;
                            double f1 = dsc2dL * t1 * t2;
                            double f2 = sc2 * dt1 * t2;
                            double f3 = sc2 * t1 * dt2;
                            double dedl = ev * (f1 + f2 + f3);
                            this.dEdL += selfScale * dedl * taper * esvik;
                            double t1d2 = -dsc1dL * t1d * t1d;
                            double t2d2 = -dsc1dL * t2d * t2d;
                            double d2t1 = -dt1 * t1d * dsc1dL - t1 * t1d * d2sc1dL2 - t1 * t1d2 * dsc1dL;
                            double d2t2 = -dt2 * t2d * dsc1dL - t2a * t2d * d2sc1dL2 - t2a * t2d2 * dsc1dL;
                            double df1 = d2sc2dL2 * t1 * t2 + dsc2dL * dt1 * t2 + dsc2dL * t1 * dt2;
                            double df2 = dsc2dL * dt1 * t2 + sc2 * d2t1 * t2 + sc2 * dt1 * dt2;
                            double df3 = dsc2dL * t1 * dt2 + sc2 * dt1 * dt2 + sc2 * t1 * d2t2;
                            double de2dl2 = ev * (df1 + df2 + df3);
                            this.d2EdL2 += selfScale * de2dl2 * taper * esvik;
                            double t11 = -dsc2dL * t2 * dt1_dr;
                            double t12 = -sc2 * dt2 * dt1_dr;
                            double t13 = 2.0 * sc2 * t2 * dt1_dr * dsc1dL * t1d;
                            double t21 = -dsc2dL * t1 * dt2_dr;
                            t22 = -sc2 * dt1 * dt2_dr;
                            double t23 = 2.0 * sc2 * t1 * dt2_dr * dsc1dL * t2d;
                            double dedldr = ev * (t11 + t12 + t13 + t21 + t22 + t23);
                            dedldr = esvik * (dedl * dtaper + dedldr * taper);
                            dedldx = selfScale * dedldr * drdx;
                            dedldy = selfScale * dedldr * drdy;
                            dedldz = selfScale * dedldr * drdz;
                            lxi += dedldx * redv;
                            lyi += dedldy * redv;
                            lzi += dedldz * redv;
                            lxredi += dedldx * rediv;
                            lyredi += dedldy * rediv;
                            lzredi += dedldz * rediv;
                            double dedldxk = dedldx * this.transOp[0][0] + dedldy * this.transOp[1][0] + dedldz * this.transOp[2][0];
                            double dedldyk = dedldx * this.transOp[0][1] + dedldy * this.transOp[1][1] + dedldz * this.transOp[2][1];
                            double dedldzk = dedldx * this.transOp[0][2] + dedldy * this.transOp[1][2] + dedldz * this.transOp[2][2];
                            this.this$1.this$0.lambdaGrad.sub(this.threadID, k, red * dedldxk, red * dedldyk, red * dedldzk);
                            this.this$1.this$0.lambdaGrad.sub(this.threadID, redk, redkv * dedldxk, redkv * dedldyk, redkv * dedldzk);
                        }
                        if (!this.this$1.this$0.gradient) continue;
                        this.this$1.this$0.grad.add(this.threadID, i, gxi, gyi, gzi);
                        this.this$1.this$0.grad.add(this.threadID, redi, gxredi, gyredi, gzredi);
                        if (!this.this$1.this$0.lambdaTerm) continue;
                        this.this$1.this$0.lambdaGrad.add(this.threadID, i, lxi, lyi, lzi);
                        this.this$1.this$0.lambdaGrad.add(this.threadID, redi, lxredi, lyredi, lzredi);
                    }
                    this.energy += e;
                }
            }

            public IntegerSchedule schedule() {
                return this.this$1.this$0.pairwiseSchedule;
            }

            public void start() {
                this.threadID = this.getThreadIndex();
                this.time = -System.nanoTime();
                this.energy = 0.0;
                this.count = 0;
                if (this.this$1.this$0.lambdaTerm) {
                    this.dEdL = 0.0;
                    this.d2EdL2 = 0.0;
                }
                this.lambdaFactorsLocal = this.this$1.this$0.lambdaFactors[this.threadID];
                if (this.lambdaFactorsLocal == null) {
                    System.exit(1);
                }
                if (this.mask == null || this.mask.length < this.this$1.this$0.nAtoms) {
                    this.mask = new double[this.this$1.this$0.nAtoms];
                    Arrays.fill(this.mask, 1.0);
                    this.vdw14 = new boolean[this.this$1.this$0.nAtoms];
                    Arrays.fill(this.vdw14, false);
                }
            }
        }

        private class ReductionLoop
        extends IntegerForLoop {
            protected long time;
            int threadID;
            final /* synthetic */ VanDerWaalsRegion this$1;

            private ReductionLoop(VanDerWaalsRegion vanDerWaalsRegion) {
                VanDerWaalsRegion vanDerWaalsRegion2 = vanDerWaalsRegion;
                Objects.requireNonNull(vanDerWaalsRegion2);
                this.this$1 = vanDerWaalsRegion2;
            }

            public void finish() {
                this.time += System.nanoTime();
            }

            public void run(int lb, int ub) {
                if (this.this$1.this$0.gradient) {
                    this.this$1.this$0.grad.reduce(lb, ub);
                    for (int i = lb; i <= ub; ++i) {
                        Atom ai = this.this$1.this$0.atoms[i];
                        ai.addToXYZGradient(this.this$1.this$0.grad.getX(i), this.this$1.this$0.grad.getY(i), this.this$1.this$0.grad.getZ(i));
                    }
                }
                if (this.this$1.this$0.lambdaTerm) {
                    this.this$1.this$0.lambdaGrad.reduce(lb, ub);
                }
            }

            public void start() {
                this.threadID = this.getThreadIndex();
                this.time = -System.nanoTime();
            }
        }

        private class NeighborListBarrier
        extends BarrierAction {
            final /* synthetic */ VanDerWaalsRegion this$1;

            private NeighborListBarrier(VanDerWaalsRegion vanDerWaalsRegion) {
                VanDerWaalsRegion vanDerWaalsRegion2 = vanDerWaalsRegion;
                Objects.requireNonNull(vanDerWaalsRegion2);
                this.this$1 = vanDerWaalsRegion2;
            }

            public void run() {
                this.this$1.neighborListTotalTime = -System.nanoTime();
                this.this$1.this$0.neighborList.buildList(this.this$1.this$0.reduced, this.this$1.this$0.neighborLists, null, this.this$1.this$0.forceNeighborListRebuild, false);
                this.this$1.neighborListTotalTime += System.nanoTime();
            }
        }
    }

    public class LambdaFactorsOST
    extends LambdaFactors {
        final /* synthetic */ VanDerWaals this$0;

        public LambdaFactorsOST(VanDerWaals this$0) {
            VanDerWaals vanDerWaals = this$0;
            Objects.requireNonNull(vanDerWaals);
            this.this$0 = vanDerWaals;
        }

        @Override
        public void setFactors() {
            this.sc1 = this.this$0.sc1;
            this.dsc1dL = this.this$0.dsc1dL;
            this.d2sc1dL2 = this.this$0.d2sc1dL2;
            this.sc2 = this.this$0.sc2;
            this.dsc2dL = this.this$0.dsc2dL;
            this.d2sc2dL2 = this.this$0.d2sc2dL2;
        }
    }
}

