/*
 * Decompiled with CFR 0.152.
 */
package ffx.potential.nonbonded;

import edu.rit.pj.IntegerSchedule;
import edu.rit.util.Range;

public class SpatialDensitySchedule
extends IntegerSchedule {
    private final int[] atomsPerChunk;
    private final double loadBalancePercentage;
    private int nThreads;
    private Range chunkRange;
    private boolean[] threadDone;
    private Range[] ranges;

    SpatialDensitySchedule(int nThreads, int nAtoms, int[] atomsPerChunk, double loadBalancePercentage) {
        this.atomsPerChunk = atomsPerChunk;
        this.nThreads = nThreads;
        this.threadDone = new boolean[nThreads];
        this.ranges = new Range[nThreads];
        this.loadBalancePercentage = loadBalancePercentage > 0.01 && loadBalancePercentage <= 1.0 ? loadBalancePercentage : 1.0;
    }

    public boolean isFixedSchedule() {
        return true;
    }

    public Range next(int threadID) {
        if (!this.threadDone[threadID]) {
            this.threadDone[threadID] = true;
            return this.ranges[threadID];
        }
        return null;
    }

    public void start(int nThreads, Range chunkRange) {
        this.nThreads = nThreads;
        this.chunkRange = chunkRange;
        if (nThreads != this.threadDone.length) {
            this.threadDone = new boolean[nThreads];
        }
        for (int i = 0; i < nThreads; ++i) {
            this.threadDone[i] = false;
        }
        if (nThreads != this.ranges.length) {
            this.ranges = new Range[nThreads];
        }
        this.defineRanges();
    }

    private void defineRanges() {
        int i;
        int lb = this.chunkRange.lb();
        int ub = this.chunkRange.ub();
        int thread = 0;
        int start = 0;
        int total = 0;
        for (int value : this.atomsPerChunk) {
            total += value;
        }
        int goal = (int)((double)total * this.loadBalancePercentage / (double)this.nThreads);
        total = 0;
        for (i = lb; i <= ub; ++i) {
            Range current;
            int stop;
            int chunksLeft = ub - i + 1;
            int threadsLeft = this.nThreads - thread;
            if ((total += this.atomsPerChunk[i]) > goal || chunksLeft <= threadsLeft) {
                stop = i;
                current = this.ranges[thread];
                if (current == null || current.lb() != start || current.ub() != stop) {
                    this.ranges[thread] = new Range(start, stop);
                }
                start = i + 1;
                total = 0;
                if (++thread != this.nThreads - 1) continue;
                stop = ub;
                current = this.ranges[thread];
                if (current != null && current.lb() == start && current.ub() == stop) break;
                this.ranges[thread] = new Range(start, stop);
                break;
            }
            if (i != ub) continue;
            stop = i;
            current = this.ranges[thread];
            if (current != null && current.lb() == start && current.ub() == stop) continue;
            this.ranges[thread] = new Range(start, stop);
        }
        for (i = thread + 1; i < this.nThreads; ++i) {
            this.ranges[i] = null;
        }
    }
}

