/*
 * Decompiled with CFR 0.152.
 */
package ffx.potential.nonbonded;

import ffx.crystal.Crystal;
import ffx.potential.MolecularAssembly;
import ffx.potential.bonded.Atom;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.logging.Logger;
import org.apache.commons.configuration2.CompositeConfiguration;
import org.apache.commons.math3.util.FastMath;

public class RestrainGroups {
    private static final Logger logger = Logger.getLogger(RestrainGroups.class.getName());
    final MolecularAssembly molecularAssembly;
    final Atom[] atoms;
    final int nAtoms;
    final int nGroups;
    final int[][] groupMembers;
    final int[] groupMolecule;
    final double[] groupMass;
    final int nRestraints;
    final int[] group1;
    final int[] group2;
    final double[] forceConstants;
    final double[] distance1;
    final double[] distance2;
    final boolean[] sameMolecule;

    public RestrainGroups(MolecularAssembly molecularAssembly) {
        String[] restrainGroups;
        this.molecularAssembly = molecularAssembly;
        this.atoms = molecularAssembly.getAtomArray();
        this.nAtoms = this.atoms.length;
        CompositeConfiguration compositeConfiguration = molecularAssembly.getProperties();
        String[] groups = compositeConfiguration.getStringArray("group");
        if (groups == null || groups.length < 2) {
            logger.severe(" restrain-groups requires two groups to be defined.");
        }
        if ((restrainGroups = compositeConfiguration.getStringArray("restrain-groups")) == null || restrainGroups.length < 1) {
            logger.severe(" No restrain-groups property found.");
        }
        logger.fine("\n Initializing Groups");
        HashMap groupMap = new HashMap();
        for (String g : groups) {
            String[] gs = g.trim().split(" +");
            int groupNumber = Integer.parseInt(gs[0]) - 1;
            ArrayList<Integer> groupAtomIDs = new ArrayList<Integer>();
            for (int i = 1; i < gs.length; ++i) {
                int start = Integer.parseInt(gs[i]);
                if (start < 0) {
                    start = -start - 1;
                    int end = Integer.parseInt(gs[++i]) - 1;
                    if (start >= this.nAtoms || end < start || end >= this.nAtoms) {
                        logger.severe(String.format(" Property group could not be parsed:\n %s.", g));
                        continue;
                    }
                    for (int j = start; j <= end; ++j) {
                        groupAtomIDs.add(j);
                    }
                    logger.fine(String.format(" Group %d added atoms %d to %d.", groupNumber + 1, start + 1, end + 1));
                } else {
                    int atomID = start - 1;
                    groupAtomIDs.add(atomID);
                    logger.fine(String.format(" Group %d added atom %d.", groupNumber + 1, atomID + 1));
                }
                groupMap.put(groupNumber, groupAtomIDs);
            }
        }
        int[] molecule = molecularAssembly.getMoleculeNumbers();
        this.nGroups = groupMap.size();
        this.groupMembers = new int[this.nGroups][];
        this.groupMass = new double[this.nGroups];
        this.groupMolecule = new int[this.nGroups];
        this.sameMolecule = new boolean[this.nGroups];
        for (Integer groupNumber : groupMap.keySet()) {
            ArrayList members = (ArrayList)groupMap.get(groupNumber);
            if (groupNumber >= this.nGroups) {
                logger.severe(" Please label groups from 1 to the number of groups.");
            }
            int groupID = groupNumber;
            this.groupMembers[groupID] = new int[members.size()];
            int mem = 0;
            Iterator groupAtomIDs = members.iterator();
            while (groupAtomIDs.hasNext()) {
                int member = (Integer)groupAtomIDs.next();
                this.groupMembers[groupID][mem++] = member;
            }
            logger.finer(String.format(" Group %d members %s.", groupID, Arrays.toString(this.groupMembers[groupID])));
            int k = this.groupMembers[groupID][0];
            Atom atom = this.atoms[k];
            this.groupMass[groupID] = atom.getMass();
            this.groupMolecule[groupID] = molecule[k];
            for (int i = 1; i < this.groupMembers[groupID].length; ++i) {
                k = this.groupMembers[groupID][i];
                atom = this.atoms[k];
                int n = groupID;
                this.groupMass[n] = this.groupMass[n] + atom.getMass();
                if (this.groupMolecule[groupID] == molecule[k]) continue;
                this.groupMolecule[groupID] = -1;
            }
            this.groupMass[groupID] = FastMath.max((double)this.groupMass[groupID], (double)1.0);
        }
        logger.fine("\n Initializing Restrain-Groups");
        this.nRestraints = restrainGroups.length;
        this.group1 = new int[this.nRestraints];
        this.group2 = new int[this.nRestraints];
        this.forceConstants = new double[this.nRestraints];
        this.distance1 = new double[this.nRestraints];
        this.distance2 = new double[this.nRestraints];
        int iRestraint = 0;
        for (String restraint : restrainGroups) {
            String[] values = restraint.trim().split(" +");
            if (values.length < 3) {
                logger.severe(String.format(" Property restrain-groups could not be parsed:\n %s.", restraint));
            }
            this.group1[iRestraint] = Integer.parseInt(values[0]) - 1;
            this.group2[iRestraint] = Integer.parseInt(values[1]) - 1;
            int i1 = this.group1[iRestraint];
            int i2 = this.group2[iRestraint];
            if (i1 >= this.nGroups || i2 >= this.nGroups) {
                logger.severe(String.format(" Property restrain-groups has invalid groups:\n %s.", restraint));
            }
            this.forceConstants[iRestraint] = Double.parseDouble(values[2]);
            this.distance1[iRestraint] = 0.0;
            this.distance2[iRestraint] = 0.0;
            if (values.length > 3) {
                this.distance1[iRestraint] = Double.parseDouble(values[3]);
                if (values.length > 4) {
                    this.distance2[iRestraint] = Double.parseDouble(values[4]);
                }
            }
            this.sameMolecule[iRestraint] = false;
            if (this.groupMolecule[i1] > -1 && this.groupMolecule[i2] > -1 && this.groupMolecule[i1] == this.groupMolecule[i2]) {
                this.sameMolecule[iRestraint] = true;
            }
            logger.fine(String.format(" Restrain-Groups %2d %2d %8.3f %8.3f %8.3f", i1 + 1, i2 + 1, this.forceConstants[iRestraint], this.distance1[iRestraint], this.distance2[iRestraint]));
            ++iRestraint;
        }
        logger.fine("\n");
    }

    public int getNumberOfGroups() {
        return this.nGroups;
    }

    public int[] getGroupMembers(int group) {
        return this.groupMembers[group];
    }

    public int[] getGroup1() {
        return this.group1;
    }

    public int[] getGroup2() {
        return this.group2;
    }

    public double[] getForceConstants() {
        return this.forceConstants;
    }

    public double[] getSmallerDistance() {
        return this.distance1;
    }

    public double[] getLargerDistance() {
        return this.distance2;
    }

    public double energy(boolean gradient) {
        double energy = 0.0;
        double[] xyz = new double[3];
        double[] dr = new double[3];
        Crystal crystal = this.molecularAssembly.getCrystal();
        for (int i = 0; i < this.nRestraints; ++i) {
            double ratio;
            double mass;
            Atom atom;
            int k;
            int j;
            double r2;
            int i1 = this.group1[i];
            int i2 = this.group2[i];
            double xcm = 0.0;
            double ycm = 0.0;
            double zcm = 0.0;
            for (int j2 = 0; j2 < this.groupMembers[i1].length; ++j2) {
                int k2 = this.groupMembers[i1][j2];
                Atom atom2 = this.atoms[k2];
                double mass2 = atom2.getMass();
                atom2.getXYZ(xyz);
                xcm += xyz[0] * mass2;
                ycm += xyz[1] * mass2;
                zcm += xyz[2] * mass2;
            }
            double mass1 = this.groupMass[i1];
            double xr = xcm / mass1;
            double yr = ycm / mass1;
            double zr = zcm / mass1;
            xcm = 0.0;
            ycm = 0.0;
            zcm = 0.0;
            for (int j3 = 0; j3 < this.groupMembers[i2].length; ++j3) {
                int k3 = this.groupMembers[i2][j3];
                Atom atom3 = this.atoms[k3];
                double mass3 = atom3.getMass();
                atom3.getXYZ(xyz);
                xcm += xyz[0] * mass3;
                ycm += xyz[1] * mass3;
                zcm += xyz[2] * mass3;
            }
            double mass2 = this.groupMass[i2];
            xr -= xcm / mass2;
            yr -= ycm / mass2;
            zr -= zcm / mass2;
            if (this.sameMolecule[i]) {
                r2 = xr * xr + yr * yr + zr * zr;
            } else {
                dr[0] = xr;
                dr[1] = yr;
                dr[2] = zr;
                r2 = crystal.image(dr);
            }
            double r = FastMath.sqrt((double)r2);
            double force = this.forceConstants[i];
            double gf1 = this.distance1[i];
            double gf2 = this.distance2[i];
            double target = r;
            if (r < gf1) {
                target = gf1;
            }
            if (r > gf2) {
                target = gf2;
            }
            double dt = r - target;
            double dt2 = dt * dt;
            double e = force * dt2;
            energy += e;
            if (!gradient) continue;
            if (r == 0.0) {
                r = 1.0;
            }
            double de = 2.0 * force * dt / r;
            double dedx = de * xr;
            double dedy = de * yr;
            double dedz = de * zr;
            for (j = 0; j < this.groupMembers[i1].length; ++j) {
                k = this.groupMembers[i1][j];
                atom = this.atoms[k];
                mass = atom.getMass();
                ratio = mass / mass1;
                atom.addToXYZGradient(dedx * ratio, dedy * ratio, dedz * ratio);
            }
            for (j = 0; j < this.groupMembers[i2].length; ++j) {
                k = this.groupMembers[i2][j];
                atom = this.atoms[k];
                mass = atom.getMass();
                ratio = mass / mass2;
                atom.addToXYZGradient(-dedx * ratio, -dedy * ratio, -dedz * ratio);
            }
        }
        return energy;
    }

    public int getNumberOfRestraints() {
        return this.nRestraints;
    }
}

