/*
 * Decompiled with CFR 0.152.
 */
package ffx.potential.nonbonded;

import edu.rit.pj.ParallelRegion;
import edu.rit.pj.ParallelTeam;
import ffx.crystal.Crystal;
import ffx.numerics.atomic.AtomicDoubleArray;
import ffx.numerics.atomic.AtomicDoubleArray3D;
import ffx.potential.bonded.Atom;
import ffx.potential.bonded.LambdaInterface;
import ffx.potential.nonbonded.ParticleMeshEwald;
import ffx.potential.nonbonded.implicit.BornGradRegion;
import ffx.potential.nonbonded.implicit.BornRadiiRegion;
import ffx.potential.nonbonded.implicit.BornTanhRescaling;
import ffx.potential.nonbonded.implicit.ChandlerCavitation;
import ffx.potential.nonbonded.implicit.ConnollyRegion;
import ffx.potential.nonbonded.implicit.DispersionRegion;
import ffx.potential.nonbonded.implicit.GKEnergyRegion;
import ffx.potential.nonbonded.implicit.GaussVol;
import ffx.potential.nonbonded.implicit.InducedGKFieldRegion;
import ffx.potential.nonbonded.implicit.InitializationRegion;
import ffx.potential.nonbonded.implicit.PermanentGKFieldRegion;
import ffx.potential.nonbonded.implicit.SurfaceAreaRegion;
import ffx.potential.nonbonded.pme.Polarization;
import ffx.potential.parameters.AtomType;
import ffx.potential.parameters.ForceField;
import ffx.potential.parameters.SoluteType;
import ffx.utilities.FFXProperty;
import ffx.utilities.PropertyGroup;
import java.util.Arrays;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.math3.util.FastMath;

public class GeneralizedKirkwood
implements LambdaInterface {
    public static final double DEFAULT_DIELECTRIC_OFFSET = 0.09;
    private static final Logger logger = Logger.getLogger(GeneralizedKirkwood.class.getName());
    private static final double DEFAULT_SOLUTE_SCALE = 1.0;
    private final double dOffset = 0.09;
    private final ForceField forceField;
    private final Polarization polarization;
    private final ParticleMeshEwald particleMeshEwald;
    private final ParallelTeam parallelTeam;
    private final InitializationRegion initializationRegion;
    private final BornRadiiRegion bornRadiiRegion;
    private final PermanentGKFieldRegion permanentGKFieldRegion;
    private final InducedGKFieldRegion inducedGKFieldRegion;
    private final GKEnergyRegion gkEnergyRegion;
    private final BornGradRegion bornGradRegion;
    private final DispersionRegion dispersionRegion;
    private final SurfaceAreaRegion surfaceAreaRegion;
    private final ChandlerCavitation chandlerCavitation;
    private final HashMap<Integer, Double> radiiOverride = new HashMap();
    public double electric;
    private final double bondiScale;
    private Atom[] atoms;
    private int nAtoms;
    private double[] x;
    private double[] y;
    private double[] z;
    private double[] baseRadius;
    private double[] descreenRadius;
    private double[] overlapScale;
    private double[] neckScale;
    private final boolean perfectHCTScale;
    @FFXProperty(name="solvent-dielectric", propertyGroup=PropertyGroup.ImplicitSolvent, defaultValue="78.3", description="The dielectric constant used for the solvent in generalized Kirkwood calculations.\nThe default of 78.3 corresponds to water.\n")
    private final double solventDielectric;
    @FFXProperty(name="solute-dielectric", propertyGroup=PropertyGroup.ImplicitSolvent, defaultValue="1.0", description="The dielectric constant used for the solute(s) in generalized Kirkwood calculations.\nThe default of 1.0 is consistent with all solute dielectric response arising from either\npolarization via induced dipoles and/or permanent dipole realignment.\n")
    private final double soluteDielectric;
    private static final double DEFAULT_HCT_SCALE = 0.72;
    @FFXProperty(name="hct-scale", propertyGroup=PropertyGroup.ImplicitSolvent, defaultValue="0.72", description="The default overlap scale factor for Hawkins-Cramer-Truhlar pairwise descreening.")
    private final double hctScale;
    @FFXProperty(name="element-hct-scale", clazz=Boolean.class, propertyGroup=PropertyGroup.ImplicitSolvent, defaultValue="true", description="Flag to turn on element specific overlap scale factors for Hawkins-Cramer-Truhlar pairwise descreening.")
    private final boolean elementHCTScale;
    private final HashMap<Integer, Double> elementHCTScaleFactors;
    @FFXProperty(name="descreen-vdw", propertyGroup=PropertyGroup.ImplicitSolvent, defaultValue="true", description="If true, the descreening size of each atom is based on its force field van der Waals radius.")
    private final boolean descreenVDW;
    @FFXProperty(name="descreen-hydrogen", propertyGroup=PropertyGroup.ImplicitSolvent, defaultValue="false", description="If true, hydrogen atoms are contribute to the pairwise descreening integrals.")
    private final boolean descreenHydrogen;
    private static final double DEFAULT_DESCREEN_OFFSET = 0.3;
    @FFXProperty(name="descreen-offset", propertyGroup=PropertyGroup.ImplicitSolvent, defaultValue="0.3", description="Offset applied to the pairwise descreening integral to improve stability at small separation.")
    private final double descreenOffset;
    @FFXProperty(name="neck-correction", propertyGroup=PropertyGroup.ImplicitSolvent, defaultValue="true", description="Apply a neck correction during descreening.")
    private final boolean neckCorrection;
    private static final double DEFAULT_NECK_SCALE = 0.135;
    @FFXProperty(name="neck-scale", propertyGroup=PropertyGroup.ImplicitSolvent, defaultValue="0.1350", description="The overlap scale factor to use during the descreening neck correction.")
    private double sneck;
    @FFXProperty(name="chemically-aware-neck-scale", propertyGroup=PropertyGroup.ImplicitSolvent, defaultValue="true", description="If the neck descreening correction is being used, apply a smaller overlap scale\nfactors as the number of bonded heavy atoms increases.\n")
    private final boolean chemicallyAwareSneck;
    @FFXProperty(name="tanh-correction", propertyGroup=PropertyGroup.ImplicitSolvent, defaultValue="true", description="If the neck descreening correction is being used, apply a smaller overlap scale\nfactors as the number of bonded heavy atoms increases.\n")
    private final boolean tanhCorrection;
    public static final double DEFAULT_TANH_BETA0 = 0.9563;
    public static final double DEFAULT_TANH_BETA1 = 0.2578;
    public static final double DEFAULT_TANH_BETA2 = 0.081;
    @FFXProperty(name="tanh-beta0", propertyGroup=PropertyGroup.ImplicitSolvent, defaultValue="0.9563", description="The coefficient beta0 for tanh rescaling of descreening integrals.")
    private double beta0;
    @FFXProperty(name="tanh-beta1", propertyGroup=PropertyGroup.ImplicitSolvent, defaultValue="0.2578", description="The coefficient beta1 for tanh rescaling of descreening integrals.")
    private double beta1;
    @FFXProperty(name="tanh-beta2", propertyGroup=PropertyGroup.ImplicitSolvent, defaultValue="0.0810", description="The coefficient beta2 for tanh rescaling of descreening integrals.")
    private double beta2;
    public static final double DEFAULT_GKC = 2.455;
    @FFXProperty(name="gkc", propertyGroup=PropertyGroup.ImplicitSolvent, defaultValue="2.455", description="The Generalized Kirkwood cross-term parameter.")
    public final double gkc;
    private static final NonPolarModel DEFAULT_NONPOLAR_MODEL = NonPolarModel.GAUSS_DISP;
    @FFXProperty(name="nonpolar-model", clazz=String.class, propertyGroup=PropertyGroup.ImplicitSolvent, defaultValue="gauss-disp", description="[CAV / CAV-DISP / DISP / GAUSS-DISP / SEV-DISP / NONE ]\nThe non-polar contribution to the implicit solvent.\n")
    private final NonPolarModel nonPolarModel;
    private static final double DEFAULT_CAVONLY_SURFACE_TENSION = 0.0049;
    public final double probe;
    public static final double DEFAULT_SOLVENT_PRESSURE = 0.0334;
    public static final double DEFAULT_CAVDISP_SURFACE_TENSION = 0.08;
    public static final double DEFAULT_CROSSOVER = 7.18562874251497;
    @FFXProperty(name="surface-tension", propertyGroup=PropertyGroup.ImplicitSolvent, defaultValue="0.080", description="The cavitation surface tension coefficient (kcal/mol/A^2).")
    private final double surfaceTension;
    @FFXProperty(name="solvent-pressure", propertyGroup=PropertyGroup.ImplicitSolvent, defaultValue="0.0334", description="The solvent pressure for nonpolar models with an explicit volume term (kcal/mol/A^3).")
    private final double solventPressue;
    @FFXProperty(name="gk-radius", clazz=String.class, propertyGroup=PropertyGroup.ImplicitSolvent, defaultValue="solute", description="[SOLUTE / VDW / CONSENSUS]\nThe base atomic radii to use for generalized Kirkwood calculations. The default is to use solute radii,\nwhich were fit to experimental solvation free energy differences. Alternatively, force field\nspecific van der Waals radii (vdw) or consensus Bondi radii (consensus) can be chosen.\n")
    private SoluteType.SOLUTE_RADII_TYPE soluteRadiiType;
    private double[] born;
    private boolean[] use = null;
    private Crystal crystal;
    private double[][][] sXYZ;
    private double[][][] globalMultipole;
    private double[][][] inducedDipole;
    private double[][][] inducedDipoleCR;
    private AtomicDoubleArray.AtomicDoubleArrayImpl atomicDoubleArrayImpl;
    private AtomicDoubleArray3D grad;
    private AtomicDoubleArray3D torque;
    private AtomicDoubleArray bornRadiiChainRule;
    private final AtomicDoubleArray3D fieldGK;
    private final AtomicDoubleArray3D fieldGKCR;
    private int[][][] neighborLists;
    private int maxNumAtoms;
    private double cutoff;
    private double cut2;
    private boolean lambdaTerm;
    private double lambda = 1.0;
    private double lPow = 1.0;
    private double dlPow = 0.0;
    private double dl2Pow = 0.0;
    private double solvationEnergy = 0.0;
    private double gkEnergy = 0.0;
    private double gkPermanentEnergy = 0.0;
    private double gkPolarizationEnergy = 0.0;
    private double dispersionEnergy = 0.0;
    private double cavitationEnergy = 0.0;
    private long gkTime = 0L;
    private long dispersionTime = 0L;
    private long cavitationTime = 0L;
    private final boolean nativeEnvironmentApproximation;
    private final boolean perfectRadii;

    public GeneralizedKirkwood(ForceField forceField, Atom[] atoms, ParticleMeshEwald particleMeshEwald, Crystal crystal, ParallelTeam parallelTeam, double gkCutoff) {
        double tensionDefault;
        NonPolarModel npModel;
        String[] tmpElemScaleFactors;
        this.forceField = forceField;
        this.atoms = atoms;
        this.particleMeshEwald = particleMeshEwald;
        this.crystal = crystal;
        this.parallelTeam = parallelTeam;
        this.electric = this.electric;
        this.cutoff = gkCutoff;
        this.maxNumAtoms = this.nAtoms = atoms.length;
        this.polarization = particleMeshEwald.polarization;
        this.electric = forceField.getDouble("ELECTRIC", 332.0637133);
        this.solventDielectric = forceField.getDouble("SOLVENT_DIELECTRIC", 78.3);
        this.soluteDielectric = forceField.getDouble("SOLUTE_DIELECTRIC", 1.0);
        String value = forceField.getString("ARRAY_REDUCTION", "MULTI");
        try {
            this.atomicDoubleArrayImpl = AtomicDoubleArray.AtomicDoubleArrayImpl.valueOf((String)ForceField.toEnumForm(value));
        }
        catch (Exception e) {
            this.atomicDoubleArrayImpl = AtomicDoubleArray.AtomicDoubleArrayImpl.MULTI;
            logger.info(String.format(" Unrecognized ARRAY-REDUCTION %s; defaulting to %s", value, this.atomicDoubleArrayImpl));
        }
        String gkRadius = forceField.getString("GK_RADIUS", "SOLUTE");
        try {
            this.soluteRadiiType = SoluteType.SOLUTE_RADII_TYPE.valueOf(gkRadius.trim().toUpperCase());
        }
        catch (Exception e) {
            this.soluteRadiiType = SoluteType.SOLUTE_RADII_TYPE.SOLUTE;
        }
        this.bondiScale = this.soluteRadiiType != SoluteType.SOLUTE_RADII_TYPE.SOLUTE ? forceField.getDouble("SOLUTE_SCALE", 1.0) : forceField.getDouble("SOLUTE_SCALE", 1.0);
        this.hctScale = forceField.getDouble("HCT_SCALE", 0.72);
        this.elementHCTScale = forceField.getBoolean("ELEMENT_HCT_SCALE", true);
        this.descreenVDW = forceField.getBoolean("DESCREEN_VDW", true);
        this.descreenHydrogen = forceField.getBoolean("DESCREEN_HYDROGEN", false);
        this.perfectHCTScale = this.descreenVDW && !this.descreenHydrogen ? forceField.getBoolean("PERFECT_HCT_SCALE", false) : false;
        this.descreenOffset = forceField.getDouble("DESCREEN_OFFSET", 0.3);
        this.neckCorrection = forceField.getBoolean("NECK_CORRECTION", true);
        double sn = forceField.getDouble("SNECK", 0.135);
        this.sneck = forceField.getDouble("NECK_SCALE", sn);
        this.chemicallyAwareSneck = forceField.getBoolean("CHEMICALLY_AWARE_SNECK", true);
        this.tanhCorrection = forceField.getBoolean("TANH_CORRECTION", true);
        double b0 = forceField.getDouble("BETA0", 0.9563);
        double b1 = forceField.getDouble("BETA1", 0.2578);
        double b2 = forceField.getDouble("BETA2", 0.081);
        this.beta0 = forceField.getDouble("TANH_BETA0", b0);
        this.beta1 = forceField.getDouble("TANH_BETA1", b1);
        this.beta2 = forceField.getDouble("TANH_BETA2", b2);
        BornTanhRescaling.setBeta0(this.beta0);
        BornTanhRescaling.setBeta1(this.beta1);
        BornTanhRescaling.setBeta2(this.beta2);
        HashMap<Integer, Double> DEFAULT_HCT_ELEMENTS = new HashMap<Integer, Double>();
        DEFAULT_HCT_ELEMENTS.put(1, 0.72);
        DEFAULT_HCT_ELEMENTS.put(6, 0.695);
        DEFAULT_HCT_ELEMENTS.put(7, 0.7673);
        DEFAULT_HCT_ELEMENTS.put(8, 0.7965);
        DEFAULT_HCT_ELEMENTS.put(15, 0.6117);
        DEFAULT_HCT_ELEMENTS.put(16, 0.7204);
        this.elementHCTScaleFactors = new HashMap();
        this.elementHCTScaleFactors.put(1, (Double)DEFAULT_HCT_ELEMENTS.get(1));
        this.elementHCTScaleFactors.put(6, (Double)DEFAULT_HCT_ELEMENTS.get(6));
        this.elementHCTScaleFactors.put(7, (Double)DEFAULT_HCT_ELEMENTS.get(7));
        this.elementHCTScaleFactors.put(8, (Double)DEFAULT_HCT_ELEMENTS.get(8));
        this.elementHCTScaleFactors.put(15, (Double)DEFAULT_HCT_ELEMENTS.get(15));
        this.elementHCTScaleFactors.put(16, (Double)DEFAULT_HCT_ELEMENTS.get(16));
        for (String elemScale : tmpElemScaleFactors = forceField.getProperties().getStringArray("hct-element")) {
            String[] singleScale = elemScale.trim().split(" +");
            if (this.elementHCTScaleFactors.containsKey(Integer.parseInt(singleScale[0]))) {
                this.elementHCTScaleFactors.replace(Integer.parseInt(singleScale[0]), Double.parseDouble(singleScale[1]));
                continue;
            }
            this.elementHCTScaleFactors.put(Integer.parseInt(singleScale[0]), Double.parseDouble(singleScale[1]));
        }
        this.perfectRadii = forceField.getBoolean("PERFECT_RADII", false);
        String radiiProp = forceField.getString("GK_RADIIOVERRIDE", null);
        if (radiiProp != null) {
            String[] tokens;
            for (String token : tokens = radiiProp.split("A")) {
                if (!token.contains("r")) {
                    logger.severe("Invalid radius override.");
                }
                int separator = token.indexOf("r");
                int type = Integer.parseInt(token.substring(0, separator));
                double factor = Double.parseDouble(token.substring(separator + 1));
                logger.info(String.format(" (GK) Scaling AtomType %d with bondi factor %.2f", type, factor));
                this.radiiOverride.put(type, factor);
            }
        }
        try {
            String cavModel = forceField.getString("CAVMODEL", DEFAULT_NONPOLAR_MODEL.name());
            cavModel = forceField.getString("NONPOLAR_MODEL", cavModel);
            npModel = GeneralizedKirkwood.getNonPolarModel(cavModel.toUpperCase());
        }
        catch (Exception ex) {
            npModel = NonPolarModel.NONE;
            logger.warning(String.format(" Error parsing non-polar model (set to NONE) %s", ex));
        }
        this.nonPolarModel = npModel;
        int threadCount = parallelTeam.getThreadCount();
        this.fieldGK = new AtomicDoubleArray3D(this.atomicDoubleArrayImpl, this.nAtoms, threadCount);
        this.fieldGKCR = new AtomicDoubleArray3D(this.atomicDoubleArrayImpl, this.nAtoms, threadCount);
        this.nativeEnvironmentApproximation = forceField.getBoolean("NATIVE_ENVIRONMENT_APPROXIMATION", false);
        this.probe = forceField.getDouble("PROBE_RADIUS", 1.4);
        this.cut2 = this.cutoff * this.cutoff;
        this.lambdaTerm = forceField.getBoolean("GK_LAMBDATERM", forceField.getBoolean("LAMBDATERM", false));
        double polLambdaExp = forceField.getDouble("POLARIZATION_LAMBDA_EXPONENT", 3.0);
        if (polLambdaExp == 0.0) {
            this.lambdaTerm = false;
            logger.info(" GK lambda term set to false.");
        }
        if (!this.lambdaTerm && particleMeshEwald.getPolarizationType() != Polarization.NONE && forceField.getBoolean("ELEC_LAMBDATERM", forceField.getBoolean("LAMBDATERM", false))) {
            logger.info(" If PME includes polarization and is a function of lambda, GK must also.");
            this.lambdaTerm = true;
        }
        this.initAtomArrays();
        switch (this.nonPolarModel.ordinal()) {
            case 0: {
                tensionDefault = 0.0049;
                this.surfaceAreaRegion = new SurfaceAreaRegion(atoms, this.x, this.y, this.z, this.use, this.neighborLists, this.grad, threadCount, this.probe, tensionDefault);
                this.dispersionRegion = null;
                this.chandlerCavitation = null;
                break;
            }
            case 1: {
                tensionDefault = 0.08;
                this.surfaceAreaRegion = new SurfaceAreaRegion(atoms, this.x, this.y, this.z, this.use, this.neighborLists, this.grad, threadCount, this.probe, tensionDefault);
                this.dispersionRegion = new DispersionRegion(threadCount, atoms, forceField);
                this.chandlerCavitation = null;
                break;
            }
            case 2: {
                tensionDefault = 0.08;
                this.dispersionRegion = new DispersionRegion(threadCount, atoms, forceField);
                this.surfaceAreaRegion = null;
                this.chandlerCavitation = null;
                break;
            }
            case 3: {
                tensionDefault = 0.08;
                double[] radii = new double[this.nAtoms];
                int index = 0;
                for (Atom atom : atoms) {
                    radii[index] = atom.getVDWType().radius / 2.0;
                    ++index;
                }
                ConnollyRegion connollyRegion = new ConnollyRegion(atoms, radii, threadCount);
                double wiggle = forceField.getDouble("WIGGLE", 1.0E-8);
                connollyRegion.setWiggle(wiggle);
                this.chandlerCavitation = new ChandlerCavitation(atoms, connollyRegion, forceField);
                this.dispersionRegion = new DispersionRegion(threadCount, atoms, forceField);
                this.surfaceAreaRegion = null;
                break;
            }
            case 4: {
                this.dispersionRegion = new DispersionRegion(threadCount, atoms, forceField);
                this.surfaceAreaRegion = null;
                tensionDefault = 0.08;
                GaussVol gaussVol = new GaussVol(atoms, forceField, parallelTeam);
                this.chandlerCavitation = new ChandlerCavitation(atoms, gaussVol, forceField);
                break;
            }
            case 6: {
                tensionDefault = 0.08;
                this.surfaceAreaRegion = null;
                this.chandlerCavitation = null;
                this.dispersionRegion = new DispersionRegion(threadCount, atoms, forceField);
                break;
            }
            default: {
                tensionDefault = 0.0049;
                this.surfaceAreaRegion = null;
                this.dispersionRegion = null;
                this.chandlerCavitation = null;
            }
        }
        this.gkc = forceField.getDouble("GKC", 2.455);
        this.surfaceTension = forceField.getDouble("SURFACE_TENSION", tensionDefault);
        this.solventPressue = forceField.getDouble("SOLVENT_PRESSURE", 0.0334);
        double crossOver = forceField.getDouble("CROSS_OVER", 7.18562874251497);
        if (this.chandlerCavitation != null) {
            this.chandlerCavitation.setCrossOver(crossOver);
            this.chandlerCavitation.setSurfaceTension(this.surfaceTension);
            this.chandlerCavitation.setSolventPressure(this.solventPressue);
            crossOver = this.chandlerCavitation.getCrossOver();
        }
        if (this.surfaceAreaRegion != null) {
            this.surfaceAreaRegion.setSurfaceTension(this.surfaceTension);
        }
        double dispersionOffset = forceField.getDouble("DISPERSION_OFFSET", 1.056);
        if (this.dispersionRegion != null) {
            this.dispersionRegion.setDispersionOffest(dispersionOffset);
        }
        this.initializationRegion = new InitializationRegion(threadCount);
        this.bornRadiiRegion = new BornRadiiRegion(threadCount, this.nAtoms, forceField, this.neckCorrection, this.tanhCorrection, this.perfectHCTScale);
        this.permanentGKFieldRegion = new PermanentGKFieldRegion(threadCount, this.soluteDielectric, this.solventDielectric, this.gkc);
        this.inducedGKFieldRegion = new InducedGKFieldRegion(threadCount, this.soluteDielectric, this.solventDielectric, this.gkc);
        this.bornGradRegion = !this.perfectRadii ? new BornGradRegion(threadCount, this.neckCorrection, this.tanhCorrection, this.perfectHCTScale) : null;
        boolean gkQI = forceField.getBoolean("GK_QI", false);
        this.gkEnergyRegion = new GKEnergyRegion(threadCount, this.polarization, this.nonPolarModel, this.surfaceTension, this.probe, this.electric, this.soluteDielectric, this.solventDielectric, this.gkc, gkQI);
        if (gkQI) {
            logger.info("  Continuum Solvation (QI)");
        } else {
            logger.info("  Continuum Solvation");
        }
        logger.info(String.format("   Radii:                              %8s", new Object[]{this.soluteRadiiType}));
        if (this.cutoff != Double.POSITIVE_INFINITY) {
            logger.info(String.format("   Generalized Kirkwood Cut-Off:       %8.4f (A)", this.cutoff));
        } else {
            logger.info("   Generalized Kirkwood Cut-Off:           NONE");
        }
        logger.info(String.format("   GKC:                                %8.4f", this.gkc));
        logger.info(String.format("   Solvent Dielectric:                 %8.4f", this.solventDielectric));
        logger.info(String.format("   Solute Dielectric:                  %8.4f", this.soluteDielectric));
        if (this.perfectRadii) {
            logger.info(String.format("   Use Perfect Born Radii:             %8B", this.perfectRadii));
        } else {
            logger.info(String.format("   Descreen with vdW Radii:            %8B", this.descreenVDW));
            logger.info(String.format("   Descreen with Hydrogen Atoms:       %8B", this.descreenHydrogen));
            logger.info(String.format("   Descreen Offset:                    %8.4f", this.descreenOffset));
            if (this.neckCorrection) {
                logger.info(String.format("   Use Neck Correction:                %8B", this.neckCorrection));
                logger.info(String.format("   Sneck Scale Factor:                 %8.4f", this.sneck));
                logger.info(String.format("   Chemically Aware Sneck:             %8B", this.chemicallyAwareSneck));
            }
            if (this.tanhCorrection) {
                logger.info(String.format("   Use Tanh Correction                 %8B", this.tanhCorrection));
                logger.info(String.format("    Beta0:                             %8.4f", this.beta0));
                logger.info(String.format("    Beta1:                             %8.4f", this.beta1));
                logger.info(String.format("    Beta2:                             %8.4f", this.beta2));
            }
            if (this.perfectHCTScale) {
                logger.info(String.format("   GaussVol HCT Scale Factors:         %8B", this.perfectHCTScale));
            }
            logger.info(String.format("   General HCT Scale Factor:           %8.4f", forceField.getDouble("HCT-SCALE", 0.72)));
            if (this.elementHCTScale) {
                logger.info(String.format("   Element-Specific HCT Scale Factors: %8B", this.elementHCTScale));
                Object[] elementHCTkeyset = this.elementHCTScaleFactors.keySet().toArray(new Integer[0]);
                Arrays.sort(elementHCTkeyset);
                for (Object key : elementHCTkeyset) {
                    logger.info(String.format("    HCT-Element # %d:                   %8.4f", key, this.elementHCTScaleFactors.get(key)));
                }
            }
        }
        logger.info(String.format("   Non-Polar Model:                  %10s", this.nonPolarModel.toString().replace('_', '-')));
        if (this.nonPolarModel.equals((Object)NonPolarModel.GAUSS_DISP)) {
            logger.info(String.format("    GaussVol Radii Offset:               %2.4f", forceField.getDouble("GAUSSVOL_RADII_OFFSET", 0.0)));
            logger.info(String.format("    GaussVol Radii Scale:                %2.4f", forceField.getDouble("GAUSSVOL_RADII_SCALE", 1.15)));
        }
        if (this.dispersionRegion != null) {
            logger.info(String.format("   Dispersion Integral Offset:         %8.4f (A)", this.dispersionRegion.getDispersionOffset()));
        }
        if (this.surfaceAreaRegion != null) {
            logger.info(String.format("   Cavitation Probe Radius:            %8.4f (A)", this.probe));
            logger.info(String.format("   Cavitation Surface Tension:         %8.4f (Kcal/mol/A^2)", this.surfaceTension));
        } else if (this.chandlerCavitation != null) {
            logger.info(String.format("   Cavitation Solvent Pressure:        %8.4f (Kcal/mol/A^3)", this.solventPressue));
            logger.info(String.format("   Cavitation Surface Tension:         %8.4f (Kcal/mol/A^2)", this.surfaceTension));
            logger.info(String.format("   Cavitation Cross-Over Radius:       %8.4f (A)", crossOver));
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("      Base Radii  Descreen Radius  Overlap Scale  Neck Scale");
            for (int i = 0; i < this.nAtoms; ++i) {
                logger.info(String.format("   %s %8.6f %8.6f %5.3f %5.3f", atoms[i].toString(), this.baseRadius[i], this.descreenRadius[i], this.overlapScale[i], this.neckScale[i]));
            }
        }
    }

    public boolean getUsePerfectRadii() {
        return this.perfectRadii;
    }

    public double[] getPerfectRadii() {
        this.bornRadiiRegion.init(this.atoms, this.crystal, this.sXYZ, this.neighborLists, this.baseRadius, this.descreenRadius, this.overlapScale, this.neckScale, this.descreenOffset, this.use, this.cut2, this.nativeEnvironmentApproximation, this.born);
        return this.bornRadiiRegion.getPerfectRadii();
    }

    public static NonPolarModel getNonPolarModel(String nonpolarModel) {
        try {
            return NonPolarModel.valueOf(ForceField.toEnumForm(nonpolarModel));
        }
        catch (IllegalArgumentException ex) {
            logger.warning(" Unrecognized nonpolar model requested; defaulting to NONE.");
            return NonPolarModel.NONE;
        }
    }

    public void computeBornRadii() {
        this.applySoluteRadii();
        if (this.tanhCorrection) {
            BornTanhRescaling.setBeta0(this.beta0);
            BornTanhRescaling.setBeta1(this.beta1);
            BornTanhRescaling.setBeta2(this.beta2);
        }
        try {
            this.bornRadiiRegion.init(this.atoms, this.crystal, this.sXYZ, this.neighborLists, this.baseRadius, this.descreenRadius, this.overlapScale, this.neckScale, this.descreenOffset, this.use, this.cut2, this.nativeEnvironmentApproximation, this.born);
            this.parallelTeam.execute((ParallelRegion)this.bornRadiiRegion);
        }
        catch (Exception e) {
            String message = "Fatal exception computing Born radii.";
            logger.log(Level.SEVERE, message, e);
        }
    }

    public void computeInducedGKField() {
        try {
            this.fieldGK.reset(this.parallelTeam);
            this.fieldGKCR.reset(this.parallelTeam);
            this.inducedGKFieldRegion.init(this.atoms, this.inducedDipole, this.inducedDipoleCR, this.crystal, this.sXYZ, this.neighborLists, this.use, this.cut2, this.born, this.fieldGK, this.fieldGKCR);
            this.parallelTeam.execute((ParallelRegion)this.inducedGKFieldRegion);
            this.fieldGK.reduce(this.parallelTeam);
            this.fieldGKCR.reduce(this.parallelTeam);
        }
        catch (Exception e) {
            String message = "Fatal exception computing induced GK field.";
            logger.log(Level.SEVERE, message, e);
        }
    }

    public void computePermanentGKField() {
        try {
            this.fieldGK.reset(this.parallelTeam);
            this.permanentGKFieldRegion.init(this.atoms, this.globalMultipole, this.crystal, this.sXYZ, this.neighborLists, this.use, this.cut2, this.born, this.fieldGK);
            this.parallelTeam.execute((ParallelRegion)this.permanentGKFieldRegion);
            this.fieldGK.reduce(this.parallelTeam);
        }
        catch (Exception e) {
            String message = "Fatal exception computing permanent GK field.";
            logger.log(Level.SEVERE, message, e);
        }
    }

    public double[] getBaseRadii() {
        return this.baseRadius;
    }

    public double[] getDescreenRadii() {
        return this.descreenRadius;
    }

    public double getCavitationEnergy() {
        return this.cavitationEnergy;
    }

    public ChandlerCavitation getChandlerCavitation() {
        return this.chandlerCavitation;
    }

    public double getCutoff() {
        return this.cutoff;
    }

    public void setCutoff(double cutoff) {
        this.cutoff = cutoff;
        this.cut2 = cutoff * cutoff;
    }

    public double getDielecOffset() {
        return 0.09;
    }

    public double getDescreenOffset() {
        return this.descreenOffset;
    }

    public double getDispersionEnergy() {
        return this.dispersionEnergy;
    }

    public DispersionRegion getDispersionRegion() {
        return this.dispersionRegion;
    }

    public AtomicDoubleArray3D getFieldGK() {
        return this.fieldGK;
    }

    public AtomicDoubleArray3D getFieldGKCR() {
        return this.fieldGKCR;
    }

    public SurfaceAreaRegion getSurfaceAreaRegion() {
        return this.surfaceAreaRegion;
    }

    public double getGeneralizedKirkwoordEnergy() {
        return this.gkEnergy;
    }

    public double getGeneralizedKirkwoordPermanentEnergy() {
        return this.gkPermanentEnergy;
    }

    public double getGeneralizedKirkwoordPolariztionEnergy() {
        return this.gkPolarizationEnergy;
    }

    public AtomicDoubleArray3D getGrad() {
        return this.grad;
    }

    public int getInteractions() {
        return this.gkEnergyRegion.getInteractions();
    }

    @Override
    public double getLambda() {
        return this.lambda;
    }

    @Override
    public void setLambda(double lambda) {
        if (this.lambdaTerm) {
            this.lambda = lambda;
        } else {
            this.lambda = 1.0;
            this.lPow = 1.0;
            this.dlPow = 0.0;
            this.dl2Pow = 0.0;
        }
    }

    public boolean getNativeEnvironmentApproximation() {
        return this.nativeEnvironmentApproximation;
    }

    public NonPolarModel getNonPolarModel() {
        return this.nonPolarModel;
    }

    public double[] getOverlapScale() {
        return this.overlapScale;
    }

    public double[] getNeckScale() {
        return this.neckScale;
    }

    public boolean getTanhCorrection() {
        return this.tanhCorrection;
    }

    public double getProbeRadius() {
        return this.probe;
    }

    public double getSolventPermittivity() {
        return this.solventDielectric;
    }

    public double getSolutePermittivity() {
        return this.soluteDielectric;
    }

    public double getSurfaceTension() {
        return this.surfaceTension;
    }

    public AtomicDoubleArray3D getTorque() {
        return this.torque;
    }

    @Override
    public double getd2EdL2() {
        if (this.lambdaTerm) {
            return this.dl2Pow * this.solvationEnergy;
        }
        return 0.0;
    }

    @Override
    public double getdEdL() {
        if (this.lambdaTerm) {
            return this.dlPow * this.solvationEnergy;
        }
        return 0.0;
    }

    @Override
    public void getdEdXdL(double[] gradient) {
    }

    public void init() {
        this.initializationRegion.init(this, this.atoms, this.lambdaTerm, this.grad, this.torque, this.bornRadiiChainRule);
        this.initializationRegion.executeWith(this.parallelTeam);
    }

    public void reduce(AtomicDoubleArray3D g, AtomicDoubleArray3D t, AtomicDoubleArray3D lg, AtomicDoubleArray3D lt) {
        this.grad.reduce(this.parallelTeam);
        this.torque.reduce(this.parallelTeam);
        for (int i = 0; i < this.nAtoms; ++i) {
            g.add(0, i, this.lPow * this.grad.getX(i), this.lPow * this.grad.getY(i), this.lPow * this.grad.getZ(i));
            t.add(0, i, this.lPow * this.torque.getX(i), this.lPow * this.torque.getY(i), this.lPow * this.torque.getZ(i));
            if (!this.lambdaTerm) continue;
            lg.add(0, i, this.dlPow * this.grad.getX(i), this.dlPow * this.grad.getY(i), this.dlPow * this.grad.getZ(i));
            lt.add(0, i, this.dlPow * this.torque.getX(i), this.dlPow * this.torque.getY(i), this.dlPow * this.torque.getZ(i));
        }
    }

    public AtomicDoubleArray getSelfEnergy() {
        return this.gkEnergyRegion.getSelfEnergy();
    }

    public double[] getBorn() {
        return this.bornRadiiRegion.getBorn();
    }

    public void setElementHCTScaleFactors(HashMap<Integer, Double> elementHCT) {
        for (Integer element : elementHCT.keySet()) {
            if (this.elementHCTScaleFactors.containsKey(element)) {
                this.elementHCTScaleFactors.replace(element, elementHCT.get(element));
                continue;
            }
            logger.info("No HCT scale factor set for element: " + element);
        }
        this.initAtomArrays();
    }

    public void setAtoms(Atom[] atoms) {
        this.atoms = atoms;
        this.nAtoms = atoms.length;
        this.maxNumAtoms = FastMath.max((int)this.nAtoms, (int)this.maxNumAtoms);
        this.initAtomArrays();
    }

    public void setCrystal(Crystal crystal) {
        this.crystal = crystal;
    }

    public void setNeighborList(int[][][] neighbors) {
        this.neighborLists = neighbors;
    }

    public void setUse(boolean[] use) {
        this.use = use;
    }

    public double solvationEnergy(boolean gradient, boolean print) {
        return this.solvationEnergy(0.0, gradient, print);
    }

    public double solvationEnergy(double gkInducedCorrectionEnergy, boolean gradient, boolean print) {
        this.cavitationEnergy = 0.0;
        this.dispersionEnergy = 0.0;
        this.gkEnergy = 0.0;
        try {
            this.gkTime = -System.nanoTime();
            this.gkEnergyRegion.init(this.atoms, this.globalMultipole, this.inducedDipole, this.inducedDipoleCR, this.crystal, this.sXYZ, this.neighborLists, this.use, this.cut2, this.baseRadius, this.born, gradient, this.parallelTeam, this.grad, this.torque, this.bornRadiiChainRule);
            this.parallelTeam.execute((ParallelRegion)this.gkEnergyRegion);
            this.gkTime += System.nanoTime();
            switch (this.nonPolarModel.ordinal()) {
                case 0: {
                    this.cavitationTime = -System.nanoTime();
                    this.parallelTeam.execute((ParallelRegion)this.surfaceAreaRegion);
                    this.cavitationEnergy = this.surfaceAreaRegion.getEnergy();
                    this.cavitationTime += System.nanoTime();
                    break;
                }
                case 1: {
                    this.dispersionTime = -System.nanoTime();
                    this.dispersionRegion.init(this.atoms, this.crystal, this.use, this.neighborLists, this.x, this.y, this.z, this.cut2, gradient, this.grad);
                    this.parallelTeam.execute((ParallelRegion)this.dispersionRegion);
                    this.dispersionEnergy = this.dispersionRegion.getEnergy();
                    this.dispersionTime += System.nanoTime();
                    this.cavitationTime = -System.nanoTime();
                    this.parallelTeam.execute((ParallelRegion)this.surfaceAreaRegion);
                    this.cavitationEnergy = this.surfaceAreaRegion.getEnergy();
                    this.cavitationTime += System.nanoTime();
                    break;
                }
                case 2: {
                    this.dispersionTime = -System.nanoTime();
                    this.dispersionRegion.init(this.atoms, this.crystal, this.use, this.neighborLists, this.x, this.y, this.z, this.cut2, gradient, this.grad);
                    this.parallelTeam.execute((ParallelRegion)this.dispersionRegion);
                    this.dispersionEnergy = this.dispersionRegion.getEnergy();
                    this.dispersionTime += System.nanoTime();
                    break;
                }
                case 3: {
                    int i;
                    this.dispersionTime = -System.nanoTime();
                    this.dispersionRegion.init(this.atoms, this.crystal, this.use, this.neighborLists, this.x, this.y, this.z, this.cut2, gradient, this.grad);
                    this.parallelTeam.execute((ParallelRegion)this.dispersionRegion);
                    this.dispersionEnergy = this.dispersionRegion.getEnergy();
                    this.dispersionTime += System.nanoTime();
                    this.cavitationTime = -System.nanoTime();
                    this.cavitationTime = -System.nanoTime();
                    double[][] positions = new double[this.nAtoms][3];
                    for (i = 0; i < this.nAtoms; ++i) {
                        positions[i][0] = this.atoms[i].getX();
                        positions[i][1] = this.atoms[i].getY();
                        positions[i][2] = this.atoms[i].getZ();
                    }
                    this.chandlerCavitation.energyAndGradient(positions, this.grad);
                    this.cavitationEnergy = this.chandlerCavitation.getEnergy();
                    this.cavitationTime += System.nanoTime();
                    break;
                }
                case 4: {
                    int i;
                    this.dispersionTime = -System.nanoTime();
                    this.dispersionRegion.init(this.atoms, this.crystal, this.use, this.neighborLists, this.x, this.y, this.z, this.cut2, gradient, this.grad);
                    this.parallelTeam.execute((ParallelRegion)this.dispersionRegion);
                    this.dispersionEnergy = this.dispersionRegion.getEnergy();
                    this.dispersionTime += System.nanoTime();
                    this.cavitationTime = -System.nanoTime();
                    double[][] positions = new double[this.nAtoms][3];
                    for (i = 0; i < this.nAtoms; ++i) {
                        positions[i][0] = this.atoms[i].getX();
                        positions[i][1] = this.atoms[i].getY();
                        positions[i][2] = this.atoms[i].getZ();
                    }
                    this.chandlerCavitation.energyAndGradient(positions, this.grad);
                    this.cavitationEnergy = this.chandlerCavitation.getEnergy();
                    this.cavitationTime += System.nanoTime();
                    break;
                }
                case 6: {
                    this.dispersionTime = -System.nanoTime();
                    this.dispersionRegion.init(this.atoms, this.crystal, this.use, this.neighborLists, this.x, this.y, this.z, this.cut2, gradient, this.grad);
                    this.parallelTeam.execute((ParallelRegion)this.dispersionRegion);
                    this.dispersionEnergy = this.dispersionRegion.getEnergy();
                    this.dispersionTime += System.nanoTime();
                    break;
                }
            }
        }
        catch (Exception e) {
            String message = "Fatal exception computing the continuum solvation energy.";
            logger.log(Level.SEVERE, message, e);
        }
        if (gradient && !this.perfectRadii) {
            try {
                this.gkTime -= System.nanoTime();
                this.bornGradRegion.init(this.atoms, this.crystal, this.sXYZ, this.neighborLists, this.baseRadius, this.descreenRadius, this.overlapScale, this.neckScale, this.descreenOffset, this.bornRadiiRegion.getUnscaledBornIntegral(), this.use, this.cut2, this.nativeEnvironmentApproximation, this.born, this.grad, this.bornRadiiChainRule);
                this.bornGradRegion.executeWith(this.parallelTeam);
                this.gkTime += System.nanoTime();
            }
            catch (Exception e) {
                String message = "Fatal exception computing Born radii chain rule term.";
                logger.log(Level.SEVERE, message, e);
            }
        }
        this.gkEnergy = this.gkEnergyRegion.getEnergy() + gkInducedCorrectionEnergy;
        this.gkPermanentEnergy = this.gkEnergyRegion.getPermanentEnergy();
        this.gkPolarizationEnergy = this.gkEnergy - this.gkPermanentEnergy;
        this.solvationEnergy = this.cavitationEnergy + this.dispersionEnergy + this.gkEnergy;
        if (print) {
            logger.info(String.format(" Generalized Kirkwood%16.8f %10.3f", this.gkEnergy, (double)this.gkTime * 1.0E-9));
            switch (this.nonPolarModel.ordinal()) {
                case 0: {
                    logger.info(String.format(" Cavitation          %16.8f %10.3f", this.cavitationEnergy, (double)this.cavitationTime * 1.0E-9));
                    break;
                }
                case 2: {
                    logger.info(String.format(" Dispersion          %16.8f %10.3f", this.dispersionEnergy, (double)this.dispersionTime * 1.0E-9));
                    break;
                }
                case 1: 
                case 3: 
                case 4: {
                    logger.info(String.format(" Cavitation          %16.8f %10.3f", this.cavitationEnergy, (double)this.cavitationTime * 1.0E-9));
                    logger.info(String.format(" Dispersion          %16.8f %10.3f", this.dispersionEnergy, (double)this.dispersionTime * 1.0E-9));
                    break;
                }
                case 6: {
                    logger.info(String.format(" Dispersion          %16.8f %10.3f", this.dispersionEnergy, (double)this.dispersionTime * 1.0E-9));
                    break;
                }
            }
        }
        if (this.lambdaTerm) {
            return this.lPow * this.solvationEnergy;
        }
        return this.solvationEnergy;
    }

    private void initAtomArrays() {
        this.sXYZ = this.particleMeshEwald.coordinates;
        this.x = this.sXYZ[0][0];
        this.y = this.sXYZ[0][1];
        this.z = this.sXYZ[0][2];
        this.globalMultipole = this.particleMeshEwald.globalMultipole;
        this.inducedDipole = this.particleMeshEwald.inducedDipole;
        this.inducedDipoleCR = this.particleMeshEwald.inducedDipoleCR;
        this.neighborLists = this.particleMeshEwald.neighborLists;
        if (this.grad == null) {
            int threadCount = this.parallelTeam.getThreadCount();
            this.grad = new AtomicDoubleArray3D(this.atomicDoubleArrayImpl, this.nAtoms, threadCount);
            this.torque = new AtomicDoubleArray3D(this.atomicDoubleArrayImpl, this.nAtoms, threadCount);
            this.bornRadiiChainRule = this.atomicDoubleArrayImpl.createInstance(threadCount, this.nAtoms);
        } else {
            this.grad.alloc(this.nAtoms);
            this.torque.alloc(this.nAtoms);
            this.bornRadiiChainRule.alloc(this.nAtoms);
        }
        this.fieldGK.alloc(this.nAtoms);
        this.fieldGKCR.alloc(this.nAtoms);
        if (this.baseRadius == null || this.baseRadius.length < this.nAtoms) {
            this.baseRadius = new double[this.nAtoms];
            this.descreenRadius = new double[this.nAtoms];
            this.overlapScale = new double[this.nAtoms];
            this.neckScale = new double[this.nAtoms];
            this.born = new double[this.nAtoms];
            this.use = new boolean[this.nAtoms];
        }
        Arrays.fill(this.use, true);
        SoluteType.setSoluteRadii(this.forceField, this.atoms, this.soluteRadiiType);
        this.applySoluteRadii();
        if (this.dispersionRegion != null) {
            this.dispersionRegion.allocate(this.atoms);
        }
        if (this.surfaceAreaRegion != null) {
            this.surfaceAreaRegion.init();
        }
        if (this.chandlerCavitation != null) {
            GaussVol gaussVol = this.chandlerCavitation.getGaussVol();
            try {
                gaussVol.allocate(this.atoms);
            }
            catch (Exception e) {
                logger.severe(" " + String.valueOf(e));
            }
        }
    }

    public void udpateSoluteParameters(int i) {
        Atom atom = this.atoms[i];
        SoluteType soluteType = atom.getSoluteType();
        if (soluteType == null) {
            logger.severe(String.format(" No SoluteType for atom %s.", atom));
            return;
        }
        this.baseRadius[i] = soluteType.gkDiameter * 0.5 * this.bondiScale;
        this.overlapScale[i] = this.hctScale;
        if (this.elementHCTScale) {
            int atomicNumber = atom.getAtomicNumber();
            if (this.elementHCTScaleFactors.containsKey(atomicNumber)) {
                this.overlapScale[i] = this.elementHCTScaleFactors.get(atomicNumber);
            } else {
                logger.fine(String.format(" No element-specific HCT scale factor for %s", atom));
                this.overlapScale[i] = this.hctScale;
            }
        }
        this.descreenRadius[i] = this.baseRadius[i];
        AtomType atomType = atom.getAtomType();
        if (this.radiiOverride.containsKey(atomType.type)) {
            double override = this.radiiOverride.get(atomType.type);
            this.baseRadius[i] = this.baseRadius[i] * override / this.bondiScale;
            logger.fine(String.format(" Scaling %s (atom type %d) to %7.4f (Bondi factor %7.4f)", atom, atomType.type, this.baseRadius[i], override));
            this.descreenRadius[i] = this.baseRadius[i];
        }
        if (this.descreenVDW) {
            this.descreenRadius[i] = atom.getVDWType().radius / 2.0;
        }
        if (!this.descreenHydrogen && atom.getAtomicNumber() == 1) {
            this.overlapScale[i] = 0.0;
        }
        if (!atom.isHydrogen()) {
            if (!this.neckCorrection || this.overlapScale[i] == 0.0) {
                this.neckScale[i] = 0.0;
            } else if (this.chemicallyAwareSneck) {
                int numBoundHeavyAtoms = 0;
                for (Atom boundAtom : atom.get12List()) {
                    if (boundAtom.isHydrogen()) continue;
                    ++numBoundHeavyAtoms;
                }
                this.neckScale[i] = numBoundHeavyAtoms == 0 ? 1.0 : atom.getSoluteType().sneck * (5.0 - (double)numBoundHeavyAtoms) / 4.0;
            } else {
                this.neckScale[i] = atom.getSoluteType().sneck;
            }
            for (Atom boundAtom : atom.get12List()) {
                if (!boundAtom.isHydrogen()) continue;
                int hydrogenIndex = boundAtom.getIndex();
                this.neckScale[hydrogenIndex - 1] = this.neckScale[i];
            }
        }
    }

    public void applySoluteRadii() {
        for (int i = 0; i < this.nAtoms; ++i) {
            this.udpateSoluteParameters(i);
        }
        if (this.perfectHCTScale) {
            double[][] coords = new double[this.nAtoms][3];
            int index = 0;
            for (Atom atom : this.atoms) {
                coords[index][0] = atom.getX();
                coords[index][1] = atom.getY();
                coords[index][2] = atom.getZ();
                ++index;
            }
            GaussVol gaussVol = new GaussVol(this.atoms, this.forceField, this.parallelTeam);
            gaussVol.computeVolumeAndSA(coords);
            double[] selfVolumesFractions = gaussVol.getSelfVolumeFractions();
            for (int i = 0; i < this.nAtoms; ++i) {
                this.overlapScale[i] = selfVolumesFractions[i] * this.hctScale;
                if (this.descreenHydrogen || this.atoms[i].getAtomicNumber() != 1) continue;
                this.overlapScale[i] = 0.0;
            }
        }
    }

    public void setSneck(double sneck_input) {
        this.sneck = sneck_input;
        this.initAtomArrays();
    }

    public double[] getTanhBetas() {
        double[] betas = new double[]{this.beta0, this.beta1, this.beta2};
        return betas;
    }

    public void setTanhBetas(double[] betas) {
        this.beta0 = betas[0];
        this.beta1 = betas[1];
        this.beta2 = betas[2];
    }

    void setLambdaFunction(double lPow, double dlPow, double dl2Pow) {
        if (this.lambdaTerm) {
            this.lPow = lPow;
            this.dlPow = dlPow;
            this.dl2Pow = dl2Pow;
        } else {
            this.lambda = 1.0;
            this.lPow = 1.0;
            this.dlPow = 0.0;
            this.dl2Pow = 0.0;
        }
    }

    public static enum NonPolarModel {
        CAV,
        CAV_DISP,
        DISP,
        SEV_DISP,
        GAUSS_DISP,
        HYDROPHOBIC_PMF,
        BORN_CAV_DISP,
        BORN_SOLV,
        NONE;

    }
}

