/*
 * Decompiled with CFR 0.152.
 */
package ffx.potential.nonbonded;

import ffx.numerics.math.DoubleMath;
import ffx.potential.MolecularAssembly;
import ffx.potential.bonded.Atom;
import ffx.potential.bonded.LambdaInterface;
import ffx.potential.bonded.MSNode;
import ffx.potential.bonded.Polymer;
import ffx.potential.parameters.ForceField;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Logger;
import org.apache.commons.math3.util.FastMath;

public class COMRestraint
implements LambdaInterface {
    private static final Logger logger = Logger.getLogger(COMRestraint.class.getName());
    private final Atom[] atoms;
    private final int nAtoms;
    private final Polymer[] polymers;
    private final List<MSNode> molecules;
    private final List<MSNode> water;
    private final List<MSNode> ions;
    private final int nMolecules;
    private final double forceConstant;
    private final double[][] initialCOM;
    private final double[][] currentCOM;
    private final double[] dx = new double[3];
    private final double[] dcomdx;
    private final double lambdaExp = 1.0;
    private final double[] lambdaGradient;
    private double lambda = 1.0;
    private double lambdaPow = FastMath.pow((double)this.lambda, (double)1.0);
    private double dLambdaPow = 1.0 * FastMath.pow((double)this.lambda, (double)0.0);
    private double d2LambdaPow = 0.0;
    private double dEdL = 0.0;
    private double d2EdL2 = 0.0;
    private boolean lambdaTerm;

    public COMRestraint(MolecularAssembly molecularAssembly) {
        this.atoms = molecularAssembly.getAtomArray();
        this.nAtoms = this.atoms.length;
        this.polymers = molecularAssembly.getChains();
        this.molecules = molecularAssembly.getMolecules();
        this.water = molecularAssembly.getWater();
        this.ions = molecularAssembly.getIons();
        ForceField forceField = molecularAssembly.getForceField();
        this.nMolecules = this.countMolecules();
        this.initialCOM = new double[3][this.nMolecules];
        this.currentCOM = new double[3][this.nMolecules];
        this.lambdaTerm = false;
        if (this.lambdaTerm) {
            this.lambdaGradient = new double[this.nAtoms * 3];
        } else {
            this.lambdaGradient = null;
            this.lambda = 1.0;
            this.lambdaPow = 1.0;
            this.dLambdaPow = 0.0;
            this.d2LambdaPow = 0.0;
        }
        this.dcomdx = new double[this.nAtoms];
        this.forceConstant = forceField.getDouble("COMRESTRAINT_K", 10.0);
        this.computeCOM(this.initialCOM, this.nMolecules);
        logger.info("\n COM restraint initialized");
    }

    @Override
    public double getLambda() {
        return this.lambda;
    }

    @Override
    public void setLambda(double lambda) {
        if (this.lambdaTerm) {
            this.lambda = lambda;
            double lambdaWindow = 1.0;
            if (this.lambda <= lambdaWindow) {
                double dldgl = 1.0 / lambdaWindow;
                double l = dldgl * this.lambda;
                double l2 = l * l;
                double l3 = l2 * l;
                double l4 = l2 * l2;
                double l5 = l4 * l;
                double c3 = 10.0;
                double c4 = -15.0;
                double c5 = 6.0;
                double threeC3 = 3.0 * c3;
                double sixC3 = 6.0 * c3;
                double fourC4 = 4.0 * c4;
                double twelveC4 = 12.0 * c4;
                double fiveC5 = 5.0 * c5;
                double twentyC5 = 20.0 * c5;
                this.lambdaPow = c3 * l3 + c4 * l4 + c5 * l5;
                this.dLambdaPow = (threeC3 * l2 + fourC4 * l3 + fiveC5 * l4) * dldgl;
                this.d2LambdaPow = (sixC3 * l + twelveC4 * l2 + twentyC5 * l3) * dldgl * dldgl;
            } else {
                this.lambdaPow = 1.0;
                this.dLambdaPow = 0.0;
                this.d2LambdaPow = 0.0;
            }
        } else {
            this.lambda = 1.0;
            this.lambdaPow = 1.0;
            this.dLambdaPow = 0.0;
            this.d2LambdaPow = 0.0;
        }
    }

    @Override
    public double getd2EdL2() {
        if (this.lambdaTerm) {
            return this.d2EdL2;
        }
        return 0.0;
    }

    @Override
    public double getdEdL() {
        if (this.lambdaTerm) {
            return this.dEdL;
        }
        return 0.0;
    }

    @Override
    public void getdEdXdL(double[] gradient) {
        if (this.lambdaTerm) {
            int n3 = this.nAtoms * 3;
            for (int i = 0; i < n3; ++i) {
                int n = i;
                gradient[n] = gradient[n] + this.lambdaGradient[i];
            }
        }
    }

    public double residual(boolean gradient, boolean print) {
        if (this.lambdaTerm) {
            this.dEdL = 0.0;
            this.d2EdL2 = 0.0;
            Arrays.fill(this.lambdaGradient, 0.0);
        }
        double residual = 0.0;
        double fx2 = this.forceConstant * 2.0;
        this.computeCOM(this.currentCOM, this.nMolecules);
        this.computedcomdx();
        for (int i = 0; i < this.nMolecules; ++i) {
            this.dx[0] = this.currentCOM[0][i] - this.initialCOM[0][i];
            this.dx[1] = this.currentCOM[1][i] - this.initialCOM[1][i];
            this.dx[2] = this.currentCOM[2][i] - this.initialCOM[2][i];
            double r2 = DoubleMath.length2((double[])this.dx);
            residual += r2;
            for (int j = 0; j < this.nAtoms; ++j) {
                if (!gradient && !this.lambdaTerm) continue;
                double dedx = this.dx[0] * fx2 * this.dcomdx[j];
                double dedy = this.dx[1] * fx2 * this.dcomdx[j];
                double dedz = this.dx[2] * fx2 * this.dcomdx[j];
                Atom atom = this.atoms[j];
                if (gradient) {
                    atom.addToXYZGradient(this.lambdaPow * dedx, this.lambdaPow * dedy, this.lambdaPow * dedz);
                }
                if (!this.lambdaTerm) continue;
                int j3 = i * 3;
                this.lambdaGradient[j3] = this.dLambdaPow * dedx;
                this.lambdaGradient[j3 + 1] = this.dLambdaPow * dedy;
                this.lambdaGradient[j3 + 2] = this.dLambdaPow * dedz;
            }
        }
        if (this.lambdaTerm) {
            this.dEdL = this.dLambdaPow * this.forceConstant * residual;
            this.d2EdL2 = this.d2LambdaPow * this.forceConstant * residual;
        }
        return this.forceConstant * residual * this.lambdaPow;
    }

    public void setLambdaTerm(boolean lambdaTerm) {
        this.lambdaTerm = lambdaTerm;
        this.setLambda(this.lambda);
    }

    private void computeCOM(double[][] com, int nMolecules) {
        int i = 0;
        while (i < nMolecules) {
            if (this.polymers != null && this.polymers.length > 0) {
                for (Polymer polymer : this.polymers) {
                    List<Atom> list = polymer.getAtomList();
                    com[0][i] = 0.0;
                    com[1][i] = 0.0;
                    com[2][i] = 0.0;
                    double totalMass = 0.0;
                    for (Atom atom : list) {
                        double m = atom.getMass();
                        double[] dArray = com[0];
                        int n = i;
                        dArray[n] = dArray[n] + atom.getX() * m;
                        double[] dArray2 = com[1];
                        int n2 = i;
                        dArray2[n2] = dArray2[n2] + atom.getY() * m;
                        double[] dArray3 = com[2];
                        int n3 = i;
                        dArray3[n3] = dArray3[n3] + atom.getZ() * m;
                        totalMass += m;
                    }
                    double[] dArray = com[0];
                    int n = i;
                    dArray[n] = dArray[n] / totalMass;
                    double[] dArray4 = com[1];
                    int n4 = i;
                    dArray4[n4] = dArray4[n4] / totalMass;
                    double[] dArray5 = com[2];
                    int n5 = i++;
                    dArray5[n5] = dArray5[n5] / totalMass;
                }
            }
            for (MSNode molecule : this.molecules) {
                List<Atom> list = molecule.getAtomList();
                com[0][i] = 0.0;
                com[1][i] = 0.0;
                com[2][i] = 0.0;
                double totalMass = 0.0;
                for (Atom atom : list) {
                    double m = atom.getMass();
                    double[] dArray = com[0];
                    int n = i;
                    dArray[n] = dArray[n] + atom.getX() * m;
                    double[] dArray6 = com[1];
                    int n6 = i;
                    dArray6[n6] = dArray6[n6] + atom.getY() * m;
                    double[] dArray7 = com[2];
                    int n7 = i;
                    dArray7[n7] = dArray7[n7] + atom.getZ() * m;
                    totalMass += m;
                }
                double[] dArray = com[0];
                int n = i;
                dArray[n] = dArray[n] / totalMass;
                double[] dArray8 = com[1];
                int n8 = i;
                dArray8[n8] = dArray8[n8] / totalMass;
                double[] dArray9 = com[2];
                int n9 = i++;
                dArray9[n9] = dArray9[n9] / totalMass;
            }
            for (MSNode water : this.water) {
                List<Atom> list = water.getAtomList();
                com[0][i] = 0.0;
                com[1][i] = 0.0;
                com[2][i] = 0.0;
                double totalMass = 0.0;
                for (Atom atom : list) {
                    double m = atom.getMass();
                    double[] dArray = com[0];
                    int n = i;
                    dArray[n] = dArray[n] + atom.getX() * m;
                    double[] dArray10 = com[1];
                    int n10 = i;
                    dArray10[n10] = dArray10[n10] + atom.getY() * m;
                    double[] dArray11 = com[2];
                    int n11 = i;
                    dArray11[n11] = dArray11[n11] + atom.getZ() * m;
                    totalMass += m;
                }
                double[] dArray = com[0];
                int n = i;
                dArray[n] = dArray[n] / totalMass;
                double[] dArray12 = com[1];
                int n12 = i;
                dArray12[n12] = dArray12[n12] / totalMass;
                double[] dArray13 = com[2];
                int n13 = i++;
                dArray13[n13] = dArray13[n13] / totalMass;
            }
            for (MSNode ion : this.ions) {
                List<Atom> list = ion.getAtomList();
                com[0][i] = 0.0;
                com[1][i] = 0.0;
                com[2][i] = 0.0;
                double totalMass = 0.0;
                for (Atom atom : list) {
                    double m = atom.getMass();
                    double[] dArray = com[0];
                    int n = i;
                    dArray[n] = dArray[n] + atom.getX() * m;
                    double[] dArray14 = com[1];
                    int n14 = i;
                    dArray14[n14] = dArray14[n14] + atom.getY() * m;
                    double[] dArray15 = com[2];
                    int n15 = i;
                    dArray15[n15] = dArray15[n15] + atom.getZ() * m;
                    totalMass += m;
                }
                double[] dArray = com[0];
                int n = i;
                dArray[n] = dArray[n] / totalMass;
                double[] dArray16 = com[1];
                int n16 = i;
                dArray16[n16] = dArray16[n16] / totalMass;
                double[] dArray17 = com[2];
                int n17 = i++;
                dArray17[n17] = dArray17[n17] / totalMass;
            }
        }
    }

    private void computedcomdx() {
        int i = 0;
        while (i < this.nAtoms) {
            if (this.polymers != null && this.polymers.length > 0) {
                for (Polymer polymer : this.polymers) {
                    List<Atom> list = polymer.getAtomList();
                    double totalMass = 0.0;
                    for (Atom atom : list) {
                        double m = atom.getMass();
                        totalMass += m;
                    }
                    for (Atom atom : list) {
                        this.dcomdx[i] = atom.getMass();
                        int n = i++;
                        this.dcomdx[n] = this.dcomdx[n] / totalMass;
                    }
                }
            }
            for (MSNode molecule : this.molecules) {
                List<Atom> list = molecule.getAtomList();
                double totalMass = 0.0;
                for (Atom atom : list) {
                    double m = atom.getMass();
                    totalMass += m;
                }
                for (Atom atom : list) {
                    this.dcomdx[i] = atom.getMass();
                    int n = i++;
                    this.dcomdx[n] = this.dcomdx[n] / totalMass;
                }
            }
            for (MSNode water : this.water) {
                List<Atom> list = water.getAtomList();
                double totalMass = 0.0;
                for (Atom atom : list) {
                    double m = atom.getMass();
                    totalMass += m;
                }
                for (Atom atom : list) {
                    this.dcomdx[i] = atom.getMass();
                    int n = i++;
                    this.dcomdx[n] = this.dcomdx[n] / totalMass;
                }
            }
            for (MSNode ion : this.ions) {
                List<Atom> list = ion.getAtomList();
                double totalMass = 0.0;
                for (Atom atom : list) {
                    double m = atom.getMass();
                    totalMass += m;
                }
                for (Atom atom : list) {
                    this.dcomdx[i] = atom.getMass();
                    int n = i++;
                    this.dcomdx[n] = this.dcomdx[n] / totalMass;
                }
            }
        }
    }

    private int countMolecules() {
        int count = 0;
        if (this.polymers != null && this.polymers.length > 0) {
            count += this.polymers.length;
        }
        if (this.molecules != null) {
            count += this.molecules.size();
        }
        if (this.water != null) {
            count += this.water.size();
        }
        if (this.ions != null) {
            count += this.ions.size();
        }
        return count;
    }
}

