/*
 * Decompiled with CFR 0.152.
 */
package ffx.potential.constraint;

import ffx.numerics.Constraint;
import ffx.potential.bonded.Angle;
import ffx.potential.bonded.Atom;
import ffx.potential.bonded.Bond;
import ffx.potential.constraint.SettleConstraint;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import java.util.stream.IntStream;
import org.apache.commons.math3.linear.OpenMapRealMatrix;
import org.apache.commons.math3.linear.QRDecomposition;
import org.apache.commons.math3.linear.RealMatrix;
import org.apache.commons.math3.linear.RealVectorPreservingVisitor;
import org.apache.commons.math3.util.FastMath;

public class CcmaConstraint
implements Constraint {
    public static final double DEFAULT_CCMA_NONZERO_CUTOFF = 0.01;
    private static final Logger logger = Logger.getLogger(CcmaConstraint.class.getName());
    private static final int DEFAULT_MAX_ITERS = 150;
    private final int[] atoms1;
    private final int[] atoms2;
    private final double[] lengths;
    private final int nConstraints;
    private final int[] uniqueIndices;
    private final int maxIters = 150;
    private final double elementCutoff = 0.01;
    private final double[] reducedMasses;
    private final RealMatrix kInvSparse;

    private CcmaConstraint(List<Bond> constrainedBonds, List<Angle> constrainedAngles, Atom[] allAtoms, double[] masses, double nonzeroCutoff) {
        int i2;
        int i3;
        int i4;
        long time = -System.nanoTime();
        int nBonds = constrainedBonds.size();
        int nAngles = constrainedAngles.size();
        assert (constrainedAngles.stream().flatMap(a -> a.getBondList().stream()).noneMatch(constrainedBonds::contains));
        this.nConstraints = nBonds + 3 * nAngles;
        this.atoms1 = new int[this.nConstraints];
        this.atoms2 = new int[this.nConstraints];
        this.lengths = new double[this.nConstraints];
        for (i4 = 0; i4 < nBonds; ++i4) {
            Bond bi = constrainedBonds.get(i4);
            this.atoms1[i4] = bi.getAtom(0).getXyzIndex() - 1;
            this.atoms2[i4] = bi.getAtom(1).getXyzIndex() - 1;
            this.lengths[i4] = bi.bondType.distance;
        }
        for (i4 = 0; i4 < nAngles; ++i4) {
            int iAng = nBonds + 3 * i4;
            Angle ai = constrainedAngles.get(i4);
            Atom center = ai.getCentralAtom();
            Bond b1 = ai.getBond(0);
            Bond b2 = ai.getBond(1);
            Atom at0 = b1.get1_2(center);
            Atom at2 = b2.get1_2(center);
            double angVal = ai.angleType.angle[ai.nh];
            double dist1 = b1.bondType.distance;
            double dist2 = b2.bondType.distance;
            double dist3 = SettleConstraint.lawOfCosines(dist1, dist2, angVal);
            int index0 = at0.getXyzIndex() - 1;
            int index1 = center.getXyzIndex() - 1;
            int index2 = at2.getXyzIndex() - 1;
            this.atoms1[iAng] = index0;
            this.atoms2[iAng] = index1;
            this.lengths[iAng] = dist1;
            this.atoms1[++iAng] = index1;
            this.atoms2[iAng] = index2;
            this.lengths[iAng] = dist2;
            this.atoms1[++iAng] = index0;
            this.atoms2[iAng] = index2;
            this.lengths[iAng] = dist3;
        }
        this.uniqueIndices = IntStream.concat(Arrays.stream(this.atoms1), Arrays.stream(this.atoms2)).sorted().distinct().toArray();
        OpenMapRealMatrix kSparse = new OpenMapRealMatrix(this.nConstraints, this.nConstraints);
        int nAtoms = allAtoms.length;
        ArrayList atomsToConstraints = new ArrayList(nAtoms);
        for (i3 = 0; i3 < nAtoms; ++i3) {
            atomsToConstraints.add(new HashSet(4));
        }
        for (i3 = 0; i3 < this.nConstraints; ++i3) {
            ((Set)atomsToConstraints.get(this.atoms1[i3])).add(i3);
            ((Set)atomsToConstraints.get(this.atoms2[i3])).add(i3);
        }
        logger.info(String.format(" Initial CCMA setup: %10.6g sec", 1.0E-9 * (double)(time + System.nanoTime())));
        long subTime = -System.nanoTime();
        for (int i5 = 0; i5 < this.nConstraints; ++i5) {
            int atomi0 = this.atoms1[i5];
            int atomi1 = this.atoms2[i5];
            double invMassI0 = 1.0 / masses[atomi0 * 3];
            double invMassI1 = 1.0 / masses[atomi1 * 3];
            double sumInv = invMassI0 + invMassI1;
            HashSet coupledConstraints = new HashSet((Collection)atomsToConstraints.get(atomi0));
            coupledConstraints.addAll((Collection)atomsToConstraints.get(atomi1));
            Iterator iterator = coupledConstraints.iterator();
            while (iterator.hasNext()) {
                double scale;
                int atomc;
                int atomb;
                int atoma;
                int j = (Integer)iterator.next();
                if (i5 == j) {
                    kSparse.setEntry(i5, j, 1.0);
                    continue;
                }
                int atomj0 = this.atoms1[j];
                int atomj1 = this.atoms2[j];
                if (atomi0 == atomj0) {
                    assert (atomi1 != atomj1);
                    atoma = atomi1;
                    atomb = atomi0;
                    atomc = atomj1;
                    scale = invMassI0 / sumInv;
                } else if (atomi0 == atomj1) {
                    assert (atomi1 != atomj0);
                    atoma = atomi1;
                    atomb = atomi0;
                    atomc = atomj0;
                    scale = invMassI0 / sumInv;
                } else if (atomi1 == atomj0) {
                    assert (atomi0 != atomj1);
                    atoma = atomi0;
                    atomb = atomi1;
                    atomc = atomj1;
                    scale = invMassI1 / sumInv;
                } else if (atomi1 == atomj1) {
                    assert (atomi0 != atomj0);
                    atoma = atomi1;
                    atomb = atomi0;
                    atomc = atomj1;
                    scale = invMassI1 / sumInv;
                } else {
                    throw new IllegalArgumentException(" Despite by necessity sharing an atom, these constraints don't share an atom.");
                }
                boolean foundAngle = false;
                Iterator iterator2 = ((Set)atomsToConstraints.get(atoma)).iterator();
                while (iterator2.hasNext()) {
                    int constraintK = (Integer)iterator2.next();
                    if (this.atoms1[constraintK] != atomc && this.atoms2[constraintK] != atomc) continue;
                    double dab = this.lengths[i5];
                    double dbc = this.lengths[j];
                    double dac = this.lengths[constraintK];
                    double angle = dab * dab + dbc * dbc - dac * dac;
                    double coupling = scale * (angle /= 2.0 * dab * dbc);
                    kSparse.setEntry(i5, j, coupling);
                    foundAngle = true;
                    break;
                }
                if (!foundAngle) {
                    Atom atA = allAtoms[atoma];
                    Atom atB = allAtoms[atomb];
                    Atom atC = allAtoms[atomc];
                    Angle angleB = atA.getAngle(atB, atC);
                    double angVal = angleB.angleType.angle[angleB.nh];
                    double coupling = scale * FastMath.cos((double)FastMath.toRadians((double)angVal));
                    kSparse.setEntry(i5, j, coupling);
                    foundAngle = true;
                }
                if (foundAngle) continue;
                logger.severe(String.format(" Could not find the angle between coupled constraints %d, %d", i5, j));
            }
        }
        logger.info(String.format(" Time to construct K as a sparse matrix: %10.6g sec", 1.0E-9 * (double)(subTime += System.nanoTime())));
        subTime = -System.nanoTime();
        QRDecomposition qrd = new QRDecomposition((RealMatrix)kSparse);
        RealMatrix kInvDense = qrd.getSolver().getInverse();
        logger.info(String.format(" Time to invert K: %10.6g sec", 1.0E-9 * (double)(subTime += System.nanoTime())));
        subTime = -System.nanoTime();
        this.kInvSparse = new OpenMapRealMatrix(this.nConstraints, this.nConstraints);
        IntStream.range(0, this.nConstraints).forEach(i -> {
            double[] rowI = kInvDense.getRow(i);
            for (int j = 0; j < this.nConstraints; ++j) {
                double val = rowI[j];
                if (!(Math.abs(val) > 0.01)) continue;
                this.kInvSparse.setEntry(i, j, val);
            }
        });
        double[][] dataDense = kInvDense.getData();
        double[][] dataSparse = this.kInvSparse.getData();
        logger.fine(" Dense array:");
        for (i2 = 0; i2 < this.nConstraints; ++i2) {
            logger.fine(Arrays.toString(dataDense[i2]));
        }
        logger.fine(" Sparse array:");
        for (i2 = 0; i2 < this.nConstraints; ++i2) {
            logger.fine(Arrays.toString(dataSparse[i2]));
        }
        this.reducedMasses = new double[this.nConstraints];
        for (i2 = 0; i2 < this.nConstraints; ++i2) {
            int atI = this.atoms1[i2];
            int atJ = this.atoms2[i2];
            double invMassI = 1.0 / masses[atI *= 3];
            double invMassJ = 1.0 / masses[atJ *= 3];
            this.reducedMasses[i2] = 0.5 / (invMassI + invMassJ);
        }
    }

    public static CcmaConstraint ccmaFactory(List<Bond> constrainedBonds, List<Angle> constrainedAngles, Atom[] allAtoms, double[] masses, double nonzeroCutoff) {
        CcmaConstraint newC = new CcmaConstraint(constrainedBonds, constrainedAngles, allAtoms, masses, nonzeroCutoff);
        constrainedBonds.forEach(b -> b.setConstraint(newC));
        constrainedAngles.forEach(a -> a.setConstraint(newC));
        return newC;
    }

    public void applyConstraintToStep(double[] xPrior, double[] xNew, double[] masses, double tol) {
        this.applyConstraints(xPrior, xNew, masses, false, tol);
    }

    public void applyConstraintToVelocities(double[] x, double[] v, double[] masses, double tol) {
        this.applyConstraints(x, v, masses, true, tol);
    }

    public int[] constrainedAtomIndices() {
        return Arrays.copyOf(this.uniqueIndices, this.uniqueIndices.length);
    }

    public boolean constraintSatisfied(double[] x, double tol) {
        return false;
    }

    public boolean constraintSatisfied(double[] x, double[] v, double xTol, double vTol) {
        return false;
    }

    public int getNumDegreesFrozen() {
        return this.nConstraints;
    }

    private void applyConstraints(double[] xPrior, double[] output, double[] masses, boolean constrainV, double tol) {
        if (xPrior == output) {
            throw new IllegalArgumentException(" xPrior and output must be different arrays!");
        }
        long time = -System.nanoTime();
    }

    private static class MatrixWalker
    implements RealVectorPreservingVisitor {
        private final double[] constraintDelta;
        private double sum = 0.0;

        MatrixWalker(double[] cDelta) {
            this.constraintDelta = cDelta;
        }

        public double end() {
            return this.sum;
        }

        public void start(int dimension, int start, int end) {
        }

        public void visit(int index, double value) {
            this.sum += value * this.constraintDelta[index];
        }
    }
}

