/*
 * Decompiled with CFR 0.152.
 */
package ffx.potential.commands.test;

import ffx.potential.ForceFieldEnergy;
import ffx.potential.MolecularAssembly;
import ffx.potential.cli.PotentialCommand;
import ffx.potential.parameters.ForceField;
import ffx.potential.parameters.TitrationUtils;
import ffx.potential.parsers.ForceFieldFilter;
import ffx.potential.parsers.PDBFilter;
import ffx.utilities.FFXBinding;
import ffx.utilities.Keyword;
import java.io.File;
import org.apache.commons.configuration2.CompositeConfiguration;
import org.apache.commons.io.FilenameUtils;
import picocli.CommandLine;

@CommandLine.Command(description={" Save a PDB file that includes all titrating tautomer hydrogen atoms."}, name="test.SaveAsConstantPhPDB")
public class SaveAsConstantPhPDB
extends PotentialCommand {
    @CommandLine.Option(names={"--rt", "--rotamerTitration"}, paramLabel="false", description={"Prepare PDB for rotamer optimization with titration states."})
    private boolean rotamerTitration = false;
    @CommandLine.Parameters(arity="1", paramLabel="file", description={"The atomic coordinate file in PDB format."})
    private String filename = null;

    public SaveAsConstantPhPDB() {
    }

    public SaveAsConstantPhPDB(FFXBinding binding) {
        super(binding);
    }

    public SaveAsConstantPhPDB(String[] args) {
        super(args);
    }

    public SaveAsConstantPhPDB run() {
        if (!this.init()) {
            return this;
        }
        if (this.rotamerTitration) {
            logger.info("\n Adding rotamer optimization with titration protons to : " + this.filename + "\n");
        } else {
            logger.info("\n Adding constant pH protons to: " + this.filename + "\n");
        }
        File structureFile = new File(this.filename);
        int index = this.filename.lastIndexOf(".");
        String name = this.filename.substring(0, index);
        this.activeAssembly = new MolecularAssembly(name);
        this.activeAssembly.setFile(structureFile);
        CompositeConfiguration properties = Keyword.loadProperties((File)structureFile);
        ForceFieldFilter forceFieldFilter = new ForceFieldFilter(properties);
        ForceField forceField = forceFieldFilter.parse();
        String[] patches = properties.getStringArray("patch");
        if (patches != null) {
            for (String patch : patches) {
                logger.info(" Attempting to read force field patch from " + patch + ".");
                CompositeConfiguration patchConfiguration = new CompositeConfiguration();
                patchConfiguration.addProperty("parameters", (Object)patch);
                forceFieldFilter = new ForceFieldFilter(patchConfiguration);
                ForceField patchForceField = forceFieldFilter.parse();
                forceField.append(patchForceField);
            }
        }
        this.activeAssembly.setForceField(forceField);
        PDBFilter pdbFilter = new PDBFilter(structureFile, this.activeAssembly, forceField, properties);
        if (this.rotamerTitration) {
            pdbFilter.setRotamerTitration(true);
        } else {
            pdbFilter.setConstantPH(true);
        }
        pdbFilter.readFile();
        pdbFilter.applyAtomProperties();
        ForceFieldEnergy potential = ForceFieldEnergy.energyFactory(this.activeAssembly);
        this.activeAssembly.setPotential(potential);
        this.activeAssembly.finalize(true, forceField);
        File saveDir = this.baseDir;
        if (!(saveDir != null && saveDir.exists() && saveDir.isDirectory() && saveDir.canWrite())) {
            saveDir = new File(FilenameUtils.getFullPath((String)this.filename));
        }
        String dirName = saveDir.getAbsolutePath() + File.separator;
        String fileName = FilenameUtils.getBaseName((String)this.filename);
        File modelFile = new File(dirName + fileName + ".pdb");
        if (!pdbFilter.writeFile(modelFile = this.potentialFunctions.versionFile(modelFile), false, false, true)) {
            logger.info(String.format(" Save failed for %s", this.activeAssembly));
        }
        TitrationUtils constantPhUtils = new TitrationUtils(forceField);
        return this;
    }
}

