/*
 * Decompiled with CFR 0.152.
 */
package ffx.potential.commands.test;

import ffx.potential.cli.PotentialCommand;
import ffx.potential.parameters.BaseType;
import ffx.potential.parameters.ChargeType;
import ffx.potential.parameters.ForceField;
import ffx.potential.parameters.MultipoleType;
import ffx.potential.parameters.VDWType;
import ffx.potential.parsers.ForceFieldFilter;
import ffx.utilities.FFXBinding;
import ffx.utilities.Keyword;
import java.util.List;
import java.util.Map;
import org.apache.commons.configuration2.CompositeConfiguration;
import picocli.CommandLine;

@CommandLine.Command(description={"PrmToProperty converts a TINKER *.prm file to Java properties."}, name="test.PrmToProperty")
public class PrmToProperty
extends PotentialCommand {
    @CommandLine.Option(names={"-t", "--tinker"}, paramLabel="false", defaultValue="false", description={"Remove line continuation characters from multi-line force field types (i.e. Tinker prm format)."})
    private boolean tinker = false;
    @CommandLine.Option(names={"-c", "--useCharges"}, paramLabel="false", defaultValue="false", description={"Output charge keywords instead of multipole keywords."})
    private boolean useCharges = false;
    @CommandLine.Option(names={"-z", "--zeroVDW"}, paramLabel="false", defaultValue="false", description={"Add a zero VDW class with zero parameters."})
    private boolean zeroVDW = false;
    @CommandLine.Parameters(arity="1", paramLabel="files", description={"TINKER *.prm file(s)."})
    private List<String> filenames = null;

    public PrmToProperty() {
    }

    public PrmToProperty(FFXBinding binding) {
        super(binding);
    }

    public PrmToProperty(String[] args) {
        super(args);
    }

    public PrmToProperty run() {
        if (!this.init()) {
            return this;
        }
        if (this.filenames == null || this.filenames.size() < 1) {
            logger.info(this.helpString());
            return this;
        }
        String prmName = this.filenames.get(0);
        CompositeConfiguration properties = Keyword.loadProperties(null);
        properties.setProperty("parameters", (Object)prmName);
        ForceFieldFilter forceFieldFilter = new ForceFieldFilter(properties);
        ForceField forceField = forceFieldFilter.parse();
        for (int i = 1; i < this.filenames.size(); ++i) {
            String filename = this.filenames.get(i);
            properties = Keyword.loadProperties(null);
            properties.setProperty("parameters", (Object)filename);
            forceFieldFilter = new ForceFieldFilter(properties);
            ForceField forceField2 = forceFieldFilter.parse();
            forceField.append(forceField2);
        }
        if (this.useCharges) {
            Map<String, ? extends BaseType> multipoleTypes = forceField.getTypes(ForceField.ForceFieldType.MULTIPOLE);
            for (String key : multipoleTypes.keySet()) {
                MultipoleType multipoleType = (MultipoleType)multipoleTypes.get(key);
                ChargeType chargeType = new ChargeType(multipoleType.frameAtomTypes[0], multipoleType.getCharge());
                forceField.addForceFieldType(chargeType);
            }
            forceField.clearForceFieldType(ForceField.ForceFieldType.MULTIPOLE);
        }
        if (this.zeroVDW) {
            forceField.addForceFieldType(new VDWType(0, 0.0, 0.0, -1.0));
        }
        if (forceField != null) {
            StringBuffer sb = forceField.toStringBuffer();
            if (this.tinker) {
                logger.info(sb.toString().replace('\\', ' '));
            } else {
                logger.info(sb.toString());
            }
        }
        return this;
    }
}

