/*
 * Decompiled with CFR 0.152.
 */
package ffx.potential.commands;

import ffx.numerics.Potential;
import ffx.potential.MolecularAssembly;
import ffx.potential.cli.PotentialCommand;
import ffx.potential.parsers.CIFFilter;
import ffx.potential.parsers.SystemFilter;
import ffx.utilities.FFXBinding;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.FilenameUtils;
import picocli.CommandLine;

@CommandLine.Command(name="ImportCIF", description={" Convert a CIF file to PDB/XYZ format."})
public class ImportCIF
extends PotentialCommand {
    @CommandLine.Option(names={"--zp", "--zPrime"}, paramLabel="-1", defaultValue="-1", description={"Specify Z' when writing a CIF file."})
    private int zPrime = -1;
    @CommandLine.Option(names={"--sg", "--spaceGroupNumber"}, paramLabel="-1", defaultValue="-1", description={"Override the CIF space group."})
    private int sgNum = -1;
    @CommandLine.Option(names={"--name", "--spaceGroupName"}, paramLabel="", defaultValue="", description={"Override the CIF space group."})
    private String sgName = "";
    @CommandLine.Option(names={"--bt", "--bondTolerance"}, paramLabel="0.2", defaultValue="0.2", description={"Tolerance added to covalent radius to determine if atoms should be bonded."})
    private double bondTolerance = 0.2;
    @CommandLine.Option(names={"--fl", "--fixLattice"}, defaultValue="false", description={"Override CIF parameters to satisfy lattice conditions (Otherwise error)."})
    private boolean fixLattice = false;
    @CommandLine.Option(names={"--sc", "--saveCIF"}, defaultValue="false", description={"Attempt to save file in CIF format (input(s) in XYZ format)."})
    private boolean saveCIF = false;
    @CommandLine.Option(names={"--ca", "--cifAppend"}, defaultValue="false", description={"Append structures."})
    private boolean cifAppend = false;
    @CommandLine.Parameters(arity="1..2", paramLabel="files", description={"A CIF file and a PDB or XYZ file (already parameterized) containing one of each molecule from the CIF."})
    private List<String> filenames = null;
    public String[] createdFiles = null;

    public ImportCIF() {
    }

    public ImportCIF(FFXBinding binding) {
        super(binding);
    }

    public ImportCIF(String[] args) {
        super(args);
    }

    public ImportCIF run() {
        System.setProperty("cdk.logging.level", "fatal");
        System.setProperty("vdwterm", "false");
        if (!this.init()) {
            return this;
        }
        if (this.filenames != null) {
            int fileInputs = this.filenames.size();
            System.clearProperty("mpoleterm");
            String dirString = this.getBaseDirString(this.filenames.get(0));
            String name = FilenameUtils.removeExtension((String)FilenameUtils.getName((String)this.filenames.get(0)));
            if (this.saveCIF) {
                MolecularAssembly[] opened = this.potentialFunctions.openAll(this.filenames.toArray(new String[0]));
                SystemFilter systemFilter = this.potentialFunctions.getFilter();
                if (systemFilter == null) {
                    logger.warning(" No systems were opened to save as CIF.");
                    return this;
                }
                do {
                    this.activeAssembly = systemFilter.getActiveMolecularSystem();
                    File saveFile = new File(dirString + name + ".cif");
                    CIFFilter cifFilter = new CIFFilter(saveFile, this.activeAssembly, this.activeAssembly.getForceField(), this.activeAssembly.getProperties(), true);
                    cifFilter.setBondTolerance(this.bondTolerance);
                    cifFilter.setFixLattice(this.fixLattice);
                    cifFilter.setSgName(this.sgName);
                    cifFilter.setSgNum(this.sgNum);
                    cifFilter.setZprime(this.zPrime);
                    if (cifFilter.writeFile(saveFile, this.cifAppend)) {
                        this.createdFiles = cifFilter.getCreatedFileNames();
                        continue;
                    }
                    logger.warning(" Assembly " + this.activeAssembly.getName() + " was not successful...");
                } while (systemFilter.readNext());
            } else if (fileInputs == 2) {
                this.getActiveAssembly(this.filenames.get(1));
                String ext = FilenameUtils.getExtension((String)this.filenames.get(1));
                File saveFile = new File(dirString + name + "." + ext);
                CIFFilter cifFilter = new CIFFilter(saveFile, this.activeAssembly, this.activeAssembly.getForceField(), this.activeAssembly.getProperties(), false);
                cifFilter.setBondTolerance(this.bondTolerance);
                cifFilter.setFixLattice(this.fixLattice);
                cifFilter.setSgName(this.sgName);
                cifFilter.setSgNum(this.sgNum);
                cifFilter.setZprime(this.zPrime);
                if (cifFilter.readFile()) {
                    this.createdFiles = cifFilter.getCreatedFileNames();
                } else {
                    logger.info(" Error occurred during conversion.");
                }
            } else {
                logger.info(this.helpString());
                logger.info(" Expected 1 or 2 file(s) as input to ImportCIF.");
            }
        } else {
            logger.info(this.helpString());
            logger.info(" Expected 1 or 2 file(s) as input to ImportCIF.");
            return this;
        }
        return this;
    }

    @Override
    public List<Potential> getPotentials() {
        return new ArrayList<Potential>();
    }
}

