/*
 * Decompiled with CFR 0.152.
 */
package ffx.potential.commands;

import ffx.crystal.Crystal;
import ffx.crystal.LatticeSystem;
import ffx.potential.bonded.Atom;
import ffx.potential.cli.PotentialCommand;
import ffx.utilities.FFXBinding;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.math3.util.FastMath;
import picocli.CommandLine;

@CommandLine.Command(name="XYZtoQE", description={"Generate QE input from a XYZ file."})
public class ExportQE
extends PotentialCommand {
    @CommandLine.Option(names={"--ns", "--nstep"}, paramLabel="500", defaultValue="500", description={"Number of structural optimization steps performed in this run."})
    private int nStep;
    @CommandLine.Option(names={"--ec", "--etot_conv_thr"}, paramLabel="1.0e-6", defaultValue="1.0e-6", description={"Convergence threshold on total energy (a.u) for ionic minimization."})
    private double etotConvThr;
    @CommandLine.Option(names={"--ef", "--forc_conv_thr"}, paramLabel="1.0e-4", defaultValue="1.0e-4", description={"Convergence threshold on forces (a.u) for ionic minimization."})
    private double forcConvThr;
    @CommandLine.Option(names={"--ke", "--ecutwfc"}, paramLabel="50.0", defaultValue="50.0", description={"Kinetic energy cutoff (Ry) for wavefunctions."})
    private double ecutwfc;
    @CommandLine.Option(names={"--rho", "--ecutrho"}, paramLabel="500.0", defaultValue="500.0", description={"Kinetic energy cutoff (Ry) for charge density and potential."})
    private double ecutrho;
    @CommandLine.Option(names={"--em", "--electron_maxstep"}, paramLabel="1500", defaultValue="1500", description={"Maximum number of iterations in a scf step."})
    private int electronMaxstep;
    @CommandLine.Option(names={"--ct", "--conv_thr"}, paramLabel="1.0e-8", defaultValue="1.0e-8", description={"Convergence threshold for self consistency."})
    private double convThr;
    @CommandLine.Option(names={"--mb", "--mixing_beta"}, paramLabel="0.5", defaultValue="0.5", description={"Mixing factor for self-consistency."})
    private double mixingBeta;
    @CommandLine.Option(names={"--hx", "--hexagonal"}, paramLabel="true", defaultValue="true", description={"Perform QE on hexagonal system."})
    private boolean hexagonal;
    @CommandLine.Parameters(arity="1", paramLabel="file", description={"XYZ file to be converted."})
    private String filename = null;

    public ExportQE() {
    }

    public ExportQE(FFXBinding binding) {
        super(binding);
    }

    public ExportQE(String[] args) {
        super(args);
    }

    public ExportQE run() {
        Atom[] atoms;
        if (!this.init()) {
            return this;
        }
        this.activeAssembly = this.getActiveAssembly(this.filename);
        if (this.activeAssembly == null) {
            logger.info(this.helpString());
            return this;
        }
        this.filename = this.activeAssembly.getFile().getAbsolutePath();
        logger.info(String.format("\n Converting %s to QE format\n", this.filename));
        String dirString = this.getBaseDirString(this.filename);
        String name = FilenameUtils.removeExtension((String)FilenameUtils.getName((String)this.filename));
        File modelFile = new File(dirString + name + ".in");
        Crystal crystal = this.activeAssembly.getCrystal().getUnitCell();
        double xtalA = crystal.a;
        double xtalB = crystal.b;
        double xtalC = crystal.c;
        HashMap<String, Double> atomTypes = new HashMap<String, Double>();
        StringBuilder atomicPositions = new StringBuilder();
        for (Atom atom : atoms = this.activeAssembly.getAtomArray()) {
            if (!atomTypes.containsKey(atom.getName())) {
                atomTypes.put(atom.getName(), atom.getAtomType().atomicWeight);
            }
            double[] xyz = atom.getXYZ(null);
            crystal.toFractionalCoordinates(xyz, xyz);
            atomicPositions.append(String.format("%2s %16.12f %16.12f %16.12f%n", atom.getName(), xyz[0], xyz[1], xyz[2]));
        }
        try (BufferedWriter bwQE = new BufferedWriter(new FileWriter(modelFile));){
            bwQE.write(String.format("&CONTROL%n\tcalculation = 'vc-relax',%n\trestart_mode = 'from_scratch',%n\tprefix = '%s',%n\tetot_conv_thr = %6.4E,%n\tforc_conv_thr = %6.4E,%n\tnstep = %d,%n/%n", name, this.etotConvThr, this.forcConvThr, this.nStep));
            bwQE.write(String.format("&SYSTEM%n\tspace_group = %d,%n\tnat = %d,%n\tntyp = %d,%n\ta = %16.12f%n\tb = %16.12f%n\tc = %16.12f%n\tcosAB = %16.12f%n\tcosAC = %16.12f%n\tcosBC = %16.12f%n\tecutwfc = %6.4f,%n\tecutrho = %6.4f,%n\tvdw_corr = 'XDM',%n", crystal.spaceGroup.number, this.activeAssembly.getAtomList().size(), atomTypes.size(), xtalA, xtalB, xtalC, FastMath.cos((double)crystal.gamma), FastMath.cos((double)crystal.beta), FastMath.cos((double)crystal.alpha), this.ecutwfc, this.ecutrho));
            if (crystal.spaceGroup.latticeSystem == LatticeSystem.HEXAGONAL_LATTICE) {
                bwQE.write("\trhombohedral = .FALSE.,\n");
            }
            bwQE.write("/\n");
            bwQE.write(String.format("&ELECTRONS%n\telectron_maxstep = %d,%n\tconv_thr = %6.4E,%n\tscf_must_converge = .TRUE.,%n\tmixing_beta = %5.3f,%n/%n", this.electronMaxstep, this.convThr, this.mixingBeta));
            bwQE.write("&IONS\n\tion_dynamics = 'bfgs',\n/\n");
            bwQE.write("&CELL\n\tcell_dynamics = 'bfgs',\n/\n");
            StringBuilder line = new StringBuilder();
            for (Map.Entry pair : atomTypes.entrySet()) {
                line.append(" ").append((String)pair.getKey()).append(" ").append(pair.getValue()).append(" ").append((String)pair.getKey()).append(".b86bpbe.UPF\n");
            }
            bwQE.write("ATOMIC_SPECIES\n" + String.valueOf(line) + "\n");
            bwQE.write("ATOMIC_POSITIONS crystal_sg\n" + String.valueOf(atomicPositions) + "\n");
            int k1 = xtalA < 5.0 ? 8 : (xtalA <= 7.0 ? 6 : (xtalA <= 12.0 ? 4 : 2));
            int k2 = xtalB < 5.0 ? 8 : (xtalB <= 7.0 ? 6 : (xtalB <= 12.0 ? 4 : 2));
            int k3 = xtalC < 5.0 ? 8 : (xtalC <= 7.0 ? 6 : (xtalC <= 12.0 ? 4 : 2));
            bwQE.write("K_POINTS automatic\n" + k1 + " " + k2 + " " + k3 + " 1 1 1\n");
        }
        catch (IOException e) {
            logger.severe(" Error writing QE input file: " + e.getMessage());
        }
        logger.info(String.format(" Saved QE file: %s", modelFile));
        return this;
    }
}

