/*
 * Decompiled with CFR 0.152.
 */
package ffx.potential.commands;

import ffx.crystal.Crystal;
import ffx.numerics.math.SummaryStatistics;
import ffx.potential.MolecularAssembly;
import ffx.potential.cli.PotentialCommand;
import ffx.potential.cli.WriteoutOptions;
import ffx.potential.parsers.SystemFilter;
import ffx.utilities.FFXBinding;
import picocli.CommandLine;

@CommandLine.Command(name="Density", description={" Calculate the mean system density for single topology systems."})
public class Density
extends PotentialCommand {
    @CommandLine.Mixin
    private WriteoutOptions writeoutOptions = new WriteoutOptions();
    @CommandLine.Option(names={"-s", "--start"}, paramLabel="1", defaultValue="1", description={"First frame to evaluate (1-indexed)."})
    private int start = 1;
    @CommandLine.Option(names={"-f", "--final"}, paramLabel="all frames", defaultValue="0", description={"Last frame to evaluate (1-indexed); values less than 1 evaluate to end of trajectory."})
    private int finish = 0;
    @CommandLine.Option(names={"--st", "--stride"}, paramLabel="1", defaultValue="1", description={"Stride: evaluate density every N frames. Must be positive."})
    private int stride = 1;
    @CommandLine.Option(names={"-p", "--printout"}, defaultValue="false", description={"Print out a file with density adjusted to match mean calculated density."})
    private boolean doPrint = false;
    @CommandLine.Parameters(arity="1", paramLabel="file", description={"An atomic coordinate file in PDB or XYZ format."})
    private String filename = null;

    public Density() {
    }

    public Density(FFXBinding binding) {
        super(binding);
    }

    public Density(String[] args) {
        super(args);
    }

    public Density run() {
        if (!this.init()) {
            return this;
        }
        this.activeAssembly = this.getActiveAssembly(this.filename);
        if (this.activeAssembly == null) {
            logger.info(this.helpString());
            return this;
        }
        this.filename = this.activeAssembly.getFile().getAbsolutePath();
        SystemFilter openFilter = this.potentialFunctions.getFilter();
        double totMass = this.activeAssembly.getMass();
        Crystal crystal = this.activeAssembly.getCrystal().getUnitCell();
        if (crystal.aperiodic()) {
            logger.info(String.format(" System %s is aperiodic: total mass %16.7g g/mol", this.filename, totMass));
        } else {
            double volume = crystal.volume / (double)crystal.getNumSymOps();
            double density = crystal.getDensity(totMass);
            int nFrames = openFilter.countNumModels();
            double[] densities = new double[nFrames];
            int lastFrame = this.finish < 1 ? nFrames : this.finish;
            densities[0] = density;
            logger.info(String.format("\n Evaluating density for system %s with mass %16.7g (g/mol).", this.filename, totMass));
            logger.info(String.format(" Density at frame %9d is %16.7g (g/mL) from a volume of %16.7g (A^3)", 1, density, volume));
            int ctr = 1;
            while (openFilter.readNext(false, false)) {
                volume = crystal.volume / (double)crystal.getNumSymOps();
                density = crystal.getDensity(totMass);
                logger.info(String.format(" Density at frame %9d is %16.7g (g/mL) from a volume of %16.7g (A^3)", ++ctr, density, volume));
                int i = ctr - 1;
                densities[i] = density;
            }
            SummaryStatistics densStats = new SummaryStatistics(densities, this.start - 1, lastFrame, this.stride);
            logger.info(" Summary statistics for density:");
            logger.info(densStats.toString());
            if (this.doPrint) {
                this.activeAssembly.setFractionalMode(MolecularAssembly.FractionalMode.MOLECULE);
                this.activeAssembly.computeFractionalCoordinates();
                crystal.setDensity(densStats.mean, totMass);
                this.activeAssembly.moveToFractionalCoordinates();
                this.saveByExtension(this.activeAssembly, this.filename, this.writeoutOptions.fileType);
                this.filename = this.activeAssembly.getFile().getAbsolutePath();
                logger.info("\n Saved density adjusted coordinates: " + this.filename);
                logger.info("\n Molecule based fractional coordinates were maintained.");
            }
        }
        return this;
    }
}

