/*
 * Decompiled with CFR 0.152.
 */
package ffx.potential.cli;

import ffx.numerics.Potential;
import ffx.potential.MolecularAssembly;
import ffx.potential.utils.PotentialsFunctions;
import ffx.potential.utils.PotentialsUtils;
import ffx.utilities.FFXBinding;
import ffx.utilities.FFXCommand;
import ffx.utilities.FilePathInfo;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.commons.io.FilenameUtils;
import org.apache.log4j.PropertyConfigurator;

public abstract class PotentialCommand
extends FFXCommand {
    public PotentialsFunctions potentialFunctions;
    public MolecularAssembly activeAssembly;
    public File baseDir = null;

    public PotentialCommand() {
    }

    public PotentialCommand(FFXBinding binding) {
        super(binding);
    }

    public PotentialCommand(String[] args) {
        super(args);
    }

    public void setActiveAssembly(MolecularAssembly molecularAssembly) {
        this.activeAssembly = molecularAssembly;
    }

    public List<Potential> getPotentials() {
        ArrayList<Potential> potentialList = new ArrayList<Potential>();
        if (this.activeAssembly != null && this.activeAssembly.getPotentialEnergy() != null) {
            potentialList.add((Potential)this.activeAssembly.getPotentialEnergy());
        }
        return potentialList;
    }

    public boolean destroyPotentials() {
        boolean allSucceeded = true;
        for (Potential potential : this.getPotentials()) {
            if (potential == null) continue;
            allSucceeded = allSucceeded && potential.destroy();
        }
        return allSucceeded;
    }

    public List<Potential> getPotentialsFromAssemblies(MolecularAssembly[] assemblies) {
        if (assemblies == null) {
            return new ArrayList<Potential>();
        }
        return Arrays.stream(assemblies).filter(Objects::nonNull).map(MolecularAssembly::getPotentialEnergy).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public boolean init() {
        if (!super.init()) {
            return false;
        }
        this.potentialFunctions = (PotentialsFunctions)this.binding.getVariable("functions");
        if (this.potentialFunctions == null) {
            this.potentialFunctions = new PotentialsUtils();
            this.binding.setVariable("functions", (Object)this.potentialFunctions);
            System.setProperty("log4j.threshold", "OFF");
            System.setProperty("log4j.rootLogger", "OFF");
            System.setProperty("log4j1.compatibility", "true");
            Properties properties = new Properties();
            properties.setProperty("log4j.threshold", "OFF");
            properties.setProperty("log4j2.level", "OFF");
            properties.setProperty("org.apache.logging.log4j.level", "OFF");
            PropertyConfigurator.configure((Properties)properties);
        }
        try {
            this.activeAssembly = (MolecularAssembly)this.binding.getVariable("active");
        }
        catch (Exception e) {
            this.activeAssembly = null;
        }
        try {
            this.baseDir = (File)this.binding.getVariable("baseDir");
        }
        catch (Exception exception) {
            // empty catch block
        }
        return true;
    }

    public MolecularAssembly getActiveAssembly(@Nullable String filename) {
        if (filename != null) {
            MolecularAssembly[] assemblies = new MolecularAssembly[]{this.potentialFunctions.open(filename)};
            this.activeAssembly = assemblies[0];
        }
        return this.activeAssembly;
    }

    public MolecularAssembly getActiveAssembly(@Nullable List<String> filenames) {
        if (filenames != null && !filenames.isEmpty()) {
            this.getActiveAssembly(filenames.getFirst());
        }
        return this.activeAssembly;
    }

    public MolecularAssembly[] getActiveAssemblies(@Nullable String filename) {
        if (filename != null) {
            MolecularAssembly[] assemblies = this.potentialFunctions.openAll(filename);
            this.activeAssembly = assemblies[0];
            return assemblies;
        }
        MolecularAssembly[] assemblies = new MolecularAssembly[]{this.activeAssembly};
        return assemblies;
    }

    public String getBaseDirString(String dirFromFilename) {
        if (!(this.baseDir != null && this.baseDir.exists() && this.baseDir.isDirectory() && this.baseDir.canWrite())) {
            File file = new File(dirFromFilename);
            this.baseDir = new File(FilenameUtils.getFullPath((String)file.getAbsolutePath()));
            this.binding.setVariable("baseDir", (Object)this.baseDir);
        }
        return this.baseDir.toString() + File.separator;
    }

    public FilePathInfo parseFilePath(String filepath) {
        String dirString = this.getBaseDirString(filepath);
        String name = FilenameUtils.getName((String)filepath);
        String ext = FilenameUtils.getExtension((String)name);
        String baseName = FilenameUtils.removeExtension((String)name);
        return new FilePathInfo(dirString, baseName, ext);
    }

    public File createOutputFile(String filepath, String newExtension) {
        FilePathInfo info = this.parseFilePath(filepath);
        return new File(info.directory() + info.baseName() + "." + newExtension);
    }

    public void saveByExtension(MolecularAssembly[] assemblies, String filename, String extension) {
        if (extension.toUpperCase().contains("XYZ")) {
            File outputFile = this.createOutputFile(filename, "xyz");
            this.potentialFunctions.saveAsXYZ(assemblies[0], outputFile);
        } else {
            File outputFile = this.createOutputFile(filename, "pdb");
            this.potentialFunctions.saveAsPDB(assemblies, outputFile);
        }
    }

    public void saveByExtension(MolecularAssembly molecularAssembly, String filename, String extension) {
        this.saveByExtension(new MolecularAssembly[]{molecularAssembly}, filename, extension);
    }

    public void saveByOriginalExtension(MolecularAssembly[] assemblies, String filename) {
        String ext = FilenameUtils.getExtension((String)filename);
        this.saveByExtension(assemblies, filename, ext);
    }

    public void saveByOriginalExtension(MolecularAssembly molecularAssembly, String filename) {
        String ext = FilenameUtils.getExtension((String)filename);
        this.saveByExtension(new MolecularAssembly[]{molecularAssembly}, filename, ext);
    }
}

