/*
 * Decompiled with CFR 0.152.
 */
package ffx.potential.cli;

import picocli.CommandLine;

public class GradientOptions {
    @CommandLine.ArgGroup(heading="%n Coordinate Gradient Options%n", validate=false)
    private final GradientOptionGroup group = new GradientOptionGroup();

    public double getDx() {
        return this.group.dx;
    }

    public double getTolerance() {
        return this.group.tolerance;
    }

    public String getGradientAtoms() {
        return this.group.gradientAtoms;
    }

    public boolean getVerbose() {
        return this.group.verbose;
    }

    private static class GradientOptionGroup {
        @CommandLine.Option(names={"-d", "--dx"}, defaultValue="1.0e-5", paramLabel="1.0e-5 \u00c5", description={"Finite-difference step size."})
        public double dx = 1.0E-5;
        @CommandLine.Option(names={"--tol", "--tolerance"}, defaultValue="1.0e-3", paramLabel="1.0e-3 kcal/mol/\u00c5", description={"Gradient error tolerance."})
        public double tolerance = 0.001;
        @CommandLine.Option(names={"--ga", "--gradientAtoms"}, paramLabel="ALL", defaultValue="ALL", description={"Ranges of degrees of freedom to test [ALL, NONE, Range(s): 1-3,6-N]."})
        public String gradientAtoms = "ALL";
        @CommandLine.Option(names={"-v", "--verbose"}, paramLabel="false", description={"Print out the energy for each step."})
        public boolean verbose = false;

        private GradientOptionGroup() {
        }
    }
}

