/*
 * Decompiled with CFR 0.152.
 */
package ffx.potential.cli;

import ffx.potential.MolecularAssembly;
import ffx.potential.bonded.Atom;
import ffx.potential.bonded.Residue;
import ffx.utilities.StringUtils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import picocli.CommandLine;

public class AtomSelectionOptions {
    private static final Logger logger = Logger.getLogger(AtomSelectionOptions.class.getName());
    @CommandLine.ArgGroup(heading="%n Atom Selection Options%n", validate=false)
    private final AtomSelectionOptionGroup group = new AtomSelectionOptionGroup();

    public static void actOnAtoms(@Nonnull MolecularAssembly assembly, @Nullable String selection, @Nonnull BiConsumer<Atom, Boolean> action, @Nonnull String description) {
        if (selection == null || selection.equalsIgnoreCase("")) {
            return;
        }
        Atom[] atoms = assembly.getAtomArray();
        if (selection.equalsIgnoreCase("NONE")) {
            for (Atom atom : atoms) {
                action.accept(atom, false);
            }
            logger.info(" No atoms are " + description + ".\n");
            return;
        }
        if (selection.equalsIgnoreCase("ALL")) {
            for (Atom atom : atoms) {
                action.accept(atom, true);
            }
            logger.info(" All atoms are " + description + ".\n");
            return;
        }
        int nAtoms = atoms.length;
        for (Atom atom : atoms) {
            action.accept(atom, false);
        }
        List atomRanges = StringUtils.parseAtomRanges((String)description, (String)selection, (int)nAtoms);
        Iterator iterator = atomRanges.iterator();
        while (iterator.hasNext()) {
            int i = (Integer)iterator.next();
            action.accept(atoms[i], true);
        }
        logger.info("\n " + description + " atoms set to: " + selection);
    }

    public static void actOnResidueAtoms(@Nonnull MolecularAssembly assembly, @Nullable String selection, @Nonnull BiConsumer<Atom, Boolean> action, String description) {
        if (selection == null || selection.equalsIgnoreCase("")) {
            return;
        }
        Atom[] atoms = assembly.getAtomArray();
        if (selection.equalsIgnoreCase("NONE")) {
            for (Atom atom : atoms) {
                action.accept(atom, false);
            }
            logger.info(" No residues are " + description + ".\n");
            return;
        }
        if (selection.equalsIgnoreCase("ALL")) {
            for (Atom atom : atoms) {
                action.accept(atom, true);
            }
            logger.info(" All residues (and atoms) are " + description + ".\n");
            return;
        }
        for (Atom atom : atoms) {
            action.accept(atom, false);
        }
        StringBuilder seleRes = new StringBuilder();
        StringBuilder seleAtoms = new StringBuilder();
        int nResidues = assembly.getResidueList().size();
        List resList = StringUtils.parseResidueString((String)description, (String)selection, (int)nResidues);
        assert (resList.size() % 2 == 0);
        for (int i = 0; i < resList.size(); i += 2) {
            String chain = (String)resList.get(i);
            int resid = Integer.parseInt((String)resList.get(i + 1));
            List<Object> atomList = new ArrayList();
            Residue res = assembly.getChain(chain).getResidue(resid);
            seleRes.append(res.toFormattedString(true, true)).append(",");
            if (res.getResidueType() == Residue.ResidueType.AA) {
                atomList = res.getSideChainAtoms();
            } else if (res.getResidueType() == Residue.ResidueType.NA) {
                atomList = res.getBackboneAtoms();
            }
            for (Atom atom : atomList) {
                seleAtoms.append(atom.getIndex()).append(",");
                action.accept(atom, true);
            }
        }
        logger.info("\n " + description + " residues are: " + seleRes.substring(0, seleRes.length() - 1));
        logger.info(" " + description + " atoms set to: " + seleAtoms.substring(0, seleAtoms.length() - 1));
    }

    public String getActiveAtoms() {
        return this.group.activeAtoms;
    }

    public void setActiveAtoms(MolecularAssembly molecularAssembly) {
        this.setInactive(molecularAssembly);
        this.setActive(molecularAssembly);
    }

    public String getInactiveAtoms() {
        return this.group.inactiveAtoms;
    }

    public boolean isAtomSelectionSet() {
        if (this.group.activeAtoms != null && !this.group.activeAtoms.isEmpty()) {
            return true;
        }
        return this.group.inactiveAtoms != null && !this.group.inactiveAtoms.isEmpty();
    }

    private void setInactive(MolecularAssembly assembly) {
        AtomSelectionOptions.actOnAtoms(assembly, this.getInactiveAtoms(), (a, b) -> a.setActive(b == false), "Inactive");
    }

    private void setActive(MolecularAssembly assembly) {
        AtomSelectionOptions.actOnAtoms(assembly, this.getActiveAtoms(), Atom::setActive, "Active");
    }

    private static class AtomSelectionOptionGroup {
        @CommandLine.Option(names={"--aa", "--active"}, paramLabel="<selection>", defaultValue="", description={"Ranges of active atoms [NONE, ALL, Range(s): 1-3,6-N]."})
        public String activeAtoms = "";
        @CommandLine.Option(names={"--ia", "--inactive"}, paramLabel="<selection>", defaultValue="", description={"Ranges of inactive atoms [NONE, ALL, Range(s): 1-3,6-N]."})
        public String inactiveAtoms = "";

        private AtomSelectionOptionGroup() {
        }
    }
}

