/*
 * Decompiled with CFR 0.152.
 */
package ffx.potential.bonded;

import ffx.numerics.atomic.AtomicDoubleArray3D;
import ffx.numerics.math.Double3;
import ffx.potential.bonded.Angle;
import ffx.potential.bonded.Atom;
import ffx.potential.bonded.BondedTerm;
import ffx.potential.parameters.ForceField;
import ffx.potential.parameters.UreyBradleyType;
import java.util.logging.Logger;

public class UreyBradley
extends BondedTerm {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = Logger.getLogger(UreyBradley.class.getName());
    public final UreyBradleyType ureyBradleyType;
    protected final Angle angle;
    private double rigidScale = 1.0;

    public UreyBradley(Angle a, UreyBradleyType ureyBradleyType) {
        this.angle = a;
        this.bonds = a.bonds;
        this.atoms = a.atoms;
        this.ureyBradleyType = ureyBradleyType;
        this.setID_Key(false);
    }

    public static UreyBradley ureyBradlyFactory(Angle angle, ForceField forceField) {
        if (angle == null) {
            return null;
        }
        UreyBradleyType ureyBradleyType = forceField.getUreyBradleyType(angle.angleType.getKey());
        if (ureyBradleyType == null) {
            return null;
        }
        return new UreyBradley(angle, ureyBradleyType);
    }

    @Override
    public int compareTo(BondedTerm ub) {
        if (!ub.getClass().isInstance(this)) {
            return super.compareTo(ub);
        }
        return this.angle.compareTo(((UreyBradley)ub).angle);
    }

    @Override
    public double energy(boolean gradient, int threadID, AtomicDoubleArray3D grad, AtomicDoubleArray3D lambdaGrad) {
        this.value = 0.0;
        this.energy = 0.0;
        if (!this.getUse()) {
            return this.energy;
        }
        Atom atomA = this.atoms[0];
        Atom atomC = this.atoms[2];
        Double3 va = atomA.getXYZ();
        Double3 vc = atomC.getXYZ();
        Double3 vac = va.sub(vc);
        this.value = vac.length();
        double dv = this.value - this.ureyBradleyType.distance;
        double dv2 = dv * dv;
        this.energy = this.ureyBradleyType.ureyUnit * this.rigidScale * this.ureyBradleyType.forceConstant * dv2 * (1.0 + this.ureyBradleyType.cubic * dv + this.ureyBradleyType.quartic * dv2);
        if (gradient) {
            double deddt = 2.0 * this.ureyBradleyType.ureyUnit * this.rigidScale * this.ureyBradleyType.forceConstant * dv * (1.0 + 1.5 * this.ureyBradleyType.cubic * dv + 2.0 * this.ureyBradleyType.quartic * dv2);
            double de = 0.0;
            if (this.value > 0.0) {
                de = deddt / this.value;
            }
            int ia = atomA.getIndex() - 1;
            int ic = atomC.getIndex() - 1;
            grad.add(threadID, ia, vac.scaleI(de));
            grad.sub(threadID, ic, vac);
        }
        return this.energy;
    }

    public void log() {
        logger.info(String.format(" %s %6d-%s %6d-%s %6.4f  %6.4f  %10.4f", "Urey-Bradley", this.atoms[0].getIndex(), this.atoms[0].getAtomType().name, this.atoms[2].getIndex(), this.atoms[2].getAtomType().name, this.ureyBradleyType.distance, this.value, this.energy));
    }

    public void setRigidScale(double rigidScale) {
        this.rigidScale = rigidScale;
    }
}

