/*
 * Decompiled with CFR 0.152.
 */
package ffx.potential.bonded;

import ffx.potential.bonded.MSNode;
import ffx.potential.bonded.ROLS;
import ffx.potential.bonded.RendererCache;
import java.util.Enumeration;
import java.util.List;
import java.util.Objects;
import java.util.logging.Logger;
import javax.swing.tree.TreeNode;
import org.jogamp.java3d.BranchGroup;

public class ROLSP
extends MSNode
implements ROLS,
Runnable {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = Logger.getLogger(ROLSP.class.getName());
    public static boolean GO_PARALLEL;
    public static int parallelNotDone;
    private PARALLELMETHOD parallelMethod = PARALLELMETHOD.NONE;
    private long startTime = 0L;
    private long threadTime = 0L;
    private RendererCache.ViewModel viewModel = null;
    private List<BranchGroup> newShapes = null;

    public ROLSP() {
        super("Parallel Node");
    }

    @Override
    public boolean equals(Object o) {
        return this == o;
    }

    @Override
    public int hashCode() {
        MSNode child = (MSNode)this.getChildAt(0);
        if (child == null) {
            return Objects.hash("none");
        }
        return Objects.hash(child.hashCode());
    }

    @Override
    public void run() {
        switch (this.parallelMethod.ordinal()) {
            case 0: {
                this.setView(this.viewModel, this.newShapes);
                break;
            }
            default: {
                return;
            }
        }
        this.threadTime = System.currentTimeMillis() - this.startTime;
        logger.info("Start Time: " + this.startTime + " Total Time: " + this.threadTime);
        --parallelNotDone;
    }

    @Override
    public void setView(RendererCache.ViewModel viewModel, List<BranchGroup> newShapes) {
        if (this.parallelMethod == PARALLELMETHOD.NONE) {
            this.startTime = System.currentTimeMillis();
            this.viewModel = viewModel;
            this.newShapes = newShapes;
            this.parallelMethod = PARALLELMETHOD.SETVIEW;
            Thread thread = new Thread(this);
            thread.setName(this.getParent().toString() + ": Parallel setView MSM");
            thread.setPriority(10);
            ++parallelNotDone;
            thread.start();
        } else if (this.parallelMethod == PARALLELMETHOD.SETVIEW) {
            Enumeration<TreeNode> e = this.children();
            while (e.hasMoreElements()) {
                MSNode node = (MSNode)e.nextElement();
                node.setView(viewModel, newShapes);
            }
            this.parallelMethod = PARALLELMETHOD.NONE;
        } else {
            logger.info(" Parallel setView method called by: " + String.valueOf((Object)this.parallelMethod));
        }
    }

    @Override
    public String toString() {
        if (this.threadTime != 0L) {
            return "Parallel Node " + this.threadTime + " (msec)";
        }
        return "Parallel Node";
    }

    static {
        parallelNotDone = 0;
        try {
            GO_PARALLEL = Boolean.parseBoolean(System.getProperty("ffx.lang.parallel", "false"));
        }
        catch (Exception e) {
            GO_PARALLEL = false;
        }
    }

    public static enum PARALLELMETHOD {
        SETVIEW,
        NONE;

    }
}

