/*
 * Decompiled with CFR 0.152.
 */
package ffx.potential.bonded;

import ffx.numerics.math.DoubleMath;
import ffx.potential.bonded.Angle;
import ffx.potential.bonded.AngleTorsion;
import ffx.potential.bonded.Atom;
import ffx.potential.bonded.Bond;
import ffx.potential.bonded.ImproperTorsion;
import ffx.potential.bonded.Joint;
import ffx.potential.bonded.MSNode;
import ffx.potential.bonded.OutOfPlaneBend;
import ffx.potential.bonded.PiOrbitalTorsion;
import ffx.potential.bonded.ROLS;
import ffx.potential.bonded.RendererCache;
import ffx.potential.bonded.StretchBend;
import ffx.potential.bonded.StretchTorsion;
import ffx.potential.bonded.Torsion;
import ffx.potential.bonded.TorsionTorsion;
import ffx.potential.bonded.UreyBradley;
import ffx.potential.parameters.ForceField;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.tree.MutableTreeNode;
import org.jogamp.java3d.BranchGroup;
import org.jogamp.java3d.Material;
import org.jogamp.vecmath.Color3f;

public abstract class MSGroup
extends MSNode {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = Logger.getLogger(MSGroup.class.getName());
    protected static long bondTime = 0L;
    protected static long angleTime = 0L;
    protected static long stretchBendTime = 0L;
    protected static long ureyBradleyTime = 0L;
    protected static long outOfPlaneBendTime = 0L;
    protected static long torsionTime = 0L;
    protected static long stretchTorsionTime = 0L;
    protected static long angleTorsionTime = 0L;
    protected static long piOrbitalTorsionTime = 0L;
    protected static long torsionTorsionTime = 0L;
    protected static long improperTorsionTime = 0L;
    private MSNode atomNode = new MSNode("Atoms");
    private MSNode termNode = new MSNode("Valence Terms");
    private MSNode bondNode = new MSNode("Bonds");
    private MSNode angleNode = new MSNode("Angles");
    private MSNode stretchBendNode = new MSNode("Stretch-Bends");
    private MSNode ureyBradleyNode = new MSNode("Urey-Bradleys");
    private MSNode outOfPlaneBendNode = new MSNode("Out-of-Plane Bends");
    private MSNode torsionNode = new MSNode("Torsions");
    private MSNode stretchTorsionNode = new MSNode("Stretch-Torsions");
    private MSNode angleTorsionNode = new MSNode("Angle-Torsions");
    private MSNode piOrbitalTorsionNode = new MSNode("Pi-Orbital Torsions");
    private MSNode torsionTorsionNode = new MSNode("Torsion-Torsions");
    private MSNode improperTorsionNode = new MSNode("Improper Torsions");
    private final List<Joint> joints = new ArrayList<Joint>();
    private boolean finalized = false;
    private double[] center;
    private List<Atom> danglingAtomList;
    private boolean matchDeuterium = true;

    public MSGroup() {
        super("", 2);
        this.termNode.add(this.bondNode);
        this.termNode.add(this.angleNode);
        this.termNode.add(this.stretchBendNode);
        this.termNode.add(this.ureyBradleyNode);
        this.termNode.add(this.outOfPlaneBendNode);
        this.termNode.add(this.torsionNode);
        this.termNode.add(this.stretchTorsionNode);
        this.termNode.add(this.angleTorsionNode);
        this.termNode.add(this.piOrbitalTorsionNode);
        this.termNode.add(this.torsionTorsionNode);
        this.termNode.add(this.improperTorsionNode);
        this.add(this.atomNode);
        this.add(this.termNode);
    }

    public MSGroup(String n) {
        this();
        this.setName(n);
    }

    public MSGroup(String n, MSNode node) {
        this(n);
        this.atomNode = node;
        this.add(this.atomNode);
    }

    public abstract MSNode addMSNode(MSNode var1);

    public void assignBondedTerms(ForceField forceField) {
        MSNode newBondNode = new MSNode("Bonds");
        MSNode newAngleNode = new MSNode("Angles");
        MSNode newStretchBendNode = new MSNode("Stretch-Bends");
        MSNode newUreyBradleyNode = new MSNode("Urey-Bradleys");
        MSNode newOutOfPlaneBendNode = new MSNode("Out-of-Plane Bends");
        MSNode newTorsionNode = new MSNode("Torsions");
        MSNode newStretchTorsionNode = new MSNode("Stretch-Torsions");
        MSNode newAngleTorsionNode = new MSNode("Angle-Torsions");
        MSNode newPiOrbitalTorsionNode = new MSNode("Pi-Orbital Torsions");
        MSNode newTorsionTorsionNode = new MSNode("Torsion-Torsions");
        MSNode newImproperTorsionNode = new MSNode("Improper Torsions");
        String[] polyLinks = forceField.getProperties().getStringArray("polymerlink");
        long time = System.nanoTime();
        ArrayList<Bond> bonds = new ArrayList<Bond>();
        for (Atom atom : this.getAtomList()) {
            if (atom.getNumBonds() == 0) continue;
            for (Bond bond : atom.getBonds()) {
                if (!bond.sameGroup() && !this.polymerLinked(polyLinks, bond) || bond.getParent() != null) continue;
                newBondNode.add(bond);
                bonds.add(bond);
            }
        }
        newBondNode.setName("Bonds (" + newBondNode.getChildCount() + ")");
        this.setBonds(newBondNode);
        bondTime += System.nanoTime() - time;
        time = System.nanoTime();
        ArrayList<Angle> angles = new ArrayList<Angle>();
        for (Atom atom : this.getAtomList()) {
            if (atom.getNumBonds() == 0) continue;
            int index = 0;
            for (Bond bond : atom.getBonds()) {
                ++index;
                if (!bond.sameGroup() && !this.polymerLinked(polyLinks, bond)) continue;
                Iterator<Bond> li = atom.getBonds().listIterator(index);
                while (li.hasNext()) {
                    Bond bond2 = li.next();
                    if (!bond2.sameGroup() && !this.polymerLinked(polyLinks, bond2)) continue;
                    Angle newAngle = Angle.angleFactory(bond, bond2, forceField);
                    newAngleNode.insert(newAngle, 0);
                    angles.add(newAngle);
                }
            }
        }
        newAngleNode.setName("Angles (" + newAngleNode.getChildCount() + ")");
        this.setAngles(newAngleNode);
        angleTime += System.nanoTime() - time;
        time = System.nanoTime();
        for (Angle angle : angles) {
            StretchBend newStretchBend = StretchBend.stretchBendFactory(angle, forceField);
            if (newStretchBend == null) continue;
            newStretchBendNode.insert(newStretchBend, 0);
        }
        newStretchBendNode.setName("Stretch-Bends (" + newStretchBendNode.getChildCount() + ")");
        this.setStretchBends(newStretchBendNode);
        stretchBendTime += System.nanoTime() - time;
        time = System.nanoTime();
        for (Angle angle : angles) {
            UreyBradley newUreyBradley = UreyBradley.ureyBradlyFactory(angle, forceField);
            if (newUreyBradley == null) continue;
            newUreyBradleyNode.insert(newUreyBradley, 0);
        }
        newUreyBradleyNode.setName("Urey-Bradleys (" + newUreyBradleyNode.getChildCount() + ")");
        this.setUreyBradleys(newUreyBradleyNode);
        ureyBradleyTime += System.nanoTime() - time;
        time = System.nanoTime();
        for (Angle angle : angles) {
            OutOfPlaneBend opBend = OutOfPlaneBend.outOfPlaneBendFactory(angle, forceField);
            if (opBend == null) continue;
            newOutOfPlaneBendNode.insert(opBend, 0);
        }
        newOutOfPlaneBendNode.setName("Out-of-Plane Bends (" + newOutOfPlaneBendNode.getChildCount() + ")");
        this.setOutOfPlaneBends(newOutOfPlaneBendNode);
        outOfPlaneBendTime += System.nanoTime() - time;
        time = System.nanoTime();
        ArrayList<Torsion> arrayList = new ArrayList<Torsion>();
        for (Bond middleBond : bonds) {
            Atom atom1 = middleBond.getAtom(0);
            Atom atom2 = middleBond.getAtom(1);
            if (atom1.getNumBonds() == 0 || atom2.getNumBonds() == 0) continue;
            for (Bond bond1 : atom1.getBonds()) {
                if (bond1 == middleBond) continue;
                for (Bond bond3 : atom2.getBonds()) {
                    Torsion torsion;
                    if (bond3 == middleBond || (torsion = Torsion.torsionFactory(bond1, middleBond, bond3, forceField)) == null) continue;
                    newTorsionNode.add(torsion);
                    arrayList.add(torsion);
                }
            }
        }
        newTorsionNode.setName("Torsions (" + newTorsionNode.getChildCount() + ")");
        this.setTorsions(newTorsionNode);
        torsionTime += System.nanoTime() - time;
        time = System.nanoTime();
        for (Torsion torsion : arrayList) {
            StretchTorsion stretchTorsion = StretchTorsion.stretchTorsionFactory(torsion, forceField);
            if (stretchTorsion == null) continue;
            newStretchTorsionNode.add(stretchTorsion);
        }
        newStretchTorsionNode.setName("Stretch-Torsions (" + newStretchTorsionNode.getChildCount() + ")");
        this.setStretchTorsions(newStretchTorsionNode);
        stretchTorsionTime += System.nanoTime() - time;
        time = System.nanoTime();
        for (Torsion torsion : arrayList) {
            AngleTorsion angleTorsion = AngleTorsion.angleTorsionFactory(torsion, forceField);
            if (angleTorsion == null) continue;
            newAngleTorsionNode.add(angleTorsion);
        }
        newAngleTorsionNode.setName("Angle-Torsions (" + newAngleTorsionNode.getChildCount() + ")");
        this.setAngleTorsions(newAngleTorsionNode);
        angleTorsionTime += System.nanoTime() - time;
        time = System.nanoTime();
        for (Bond bond : bonds) {
            PiOrbitalTorsion piOrbitalTorsion = PiOrbitalTorsion.piOrbitalTorsionFactory(bond, forceField);
            if (piOrbitalTorsion == null) continue;
            newPiOrbitalTorsionNode.add(piOrbitalTorsion);
        }
        newPiOrbitalTorsionNode.setName("Pi-Orbital Torsions (" + newPiOrbitalTorsionNode.getChildCount() + ")");
        this.setPiOrbitalTorsions(newPiOrbitalTorsionNode);
        piOrbitalTorsionTime += System.nanoTime() - time;
        time = System.nanoTime();
        List<Atom> list = this.getAtomList();
        for (Atom atom : list) {
            ArrayList<ImproperTorsion> improperTorsions;
            if (!atom.isTrigonal() || (improperTorsions = ImproperTorsion.improperTorsionFactory(atom, forceField)) == null) continue;
            for (ImproperTorsion improperTorsion : improperTorsions) {
                newImproperTorsionNode.add(improperTorsion);
            }
        }
        newImproperTorsionNode.setName("Improper Torsions (" + newImproperTorsionNode.getChildCount() + ")");
        this.setImproperTorsions(newImproperTorsionNode);
        improperTorsionTime += System.nanoTime() - time;
        time = System.nanoTime();
        for (Angle angle : angles) {
            Atom atom1 = angle.atoms[0];
            Atom atom2 = angle.atoms[1];
            Atom atom3 = angle.atoms[2];
            for (Bond firstBond : atom1.getBonds()) {
                Atom atom0 = firstBond.get1_2(atom1);
                if (atom0 == atom2 || atom0 == atom3) continue;
                for (Bond lastBond : atom3.getBonds()) {
                    TorsionTorsion torsionTorsion;
                    Atom atom4 = lastBond.get1_2(atom3);
                    if (atom4 == atom0 || atom4 == atom1 || atom4 == atom2 || (torsionTorsion = TorsionTorsion.torsionTorsionFactory(firstBond, angle, lastBond, forceField)) == null) continue;
                    newTorsionTorsionNode.insert(torsionTorsion, 0);
                }
            }
        }
        newTorsionTorsionNode.setName("Torsion-Torsions (" + newTorsionTorsionNode.getChildCount() + ")");
        this.setTorsionTorsions(newTorsionTorsionNode);
        torsionTorsionTime += System.nanoTime() - time;
        int numberOfValenceTerms = newBondNode.getChildCount() + newAngleNode.getChildCount() + newStretchBendNode.getChildCount() + newUreyBradleyNode.getChildCount() + newOutOfPlaneBendNode.getChildCount() + newTorsionNode.getChildCount() + newStretchTorsionNode.getChildCount() + newAngleTorsionNode.getChildCount() + newPiOrbitalTorsionNode.getChildCount() + newTorsionTorsionNode.getChildCount() + newImproperTorsionNode.getChildCount();
        this.termNode.setName("Valence Terms (" + numberOfValenceTerms + ")");
    }

    public Joint createJoint(Bond bond, MSGroup group1, MSGroup group2, ForceField forceField) {
        if (bond == null || group1 == null || group2 == null) {
            return null;
        }
        MSNode newBondNode = new MSNode("Bonds");
        MSNode newAngleNode = new MSNode("Angles");
        MSNode newStretchBendNode = new MSNode("Stretch-Bends");
        MSNode newUreyBradleyNode = new MSNode("Urey-Bradleys");
        MSNode newOutOfPlaneNode = new MSNode("Out-of-Plane Bends");
        MSNode newTorsionNode = new MSNode("Torsions");
        MSNode newStretchTorsionNode = new MSNode("Stretch-Torsions");
        MSNode newAngleTorsionNode = new MSNode("Angle-Torsions");
        MSNode newPiOrbitalTorsionNode = new MSNode("Pi-Orbital Torsions");
        MSNode newTorsionTorsionNode = new MSNode("Torsion-Torsions");
        newBondNode.add(bond);
        newBondNode.setName("Bonds (" + newBondNode.getChildCount() + ")");
        ArrayList<Angle> angles = new ArrayList<Angle>();
        Atom atom1 = bond.getAtom(0);
        for (Bond bond2 : atom1.getBonds()) {
            Angle angle;
            if (bond == bond2 || bond.getOtherAtom(bond2) == null || (angle = Angle.angleFactory(bond, bond2, forceField)) == null) continue;
            newAngleNode.add(angle);
            angles.add(angle);
        }
        Atom atom2 = bond.getAtom(1);
        for (Bond bond3 : atom2.getBonds()) {
            Angle angle;
            if (bond == bond3 || bond.getOtherAtom(bond3) == null || (angle = Angle.angleFactory(bond, bond3, forceField)) == null) continue;
            newAngleNode.add(angle);
            angles.add(angle);
        }
        newAngleNode.setName("Angles (" + newAngleNode.getChildCount() + ")");
        for (Angle angle : angles) {
            OutOfPlaneBend outOfPlaneBend;
            Object ureyBradley;
            StretchBend stretchBend = StretchBend.stretchBendFactory(angle, forceField);
            if (stretchBend != null) {
                newStretchBendNode.add(stretchBend);
            }
            if ((ureyBradley = UreyBradley.ureyBradlyFactory(angle, forceField)) != null) {
                newUreyBradleyNode.add((MutableTreeNode)ureyBradley);
            }
            if ((outOfPlaneBend = OutOfPlaneBend.outOfPlaneBendFactory(angle, forceField)) == null) continue;
            newOutOfPlaneNode.add(outOfPlaneBend);
        }
        newStretchBendNode.setName("Stretch-Bends (" + newStretchBendNode.getChildCount() + ")");
        newUreyBradleyNode.setName("Urey-Bradleys (" + newUreyBradleyNode.getChildCount() + ")");
        newOutOfPlaneNode.setName("Out-of-Plane Bends (" + newOutOfPlaneNode.getChildCount() + ")");
        atom1 = bond.getAtom(0);
        atom2 = bond.getAtom(1);
        ArrayList<Torsion> arrayList = new ArrayList<Torsion>();
        if (atom1.getNumBonds() != 0 && atom2.getNumBonds() != 0) {
            for (Bond bond4 : atom1.getBonds()) {
                if (bond4 == bond) continue;
                for (Bond lastBond : atom2.getBonds()) {
                    Torsion torsion;
                    if (lastBond == bond || (torsion = Torsion.torsionFactory(bond4, bond, lastBond, forceField)) == null) continue;
                    newTorsionNode.add(torsion);
                    arrayList.add(torsion);
                }
            }
        }
        newTorsionNode.setName("Torsional Angles (" + newTorsionNode.getChildCount() + ")");
        for (Torsion torsion : arrayList) {
            AngleTorsion angleTorsion;
            StretchTorsion stretchTorsion = StretchTorsion.stretchTorsionFactory(torsion, forceField);
            if (stretchTorsion != null) {
                newStretchTorsionNode.add(stretchTorsion);
            }
            if ((angleTorsion = AngleTorsion.angleTorsionFactory(torsion, forceField)) == null) continue;
            newAngleTorsionNode.add(angleTorsion);
        }
        newStretchTorsionNode.setName("Stretch-Torsions (" + this.stretchTorsionNode.getChildCount() + ")");
        newAngleTorsionNode.setName("Angle-Torsions (" + this.angleTorsionNode.getChildCount() + ")");
        PiOrbitalTorsion piOrbitalTorsion = PiOrbitalTorsion.piOrbitalTorsionFactory(bond, forceField);
        if (piOrbitalTorsion != null) {
            newPiOrbitalTorsionNode.add(piOrbitalTorsion);
        }
        newPiOrbitalTorsionNode.setName("Pi-Orbital Torsions (" + newPiOrbitalTorsionNode.getChildCount() + ")");
        for (Angle angle : angles) {
            atom1 = angle.atoms[0];
            atom2 = angle.atoms[1];
            Atom atom3 = angle.atoms[2];
            for (Bond firstBond : atom1.getBonds()) {
                Atom atom0 = firstBond.get1_2(atom1);
                if (atom0 == atom2 || atom0 == atom3) continue;
                for (Bond lastBond : atom3.getBonds()) {
                    TorsionTorsion torsionTorsion;
                    Atom atom4 = lastBond.get1_2(atom3);
                    if (atom4 == atom0 || atom4 == atom1 || atom4 == atom2 || (torsionTorsion = TorsionTorsion.torsionTorsionFactory(firstBond, angle, lastBond, forceField)) == null) continue;
                    newTorsionTorsionNode.add(torsionTorsion);
                }
            }
        }
        newTorsionTorsionNode.setName("Torsion-Torsions (" + newTorsionTorsionNode.getChildCount() + ")");
        Joint joint = new Joint(group1, group2, newBondNode, newAngleNode, newStretchBendNode, newUreyBradleyNode, newOutOfPlaneNode, newTorsionNode, null, newStretchTorsionNode, newAngleTorsionNode, newPiOrbitalTorsionNode, newTorsionTorsionNode);
        group1.addJoint(joint);
        group2.addJoint(joint);
        return joint;
    }

    public Joint createJoint(MSGroup group1, MSGroup group2, ForceField forceField) {
        Joint joint = null;
        double[] da = new double[3];
        double[] db = new double[3];
        for (Atom a1 : group1.getAtomList()) {
            a1.getXYZ(da);
            for (Atom a2 : group2.getAtomList()) {
                double d2;
                a2.getXYZ(db);
                double d1 = DoubleMath.dist((double[])da, (double[])db);
                if (!(d1 < (d2 = (double)0.7f + a1.getVDWR() / 2.0 + a2.getVDWR() / 2.0))) continue;
                Bond b = new Bond(a1, a2);
                Joint newJoint = this.createJoint(b, group1, group2, forceField);
                if (joint != null) {
                    joint.merge(newJoint);
                    continue;
                }
                joint = newJoint;
            }
        }
        return joint;
    }

    public abstract void finalize(boolean var1, ForceField var2);

    public void findDangelingAtoms() {
        ArrayList<Atom> d = new ArrayList<Atom>();
        for (Atom a : this.getAtomList()) {
            if (!a.isDangeling()) continue;
            d.add(a);
        }
        this.setDanglingAtoms(d);
    }

    public MSNode getAngles() {
        return this.angleNode;
    }

    public void setAngles(MSNode t) {
        this.termNode.removeChild(this.angleNode);
        this.angleNode = t;
        this.termNode.add(this.angleNode);
    }

    public Atom getAtomByName(String n, boolean caseInsensitive) {
        List<MSNode> list = this.getAtomNodeList();
        for (MSNode msNode : list) {
            if (!msNode.getName().equals(n) && (!caseInsensitive || !msNode.getName().equalsIgnoreCase(n))) continue;
            return (Atom)msNode;
        }
        return null;
    }

    public MSNode getAtomNode() {
        return this.atomNode;
    }

    public void setAtomNode(MSNode t) {
        this.remove(this.atomNode);
        this.atomNode = t;
        this.add(this.atomNode);
    }

    public MSNode getAtomNode(int index) {
        return this.getAtomNodeList().get(index);
    }

    public MSNode getAtomNode(String n) {
        List<MSNode> list = this.getAtomNodeList();
        for (MSNode msNode : list) {
            if (msNode.getName().compareTo(n) != 0) continue;
            return msNode;
        }
        if (this.matchDeuterium) {
            n = n.replaceFirst("H", "D");
            for (MSNode msNode : list) {
                if (msNode.getName().compareTo(n) != 0) continue;
                return msNode;
            }
        }
        return null;
    }

    public void setMatchDeuterium(boolean matchDeuterium) {
        this.matchDeuterium = matchDeuterium;
    }

    public boolean getMatchDeuterium() {
        return this.matchDeuterium;
    }

    public List<MSNode> getAtomNodeList() {
        return this.atomNode.getChildList();
    }

    public Bond getBond(int index) {
        return (Bond)this.bondNode.getChildAt(index);
    }

    public Bond getBond(String id) {
        int i = this.bondNode.getIndex(new Bond(id));
        if (i == -1) {
            return null;
        }
        return (Bond)this.bondNode.getChildAt(i);
    }

    public MSNode getBonds() {
        return this.bondNode;
    }

    public void setBonds(MSNode t) {
        this.termNode.removeChild(this.bondNode);
        this.bondNode.removeAllChildren();
        this.bondNode = t;
        this.termNode.add(this.bondNode);
    }

    public double[] getCenter() {
        return this.center;
    }

    public void setCenter(double[] d) {
        this.center = d;
    }

    public List<Atom> getDanglingAtoms() {
        return this.danglingAtomList;
    }

    public void setDanglingAtoms(List<Atom> a) {
        this.danglingAtomList = a;
    }

    public double[] getMultiScaleCenter(boolean w) {
        double[] Rc = new double[]{0.0, 0.0, 0.0};
        List<Atom> atoms = this.getAtomList();
        if (atoms == null) {
            return Rc;
        }
        double sum = 0.0;
        if (w) {
            for (Atom a : atoms) {
                double mass = a.getMass();
                Rc[0] = Rc[0] + mass * a.getX();
                Rc[1] = Rc[1] + mass * a.getY();
                Rc[2] = Rc[2] + mass * a.getZ();
                sum += mass;
            }
        } else {
            for (Atom a : atoms) {
                Rc[0] = Rc[0] + a.getX();
                Rc[1] = Rc[1] + a.getY();
                Rc[2] = Rc[2] + a.getZ();
            }
            sum = atoms.size();
        }
        Rc[0] = Rc[0] / sum;
        Rc[1] = Rc[1] / sum;
        Rc[2] = Rc[2] / sum;
        return Rc;
    }

    public MSNode getTermNode() {
        return this.termNode;
    }

    public MSNode getTorsions() {
        return this.torsionNode;
    }

    public void setTorsions(MSNode t) {
        this.termNode.removeChild(this.torsionNode);
        this.torsionNode = t;
        this.termNode.add(this.torsionNode);
    }

    public boolean isFinalized() {
        return this.finalized;
    }

    public void setFinalized(boolean t) {
        this.finalized = t;
    }

    @Override
    public void print() {
        super.print();
        for (Atom a : this.atomNode.getAtomList()) {
            a.print();
        }
        for (Bond b : this.bondNode.getBondList()) {
            b.print();
        }
    }

    public void reOrderAtoms() {
        boolean sorted;
        Atom[] atoms = this.getAtomList().toArray(new Atom[0]);
        int nAtoms = atoms.length;
        do {
            sorted = true;
            for (int i = 1; i < nAtoms; ++i) {
                Atom a1 = atoms[i - 1];
                Atom a2 = atoms[i];
                if (a1.getName().compareToIgnoreCase(a2.getName()) <= 0) continue;
                int i1 = a1.getIndex();
                int i2 = a2.getIndex();
                atoms[i - 1] = a2;
                atoms[i] = a1;
                a1.setXyzIndex(i2);
                a2.setXyzIndex(i1);
                sorted = false;
            }
        } while (!sorted);
    }

    public void setAngleTorsions(MSNode t) {
        this.termNode.removeChild(this.angleTorsionNode);
        this.angleTorsionNode = t;
        this.termNode.add(this.angleTorsionNode);
    }

    @Override
    public void setColor(RendererCache.ColorModel newColorModel, Color3f color, Material mat) {
        if (newColorModel == RendererCache.ColorModel.MOLECULE && (color == null || mat == null)) {
            return;
        }
        this.atomNode.setColor(newColorModel, color, mat);
    }

    public void setImproperTorsions(MSNode t) {
        this.termNode.removeChild(this.improperTorsionNode);
        this.improperTorsionNode = t;
        this.termNode.add(this.improperTorsionNode);
    }

    public void setOutOfPlaneBends(MSNode t) {
        this.termNode.removeChild(this.outOfPlaneBendNode);
        this.outOfPlaneBendNode.removeAllChildren();
        this.outOfPlaneBendNode = t;
        this.termNode.add(this.outOfPlaneBendNode);
    }

    public void setPiOrbitalTorsions(MSNode t) {
        this.termNode.removeChild(this.piOrbitalTorsionNode);
        this.piOrbitalTorsionNode = t;
        this.termNode.add(this.piOrbitalTorsionNode);
    }

    public void setStretchBends(MSNode t) {
        this.termNode.removeChild(this.stretchBendNode);
        this.stretchBendNode.removeAllChildren();
        this.stretchBendNode = t;
        this.termNode.add(this.stretchBendNode);
    }

    public void setStretchTorsions(MSNode t) {
        this.termNode.removeChild(this.stretchTorsionNode);
        this.stretchTorsionNode = t;
        this.termNode.add(this.stretchTorsionNode);
    }

    public void setTerms(MSNode t) {
        this.remove(this.termNode);
        this.termNode = t;
        this.add(this.termNode);
    }

    public void setTorsionTorsions(MSNode t) {
        this.termNode.removeChild(this.torsionTorsionNode);
        this.torsionTorsionNode = t;
        this.termNode.add(this.torsionTorsionNode);
    }

    public void setUreyBradleys(MSNode t) {
        this.termNode.removeChild(this.ureyBradleyNode);
        this.ureyBradleyNode.removeAllChildren();
        this.ureyBradleyNode = t;
        this.termNode.add(this.ureyBradleyNode);
    }

    public boolean conatainsAltLoc(Character altLoc) {
        List<Atom> atoms = this.getAtomList();
        for (Atom a : atoms) {
            if (a.getAltLoc() != altLoc) continue;
            return true;
        }
        return false;
    }

    public void setOccupancy(double occupancy) {
        List<Atom> atoms = this.getAtomList();
        for (Atom a : atoms) {
            a.setOccupancy(occupancy);
        }
    }

    public void setAtomicAltLoc(Character altLoc) {
        List<Atom> atoms = this.getAtomList();
        for (Atom a : atoms) {
            a.setAltLoc(altLoc);
        }
    }

    public boolean conformationEquals(MSGroup other) {
        List<Atom> atoms = this.getAtomList();
        List<Atom> otherAtoms = other.getAtomList();
        if (atoms.size() != otherAtoms.size()) {
            return false;
        }
        double[] xyz = new double[3];
        double[] xyzOther = new double[3];
        for (int i = 0; i < atoms.size(); ++i) {
            Atom a1 = atoms.get(i);
            Atom a2 = otherAtoms.get(i);
            a1.getXYZ(xyz);
            a2.getXYZ(xyzOther);
            if (!(DoubleMath.dist2((double[])xyz, (double[])xyzOther) > 0.0)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void setView(RendererCache.ViewModel newViewModel, List<BranchGroup> newShapes) {
        this.atomNode.setView(newViewModel, newShapes);
        this.bondNode.setView(newViewModel, newShapes);
    }

    @Override
    public String toString() {
        return this.getName();
    }

    @Override
    public void update() {
        this.updateAtoms();
        this.updateBonds();
    }

    public void updateAtoms() {
        for (Atom a : this.getAtomList()) {
            a.update();
        }
    }

    public void updateBonds() {
        for (ROLS rOLS : this.getBondList()) {
            rOLS.update();
        }
    }

    private boolean polymerLinked(String[] polyLinks, Bond bond) {
        Atom a1 = bond.getAtom(0);
        Atom a2 = bond.get1_2(a1);
        String resName = a1.getResidueName();
        if (resName == null) {
            logger.warning(String.format(" Residue name of atom 1 (%s) is null!", a1));
            return false;
        }
        String r2name = a2.getResidueName();
        if (r2name == null) {
            logger.warning(String.format(" Residue name of atom 2 (%s) is null!", a2));
            return false;
        }
        if (!resName.equals(r2name)) {
            return false;
        }
        String name1 = a1.getName();
        String name2 = a2.getName();
        for (String pLink : polyLinks) {
            String[] toks = pLink.split("\\s+");
            if (!resName.equalsIgnoreCase(toks[0])) continue;
            if (name1.equalsIgnoreCase(toks[1]) && name2.equalsIgnoreCase(toks[2])) {
                return true;
            }
            if (!name1.equalsIgnoreCase(toks[2]) || !name2.equalsIgnoreCase(toks[1])) continue;
            return true;
        }
        return false;
    }

    void addJoint(Joint newJoint) {
        this.joints.add(newJoint);
    }

    List<Joint> getJoints() {
        return this.joints;
    }

    protected void removeLeaves() {
        if (this.termNode.getParent() == null) {
            return;
        }
        if (this.bondNode.getChildCount() == 0 && this.bondNode.getParent() != null) {
            this.termNode.removeChild(this.bondNode);
        }
        if (this.angleNode.getChildCount() == 0 && this.angleNode.getParent() != null) {
            this.termNode.removeChild(this.angleNode);
        }
        if (this.stretchBendNode.getChildCount() == 0 && this.stretchBendNode.getParent() != null) {
            this.termNode.removeChild(this.stretchBendNode);
        }
        if (this.ureyBradleyNode.getChildCount() == 0 && this.ureyBradleyNode.getParent() != null) {
            this.termNode.removeChild(this.ureyBradleyNode);
        }
        if (this.outOfPlaneBendNode.getChildCount() == 0 && this.outOfPlaneBendNode.getParent() != null) {
            this.termNode.removeChild(this.outOfPlaneBendNode);
        }
        if (this.torsionNode.getChildCount() == 0 && this.torsionNode.getParent() != null) {
            this.termNode.removeChild(this.torsionNode);
        }
        if (this.stretchTorsionNode.getChildCount() == 0 && this.stretchTorsionNode.getParent() != null) {
            this.termNode.removeChild(this.stretchTorsionNode);
        }
        if (this.angleTorsionNode.getChildCount() == 0 && this.angleTorsionNode.getParent() != null) {
            this.termNode.removeChild(this.angleTorsionNode);
        }
        if (this.piOrbitalTorsionNode.getChildCount() == 0 && this.piOrbitalTorsionNode.getParent() != null) {
            this.termNode.removeChild(this.piOrbitalTorsionNode);
        }
        if (this.torsionTorsionNode.getChildCount() == 0 && this.torsionTorsionNode.getParent() != null) {
            this.termNode.removeChild(this.torsionTorsionNode);
        }
        if (this.improperTorsionNode.getChildCount() == 0 && this.improperTorsionNode.getParent() != null) {
            this.termNode.removeChild(this.improperTorsionNode);
        }
        if (this.termNode.getChildCount() == 0) {
            this.removeChild(this.termNode);
        }
        if (this.atomNode.getChildCount() == 0) {
            this.removeChild(this.atomNode);
        }
    }
}

