/*
 * Decompiled with CFR 0.152.
 */
package ffx.potential.bonded;

import ffx.numerics.atomic.AtomicDoubleArray3D;
import ffx.numerics.math.Double3;
import ffx.potential.bonded.Atom;
import ffx.potential.bonded.Bond;
import ffx.potential.bonded.BondedTerm;
import ffx.potential.parameters.ForceField;
import ffx.potential.parameters.ImproperTorsionType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.logging.Logger;
import org.apache.commons.math3.util.FastMath;

public class ImproperTorsion
extends BondedTerm {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = Logger.getLogger(ImproperTorsion.class.getName());
    public ImproperTorsionType improperType = null;
    public double scaleFactor = 1.0;

    private ImproperTorsion(Atom atom1, Atom atom2, Atom atom3, Atom atom4) {
        this.atoms = new Atom[4];
        this.atoms[0] = atom1;
        this.atoms[1] = atom2;
        this.atoms[2] = atom3;
        this.atoms[3] = atom4;
        this.setID_Key(false);
    }

    private static void createWildCardImproperTorsion(Atom[] atoms, int[] classes, ImproperTorsionType type, ArrayList<ImproperTorsion> improperTorsions) {
        Atom temp;
        if (classes[3] != atoms[3].getAtomType().atomClass && type.atomClasses[3] != 0) {
            if (classes[3] == atoms[1].getAtomType().atomClass) {
                temp = atoms[3];
                atoms[3] = atoms[1];
                atoms[1] = temp;
            } else {
                temp = atoms[0];
                atoms[0] = atoms[3];
                atoms[3] = temp;
            }
        }
        if (classes[1] != atoms[1].getAtomType().atomClass && type.atomClasses[1] != 0 && classes[1] == atoms[0].getAtomType().atomClass) {
            temp = atoms[1];
            atoms[1] = atoms[0];
            atoms[0] = temp;
        }
        ImproperTorsion improperTorsion = new ImproperTorsion(atoms[0], atoms[1], atoms[2], atoms[3]);
        improperTorsion.setImproperType(type);
        improperTorsions.add(improperTorsion);
        improperTorsion.scaleFactor = 0.3333333333333333;
        improperTorsions.add(improperTorsion);
        improperTorsion = new ImproperTorsion(atoms[1], atoms[3], atoms[2], atoms[0]);
        improperTorsion.setImproperType(type);
        improperTorsions.add(improperTorsion);
        improperTorsion.scaleFactor = 0.3333333333333333;
        improperTorsions.add(improperTorsion);
        improperTorsion = new ImproperTorsion(atoms[3], atoms[0], atoms[2], atoms[1]);
        improperTorsion.setImproperType(type);
        improperTorsions.add(improperTorsion);
        improperTorsion.scaleFactor = 0.3333333333333333;
        improperTorsions.add(improperTorsion);
    }

    static ArrayList<ImproperTorsion> improperTorsionFactory(Atom atom, ForceField forceField) {
        boolean assigned;
        int[] classes;
        if (atom == null) {
            return null;
        }
        Atom[] atoms = new Atom[4];
        atoms[2] = atom;
        List<Bond> bonds = atom.getBonds();
        if (bonds == null || bonds.size() != 3) {
            return null;
        }
        for (int i = 0; i < 3; ++i) {
            Bond bond = bonds.get(i);
            Atom atom2 = bond.get1_2(atom);
            if (i == 2) {
                atoms[3] = atom2;
                continue;
            }
            atoms[i] = atom2;
        }
        ArrayList<ImproperTorsion> improperTorsions = new ArrayList<ImproperTorsion>();
        Collection<ImproperTorsionType> types = forceField.getImproperTypes();
        boolean done = false;
        for (ImproperTorsionType type : types) {
            assigned = type.assigned(classes = new int[]{atoms[0].getAtomType().atomClass, atoms[1].getAtomType().atomClass, atoms[2].getAtomType().atomClass, atoms[3].getAtomType().atomClass}, false, false);
            if (assigned) {
                Atom temp;
                done = true;
                if (classes[3] != atoms[3].getAtomType().atomClass && type.atomClasses[3] != 0) {
                    if (classes[3] == atoms[1].getAtomType().atomClass) {
                        temp = atoms[3];
                        atoms[3] = atoms[1];
                        atoms[1] = temp;
                    } else {
                        temp = atoms[0];
                        atoms[0] = atoms[3];
                        atoms[3] = temp;
                    }
                }
                if (classes[1] != atoms[1].getAtomType().atomClass && type.atomClasses[1] != 0 && classes[1] == atoms[0].getAtomType().atomClass) {
                    temp = atoms[1];
                    atoms[1] = atoms[0];
                    atoms[0] = temp;
                }
                ImproperTorsion improperTorsion = new ImproperTorsion(atoms[0], atoms[1], atoms[2], atoms[3]);
                improperTorsion.setImproperType(type);
                improperTorsions.add(improperTorsion);
                int c0 = type.atomClasses[0];
                int c1 = type.atomClasses[1];
                int c3 = type.atomClasses[3];
                if (c0 == c1 && c1 == c3) {
                    improperTorsion.scaleFactor = 0.16666666666666666;
                    improperTorsion = new ImproperTorsion(atoms[0], atoms[3], atoms[2], atoms[1]);
                    improperTorsion.setImproperType(type);
                    improperTorsion.scaleFactor = 0.16666666666666666;
                    improperTorsions.add(improperTorsion);
                    improperTorsion = new ImproperTorsion(atoms[1], atoms[0], atoms[2], atoms[3]);
                    improperTorsion.setImproperType(type);
                    improperTorsion.scaleFactor = 0.16666666666666666;
                    improperTorsions.add(improperTorsion);
                    improperTorsion = new ImproperTorsion(atoms[1], atoms[3], atoms[2], atoms[0]);
                    improperTorsion.setImproperType(type);
                    improperTorsion.scaleFactor = 0.16666666666666666;
                    improperTorsions.add(improperTorsion);
                    improperTorsion = new ImproperTorsion(atoms[3], atoms[0], atoms[2], atoms[1]);
                    improperTorsion.setImproperType(type);
                    improperTorsion.scaleFactor = 0.16666666666666666;
                    improperTorsions.add(improperTorsion);
                    improperTorsion = new ImproperTorsion(atoms[3], atoms[1], atoms[2], atoms[0]);
                    improperTorsion.setImproperType(type);
                    improperTorsion.scaleFactor = 0.16666666666666666;
                    improperTorsions.add(improperTorsion);
                } else if (c0 == c1) {
                    improperTorsion.scaleFactor = 0.5;
                    improperTorsion = new ImproperTorsion(atoms[1], atoms[0], atoms[2], atoms[3]);
                    improperTorsion.setImproperType(type);
                    improperTorsion.scaleFactor = 0.5;
                    improperTorsions.add(improperTorsion);
                } else if (c0 == c3) {
                    improperTorsion.scaleFactor = 0.5;
                    improperTorsion = new ImproperTorsion(atoms[3], atoms[1], atoms[2], atoms[0]);
                    improperTorsion.setImproperType(type);
                    improperTorsion.scaleFactor = 0.5;
                    improperTorsions.add(improperTorsion);
                } else if (c1 == c3) {
                    improperTorsion.scaleFactor = 0.5;
                    improperTorsion = new ImproperTorsion(atoms[0], atoms[3], atoms[2], atoms[1]);
                    improperTorsion.setImproperType(type);
                    improperTorsion.scaleFactor = 0.5;
                    improperTorsions.add(improperTorsion);
                }
            }
            if (!done) continue;
            break;
        }
        if (!done) {
            for (ImproperTorsionType type : types) {
                assigned = type.assigned(classes = new int[]{atoms[0].getAtomType().atomClass, atoms[1].getAtomType().atomClass, atoms[2].getAtomType().atomClass, atoms[3].getAtomType().atomClass}, true, false);
                if (!assigned) continue;
                done = true;
                ImproperTorsion.createWildCardImproperTorsion(atoms, classes, type, improperTorsions);
                break;
            }
        }
        if (!done) {
            for (ImproperTorsionType type : types) {
                assigned = type.assigned(classes = new int[]{atoms[0].getAtomType().atomClass, atoms[1].getAtomType().atomClass, atoms[2].getAtomType().atomClass, atoms[3].getAtomType().atomClass}, true, true);
                if (!assigned) continue;
                ImproperTorsion.createWildCardImproperTorsion(atoms, classes, type, improperTorsions);
                break;
            }
        }
        if (improperTorsions.isEmpty()) {
            return null;
        }
        return improperTorsions;
    }

    @Override
    public int compareTo(BondedTerm o) {
        int a1;
        if (o == null) {
            throw new NullPointerException();
        }
        if (o == this) {
            return 0;
        }
        if (!o.getClass().isInstance(this)) {
            return super.compareTo(o);
        }
        int this1 = this.atoms[1].getIndex();
        if (this1 < (a1 = o.atoms[1].getIndex())) {
            return -1;
        }
        if (this1 > a1) {
            return 1;
        }
        int this3 = this.atoms[3].getIndex();
        int a3 = o.atoms[3].getIndex();
        return Integer.compare(this3, a3);
    }

    @Override
    public double energy(boolean gradient, int threadID, AtomicDoubleArray3D grad, AtomicDoubleArray3D lambdaGrad) {
        double ru2;
        this.energy = 0.0;
        this.value = 0.0;
        if (!this.getUse()) {
            return this.energy;
        }
        Atom atomA = this.atoms[0];
        Atom atomB = this.atoms[1];
        Atom atomC = this.atoms[2];
        Atom atomD = this.atoms[3];
        Double3 va = atomA.getXYZ();
        Double3 vb = atomB.getXYZ();
        Double3 vc = atomC.getXYZ();
        Double3 vd = atomD.getXYZ();
        Double3 vba = vb.sub(va);
        Double3 vcb = vc.sub(vb);
        Double3 vdc = vd.sub(vc);
        Double3 vt = vba.X(vcb);
        Double3 vu = vcb.X(vdc);
        Double3 vtu = vt.X(vu);
        double rt2 = vt.length2();
        double rtru = FastMath.sqrt((double)(rt2 * (ru2 = vu.length2())));
        if (rtru != 0.0) {
            double v2 = this.improperType.k;
            double c2 = this.improperType.cos;
            double s2 = this.improperType.sin;
            double rcb = vcb.length();
            double cosine = vt.dot(vu) / rtru;
            double sine = vcb.dot(vtu) / (rcb * rtru);
            double cosine2 = cosine * cosine - sine * sine;
            double sine2 = 2.0 * cosine * sine;
            double phi2 = 1.0 + (cosine2 * c2 + sine2 * s2);
            double dphi2 = 2.0 * (cosine2 * s2 - sine2 * c2);
            this.value = FastMath.toDegrees((double)FastMath.acos((double)cosine));
            double prefactor = this.improperType.impTorUnit * this.scaleFactor;
            this.energy = prefactor * (v2 * phi2);
            double dedphi = prefactor * (v2 * dphi2);
            if (gradient) {
                Double3 vca = vc.sub(va);
                Double3 vdb = vd.sub(vb);
                Double3 dedt = vt.X(vcb).scaleI(dedphi / (rt2 * rcb));
                Double3 dedu = vu.X(vcb).scaleI(-dedphi / (ru2 * rcb));
                int ia = atomA.getIndex() - 1;
                int ib = atomB.getIndex() - 1;
                int ic = atomC.getIndex() - 1;
                int id = atomD.getIndex() - 1;
                grad.add(threadID, ia, dedt.X(vcb));
                grad.add(threadID, ib, dedu.X(vdc).addI(dedt.X(vca).scaleI(-1.0)));
                grad.add(threadID, ic, dedu.X(vdb).scaleI(-1.0).addI(dedt.X(vba)));
                grad.add(threadID, id, dedu.X(vcb));
            }
        }
        return this.energy;
    }

    public void log() {
        logger.info(String.format(" %s %6d-%s %6d-%s %6d-%s %6d-%s %6.4f %10.4f", "Improper Torsion", this.atoms[0].getIndex(), this.atoms[0].getAtomType().name, this.atoms[1].getIndex(), this.atoms[1].getAtomType().name, this.atoms[2].getIndex(), this.atoms[2].getAtomType().name, this.atoms[3].getIndex(), this.atoms[3].getAtomType().name, this.value, this.energy));
    }

    @Override
    public String toString() {
        return String.format("%s  (%7.1f,%7.2f)", this.id, this.value, this.energy);
    }

    private void setImproperType(ImproperTorsionType a) {
        this.improperType = a;
    }
}

