/*
 * Decompiled with CFR 0.152.
 */
package ffx.potential.bonded;

import ffx.numerics.Constraint;
import ffx.numerics.atomic.AtomicDoubleArray3D;
import ffx.numerics.math.Double3;
import ffx.potential.bonded.Atom;
import ffx.potential.bonded.Bond;
import ffx.potential.bonded.BondedTerm;
import ffx.potential.parameters.AngleType;
import ffx.potential.parameters.AtomType;
import ffx.potential.parameters.ForceField;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.apache.commons.math3.util.FastMath;

public class Angle
extends BondedTerm {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = Logger.getLogger(Angle.class.getName());
    public AngleType angleType;
    public int nh = 0;
    private double rigidScale = 1.0;
    private Atom atom4 = null;

    public Angle(Bond b1, Bond b2) {
        Atom a2 = b1.getCommonAtom(b2);
        Atom a1 = b1.get1_2(a2);
        Atom a3 = b2.get1_2(a2);
        b1.setAngleWith(b2);
        b2.setAngleWith(b1);
        this.atoms = new Atom[3];
        this.bonds = new Bond[2];
        this.atoms[1] = a2;
        this.atoms[0] = a1;
        this.atoms[2] = a3;
        this.bonds[0] = b1;
        this.bonds[1] = b2;
        a1.setAngle(this);
        a2.setAngle(this);
        a3.setAngle(this);
        this.setID_Key(false);
    }

    public static void logNoAngleType(Atom a1, Atom a2, Atom a3, ForceField forceField) {
        AtomType atomType1 = a1.getAtomType();
        AtomType atomType2 = a2.getAtomType();
        AtomType atomType3 = a3.getAtomType();
        int c1 = atomType1.atomClass;
        int c2 = atomType2.atomClass;
        int c3 = atomType3.atomClass;
        int[] c = new int[]{c1, c2, c3};
        String key = AngleType.sortKey(c);
        StringBuilder sb = new StringBuilder(String.format("No AngleType for key: %s\n %s -> %s\n %s -> %s\n %s -> %s", key, a1, atomType1, a2, atomType2, a3, atomType3));
        List<AtomType> types1 = forceField.getSimilarAtomTypes(atomType1);
        List<AtomType> types2 = forceField.getSimilarAtomTypes(atomType2);
        List<AtomType> types3 = forceField.getSimilarAtomTypes(atomType3);
        ArrayList<AngleType> angleTypes = new ArrayList<AngleType>();
        boolean match = false;
        for (AtomType type1 : types1) {
            for (AtomType type2 : types2) {
                if (type2.atomClass != c2) continue;
                for (AtomType type3 : types3) {
                    AngleType angleType;
                    if (type1.atomClass != c1 && type1.atomClass != c3 && type3.atomClass != c1 && type3.atomClass != c3 || (angleType = forceField.getAngleType(type1, type2, type3)) == null || angleTypes.contains(angleType)) continue;
                    if (!match) {
                        match = true;
                        sb.append("\n Similar Angle Types:");
                    }
                    angleTypes.add(angleType);
                    sb.append(String.format("\n  %s", angleType));
                }
            }
        }
        logger.severe(sb.toString());
    }

    static Angle angleFactory(Bond b1, Bond b2, ForceField forceField) {
        Angle newAngle = new Angle(b1, b2);
        Atom ac = b1.getCommonAtom(b2);
        Atom a1 = b1.get1_2(ac);
        Atom a3 = b2.get1_2(ac);
        AngleType angleType = forceField.getAngleType(a1.getAtomType(), ac.getAtomType(), a3.getAtomType());
        if (angleType == null) {
            Angle.logNoAngleType(a1, ac, a3, forceField);
            return null;
        }
        newAngle.setAngleType(angleType);
        return newAngle;
    }

    @Override
    public int compareTo(BondedTerm a) {
        int a0;
        int a1;
        if (a == null) {
            throw new NullPointerException();
        }
        if (a == this) {
            return 0;
        }
        if (!a.getClass().isInstance(this)) {
            return super.compareTo(a);
        }
        int this1 = this.atoms[1].getIndex();
        if (this1 < (a1 = a.atoms[1].getIndex())) {
            return -1;
        }
        if (this1 > a1) {
            return 1;
        }
        int this0 = this.atoms[0].getIndex();
        if (this0 < (a0 = a.atoms[0].getIndex())) {
            return -1;
        }
        if (this0 > a0) {
            return 1;
        }
        int this2 = this.atoms[2].getIndex();
        int a2 = a.atoms[2].getIndex();
        return Integer.compare(this2, a2);
    }

    @Override
    public double energy(boolean gradient, int threadID, AtomicDoubleArray3D grad, AtomicDoubleArray3D lambdaGrad) {
        this.value = 0.0;
        this.energy = 0.0;
        if (!this.getUse()) {
            return this.energy;
        }
        Atom atomA = this.atoms[0];
        Atom atomB = this.atoms[1];
        Atom atomC = this.atoms[2];
        int ia = atomA.getIndex() - 1;
        int ib = atomB.getIndex() - 1;
        int ic = atomC.getIndex() - 1;
        Double3 va = atomA.getXYZ();
        Double3 vb = atomB.getXYZ();
        Double3 vc = atomC.getXYZ();
        double prefactor = this.angleType.angleUnit * this.rigidScale * this.angleType.forceConstant;
        switch (this.angleType.angleMode) {
            case NORMAL: {
                Double3 vab = va.sub(vb);
                Double3 vcb = vc.sub(vb);
                double rab2 = vab.length2();
                double rcb2 = vcb.length2();
                if (rab2 == 0.0 || rcb2 == 0.0) break;
                Double3 p = vcb.X(vab);
                double cosine = FastMath.min((double)1.0, (double)FastMath.max((double)-1.0, (double)(vab.dot(vcb) / FastMath.sqrt((double)(rab2 * rcb2)))));
                this.value = FastMath.toDegrees((double)FastMath.acos((double)cosine));
                double dv = this.value - this.angleType.angle[this.nh];
                double dv2 = dv * dv;
                double dv3 = dv2 * dv;
                double dv4 = dv2 * dv2;
                this.energy = prefactor * dv2 * (1.0 + this.angleType.cubic * dv + this.angleType.quartic * dv2 + this.angleType.pentic * dv3 + this.angleType.sextic * dv4);
                if (gradient) {
                    double deddt = prefactor * dv * FastMath.toDegrees((double)(2.0 + 3.0 * this.angleType.cubic * dv + 4.0 * this.angleType.quartic * dv2 + 5.0 * this.angleType.pentic * dv3 + 6.0 * this.angleType.sextic * dv4));
                    double rp = FastMath.max((double)p.length(), (double)1.0E-6);
                    double terma = -deddt / (rab2 * rp);
                    double termc = deddt / (rcb2 * rp);
                    Double3 ga = vab.X(p).scale(terma);
                    Double3 gc = vcb.X(p).scale(termc);
                    grad.add(threadID, ia, ga);
                    grad.sub(threadID, ib, ga.add(gc));
                    grad.add(threadID, ic, gc);
                }
                this.value = dv;
                break;
            }
            case IN_PLANE: {
                Double3 vd = this.getAtom4XYZ();
                int id = this.atom4.getIndex() - 1;
                Double3 vad = va.sub(vd);
                Double3 vbd = vb.sub(vd);
                Double3 vcd = vc.sub(vd);
                Double3 vp = vad.X(vcd);
                double rp2 = vp.length2();
                double delta = -vp.dot(vbd) / rp2;
                Double3 vip = vp.scale(delta).addI(vbd);
                Double3 vjp = vad.sub(vip);
                Double3 vkp = vcd.sub(vip);
                double jp2 = vjp.length2();
                double kp2 = vkp.length2();
                if (jp2 == 0.0 || kp2 == 0.0) break;
                double cosine = FastMath.min((double)1.0, (double)FastMath.max((double)-1.0, (double)(vjp.dot(vkp) / FastMath.sqrt((double)(jp2 * kp2)))));
                this.value = FastMath.toDegrees((double)FastMath.acos((double)cosine));
                double dv = this.value - this.angleType.angle[this.nh];
                double dv2 = dv * dv;
                double dv3 = dv2 * dv;
                double dv4 = dv2 * dv2;
                this.energy = prefactor * dv2 * (1.0 + this.angleType.cubic * dv + this.angleType.quartic * dv2 + this.angleType.pentic * dv3 + this.angleType.sextic * dv4);
                if (gradient) {
                    double deddt = prefactor * dv * FastMath.toDegrees((double)(2.0 + 3.0 * this.angleType.cubic * dv + 4.0 * this.angleType.quartic * dv2 + 5.0 * this.angleType.pentic * dv3 + 6.0 * this.angleType.sextic * dv4));
                    Double3 lp = vkp.X(vjp);
                    double lpr = FastMath.max((double)lp.length(), (double)1.0E-6);
                    Double3 ded0 = vjp.X(lp).scaleI(-deddt / (jp2 * lpr));
                    Double3 ded2 = vkp.X(lp).scaleI(deddt / (kp2 * lpr));
                    Double3 dedp = ded0.add(ded2);
                    Double3 gb = dedp.scale(-1.0);
                    double delta2 = 2.0 * delta;
                    double pt2 = dedp.dot(vp) / rp2;
                    Double3 xd2 = vcd.X(gb).scaleI(delta);
                    Double3 xp2 = vp.X(vcd).scaleI(delta2);
                    Double3 x21 = vbd.X(vcd).addI(xp2).scaleI(pt2);
                    Double3 dpd0 = xd2.add(x21);
                    xd2 = gb.X(vad).scaleI(delta);
                    xp2 = vp.X(vad).scaleI(delta2);
                    x21.addI(xp2).scaleI(pt2);
                    Double3 dpd2 = xd2.addI(x21);
                    Double3 ga = ded0.addI(dpd0);
                    Double3 gc = ded2.addI(dpd2);
                    grad.add(threadID, ia, ga);
                    grad.add(threadID, ib, gb);
                    grad.add(threadID, ic, gc);
                    grad.sub(threadID, id, ga.addI(gb).addI(gc));
                }
                this.value = dv;
            }
        }
        return this.energy;
    }

    public Atom get1_3(Atom a) {
        if (a == this.atoms[0]) {
            return this.atoms[2];
        }
        if (a == this.atoms[2]) {
            return this.atoms[0];
        }
        return null;
    }

    public AngleType.AngleMode getAngleMode() {
        return this.angleType.angleMode;
    }

    public AngleType getAngleType() {
        return this.angleType;
    }

    public void setAngleType(AngleType a) {
        this.angleType = a;
        List<Bond> ba = this.atoms[1].getBonds();
        this.nh = 0;
        for (Bond b1 : ba) {
            if (b1 == this.bonds[0] || b1 == this.bonds[1]) continue;
            Atom atom = b1.get1_2(this.atoms[1]);
            if (atom.getAtomType().atomicNumber != 1) continue;
            ++this.nh;
        }
        while (this.angleType.angle.length <= this.nh) {
            --this.nh;
        }
    }

    public Atom getAtom4() {
        return this.atom4;
    }

    public Atom getCentralAtom() {
        return this.atoms[1];
    }

    public void log() {
        switch (this.angleType.angleMode) {
            case NORMAL: {
                logger.info(String.format(" %-8s %6d-%s %6d-%s %6d-%s %7.4f  %7.4f  %10.4f", "Angle", this.atoms[0].getIndex(), this.atoms[0].getAtomType().name, this.atoms[1].getIndex(), this.atoms[1].getAtomType().name, this.atoms[2].getIndex(), this.atoms[2].getAtomType().name, this.angleType.angle[this.nh], this.value, this.energy));
                break;
            }
            case IN_PLANE: {
                logger.info(String.format(" %-8s %6d-%s %6d-%s %6d-%s %7.4f  %7.4f  %10.4f", "Angle-IP", this.atoms[0].getIndex(), this.atoms[0].getAtomType().name, this.atoms[1].getIndex(), this.atoms[1].getAtomType().name, this.atoms[2].getIndex(), this.atoms[2].getAtomType().name, this.angleType.angle[this.nh], this.value, this.energy));
            }
        }
    }

    @Override
    public void setConstraint(Constraint c) {
        super.setConstraint(c);
        for (Bond b : this.bonds) {
            b.setConstraint(c);
        }
    }

    public void setRigidScale(double rigidScale) {
        this.rigidScale = rigidScale;
    }

    @Override
    public String toString() {
        return String.format("%s  (%7.1f,%7.2f)", this.id, this.value, this.energy);
    }

    private Double3 getAtom4XYZ() {
        try {
            return this.atom4.getXYZ();
        }
        catch (Exception e) {
            logger.info(" Atom 4 not found for angle: " + String.valueOf(this));
            for (Atom atom : this.atoms) {
                logger.info(" Atom: " + atom.toString());
                logger.info(" Type: " + atom.getAtomType().toString());
            }
            throw e;
        }
    }

    void setInPlaneAtom(Atom a4) {
        if (this.angleType.angleMode != AngleType.AngleMode.IN_PLANE) {
            logger.severe(" Attempted to set fourth atom for a normal angle.");
        }
        this.atom4 = a4;
    }

    Bond getCommonBond(Angle a) {
        if (a == this || a == null) {
            return null;
        }
        if (a.bonds[0] == this.bonds[0]) {
            return this.bonds[0];
        }
        if (a.bonds[0] == this.bonds[1]) {
            return this.bonds[1];
        }
        if (a.bonds[1] == this.bonds[0]) {
            return this.bonds[0];
        }
        if (a.bonds[1] == this.bonds[1]) {
            return this.bonds[1];
        }
        return null;
    }

    Bond getOtherBond(Bond b) {
        if (b == this.bonds[0]) {
            return this.bonds[1];
        }
        if (b == this.bonds[1]) {
            return this.bonds[0];
        }
        return null;
    }

    public Atom getFourthAtomOfTrigonalCenter() {
        if (this.atoms[1].isTrigonal()) {
            for (Bond b : this.atoms[1].getBonds()) {
                if (b == this.bonds[0] || b == this.bonds[1]) continue;
                return b.get1_2(this.atoms[1]);
            }
        }
        return null;
    }
}

