/*
 * Decompiled with CFR 0.152.
 */
package ffx.potential;

import ffx.potential.UnmodifiableState;
import java.util.Arrays;

public class SystemState {
    protected final int numberOfVariables;
    protected final double[] x;
    protected final double[] v;
    protected final double[] a;
    protected final double[] aPrevious;
    protected final double[] gradient;
    protected final double[] mass;
    double temperature;
    double kineticEnergy;
    double potentialEnergy;

    public SystemState(int numberOfVariables) {
        this.numberOfVariables = numberOfVariables;
        this.x = new double[numberOfVariables];
        this.v = new double[numberOfVariables];
        this.a = new double[numberOfVariables];
        this.aPrevious = new double[numberOfVariables];
        this.gradient = new double[numberOfVariables];
        this.mass = new double[numberOfVariables];
    }

    public UnmodifiableState getUnmodifiableState() {
        return new UnmodifiableState(this.x, this.v, this.a, this.aPrevious, this.mass, this.gradient, this.kineticEnergy, this.potentialEnergy, this.temperature);
    }

    public int getNumberOfVariables() {
        return this.numberOfVariables;
    }

    public void revertState(UnmodifiableState state) {
        assert (state.x().length == this.numberOfVariables);
        System.arraycopy(state.x(), 0, this.x, 0, this.numberOfVariables);
        System.arraycopy(state.v(), 0, this.v, 0, this.numberOfVariables);
        System.arraycopy(state.a(), 0, this.a, 0, this.numberOfVariables);
        System.arraycopy(state.aPrevious(), 0, this.aPrevious, 0, this.numberOfVariables);
        System.arraycopy(state.mass(), 0, this.mass, 0, this.numberOfVariables);
        System.arraycopy(state.gradient(), 0, this.gradient, 0, this.numberOfVariables);
        this.kineticEnergy = state.kineticEnergy();
        this.potentialEnergy = state.potentialEnergy();
        this.temperature = state.temperature();
    }

    public void setMass(double[] mass) {
        assert (mass.length == this.numberOfVariables);
        System.arraycopy(mass, 0, this.mass, 0, this.numberOfVariables);
    }

    public void setCoordinates(double[] x) {
        assert (x.length == this.numberOfVariables);
        System.arraycopy(x, 0, this.x, 0, this.numberOfVariables);
    }

    public void setVelocities(double[] v) {
        assert (v.length == this.numberOfVariables);
        System.arraycopy(v, 0, this.v, 0, this.numberOfVariables);
    }

    public void setAccelerations(double[] a) {
        assert (a.length == this.numberOfVariables);
        System.arraycopy(a, 0, this.a, 0, this.numberOfVariables);
    }

    public void setPreviousAccelerations(double[] aPrevious) {
        assert (aPrevious.length == this.numberOfVariables);
        System.arraycopy(aPrevious, 0, this.aPrevious, 0, this.numberOfVariables);
    }

    public double[] x() {
        return this.x;
    }

    public double[] v() {
        return this.v;
    }

    public double[] a() {
        return this.a;
    }

    public double[] aPrevious() {
        return this.aPrevious;
    }

    public double[] getMass() {
        return this.mass;
    }

    public double[] gradient() {
        return this.gradient;
    }

    public double[] getCoordinatesCopy() {
        return Arrays.copyOf(this.x, this.numberOfVariables);
    }

    public void copyAccelerationsToPrevious() {
        System.arraycopy(this.a, 0, this.aPrevious, 0, this.numberOfVariables);
    }

    public void setTemperature(double temperature) {
        this.temperature = temperature;
    }

    public void setKineticEnergy(double kineticEnergy) {
        this.kineticEnergy = kineticEnergy;
    }

    public void setPotentialEnergy(double potentialEnergy) {
        this.potentialEnergy = potentialEnergy;
    }

    public double getTemperature() {
        return this.temperature;
    }

    public double getKineticEnergy() {
        return this.kineticEnergy;
    }

    public double getPotentialEnergy() {
        return this.potentialEnergy;
    }

    public double getTotalEnergy() {
        return this.kineticEnergy + this.potentialEnergy;
    }

    public double getKineticEnergyFromVelocities() {
        double e = 0.0;
        for (int i = 0; i < this.numberOfVariables; ++i) {
            double m = this.mass[i];
            if (!(m > 0.0)) continue;
            double velocity = this.v[i];
            double v2 = velocity * velocity;
            e += m * v2;
        }
        return e *= 0.0011950286806883365;
    }
}

